/*
 * Decompiled with CFR 0.152.
 */
package com.indy.file.xml.editor;

import com.indy.addons.Messages;
import com.indy.file.xml.IXsdProvider;
import com.indy.file.xml.XmlEditorInput;
import com.indy.file.xml.XmlFormater;
import com.indy.file.xml.editor.XMLConfiguration;
import com.indy.file.xml.editor.XMLDocumentProvider;
import com.indy.file.xml.editor.XmlTextListener;
import com.indy.file.xml.editor.XsdValidationException;
import com.indy.jdbc.editor.Activator;
import com.indy.ui.out.qa.InternalIdentifier;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.xml.sax.SAXParseException;

public class XMLEditor
extends TextEditor {
    public static String ERROR_TYPE = "error.type";
    public static Image ERROR_IMAGE;
    public static final String ID = "com.indy.file.xml.editor.XMLEditor";
    private XmlTextListener textListener;
    private Button validate;

    public XMLEditor() {
        this.setSourceViewerConfiguration(new XMLConfiguration());
        this.setDocumentProvider((IDocumentProvider)new XMLDocumentProvider());
        this.textListener = new XmlTextListener();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof XmlEditorInput) {
            ((XmlEditorInput)input).adaptXsdPathAttribute((Adapter)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    boolean enabled = false;
                    if (msg.getNewStringValue() != null && !msg.getNewStringValue().isEmpty()) {
                        enabled = true;
                    }
                    final boolean state = enabled;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (XMLEditor.this.validate != null && !XMLEditor.this.validate.isDisposed()) {
                                XMLEditor.this.validate.setEnabled(state);
                            }
                        }
                    });
                }
            });
        }
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        try {
            try {
                provider.aboutToChange((Object)this.getEditorInput());
                IEditorInput input = this.getEditorInput();
                provider.saveDocument(progressMonitor, (Object)input, this.getDocumentProvider().getDocument((Object)input), overwrite);
                this.editorSaved();
            }
            catch (XsdValidationException x) {
                this.openSaveErrorDialog(Messages.XMLEditor_2, Messages.XMLEditor_3, x);
                progressMonitor.setCanceled(true);
                provider.changed((Object)this.getEditorInput());
            }
            catch (CoreException x) {
                block9: {
                    IStatus status = x.getStatus();
                    if (status != null && status.getSeverity() == 8) break block9;
                    this.handleExceptionOnSave(x, progressMonitor);
                }
                provider.changed((Object)this.getEditorInput());
            }
        }
        finally {
            provider.changed((Object)this.getEditorInput());
        }
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        IOverviewRuler ruler = super.createOverviewRuler(sharedColors);
        ruler.addAnnotationType((Object)"org.eclipse.ui.workbench.texteditor.error");
        return ruler;
    }

    public void createPartControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout());
        Composite main = new Composite(c, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        main.setLayoutData((Object)new GridData(4, 1, true, false));
        Button b = new Button(main, 8);
        b.setLayoutData((Object)new GridData());
        b.setData("qa", (Object)InternalIdentifier.XML_EDITOR_BUTTON_FORMAT_FILE.getId());
        b.setText(Messages.XMLEditor_6);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String baseString = XMLEditor.this.getSourceViewer().getDocument().get();
                try {
                    XmlFormater f = new XmlFormater();
                    String s = f.format(new ByteArrayInputStream(baseString.getBytes()));
                    XMLEditor.this.getSourceViewer().getDocument().set(s);
                }
                catch (Exception ex) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.jdbc.editor", "Failed to format document", (Throwable)ex), 2);
                }
            }
        });
        this.validate = new Button(main, 8);
        this.validate.setLayoutData((Object)new GridData());
        this.validate.setData("qa", (Object)InternalIdentifier.XML_EDITOR_BUTTON_VALIDATE_XML.getId());
        this.validate.setText(Messages.XMLEditor_9);
        this.validate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLEditor.this.validateDocument();
            }
        });
        this.validate.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IEditorInput input = XMLEditor.this.getEditorInput();
                if (input instanceof XmlEditorInput) {
                    ((XmlEditorInput)input).adaptXsdPathAttribute(null);
                }
            }
        });
        try {
            if (this.getEditorInput().getAdapter(IXsdProvider.class) == null) {
                this.validate.setEnabled(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        b = new Button(main, 32);
        b.setLayoutData((Object)new GridData(4, 1, false, false));
        b.setData("qa", (Object)InternalIdentifier.XML_EDITOR_CHECK_SYNTAX_COLORING.getId());
        b.setText(Messages.XMLEditor_11);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    XMLEditor.this.getSourceViewer().getTextWidget().addLineStyleListener((LineStyleListener)XMLEditor.this.textListener);
                } else {
                    XMLEditor.this.getSourceViewer().getTextWidget().removeLineStyleListener((LineStyleListener)XMLEditor.this.textListener);
                }
                XMLEditor.this.getSourceViewer().getTextWidget().redraw();
            }
        });
        Composite r = new Composite(c, 0);
        r.setLayoutData((Object)new GridData(1808));
        r.setLayout((Layout)new FillLayout());
        super.createPartControl(r);
    }

    private void validateDocument() {
        IRunnableWithProgress rwp = new IRunnableWithProgress(){

            /*
             * Unable to fully structure code
             */
            public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block10: {
                    provider = (XMLDocumentProvider)XMLEditor.this.getDocumentProvider();
                    input = (XmlEditorInput)XMLEditor.this.getEditorInput();
                    doc = provider.getDocument(input);
                    model = provider.getAnnotationModel(input);
                    if (model instanceof AnnotationModel) {
                        ((AnnotationModel)model).removeAllAnnotations();
                    }
                    try {
                        provider.validate(provider.getDocument(input), (File)XMLEditor.this.getEditorInput().getAdapter(IXsdProvider.class));
                    }
                    catch (XsdValidationException ex) {
                        Activator.error(ex.getMessage(), (Throwable)ex);
                        ms = (MultiStatus)ex.getStatus();
                        var11_9 = ms.getChildren();
                        var10_10 = var11_9.length;
                        var9_11 = 0;
                        ** while (var9_11 < var10_10)
                    }
lbl-1000:
                    // 1 sources

                    {
                        s = var11_9[var9_11];
                        spe = (SAXParseException)s.getException();
                        annoteType = null;
                        if (s.getSeverity() == 2) {
                            annoteType = "org.eclipse.ui.workbench.texteditor.warning";
                        } else if (s.getSeverity() == 4) {
                            annoteType = "org.eclipse.ui.workbench.texteditor.error";
                        }
                        try {
                            provider.getAnnotationModel(input).addAnnotation(new Annotation(annoteType, false, spe.getMessage()), new Position(doc.getLineOffset(spe.getLineNumber() - 1)));
                        }
                        catch (Exception ex2) {
                            Activator.error(ex2.getMessage(), ex2);
                        }
                        ++var9_11;
                        continue;
                    }
lbl32:
                    // 1 sources

                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            monitor.setCanceled(true);
                            ErrorDialog errorDialog = new ErrorDialog(XMLEditor.this.getSite().getShell(), Messages.XMLEditor_14, ex.getMessage(), ex.getStatus(), 4);
                            errorDialog.open();
                        }
                    });
                    break block10;
                    catch (Exception ex) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.jdbc.editor", Messages.XMLEditor_15, (Throwable)ex), 2);
                    }
                }
            }
        };
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.busyCursorWhile(rwp);
        }
        catch (Exception ex) {
            Activator.error(ex.getMessage(), ex);
        }
    }

    public void dispose() {
        super.dispose();
    }
}

