/*
 * Decompiled with CFR 0.152.
 */
package com.indy.jdbc.editor;

import com.indy.jdbc.editor.Activator;
import com.indy.ui.sql.IConnectionProvider;
import com.stambia.md.MdNode;
import java.sql.Connection;
import javax.inject.Inject;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;

public class JDBCHelper {
    public static final JDBCHelper INSTANCE = new JDBCHelper();
    @Inject
    private IConnectionProvider connectionManager;

    private JDBCHelper() {
        IEclipseContext ctx = EclipseContextFactory.getServiceContext((BundleContext)Activator.getDefault().getBundle().getBundleContext());
        ContextInjectionFactory.inject((Object)this, (IEclipseContext)ctx);
    }

    public Connection createJDBCConnection(IConnectionProvider.IConnectionDescriptor desc) throws Exception {
        return this.connectionManager.createJDBCConnection(desc);
    }

    public Connection createJDBCConnection(MdNode mdNode) throws Exception {
        MdNode server = null;
        try {
            server = (MdNode)mdNode.evaluateXpathExpressionMdNode("INTERNAL_JDBC_SEVER_REF");
            if (server == null) {
                server = (MdNode)mdNode.evaluateMdNode("ancestor-or-self::*[name()='server'][1]");
            }
        }
        catch (XPathExpressionException e1) {
            e1.printStackTrace();
        }
        IConnectionProvider.IConnectionDescriptor desc = this.connectionManager.getConnectionDescriptor(server);
        return this.connectionManager.createJDBCConnection(desc);
    }
}

