/*
 * Decompiled with CFR 0.152.
 */
package com.indy.jdbc.editor.connection;

import com.indy.addons.Messages;
import com.indy.engine.core.module.IModuleService;
import com.indy.engine.core.module.classloader.StambiaClassLoaderRegistry;
import com.indy.jdbc.editor.JDBCHelper;
import com.indy.jdbc.editor.connection.ConnectionBean;
import com.indy.libraries.management.util.ModuleJDBCHelper;
import com.semarchy.xdi.designer.core.services.IBaseModuleProvider;
import com.semarchy.xdi.designer.core.services.IModuleClassLoaderProvider;
import com.stambia.md.MdNode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.ui.PlatformUI;

public class ConnectionController {
    private ConnectionBean bean = new ConnectionBean();
    private MdNode mdNode;
    private Connection connection;
    private ModuleJDBCHelper jdbcHelper = new ModuleJDBCHelper((IBaseModuleProvider)PlatformUI.getWorkbench().getService(IBaseModuleProvider.class), (IModuleService)PlatformUI.getWorkbench().getService(IModuleService.class));
    private List<ConnectionListener> listeners = new ArrayList<ConnectionListener>();

    public ConnectionController(MdNode node) {
        this.mdNode = node;
        this.bean.load(node, this.jdbcHelper);
    }

    public void addListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public ConnectionBean getBean() {
        return this.bean;
    }

    public void dispose() {
        if (this.connection != null) {
            try {
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.connection = null;
                }
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void validate() throws Exception {
        if (this.getBean().getModule() == null || this.getBean().getModule().isEmpty()) {
            throw new Exception(Messages.ConnectionController_0);
        }
        if (this.getBean().getDriver() == null || this.getBean().getDriver().isEmpty()) {
            throw new Exception(Messages.ConnectionController_1);
        }
        IModuleClassLoaderProvider moduleProvider = (IModuleClassLoaderProvider)PlatformUI.getWorkbench().getService(IModuleClassLoaderProvider.class);
        ClassLoader cl = moduleProvider.getClassLoader(StambiaClassLoaderRegistry.INSTANCE.getClassLoader("core"), this.getBean().getModule(), new IModuleClassLoaderProvider.ClassLoaderValidator(){

            public void checkClassLoader(ClassLoader toValidate) throws Exception {
                toValidate.loadClass(ConnectionController.this.getBean().getDriver());
            }
        });
        if (cl != null) {
            try {
                Class<?> clazz = cl.loadClass(this.getBean().getDriver());
            }
            catch (ClassNotFoundException ex) {
                throw new Exception(String.valueOf(Messages.ConnectionController_2) + this.getBean().getDriver());
            }
        }
    }

    public Connection connect() throws Exception {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        try {
            this.connection = JDBCHelper.INSTANCE.createJDBCConnection(this.bean);
            if (this.connection == null) {
                throw new SQLException(Messages.ConnectionController_3);
            }
            this.notifyListeners();
        }
        catch (ClassNotFoundException ex) {
            throw new Exception(Messages.ConnectionController_4, ex);
        }
        catch (Exception ex) {
            throw new Exception(Messages.ConnectionController_5, ex);
        }
        return this.connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public List<String> getModuleNames() {
        this.jdbcHelper.refreshModules(this.getBean().getModuleFilters());
        ArrayList<String> modules = new ArrayList<String>();
        for (ModuleJDBCHelper.ModuleDescription m : this.jdbcHelper.getModules()) {
            modules.add(m.getName());
        }
        return modules;
    }

    public List<String> getDriverNames() {
        HashSet r = new HashSet();
        for (ModuleJDBCHelper.ModuleDescription m : this.jdbcHelper.getModules()) {
            if (!m.getName().equals(this.bean.getModule())) continue;
            m.getJDBCProviders().forEach(j -> {
                boolean bl = r.add(j.getDriverClassName());
            });
            break;
        }
        ArrayList<String> l = new ArrayList<String>(r);
        Collections.sort(l);
        return l;
    }

    public List<String> getSampleURL(String moduleName, String driverName) {
        HashSet r = new HashSet();
        for (ModuleJDBCHelper.ModuleDescription m : this.jdbcHelper.getModules()) {
            if (!m.getName().equals(moduleName)) continue;
            for (IModuleService.IJDBCDriverDescriptor d : m.getJDBCProviders()) {
                if (!driverName.equals(d.getDriverClassName())) continue;
                r.addAll(d.getSamplesURLs());
            }
        }
        ArrayList<String> l = new ArrayList<String>(r);
        Collections.sort(l);
        return l;
    }

    public void applyChanges() {
        this.bean.apply(this.mdNode);
    }

    private void notifyListeners() {
        this.listeners.forEach(l -> l.handleConnectionChanged());
    }

    public static interface ConnectionListener {
        public void handleConnectionChanged();
    }
}

