/*
 * Decompiled with CFR 0.152.
 */
package com.indy.jdbc.properties;

import com.indy.addons.Messages;
import com.indy.jdbc.MdReverserNode;
import com.indy.jdbc.composite.SchemaDatastoreReverserComposite;
import com.indy.jdbc.editor.JDBCHelper;
import com.indy.md.ui.editor.ui.MdPropertyPage;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.custom.ReverseEvent;
import com.stambia.md.custom.ReverseListener;
import com.stambia.md.custom.Util;
import com.stambia.md.custom.exception.ReverseException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.service.log.LogService;

public class SchemaPropertiesPage
extends MdPropertyPage {
    Connection conn = null;
    private boolean scheduled = false;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private SchemaDatastoreReverserComposite composite;

    public void dispose() {
        super.dispose();
        if (this.conn != null && !this.scheduled) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
    }

    public boolean performOk() {
        block5: {
            if (this.composite != null && this.conn != null) {
                try {
                    if (this.conn.isClosed()) break block5;
                    final MessageConsole console = com.indy.ui.custom.out.Util.findConsole((String)Messages.SchemaPropertiesPage_0);
                    console.activate();
                    ReverseListener listener = new ReverseListener(){

                        public void objectReverseStart(ReverseEvent event) throws ReverseException {
                            String msg = String.valueOf(Messages.SchemaPropertiesPage_1) + event.objectType + " : " + event.data;
                            if (event.monitor != null) {
                                event.monitor.subTask(msg);
                            }
                            try {
                                Throwable throwable = null;
                                Object var4_6 = null;
                                try (MessageConsoleStream stream = console.newMessageStream();){
                                    stream.println(msg);
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (IOException e) {
                                SchemaPropertiesPage.this.logger.warn("Exception while closing stream", (Throwable)e);
                            }
                        }

                        public void reverseStart(ReverseEvent event) throws ReverseException {
                            if (event.monitor != null) {
                                event.monitor.beginTask(event.objectType, ((Object[])event.data).length);
                            }
                        }

                        public void objectReverseEnd(ReverseEvent event) throws ReverseException {
                            if (event.monitor != null) {
                                event.monitor.worked(1);
                            }
                        }
                    };
                    try {
                        final MdReverserNode reverser = this.composite.reverse(listener);
                        final MdNode n = this.composite.getSchema();
                        final String filter = this.composite.getFilter().getText();
                        MdReverserNode.ReverseJob job = new MdReverserNode.ReverseJob(n){

                            protected IStatus run(IProgressMonitor monitor) {
                                this.startJob();
                                try {
                                    reverser.performReverse(monitor);
                                    Attribute attr = Util.getOrCreateAttributeByCode((Configuration)n, (String)"com.stambia.rdbms.schema.dataStoreFilter");
                                    if (monitor.isCanceled()) {
                                        IStatus iStatus = Status.CANCEL_STATUS;
                                        return iStatus;
                                    }
                                    try {
                                        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)attr);
                                        ted.getCommandStack().execute((Command)new SetCommand((EditingDomain)ted, (EObject)attr, (EStructuralFeature)MdPackage.eINSTANCE.getAttribute_Value(), (Object)filter));
                                    }
                                    catch (Exception e) {
                                        Status status = new Status(4, "com.indy.addons", Messages.SchemaPropertiesPage_5, (Throwable)e);
                                        return status;
                                    }
                                }
                                finally {
                                    if (SchemaPropertiesPage.this.conn != null) {
                                        try {
                                            SchemaPropertiesPage.this.conn.close();
                                        }
                                        catch (SQLException e) {
                                            SchemaPropertiesPage.this.logger.warn("Exception while closing connection", (Throwable)e);
                                        }
                                    }
                                    this.stopJob();
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.setUser(true);
                        job.schedule();
                        this.scheduled = true;
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.SchemaPropertiesPage_6, (String)e.getMessage());
                        return false;
                    }
                }
                catch (SQLException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.SchemaPropertiesPage_7, (String)e.getMessage());
                    return false;
                }
            }
        }
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.composite = new SchemaDatastoreReverserComposite(parent, 4){

            @Override
            public Connection getConnection() {
                if (SchemaPropertiesPage.this.conn == null) {
                    try {
                        SchemaPropertiesPage.this.conn = JDBCHelper.INSTANCE.createJDBCConnection(SchemaPropertiesPage.this.getMdNode());
                        this.createReverseOptionsControls();
                    }
                    catch (Exception e) {
                        ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(SchemaPropertiesPage.class).error("Failed to connect", (Object)e);
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.SchemaPropertiesPage_8, (String)e.getMessage());
                    }
                }
                return SchemaPropertiesPage.this.conn;
            }

            @Override
            public MdNode getSchema() {
                return SchemaPropertiesPage.this.getMdNode();
            }

            @Override
            protected MdNode getServer() {
                try {
                    return (MdNode)SchemaPropertiesPage.this.getMdNode().evaluateMdNode("ancestor::server");
                }
                catch (XPathExpressionException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public void handePageComplete(boolean b) {
            }

            @Override
            public void handleEvent() {
            }
        };
        return this.composite;
    }

    public void setVisible(boolean visible) {
        try {
            String filter = this.composite.getSchema().evaluateMdString("@dataStoreFilter");
            this.composite.getFilter().setText(filter == null ? "" : filter);
            this.composite.setVisible(visible);
        }
        catch (XPathExpressionException e) {
            this.logger.warn("Unexpected", (Throwable)e);
        }
        super.setVisible(visible);
    }
}

