/*
 * Decompiled with CFR 0.152.
 */
package com.indy.jdbc.wizard;

import com.indy.addons.Messages;
import com.indy.addons.ScrolledCompositeWizardHelper;
import com.indy.jdbc.MdReverserNode;
import com.indy.jdbc.composite.SchemaDatastoreReverserComposite;
import com.indy.jdbc.composite.SchemaProperties1Composite;
import com.indy.jdbc.editor.connection.ConnectionDialog;
import com.indy.jdbc.wizard.MessageConsoleReverseListener;
import com.indy.jdbc.wizard.SelectiveWizardPage;
import com.indy.md.ui.editor.reverse.MdDiffNodeUI;
import com.indy.md.ui.editor.ui.MdWizard;
import com.indy.md.ui.editor.ui.MdWizardPage;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.MdRootNode;
import com.stambia.md.custom.AttributeRefResolver;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.ReverseEvent;
import com.stambia.md.custom.Util;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.util.MdFactoryHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.MessageConsole;

public class ServerWizard
extends MdWizard {
    private SchemaDatastoreReverserComposite compositeDataStore;
    private SchemaProperties1Composite composite;
    private SelectiveWizardPage selectivePage;
    private ConnectionDialog cad;
    MdWizardPage activePage;
    private MdWizardPage serverPage;
    private MdWizardPage schemaPage;
    private MdWizardPage dataStorePage;
    private Map<String, Boolean> reverseOptions = new HashMap<String, Boolean>();
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    MdNode schema;
    boolean schemaAlreadyExists = true;

    public void addPages() {
        this.reverseOptions.put("com.stambia.rdbms.datastore", true);
        this.setWindowTitle(Messages.ServerWizard_0);
        this.setNeedsProgressMonitor(true);
        this.serverPage = new MdWizardPage(Messages.ServerWizard_1, this.getNode()){

            public void setVisible(boolean visible) {
                if (visible) {
                    ServerWizard.this.activePage = ServerWizard.this.serverPage;
                }
                super.setVisible(visible);
            }

            public void createControl(Composite parent) {
                this.setPageComplete(false);
                ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite(parent);
                Composite contentComposite = new Composite((Composite)scrolled, 0);
                contentComposite.setLayout((Layout)new GridLayout());
                ServerWizard.this.cad = new ConnectionDialog(Display.getCurrent().getActiveShell(), "Create New Connection Profile", "", this.getNode()){

                    public void setErrorMessage(String newErrorMessage) {
                        ServerWizard.this.serverPage.setErrorMessage(newErrorMessage);
                    }

                    @Override
                    protected void handleConnectionOk() {
                        this.setPageComplete(true);
                    }

                    @Override
                    protected void handleDisconnectionOk() {
                        this.setPageComplete(false);
                    }
                };
                ServerWizard.this.cad.createDialog(contentComposite);
                ScrolledCompositeWizardHelper.adaptToContent(scrolled, contentComposite);
                this.setControl((Control)scrolled);
            }
        };
        this.serverPage.setTitle(Messages.ServerWizard_3);
        this.serverPage.setDescription(Messages.ServerWizard_4);
        this.addPage((IWizardPage)this.serverPage);
        this.schemaPage = new MdWizardPage(Messages.ServerWizard_5, this.getNode()){
            boolean lastComplete;

            public void setVisible(boolean visible) {
                if (!visible) {
                    this.lastComplete = this.isPageComplete();
                    this.setPageComplete(true);
                } else {
                    ServerWizard.this.activePage = ServerWizard.this.schemaPage;
                    this.setPageComplete(this.lastComplete);
                }
                super.setVisible(visible);
            }

            public void createControl(Composite parent) {
                this.setPageComplete(true);
                ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite(parent);
                ServerWizard.this.composite = new SchemaProperties1Composite((Composite)scrolled, 0, true){

                    @Override
                    public Connection getConnection() {
                        return ServerWizard.this.cad.getController().getConnection();
                    }

                    @Override
                    public MdNode getSchema() {
                        return ServerWizard.this.getSchema();
                    }

                    @Override
                    public void handleIsComplete(boolean complete) {
                        if (this.isVisible()) {
                            this.setPageComplete(complete);
                        } else {
                            this.setPageComplete(true);
                        }
                    }

                    @Override
                    public void handleConnectionChanged() {
                        this.getDisplay().syncExec(() -> ServerWizard.this.compositeDataStore.createReverseOptionsControls());
                    }
                };
                ServerWizard.this.cad.getController().addListener(() -> ServerWizard.this.composite.handleConnectionChanged());
                ServerWizard.this.composite.setLayoutData(new GridData(1808));
                ScrolledCompositeWizardHelper.adaptToContent(scrolled, ServerWizard.this.composite);
                this.setControl((Control)scrolled);
            }
        };
        this.schemaPage.setTitle(Messages.ServerWizard_6);
        this.schemaPage.setDescription(Messages.ServerWizard_7);
        this.addPage((IWizardPage)this.schemaPage);
        this.dataStorePage = new MdWizardPage(Messages.ServerWizard_8, this.getNode()){
            boolean lastComplete;

            public void setVisible(boolean visible) {
                if (!visible) {
                    this.lastComplete = this.isPageComplete();
                    this.setPageComplete(true);
                } else {
                    ServerWizard.this.activePage = ServerWizard.this.dataStorePage;
                    this.setPageComplete(this.lastComplete);
                }
                super.setVisible(visible);
            }

            public void createControl(Composite parent) {
                this.setPageComplete(true);
                ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite(parent);
                ServerWizard.this.compositeDataStore = new SchemaDatastoreReverserComposite((Composite)scrolled, 0){

                    @Override
                    public Connection getConnection() {
                        return ServerWizard.this.composite.getConnection();
                    }

                    @Override
                    public MdNode getSchema() {
                        return ServerWizard.this.composite.getSchema();
                    }

                    @Override
                    protected MdNode getServer() {
                        return this.getNode();
                    }

                    @Override
                    public void handePageComplete(boolean b) {
                        if (this.isVisible()) {
                            this.setPageComplete(b);
                        } else {
                            this.setPageComplete(true);
                        }
                    }

                    @Override
                    public void handleEvent() {
                    }
                };
                ScrolledCompositeWizardHelper.adaptToContent(scrolled, ServerWizard.this.compositeDataStore);
                this.setControl((Control)scrolled);
                ServerWizard.this.selectivePage.setCompositeDataStore(ServerWizard.this.compositeDataStore);
            }
        };
        this.dataStorePage.setTitle(Messages.ServerWizard_9);
        this.dataStorePage.setDescription(Messages.ServerWizard_10);
        this.addPage((IWizardPage)this.dataStorePage);
        this.selectivePage = new SelectiveWizardPage(Messages.MDWizard_1, this.getSchema());
        this.selectivePage.setDescription(Messages.MDWizard_1);
        this.selectivePage.setTitle(Messages.MDWizard_2);
        this.addPage((IWizardPage)this.selectivePage);
    }

    protected MdNode getSchema() {
        if (this.schema == null) {
            this.schemaAlreadyExists = false;
            this.schema = MdFactoryHelper.createMdNode((String)"com.stambia.rdbms.schema");
            Util.commandOnActiveTransaction((EObject)this.getNode(), (EStructuralFeature)MdPackage.eINSTANCE.getMdNode_Node(), (Object)this.schema, (int)1);
        }
        return this.schema;
    }

    public boolean performFinish() {
        this.cad.getController().applyChanges();
        if (this.activePage == this.serverPage && !this.schemaAlreadyExists) {
            Util.commandOnActiveTransaction((EObject)this.getNode(), (EStructuralFeature)MdPackage.eINSTANCE.getMdNode_Node(), (Object)this.schema, (int)2);
        } else {
            if (this.getContainer().getCurrentPage() == this.dataStorePage) {
                MessageConsole console = com.indy.ui.custom.out.Util.findConsole((String)"Reverse");
                console.activate();
                MessageConsoleReverseListener listener = new MessageConsoleReverseListener(console){

                    @Override
                    public String getMessage(ReverseEvent event) {
                        return Messages.bind((String)Messages.ServerWizard_13, (Object)event.objectType, (Object)event.data);
                    }
                };
                try {
                    final Connection conn = this.cad.getController().getConnection();
                    final MdNode n = this.getNode();
                    final MdReverserNode reverser = this.compositeDataStore.reverse(listener);
                    MdReverserNode.ReverseJob job = new MdReverserNode.ReverseJob(n){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                try {
                                    reverser.performReverse(monitor);
                                }
                                catch (ReverseException e) {
                                    Status status = new Status(4, "com.indy.addons", "Failed to reverse " + n.getName(), (Throwable)e);
                                    this.stopJob();
                                    if (conn != null) {
                                        try {
                                            conn.close();
                                        }
                                        catch (SQLException e2) {
                                            ServerWizard.this.logger.warn("Exception while closing connection", (Throwable)e2);
                                        }
                                    }
                                    return status;
                                }
                            }
                            finally {
                                this.stopJob();
                                if (conn != null) {
                                    try {
                                        conn.close();
                                    }
                                    catch (SQLException e) {
                                        ServerWizard.this.logger.warn("Exception while closing connection", (Throwable)e);
                                    }
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.startJob();
                    job.setUser(true);
                    job.schedule();
                }
                catch (ReverseException e) {
                    this.logger.warn("Reverse Exception", (Throwable)e);
                    return false;
                }
            }
            if (this.selectivePage == this.getContainer().getCurrentPage()) {
                block13: {
                    if (this.handleDiffViewerCheckState()) break block13;
                    return false;
                }
                try {
                    MdNode originalServiceNode = this.getNode();
                    while (!(originalServiceNode instanceof MdRootNode)) {
                        originalServiceNode = (MdNode)originalServiceNode.eContainer();
                    }
                    ArrayList<String> toDelete = new ArrayList<String>();
                    for (Map.Entry<String, Boolean> e : this.reverseOptions.entrySet()) {
                        if (e.getValue() != Boolean.TRUE) continue;
                        toDelete.add(e.getKey());
                    }
                    HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
                    MdDiffNodeUI.DiffState diffState = this.selectivePage.computeDiffState(null, toDelete);
                    MdNode newNode = diffState.getResultingMdNode();
                    if (newNode != null) {
                        reversedMap.put(newNode, this.compositeDataStore.getSchema());
                        TreeIterator it = newNode.eAllContents();
                        while (it.hasNext()) {
                            EObject o = (EObject)it.next();
                            if (!(o instanceof MdNode)) continue;
                            ((MdNode)o).setSubstituteContainer(null);
                        }
                        newNode.setSubstituteContainer(this.compositeDataStore.getSchema().eContainer());
                    }
                    AttributeRefResolver attributeRefResolver = this.selectivePage.getAttributeRefResolver();
                    IncrementalReverser ir = new IncrementalReverser((EObject)originalServiceNode, reversedMap, Collections.emptyList(), true, attributeRefResolver, this.reverseOptions, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, this.isCreation());
                    ir.reverse();
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.ServerWizard_14, (String)e.getMessage());
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean handleDiffViewerCheckState() {
        if (this.selectivePage.getCheckedElementsCount() == 0) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ServerWizard_15, (String)Messages.ServerWizard_16);
        }
        return true;
    }

    public boolean performCancel() {
        Connection conn = this.cad.getController().getConnection();
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.logger.warn("Exception while closing connection", (Throwable)e);
            }
        }
        return super.performCancel();
    }

    public MdWizardPage getServerPage() {
        return this.serverPage;
    }

    public ConnectionDialog getCad() {
        return this.cad;
    }
}

