/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ant;

import com.indy.ant.Messages;
import com.semarchy.xdi.designer.core.services.IMdToXmlGenerator;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MdToXMLCallback
extends Task {
    private String modelURI;
    private String fileOutputFolder;
    private String confName;
    public String mode;

    public void setConfName(String confName) {
        this.confName = confName;
    }

    public void setModelURI(String modelURI) {
        this.modelURI = modelURI;
    }

    public void setOutputFolder(String fileOutputFolder) {
        this.fileOutputFolder = fileOutputFolder;
    }

    public void execute() throws BuildException {
        block13: {
            IMdToXmlGenerator generator = (IMdToXmlGenerator)E4InjectorHelper.getService(IMdToXmlGenerator.class);
            if (generator == null) {
                this.log(Messages.MdToXMLCallback_0, 0);
            }
            String stambiaRuntimeHome = this.getProject().getBaseDir().getPath();
            File f = new File(this.fileOutputFolder != null ? this.fileOutputFolder : String.valueOf(stambiaRuntimeHome) + "build/tmp/wrk3");
            try {
                File propFile;
                this.log(String.format(Messages.MdToXMLCallback_1, this.modelURI, f.getAbsolutePath(), this.confName));
                IMdToXmlGenerator.Result res = generator.generateXML(f, this.modelURI, this.confName);
                if (res == null || res.getUDFSourceMap().isEmpty() || !(propFile = new File(String.valueOf(this.getProject().getProperty("work1.dir")) + "/" + this.getProject().getProperty("properties.file.name"))).exists()) break block13;
                this.log(String.valueOf(Messages.MdToXMLCallback_2) + propFile.getAbsolutePath());
                Properties props = new Properties();
                try (InputStreamReader reader = null;){
                    reader = new FileReader(propFile);
                    props.load(reader);
                }
                for (String udfModelID : res.getUDFSourceMap().keySet()) {
                    String path = ((File)res.getUDFSourceMap().get(udfModelID)).getAbsolutePath();
                    path = path.replace("\\", File.separator).replace("/", File.separator);
                    path = path.replace(String.valueOf(File.separator) + "wrk1" + File.separator, String.valueOf(File.separator) + "wrk2" + File.separator);
                    props.put("udfModelId." + udfModelID, path);
                }
                try (OutputStreamWriter writer = null;){
                    writer = new FileWriter(propFile);
                    props.store(writer, "");
                }
            }
            catch (Exception ex) {
                this.log(Messages.MdToXMLCallback_3, ex, 0);
                if (ex.getCause() != null) {
                    throw new BuildException(ex.getCause().getMessage(), ex.getCause());
                }
                throw new BuildException(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

