/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ant;

import com.indy.xsl.gene.process.internal.OneProcCompilation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PackageManifest {
    @XmlAttribute
    private String version = "1.1.2";
    @XmlAttribute
    private Type type;
    @XmlElement
    private String packageId;
    @XmlElement(name="packageDate")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date generationDate;
    @XmlElement
    private boolean containsDocumentation;
    @XmlElement
    private boolean containsSources;
    @XmlElement
    private String configurationName;
    @XmlElement
    private String user;
    @XmlElement(name="systemInfo")
    private SystemInfo systemInfo = new SystemInfo();
    @XmlElement(name="mainProcess")
    private List<MainProcess> deliveriesProcesses = new ArrayList<MainProcess>();
    @XmlElement(name="source")
    private List<SourceEntry> sources = new ArrayList<SourceEntry>();

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public Date getGenerationDate() {
        return this.generationDate;
    }

    public List<MainProcess> getDeliveriesProcesses() {
        return this.deliveriesProcesses;
    }

    public void setGenerationDate(Date generationDate) {
        this.generationDate = generationDate;
    }

    public List<SourceEntry> getSources() {
        return this.sources;
    }

    public void setSources(List<SourceEntry> sources) {
        this.sources = sources;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public SourceEntry findSource(String srcPath) {
        for (SourceEntry s : this.sources) {
            if (!s.path.equals(srcPath)) continue;
            return s;
        }
        return null;
    }

    public boolean isContainsDocumentation() {
        return this.containsDocumentation;
    }

    public void setContainsDocumentation(boolean containsDocumentation) {
        this.containsDocumentation = containsDocumentation;
    }

    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public boolean isContainsSources() {
        return this.containsSources;
    }

    public void setContainsSources(boolean containsSources) {
        this.containsSources = containsSources;
    }

    public static class DateAdapter
    extends XmlAdapter<String, Date> {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

        public Date unmarshal(String v) throws Exception {
            return this.sdf.parse(v);
        }

        public String marshal(Date v) throws Exception {
            return this.sdf.format(v);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class MainProcess {
        @XmlAttribute(name="id")
        String processId;
        @XmlAttribute
        String name;
        @XmlAttribute
        String deliveryChecksum;
        @XmlElement
        List<String> requiredModels = new ArrayList<String>();
        @XmlElementWrapper(name="moduleRequirement")
        @XmlElement(name="module")
        List<ModuleRequirment> requiredModules = new ArrayList<ModuleRequirment>();

        public String getProcessId() {
            return this.processId;
        }

        public void setProcessId(String processId) {
            this.processId = processId;
        }

        public void setDeliveryChecksum(String checksum) {
            this.deliveryChecksum = checksum;
        }

        public String getDeliveryChecksum() {
            return this.deliveryChecksum;
        }

        public List<String> getRequiredModels() {
            return this.requiredModels;
        }

        public List<ModuleRequirment> getRequiredModules() {
            return this.requiredModules;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ModuleRequirment {
        @XmlAttribute
        String baseModuleId;
        @XmlAttribute
        String moduleName;

        public ModuleRequirment() {
        }

        public ModuleRequirment(String baseModuleId, String moduleName) {
            this.baseModuleId = baseModuleId;
            this.moduleName = moduleName;
        }

        public String getBaseModuleId() {
            return this.baseModuleId;
        }

        public void setBaseModuleId(String baseModuleId) {
            this.baseModuleId = baseModuleId;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class SourceEntry {
        @XmlAttribute(name="path")
        String path;
        @XmlAttribute(name="id")
        String sourceId;
        @XmlAttribute(name="md5Sum")
        String sourceChecksum;

        public SourceEntry() {
        }

        public SourceEntry(String sourceId, String sourceChecksum, String path) {
            this.sourceId = sourceId;
            this.sourceChecksum = sourceChecksum;
            this.path = path.replace("\\", "/");
            if (!path.startsWith("/")) {
                this.path = "/" + this.path;
            }
            this.path = OneProcCompilation.unformatURI((String)this.path);
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public String getSourceChecksum() {
            return this.sourceChecksum;
        }

        public String getPath() {
            return this.path;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class SystemInfo {
        String designerVersion;
        String designerReleaseVersion;
        String runtimeName = System.getProperty("java.runtime.name");
        String runtimeVersion = System.getProperty("java.runtime.version");
        String specificationName = System.getProperty("java.specification.name");
        String specificationVersion;
        String specificationVendor = System.getProperty("java.specification.vendor");
        String vendor;
        String version;
        String os;
        String ws;
        String arch;
        String name;

        public SystemInfo() {
            this.specificationVersion = System.getProperty("java.specification.version");
            this.vendor = System.getProperty("java.vendor");
            this.version = System.getProperty("java.version");
            this.name = System.getProperty("os.name");
        }

        public void setOs(String os) {
            this.os = os;
        }

        public void setWs(String ws) {
            this.ws = ws;
        }

        public void setArch(String arch) {
            this.arch = arch;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDesignerVersion(String designerVersion) {
            this.designerVersion = designerVersion;
        }

        public void setDesignerReleaseVersion(String designerReleaseVersion) {
            this.designerReleaseVersion = designerReleaseVersion;
        }
    }

    public static enum Type {
        Package;

    }
}

