/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.custom;

import com.stambia.md.Attribute;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.custom.AttributeRefResolver;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.custom.reverse.AttributeMatchingVisitor;
import com.stambia.md.custom.reverse.AttributeUpdateCommandFactory;
import com.stambia.md.custom.reverse.MdMatchingVisitor;
import com.stambia.md.util.MdAttributeNativeEvaluator;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.md.util.MdNodeInitializer;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.ExceptionHandler;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class IncrementalReverser {
    Map<MdNode, MdNode> replacement;
    Map<String, Boolean> incrementalDeleteLvlDefType = Collections.EMPTY_MAP;
    Map<String, IReverseMatchingStrategy> reverseModePerLvlDefType;
    IReverseMatchingStrategy defaultReverseMode;
    List<String> excludeAttributeToUpdate;
    boolean updateName;
    AttributeRefResolver attributeRefResolver;
    boolean deleteOldAttributes = false;
    private EObject rootCurrentModel;
    ReverserExceptionHandler errorHandler = new ReverserExceptionHandler();
    Map<Attribute, MdNode> attributeToResolve = new HashMap<Attribute, MdNode>();

    public IncrementalReverser(EObject rootMd, Map<MdNode, MdNode> reversedNodes, List<String> excludeAttributeToUpdate, boolean updateName, AttributeRefResolver attributeRefResolver, Map<String, Boolean> incrementalDelete, IReverseMatchingStrategy defaultReverseMode, Map<String, IReverseMatchingStrategy> reverseMode, boolean deleteOldAttributes) {
        this.attributeRefResolver = attributeRefResolver;
        this.excludeAttributeToUpdate = excludeAttributeToUpdate;
        this.updateName = updateName;
        this.replacement = reversedNodes;
        if (incrementalDelete != null) {
            this.incrementalDeleteLvlDefType = incrementalDelete;
        }
        this.deleteOldAttributes = deleteOldAttributes;
        this.rootCurrentModel = rootMd;
        this.defaultReverseMode = defaultReverseMode;
        this.reverseModePerLvlDefType = reverseMode;
    }

    private void cleanReversedObject(List<MdNode> result) {
        if (result.size() > 0) {
            for (MdNode node : new ArrayList<MdNode>(result)) {
                node.setSubstituteContainer(null);
                this.cleanReversedObject((List<MdNode>)node.getNode());
            }
        }
    }

    public void reverse() throws ReverseException {
        MdMatchingVisitor visitor = new MdMatchingVisitor(this.defaultReverseMode, this.reverseModePerLvlDefType);
        try {
            visitor.accept(this.replacement);
            CompoundCommand cc = new CompoundCommand("Incremental Reverse");
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.rootCurrentModel);
            Collection toDelete = visitor.getNodesToDelete().stream().filter(n -> this.incrementalDeleteLvlDefType.get(n.getDefType()) == Boolean.TRUE).collect(Collectors.toList());
            if (!toDelete.isEmpty()) {
                cc.append((Command)new DeleteCommand((EditingDomain)editingDomain, toDelete));
            }
            Map<MdNode, Collection<MdNode>> toAdd = visitor.getNodesToAddByParent();
            for (MdNode k : toAdd.keySet()) {
                cc.append(this.createAddCommand((EditingDomain)editingDomain, k, toAdd.get(k)));
            }
            Map<MdNode, MdNode> toUpdate = visitor.getNodesToUpdate();
            toUpdate.keySet().forEach(arg_0 -> this.lambda$1(cc, toUpdate, (EditingDomain)editingDomain, arg_0));
            Command cmd = this.createAttributeResolutionCommand((EditingDomain)editingDomain);
            if (cmd != null) {
                cc.append(cmd);
            }
            ((TransactionalCommandStack)editingDomain.getCommandStack()).setExceptionHandler((ExceptionHandler)this.errorHandler);
            editingDomain.getCommandStack().execute((Command)cc);
            this.cleanReversedObject(toAdd.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList()));
        }
        catch (Exception ex) {
            throw new ReverseException(ex);
        }
    }

    private void searchRefAttributes(MdNode newNode) {
        if (this.attributeRefResolver != null) {
            for (Attribute attr : newNode.getAttribute()) {
                if (attr.getTechProperty() == null) continue;
                if (attr.getTechProperty().getType().equals((Object)PropertyType.REFERENCE)) {
                    this.attributeToResolve.put(attr, newNode);
                    continue;
                }
                if (attr.getTechProperty().getReverseUpdateXpathQuery() == null || attr.getTechProperty().getReverseUpdateXpathQuery().isEmpty()) continue;
                this.attributeToResolve.put(attr, newNode);
            }
            for (MdNode child : newNode.getNode()) {
                this.searchRefAttributes(child);
            }
        }
    }

    private Command createAddCommand(EditingDomain domain, MdNode owner, Collection<MdNode> newNodes) {
        CompoundCommand cc = new CompoundCommand();
        cc.append((Command)new AddCommand(domain, (EObject)owner, (EStructuralFeature)MdPackage.eINSTANCE.getMdNode_Node(), newNodes));
        for (MdNode n : newNodes) {
            MdNode rootModel = null;
            if (this.rootCurrentModel instanceof MdNode) {
                rootModel = (MdNode)this.rootCurrentModel;
            } else if (this.rootCurrentModel instanceof DocumentRoot) {
                rootModel = ((DocumentRoot)this.rootCurrentModel).getNode();
            }
            Command cmd = MdNodeInitializer.initializeCommand(domain, n, rootModel);
            if (cmd != null) {
                cc.append(cmd);
            }
            this.searchRefAttributes(n);
        }
        if (cc.isEmpty()) {
            return IdentityCommand.INSTANCE;
        }
        return cc;
    }

    private Command createUpdateCommand(MdNode current, MdNode newNode, EditingDomain domain) {
        Collection toDelete;
        CompoundCommand cc = new CompoundCommand();
        AttributeMatchingVisitor visitor = new AttributeMatchingVisitor();
        visitor.accept(newNode, current);
        if (this.deleteOldAttributes && !(toDelete = (Collection)visitor.getToDelete().stream().filter(a -> this.excludeAttributeToUpdate == null || !this.excludeAttributeToUpdate.contains(a.getDefType())).collect(Collectors.toList())).isEmpty()) {
            cc.append((Command)new RemoveCommand(domain, (EObject)current, (EStructuralFeature)MdPackage.eINSTANCE.getConfiguration_Attribute(), toDelete));
        }
        Map<Attribute, Attribute> toUpdate = visitor.getToUpdate();
        Set keys = toUpdate.keySet().stream().filter(a -> this.excludeAttributeToUpdate == null || !this.excludeAttributeToUpdate.contains(a.getDefType())).collect(Collectors.toSet());
        if (this.updateName) {
            cc.append((Command)new SetCommand(domain, (EObject)current, (EStructuralFeature)MdPackage.eINSTANCE.getElement_Name(), (Object)newNode.getName()));
        }
        for (Attribute a2 : keys) {
            Attribute newAtt;
            AttributeUpdateCommandFactory.UpdateAttributeResult res = AttributeUpdateCommandFactory.INSTANCE.updateAttribute(domain, a2, newAtt = toUpdate.get(a2), this.updateName, this.errorHandler);
            Command cmd = res.getCommand();
            if (cmd != null) {
                cc.append(cmd);
            }
            res.getToResolve().forEach(c -> {
                MdNode mdNode2 = this.attributeToResolve.put((Attribute)c, current);
            });
        }
        ArrayList<Attribute> attributesToAdd = new ArrayList<Attribute>();
        for (Attribute att : visitor.getToCreate()) {
            Attribute newAttr = MdFactoryHelper.createAttribute(att.getDefType());
            newAttr.setValue(att.getValue());
            newAttr.setRef(att.getRef());
            newAttr.getRefs().clear();
            newAttr.getValues().clear();
            newAttr.getValueEntry().clear();
            newAttr.getValueEntry().putAll(att.getValueEntry());
            newAttr.getRefs().addAll(att.getRefs());
            newAttr.getValues().addAll(att.getValues());
            attributesToAdd.add(newAttr);
            if (att.getRef() == null && att.getRefs().isEmpty()) continue;
            this.attributeToResolve.put(newAttr, current);
        }
        if (!attributesToAdd.isEmpty()) {
            cc.append((Command)new AddCommand(domain, (EObject)current, (EStructuralFeature)MdPackage.eINSTANCE.getConfiguration_Attribute(), attributesToAdd));
        }
        if (cc.isEmpty()) {
            return IdentityCommand.INSTANCE;
        }
        return cc;
    }

    private Command createAttributeResolutionCommand(EditingDomain editingDomain) {
        if (this.attributeRefResolver == null || this.attributeToResolve.isEmpty()) {
            return null;
        }
        RecordingCommand rc = new RecordingCommand((TransactionalEditingDomain)editingDomain){

            protected void doExecute() {
                for (Attribute a : IncrementalReverser.this.attributeToResolve.keySet()) {
                    List<Object> list = null;
                    try {
                        list = IncrementalReverser.this.attributeRefResolver.resolve(IncrementalReverser.this.attributeToResolve.get(a), a);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (list == null) continue;
                    Property property = a.getTechProperty();
                    if (property.getType().equals((Object)PropertyType.REFERENCE)) {
                        if (property.isUnbounded()) {
                            a.getRefs().clear();
                            a.getRefs().addAll(list);
                            continue;
                        }
                        MdNode ref = (MdNode)(list.size() == 0 ? null : list.get(0));
                        if (a.getRef() == ref) continue;
                        a.setRef(ref);
                        continue;
                    }
                    if (property.isUnbounded()) {
                        a.getValues().clear();
                        for (Object str : list) {
                            a.getValues().add((Object)str.toString());
                        }
                        continue;
                    }
                    String value = (String)(list.size() == 0 ? null : list.get(0));
                    if (a.getValue() != null && value != null && a.getValue().equals(value)) continue;
                    a.setValue(value);
                }
            }
        };
        return rc;
    }

    private /* synthetic */ void lambda$1(CompoundCommand compoundCommand, Map map, EditingDomain editingDomain, MdNode k) {
        compoundCommand.append(this.createUpdateCommand((MdNode)map.get(k), k, editingDomain));
    }

    public static enum DefaulteverseMatchingStrategy implements IReverseMatchingStrategy
    {
        ByPosition(new NodeMatcher(){

            @Override
            public boolean match(MdNode n1, MdNode n2) {
                return n1.getPosition() == null && n2.getPosition() == null || n1.getPosition() != null && n2.getPosition() != null && n2.getPosition().equals(n1.getPosition());
            }
        }),
        ByName(new NodeMatcher(){

            @Override
            public boolean match(MdNode n1, MdNode n2) {
                boolean samePosition;
                boolean sameName = n1.getName() != null && n2.getName() != null && n1.getName().equals(n2.getName());
                boolean nullName = !(n1.getName() != null && !n1.getName().isEmpty() || n2.getName() != null && !n2.getName().isEmpty());
                boolean bl = samePosition = n1.getPosition() == null && n2.getPosition() == null || n1.getPosition() != null && n2.getPosition() != null && n2.getPosition().equals(n1.getPosition());
                return sameName || nullName && samePosition;
            }
        }),
        ByAttribute(new NodeMatcher(){

            @Override
            public boolean match(MdNode n1, MdNode n2) {
                String attributeCode = (String)n1.getLevel().getHint().get((Object)ATTRIBUTE_CODE_KEY);
                String attributeValue1 = n1.getAttributeValueByShortCode(attributeCode);
                String attributeValue2 = n2.getAttributeValueByShortCode(attributeCode);
                return attributeValue1 != null && attributeValue2 != null && attributeValue1.equals(attributeValue2);
            }
        }),
        ByNaturalOrder(new NodeMatcher(){

            @Override
            public boolean match(MdNode n1, MdNode n2) {
                int secondIndex;
                int firstIndex = ((MdNode)n1.getSubstituteContainer()).getNode().indexOf((Object)n1);
                return firstIndex == (secondIndex = ((MdNode)n2.getSubstituteContainer()).getNode().indexOf((Object)n2));
            }
        }),
        ByOrderAmongstSiblingWithSameLevel(new NodeMatcher(){

            private int getIndexFromContainer(MdNode node) {
                ArrayList<MdNode> l1 = new ArrayList<MdNode>();
                MdNode parent = null;
                parent = node.eContainer() != null ? (MdNode)node.eContainer() : (MdNode)node.getSubstituteContainer();
                for (MdNode n : parent.getNode()) {
                    if (!n.getDefType().equals(node.getDefType())) continue;
                    l1.add(n);
                }
                return l1.indexOf(node);
            }

            @Override
            public boolean match(MdNode n1, MdNode n2) {
                int secondIndex;
                if (!n1.getDefType().equals(n2.getDefType())) {
                    return false;
                }
                int firstIndex = this.getIndexFromContainer(n1);
                return firstIndex == (secondIndex = this.getIndexFromContainer(n2));
            }
        });

        static String ATTRIBUTE_CODE_KEY;
        NodeMatcher matcher;

        static {
            ATTRIBUTE_CODE_KEY = "com.stambia.md.custom.IncrementalReverser.ReverseMode.attribute";
        }

        private DefaulteverseMatchingStrategy(NodeMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public NodeMatcher getMatcher() {
            return this.matcher;
        }
    }

    public static interface IReverseMatchingStrategy {
        public NodeMatcher getMatcher();
    }

    public static interface NodeMatcher {
        public boolean match(MdNode var1, MdNode var2);
    }

    public class ReverserExceptionHandler
    implements ExceptionHandler,
    MdAttributeNativeEvaluator.IExceptionHandler {
        @Override
        public void handleException(Throwable t) {
            t.printStackTrace();
        }

        public void handleException(Exception e) {
            e.printStackTrace();
        }
    }
}

