/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.custom;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.Element;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.custom.Messages;
import com.stambia.md.custom.xpath.MdNodeWrapper2;
import com.stambia.md.impl.MdPackageImpl;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import com.stambia.tech.Tech;
import com.stambia.tech.XpathExpression;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.IntStream;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class Util {
    public static final int SET_COMMAND = 0;
    public static final int ADD_COMMAND = 1;
    public static final int REMOVE_COMMAND = 2;

    public static List<MdNode> distinctMdNode(List<MdNode> list) {
        TreeMap<String, Boolean> keys = new TreeMap<String, Boolean>();
        ArrayList<MdNode> result = new ArrayList<MdNode>();
        for (MdNode node : list) {
            String type = node.getDefType();
            String name = node.getName();
            if (type == null || name == null || keys.get(String.valueOf(type) + name) != null) continue;
            keys.put(String.valueOf(type) + name, true);
            result.add(node);
        }
        return result;
    }

    public static Element findDeepElementById(EObject parent, String id) {
        if (parent instanceof Element) {
            Element elt = (Element)parent;
            if (elt.getId() != null && elt.getId().equals(id)) {
                return elt;
            }
            Element retour = null;
            for (EObject child : parent.eContents()) {
                retour = Util.findDeepElementById(child, id);
                if (retour == null) continue;
                return retour;
            }
        }
        return null;
    }

    public static List<URI> getAllTechBasedFile(Resource r) {
        ArrayList<URI> retour = new ArrayList<URI>();
        if (r != null) {
            if (r.getURI().fileExtension().equals("tech")) {
                retour.add(r.getURI());
            }
            if (r.getContents().size() > 0 && ((EObject)r.getContents().get(0)).eContents().size() > 0) {
                EObject eo;
                EObject first = (EObject)((EObject)r.getContents().get(0)).eContents().get(0);
                if (first instanceof MdNode) {
                    EObject eo2 = ((MdNode)first).getRef();
                    if (eo2 != null) {
                        if (!eo2.eIsProxy()) {
                            retour.addAll(Util.getAllTechBasedFile(eo2.eResource()));
                        } else {
                            try {
                                String fileID = CacheHelper.extractFileID((EObject)eo2);
                                URI refModelURI = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(fileID);
                                if (refModelURI != null) {
                                    Resource refResource = r.getResourceSet().getResource(refModelURI, true);
                                    retour.addAll(Util.getAllTechBasedFile(refResource));
                                }
                            }
                            catch (Exception fileID) {}
                        }
                    }
                } else if (first instanceof Tech && (eo = ((Tech)first).getRef()) != null) {
                    if (!eo.eIsProxy()) {
                        retour.addAll(Util.getAllTechBasedFile(eo.eResource()));
                    } else {
                        try {
                            String fileID = CacheHelper.extractFileID((EObject)eo);
                            URI refModelURI = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(fileID);
                            if (refModelURI != null) {
                                Resource refResource = r.getResourceSet().getResource(refModelURI, true);
                                retour.addAll(Util.getAllTechBasedFile(refResource));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return retour;
    }

    public static List<XpathExpression> getXpathExpressions(Configuration object) {
        Level level = object.getLevel();
        if (level == null) {
            return Collections.EMPTY_LIST;
        }
        return level.getXPathExpression();
    }

    public static List<XpathExpression> getglobalXpathExpressions(Configuration object) {
        if (object.getLevel() == null) {
            return Collections.EMPTY_LIST;
        }
        Tech tech = (Tech)object.getLevel().eContainer();
        return tech.getXPathExpression();
    }

    public static XpathExpression findXpathExpressions(Configuration object, String expressionName) {
        Level level = object.getLevel();
        if (level != null) {
            XpathExpression res = level.findXPathExpression(expressionName);
            if (res != null) {
                return res;
            }
            Tech tech = (Tech)object.getLevel().eContainer();
            res = tech.findXPathExpression(expressionName);
            return res;
        }
        for (XpathExpression xpathExpression : Util.getglobalXpathExpressions(object)) {
            if (!xpathExpression.getCode().contains((Object)QName.valueOf(expressionName))) continue;
            return xpathExpression;
        }
        return null;
    }

    public static Object retrieveMethod(String className, String bundleName, ParameterWrapper ... parameterTypes) throws ClassNotFoundException, InstantiationException, IllegalAccessException, BundleException {
        if (className != null && !className.isEmpty()) {
            Class c = null;
            if (bundleName != null && !bundleName.equals("")) {
                Bundle bundle = Platform.getBundle((String)bundleName);
                if (bundle == null) {
                    throw new BundleException(String.valueOf(Messages.Util_4) + bundleName);
                }
                c = bundle.loadClass(className);
            } else {
                c = Class.forName(className);
            }
            Object o = null;
            try {
                if (parameterTypes != null && parameterTypes.length > 0) {
                    Class[] types = new Class[parameterTypes.length];
                    Object[] values = new Object[parameterTypes.length];
                    IntStream.range(0, types.length).forEach(i -> {
                        classArray[i] = parameterTypes[i].parameterTypes;
                        objectArray[i] = parameterTypes[i].parameterValues;
                    });
                    try {
                        Constructor constructor = c.getConstructor(types);
                        o = constructor.newInstance(values);
                    }
                    catch (Exception e) {
                        o = c.newInstance();
                    }
                } else {
                    o = c.newInstance();
                }
            }
            catch (InstantiationException e) {
                System.err.println("Instanciation impossible");
                throw e;
            }
            catch (IllegalAccessException e) {
                System.err.println("Acc\ufffds impossible");
                throw e;
            }
            return o;
        }
        return null;
    }

    public static Property getPropertyByCode(Level level, String code) {
        if (level != null) {
            int i = 0;
            while (i < level.getAttribute().size()) {
                if (((Property)level.getAttribute().get(i)).getFullCode() != null && ((Property)level.getAttribute().get(i)).getFullCode().equals(code)) {
                    return (Property)level.getAttribute().get(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static Property getPropertyByXmlName(Level level, String xmlName) {
        if (level != null) {
            int i = 0;
            while (i < level.getAttribute().size()) {
                if (((Property)level.getAttribute().get(i)).getXmlName() != null && ((Property)level.getAttribute().get(i)).getXmlName().equals(xmlName)) {
                    return (Property)level.getAttribute().get(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static Attribute getAttributeByCode(Configuration node, String code) {
        int i = 0;
        while (i < node.getAttribute().size()) {
            if (((Attribute)node.getAttribute().get(i)).getDefType() != null && ((Attribute)node.getAttribute().get(i)).getDefType().equals(code)) {
                return (Attribute)node.getAttribute().get(i);
            }
            ++i;
        }
        return null;
    }

    @Deprecated
    public static Attribute getOrCreateAttributeByCode(Configuration node, String code) {
        Attribute attr = Util.getAttributeByCode(node, code);
        if (attr != null) {
            return attr;
        }
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)node);
        if (ted != null) {
            attr = MdFactoryHelper.createAttribute(code);
            AddCommand addCommand = new AddCommand((EditingDomain)ted, (EObject)node, (EStructuralFeature)MdPackageImpl.eINSTANCE.getConfiguration_Attribute(), (Object)attr);
            ted.getCommandStack().execute((Command)addCommand);
            return attr;
        }
        return null;
    }

    public static Property getPropertyByDisplayName(Level level, String displayName) {
        if (level != null) {
            int i = 0;
            while (i < level.getAttribute().size()) {
                if (((Property)level.getAttribute().get(i)).getDisplayName() != null && ((Property)level.getAttribute().get(i)).getDisplayName().equals(displayName)) {
                    return (Property)level.getAttribute().get(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static List<Property> getPropertyByReverseCode(Level level, String reverseCode) {
        ArrayList<Property> result = new ArrayList<Property>();
        int i = 0;
        while (i < level.getAttribute().size()) {
            if (((Property)level.getAttribute().get(i)).getReverseCode() != null && ((Property)level.getAttribute().get(i)).getReverseCode().equals(reverseCode)) {
                result.add((Property)level.getAttribute().get(i));
            }
            ++i;
        }
        return result;
    }

    public static void commandOnActiveTransaction(EObject owner, EStructuralFeature eStructuralFeature, Object value, int mode) {
        TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((EObject)owner);
        switch (mode) {
            case 1: {
                ed.getCommandStack().execute((Command)new AddCommand((EditingDomain)ed, owner, eStructuralFeature, value));
                break;
            }
            case 0: {
                ed.getCommandStack().execute((Command)new SetCommand((EditingDomain)ed, owner, eStructuralFeature, value));
                break;
            }
            case 2: {
                ed.getCommandStack().execute((Command)new RemoveCommand((EditingDomain)ed, owner, eStructuralFeature, value));
            }
        }
    }

    public static boolean isXpathConditionValided(Element context, String expression) {
        boolean result = false;
        String curConf = ((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).getCurrentConfigurationName();
        try {
            MdNodeWrapper2.useConf(false);
            if (expression != null && !expression.trim().equals("")) {
                Configuration _context = null;
                if (context instanceof Configuration) {
                    _context = (Configuration)context;
                } else if (context instanceof Attribute) {
                    _context = (Configuration)context.eContainer();
                }
                if (_context.eClass() == MdPackage.eINSTANCE.getConfiguration() && _context.getName() != null) {
                    MdNodeWrapper2.useConf(true);
                    ((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).setCurrentConfigurationName(_context.getName(), false);
                }
                if (_context != null) {
                    try {
                        result = _context.evaluateMdBoolean(expression);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else {
                result = true;
            }
        }
        finally {
            MdNodeWrapper2.useConf(true);
            ((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).setCurrentConfigurationName(curConf, false);
        }
        return result;
    }

    public static class ParameterWrapper {
        private Class parameterTypes;
        private Object parameterValues;

        public ParameterWrapper(Class parameterType, Object parameterValue) {
            this.parameterTypes = parameterType;
            this.parameterValues = parameterValue;
        }
    }
}

