/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.impl.custom;

import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.IMdNode;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.MdRootNode;
import com.stambia.md.Version;
import com.stambia.md.impl.custom.Messages;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.md.util.StbMdResourceImpl;
import com.stambia.tech.Action;
import com.stambia.tech.Level;
import com.stambia.tech.MappingInfo;
import com.stambia.tech.MappingType;
import com.stambia.tech.Property;
import com.stambia.tech.Tpl;
import com.stambia.tech.XpathExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.osgi.service.log.LogService;

public class MdNodeHelper
implements IMdNode {
    private MdNode mdNode;
    protected Object connection;

    MdNodeHelper(MdNode mdNode) {
        this.mdNode = mdNode;
    }

    @Override
    public boolean isSubMetaDataChildFile() {
        if (this.mdNode instanceof MdRootNode) {
            EObject parent;
            MdRootNode rn = (MdRootNode)this.mdNode;
            if (rn.getInternalVersion() == Version.V100) {
                return rn.isSubMd();
            }
            if (rn.eIsSet((EStructuralFeature)MdPackage.eINSTANCE.getMdNode_Ref()) && (parent = rn.getRef()) != null && parent instanceof MdNode && this.mdNode.getLevel() != null && !this.mdNode.getLevel().isIsFile() && ((MdNode)parent).getDefType().equals(this.mdNode.getDefType()) && this.mdNode.getLevel().isSubMetaDataFileCapability()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public MdNode getNodeByName(String defType, String name) {
        int i = 0;
        while (i < this.mdNode.getNode().size()) {
            if (name != null ? ((MdNode)this.mdNode.getNode().get(i)).getName() != null && ((MdNode)this.mdNode.getNode().get(i)).getDefType() != null && ((MdNode)this.mdNode.getNode().get(i)).getName().equals(name) && ((MdNode)this.mdNode.getNode().get(i)).getDefType().equals(defType) : ((MdNode)this.mdNode.getNode().get(i)).getName() == null && ((MdNode)this.mdNode.getNode().get(i)).getDefType() != null && ((MdNode)this.mdNode.getNode().get(i)).getDefType().equals(defType)) {
                return (MdNode)this.mdNode.getNode().get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public MdNode getNodeByPosition(String defType, int position) {
        int i = 0;
        while (i < this.mdNode.getNode().size()) {
            if (((MdNode)this.mdNode.getNode().get(i)).getDefType() != null && ((MdNode)this.mdNode.getNode().get(i)).getDefType().equals(defType) && ((MdNode)this.mdNode.getNode().get(i)).getPosition() != null && ((MdNode)this.mdNode.getNode().get(i)).getPosition().intValue() == position) {
                return (MdNode)this.mdNode.getNode().get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public List<MdNode> getNodeByCode(String code) {
        ArrayList<MdNode> result = new ArrayList<MdNode>();
        int i = 0;
        while (i < this.mdNode.getNode().size()) {
            if (((MdNode)this.mdNode.getNode().get(i)).getDefType() != null && ((MdNode)this.mdNode.getNode().get(i)).getDefType().equals(code)) {
                result.add((MdNode)this.mdNode.getNode().get(i));
            }
            ++i;
        }
        return result;
    }

    @Override
    public Attribute getAttributeByCode(String code) {
        for (Attribute attr : this.mdNode.getAttribute()) {
            if (attr.getDefType() == null || !attr.getDefType().equals(code)) continue;
            return attr;
        }
        return null;
    }

    @Override
    public Attribute getAttributeByMapInfo(MappingInfo mapInfo) {
        Level l = this.mdNode.getLevel();
        if (l != null) {
            for (Attribute attr : this.mdNode.getAttribute()) {
                Property prop = l.getAttributeByCode(attr.getDefType());
                if (prop == null || !prop.getMappingInfo().contains((Object)mapInfo)) continue;
                return attr;
            }
        }
        return null;
    }

    @Override
    public Configuration findConfiguration(String conf) {
        if (conf == null || conf.equals("Default")) {
            return this.mdNode;
        }
        for (Configuration obj : this.mdNode.getConfiguration()) {
            if (obj.getName() == null || !obj.getName().equals(conf)) continue;
            return obj;
        }
        return null;
    }

    @Override
    public Object getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(Object connection) {
        this.connection = connection;
    }

    @Override
    public List<Attribute> getAttribute(String configuration) {
        ArrayList<Object> list;
        Configuration conf;
        Object attrs = this.mdNode.getAttribute();
        if (configuration != null && !configuration.equals("Default") && (conf = this.mdNode.eClass() == MdPackage.eINSTANCE.getConfiguration() ? this.mdNode : this.mdNode.findConfiguration(configuration)) != null) {
            list = new ArrayList<Attribute>((Collection<Attribute>)conf.getAttribute());
            for (Attribute attr : attrs) {
                boolean found = false;
                for (Attribute attr2 : conf.getAttribute()) {
                    if (!attr2.getDefType().equals(attr.getDefType())) continue;
                    found = true;
                }
                if (found) continue;
                list.add(attr);
            }
            attrs = list;
        }
        if (this.isSubMetaDataChildFile()) {
            HashSet<String> set = new HashSet<String>();
            list = new ArrayList();
            List attrs2 = ((MdNode)this.mdNode.getRef()).getAttribute(configuration);
            for (Attribute attr : attrs) {
                Property prop = attr.getTechProperty();
                if (prop == null || !attr.hasValue(prop)) continue;
                list.add(attr);
                set.add(attr.getDefType());
            }
            for (Attribute attr : attrs2) {
                if (set.contains(attr.getDefType())) continue;
                list.add(attr);
            }
            attrs = list;
        }
        return attrs;
    }

    @Override
    public String getFullPath(boolean xmlName) {
        block9: {
            try {
                if (this.mdNode.getLevel() != null) break block9;
                return null;
            }
            catch (Exception ex) {
                if (xmlName && this.mdNode.getLevel() == null) {
                    ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.md.ui").error(String.format(Messages.MdNodeHelper_0, this.mdNode.getId(), this.mdNode.eResource()), (Object)ex);
                    return null;
                }
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        String name = "";
        if (xmlName) {
            name = String.valueOf(this.mdNode.getLevel().getXmlName()) + ":";
        }
        if (this.mdNode.getLevel().isHasName()) {
            name = String.valueOf(name) + this.mdNode.getName();
        } else if (this.mdNode.eContainer() instanceof MdNode) {
            name = String.valueOf(name) + Integer.toString(((MdNode)this.mdNode.eContainer()).getNode().indexOf((Object)this.mdNode));
        }
        if (this.mdNode.getSubstituteContainer() instanceof MdNode) {
            name = String.valueOf(((MdNode)this.mdNode.getSubstituteContainer()).getFullPath(xmlName)) + "/" + name;
        }
        return name;
    }

    @Override
    public MdNode getPreviousNode() {
        List list = ((MdNode)this.mdNode.eContainer()).getNodeByCode(this.mdNode.getDefType());
        Collections.sort(list, MdNode.comparator);
        boolean found = false;
        Object previous = null;
        for (Object child : list) {
            if (child.equals(this.mdNode)) {
                return previous;
            }
            previous = child;
        }
        return null;
    }

    @Override
    public MdNode getFollowingNode() {
        List list = ((MdNode)this.mdNode.eContainer()).getNodeByCode(this.mdNode.getDefType());
        Collections.sort(list, MdNode.comparator);
        boolean found = false;
        for (Object child : list) {
            if (child.equals(this.mdNode)) {
                found = true;
                continue;
            }
            if (!found) continue;
            return (MdNode)child;
        }
        return null;
    }

    @Override
    public List<Level> getChildrenLevel() {
        Resource r = this.mdNode.getSubstituteResource();
        if (r != null) {
            return ((StbMdResourceImpl)r).getChildrenLevel(this.mdNode);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Tpl> getExecutableTemplate() {
        StbMdResourceImpl r = (StbMdResourceImpl)this.mdNode.getSubstituteResource();
        if (r != null) {
            return r.getChildrenExecutableTemplate(this.mdNode);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Tpl> getSettableTemplate() {
        StbMdResourceImpl r = (StbMdResourceImpl)this.mdNode.getSubstituteResource();
        if (r != null) {
            return r.getChildrenSettableTemplate(this.mdNode);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Action> getExecutableAction() {
        StbMdResourceImpl r = (StbMdResourceImpl)this.mdNode.getSubstituteResource();
        if (r != null) {
            return r.getChildrenAction(this.mdNode);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public MdNode copy(int mode) {
        MdNode result = MdFactoryHelper.createMdNode(this.mdNode.getDefType());
        result.setName(this.mdNode.getName());
        result.setPosition(this.mdNode.getPosition());
        for (Attribute attr : this.mdNode.getAttribute()) {
            Attribute newAttr = MdFactoryHelper.createAttribute(attr.getDefType());
            newAttr.setValue(attr.getValue());
            newAttr.setRef(attr.getRef());
            newAttr.getRefs().clear();
            newAttr.getValues().clear();
            newAttr.getValueEntry().clear();
            newAttr.getValueEntry().putAll(attr.getValueEntry());
            newAttr.getRefs().addAll(attr.getRefs());
            newAttr.getValues().addAll(attr.getValues());
            result.getAttribute().add((Object)newAttr);
        }
        return result;
    }

    @Override
    public List<Level> getChangeToLevel() {
        Resource r = this.mdNode.getSubstituteResource();
        if (r != null) {
            ArrayList<Level> levels = new ArrayList<Level>();
            Level _lvl = this.mdNode.getLevel();
            if (_lvl != null) {
                for (String str : _lvl.getChangeTo()) {
                    Level level = ((StbMdResourceImpl)r).getLevel(str);
                    if (level == null) continue;
                    levels.add(level);
                }
            }
            return levels;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void setDefTypeWithTransaction(String code) throws IMdNode.InconsistencyException {
        String precCode = this.mdNode.getLevel().getCode();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)this.mdNode);
        CompoundCommand cc = new CompoundCommand();
        cc.append((Command)new SetCommand((EditingDomain)ted, (EObject)this.mdNode, (EStructuralFeature)MdPackage.eINSTANCE.getElement_DefType(), (Object)code));
        for (Attribute attr : this.mdNode.getAttribute()) {
            int i = attr.getDefType().indexOf(precCode);
            if (i <= -1) continue;
            String str = String.valueOf(code) + attr.getDefType().substring(precCode.length());
            cc.append((Command)new SetCommand((EditingDomain)ted, (EObject)attr, (EStructuralFeature)MdPackage.eINSTANCE.getElement_DefType(), (Object)str));
        }
        cc.append((Command)new UnsetLevelCmd());
        for (MdNode childNode : this.mdNode.getNode()) {
            if (childNode.getLevel().getParent().contains((Object)code)) continue;
            throw new IMdNode.InconsistencyException(String.format(Messages.MdNodeHelper_1, code));
        }
        ted.getCommandStack().execute((Command)cc);
    }

    @Override
    public void forceDefTypeWithTransaction(String code) {
        String precCode = this.mdNode.getLevel().getCode();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)this.mdNode);
        CompoundCommand cc = new CompoundCommand();
        for (MdNode childNode : this.mdNode.getNode()) {
            if (childNode.getLevel().getParent().contains((Object)code)) continue;
            cc.append((Command)new RemoveCommand((EditingDomain)ted, this.mdNode.getNode(), (Object)childNode));
        }
        cc.append((Command)new SetCommand((EditingDomain)ted, (EObject)this.mdNode, (EStructuralFeature)MdPackage.eINSTANCE.getElement_DefType(), (Object)code));
        for (Attribute attr : this.mdNode.getAttribute()) {
            int i = attr.getDefType().indexOf(precCode);
            if (i <= -1) continue;
            String str = String.valueOf(code) + attr.getDefType().substring(precCode.length());
            cc.append((Command)new SetCommand((EditingDomain)ted, (EObject)attr, (EStructuralFeature)MdPackage.eINSTANCE.getElement_DefType(), (Object)str));
        }
        cc.append((Command)new UnsetLevelCmd());
        ted.getCommandStack().execute((Command)cc);
    }

    @Override
    public Collection<MappingType> getMappingType() {
        ArrayList<MappingType> res = null;
        Level l = this.mdNode.getLevel();
        if (l != null) {
            block8: {
                XpathExpression expr = l.findXPathExpression("INTERNAL_MAPPING_TYPE");
                if (expr != null) {
                    try {
                        String values = this.mdNode.evaluateXpathExpressionCached("INTERNAL_MAPPING_TYPE", "");
                        if (values == null) break block8;
                        res = new ArrayList<MappingType>();
                        if (!values.isEmpty()) {
                            String[] stringArray = values.split(",");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String s = stringArray[n2];
                                try {
                                    res.add(MappingType.getByName((String)s.trim().toUpperCase()));
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                ++n2;
                            }
                        }
                        return res;
                    }
                    catch (XPathExpressionException e) {
                        e.printStackTrace();
                    }
                }
            }
            return l.getMappingType();
        }
        return null;
    }

    private class UnsetLevelCmd
    extends AbstractCommand {
        private UnsetLevelCmd() {
        }

        public void undo() {
            MdNodeHelper.this.mdNode.unsetLevel();
        }

        public void execute() {
            MdNodeHelper.this.mdNode.unsetLevel();
        }

        public void redo() {
            MdNodeHelper.this.mdNode.unsetLevel();
        }

        public boolean canExecute() {
            return true;
        }
    }
}

