/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.util;

import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.md.util.Messages;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import com.stambia.tech.Tech;
import java.util.ArrayList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.osgi.service.log.LogService;

public class MdNodeInitializer {
    public static void initialize(MdNode mdNode, Configuration context) {
        try {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)mdNode);
            Command cmd = MdNodeInitializer.initializeCommand((EditingDomain)domain, mdNode, context);
            if (cmd != null) {
                domain.getCommandStack().execute(cmd);
            }
        }
        catch (Exception ex) {
            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.md.ui").error(Messages.MdNodeInitializer_attributeInitialValue, (Object)ex);
        }
    }

    public static Command initializeCommand(EditingDomain domain, MdNode mdNode, Configuration context) {
        Level lvl = ((Tech)context.getLevel().eContainer()).getLevel(mdNode.getDefType());
        ArrayList<Attribute> toAdd = new ArrayList<Attribute>();
        for (Property p : lvl.getAttribute()) {
            if (p.getInitialValue() == null || p.getInitialValue().isEmpty()) continue;
            Attribute att = mdNode.getAttributeByShortCode(p.getCode());
            if (att == null) {
                att = MdFactoryHelper.createAttribute(String.valueOf(lvl.getCode()) + "." + p.getCode());
                if (p.isUnbounded()) {
                    att.getValues().add((Object)p.getInitialValue());
                } else {
                    att.setValue(p.getInitialValue());
                }
            }
            toAdd.add(att);
            if (domain == null) {
                mdNode.getAttribute().add((Object)att);
                continue;
            }
            toAdd.add(att);
        }
        if (!toAdd.isEmpty()) {
            return new AddCommand(domain, (EObject)mdNode, (EStructuralFeature)MdPackage.eINSTANCE.getConfiguration_Attribute(), toAdd);
        }
        return null;
    }

    public static void initialize(String defType, Configuration mdNode, Configuration context) {
        try {
            Level lvl = ((Tech)context.getLevel().eContainer()).getLevel(mdNode.getDefType());
            ArrayList<Attribute> toAdd = new ArrayList<Attribute>();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)mdNode);
            Property p = lvl.getAttributeByCode(defType);
            if (p != null) {
                Attribute att = null;
                if (p.supportDefaultValue()) {
                    att = mdNode.getAttributeByShortCode(p.getCode());
                    if (att == null) {
                        String defaultVal = null;
                        try {
                            defaultVal = MdAttributeReader.evaluateDefaultValue(p.getCode(), (MdNode)(mdNode instanceof MdNode ? mdNode : mdNode.eContainer()), mdNode instanceof MdNode ? null : mdNode.getName());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (defaultVal == null) {
                            defaultVal = "";
                        }
                        if (defaultVal != null) {
                            att = MdFactoryHelper.createAttribute(String.valueOf(lvl.getCode()) + "." + p.getCode());
                            att.setValue(defaultVal.toString());
                        }
                    }
                } else if (mdNode.eClass() == MdPackage.eINSTANCE.getConfiguration()) {
                    att = mdNode.getAttributeByShortCode(p.getCode());
                    if (att == null || !att.hasValue(p)) {
                        att = ((MdNode)mdNode.eContainer()).getAttributeByShortCode(p.getCode());
                        if ((att == null || !att.hasValue(p)) && ((MdNode)mdNode.eContainer()).isSubMetaDataChildFile()) {
                            att = ((MdNode)((MdNode)mdNode.eContainer()).getRef()).getAttributeByShortCode(p.getCode());
                        }
                        if (att != null) {
                            att = (Attribute)EcoreUtil.copy((EObject)att);
                            att.setId(EcoreUtil.generateUUID());
                        } else {
                            att = MdFactoryHelper.createAttribute(String.valueOf(lvl.getCode()) + "." + p.getCode());
                        }
                        if (!att.hasValue(p)) {
                            if (!p.isUnbounded()) {
                                if (mdNode.eClass() == MdPackage.eINSTANCE.getConfiguration()) {
                                    if (p.getType() == PropertyType.BOOLEAN) {
                                        Attribute aa = ((MdNode)mdNode.eContainer()).getAttributeByShortCode(p.getCode());
                                        if (aa == null) {
                                            att.setValue("false");
                                        } else {
                                            att.setValue(aa.getValue());
                                        }
                                    } else {
                                        att.setValue("newValue");
                                    }
                                } else {
                                    att.setValue("newValue");
                                }
                            } else {
                                att.getValues().add((Object)"newValue");
                            }
                        }
                    }
                } else if (mdNode instanceof MdNode && ((MdNode)mdNode).isSubMetaDataChildFile()) {
                    att = ((MdNode)((MdNode)mdNode).getRef()).getAttributeByShortCode(p.getCode());
                    if (att != null) {
                        att = (Attribute)EcoreUtil.copy((EObject)att);
                        att.setId(EcoreUtil.generateUUID());
                        if (!att.hasValue(p)) {
                            if (!p.isUnbounded()) {
                                att.setValue("newValue");
                            } else {
                                att.getValues().add((Object)"newValue");
                            }
                        }
                    } else {
                        att = MdFactoryHelper.createAttribute(String.valueOf(lvl.getCode()) + "." + p.getCode());
                        if (!p.isUnbounded()) {
                            att.setValue("newValue");
                        } else {
                            att.getValues().add((Object)"newValue");
                        }
                    }
                } else if (mdNode instanceof MdNode && (att = ((MdNode)mdNode).getAttributeByShortCode(p.getCode())) == null) {
                    att = MdFactoryHelper.createAttribute(String.valueOf(lvl.getCode()) + "." + p.getCode());
                    if (!p.isUnbounded() && p.getType() != PropertyType.REFERENCE) {
                        if (p.getType() == PropertyType.BOOLEAN) {
                            att.setValue("false");
                        } else {
                            att.setValue("");
                        }
                    }
                }
                if (att != null) {
                    toAdd.add(att);
                    if (domain == null) {
                        mdNode.getAttribute().add((Object)att);
                    } else {
                        toAdd.add(att);
                    }
                }
            }
            if (!toAdd.isEmpty()) {
                domain.getCommandStack().execute((Command)new AddCommand((EditingDomain)domain, (EObject)mdNode, (EStructuralFeature)MdPackage.eINSTANCE.getConfiguration_Attribute(), toAdd));
            }
        }
        catch (Exception ex) {
            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.md.ui").error(Messages.MdNodeInitializer_attributeInitialValue, (Object)ex);
        }
    }
}

