/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.util;

import com.semarchy.xdi.designer.core.services.registry.ReferencableObject;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdNode;
import com.stambia.md.MdRootNode;
import com.stambia.md.util.StbMdResourceImpl;
import com.stambia.tech.XpathExpression;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ReferencableObjectFactory {
    public List<ReferencableObject> createReferencableObject(StbMdResourceImpl resource) throws Exception {
        MdRootNode main = ((DocumentRoot)resource.getContents().get(0)).getNode();
        ArrayList<ReferencableObject> res = new ArrayList<ReferencableObject>();
        TreeIterator it = main.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof MdNode)) {
                it.prune();
                continue;
            }
            MdNode node = (MdNode)obj;
            XpathExpression xpeFinal = ReferencableObjectFactory.findReferenceableExpression(node);
            if (xpeFinal == null || !node.evaluateXpathExpressionBooleanCached(new String[]{"INTERNAL_REFERENCEABLE_REGISTRY"})) continue;
            ReferencableObject r = new ReferencableObject(EcoreUtil.getURI((EObject)obj), ((MdNode)obj).getDefType());
            res.add(r);
        }
        return res;
    }

    public static XpathExpression findReferenceableExpression(MdNode node) {
        if (node == null || node.getLevel() == null) {
            return null;
        }
        XpathExpression xpe = node.getLevel().findXPathExpression("INTERNAL_REFERENCEABLE_REGISTRY");
        if (xpe != null && xpe.getExpression() != null && !xpe.getExpression().trim().isEmpty()) {
            return xpe;
        }
        return null;
    }
}

