/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.util;

import com.semarchy.xdi.designer.core.models.IWithDisposable;
import com.semarchy.xdi.designer.core.models.IndyXMLResource;
import com.semarchy.xdi.designer.core.models.OutdatedModelDiagnostic;
import com.semarchy.xdi.designer.core.services.IRegistryHelper;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.registry.ICrossReference;
import com.semarchy.xdi.designer.core.services.registry.LevelCodeInfo;
import com.semarchy.xdi.designer.core.services.registry.ModuleRequirment;
import com.semarchy.xdi.designer.core.services.registry.ProcessToolDescriptor;
import com.semarchy.xdi.designer.core.services.registry.ReferencableObject;
import com.semarchy.xdi.designer.core.services.registry.RuntimeEngine;
import com.semarchy.xdi.designer.core.services.registry.StagingAreaDescriptor;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.DocumentRoot;
import com.stambia.md.Element;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.MdRootNode;
import com.stambia.md.Version;
import com.stambia.md.util.AutomaticEmptyAttributeUpgrader;
import com.stambia.md.util.MdXMLHandler;
import com.stambia.md.util.Messages;
import com.stambia.md.util.ModuleRequirmentFactory;
import com.stambia.md.util.ProcessToolFactory;
import com.stambia.md.util.ReferencableObjectFactory;
import com.stambia.md.util.RuntimeEngineFactory;
import com.stambia.md.util.StageAreaDescriptorFactory;
import com.stambia.md.util.TechMerger;
import com.stambia.md.util.UDFFactory;
import com.stambia.tech.Action;
import com.stambia.tech.Level;
import com.stambia.tech.MappingType;
import com.stambia.tech.Tech;
import com.stambia.tech.Tpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.DOMHandler;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.w3c.dom.Document;
import org.xml.sax.helpers.DefaultHandler;

public class StbMdResourceImpl
extends IndyXMLResource
implements IRegistryService.IRegistrationContribution,
IWithDisposable {
    private static final String REGISTRY_EXTRACTION_FAILURE_MESSAGE = Messages.StbMdResourceImpl_0;
    Map<String, Level> levelMap = new TreeMap<String, Level>();
    private Map<String, List<Level>> childrenLevelMap = new TreeMap<String, List<Level>>();
    private Map<String, List<Action>> childrenActionMap = new TreeMap<String, List<Action>>();
    private Map<String, List<Tpl>> childrenSettableTemplateMap = new TreeMap<String, List<Tpl>>();
    private Map<String, List<Tpl>> childrenExecutableTemplateMap = new TreeMap<String, List<Tpl>>();
    private TechMerger merger = new TechMerger((Resource)this);
    List<IWithDisposable.IDisposable> disposables;
    private static final String REGISTRY_FILTER_REGEX = "\\[([^\\]]+)\\]";
    private static final Pattern REGISTRY_FILTER_PATTERN = Pattern.compile("\\[([^\\]]+)\\]");

    public void releaseDisposable() {
        List<IWithDisposable.IDisposable> list = this.getDisposable();
        if (list != null) {
            for (IWithDisposable.IDisposable disposable : list) {
                disposable.dispose();
            }
            list.clear();
            list = null;
        }
        if (this.isLoaded()) {
            this.getIntrinsicIDToEObjectMap().clear();
            this.setIntrinsicIDToEObjectMap(null);
            this.levelMap.clear();
            this.levelMap = null;
            this.childrenLevelMap.clear();
            this.childrenLevelMap = null;
            this.childrenActionMap.clear();
            this.childrenActionMap = null;
            this.childrenSettableTemplateMap.clear();
            this.childrenSettableTemplateMap = null;
            this.childrenExecutableTemplateMap.clear();
            this.childrenExecutableTemplateMap = null;
            this.merger.clear();
        }
    }

    protected void doUnload() {
        this.releaseDisposable();
        super.doUnload();
    }

    public StbMdResourceImpl(URI uri) {
        super(uri);
    }

    private URI getCrossRefResourceURI() {
        String lastSegment = this.getURI().trimFileExtension().lastSegment();
        StringBuffer b = new StringBuffer();
        int i = 1;
        while (i < this.getURI().segmentCount() - 1) {
            b.append("/");
            b.append(URI.decode((String)this.getURI().segment(i)));
            if (i == 1) {
                b.append("/indy.build");
            }
            ++i;
        }
        return URI.createPlatformResourceURI((String)b.toString(), (boolean)true).appendSegment(lastSegment).appendFileExtension("md.cross");
    }

    public Document save(Document doc, Map<?, ?> options, DOMHandler handler) {
        block9: {
            if (!this.uri.segment(2).equals("indy.build")) {
                try {
                    List<Object> l = this.createRegistryItemsFor(ICrossReference.class);
                    URI crossRefURI = this.getCrossRefResourceURI();
                    if (l != null && !l.isEmpty()) {
                        ICrossReference item = (ICrossReference)l.get(0);
                        if (item == null) break block9;
                        try {
                            BundleContext ctx = Platform.getBundle((String)"com.indy.gmf.process").getBundleContext();
                            Collection sr = ctx.getServiceReferences(IRegistryHelper.class, "(&(registryItemType=com.indy.cross.CrossItem)(model.file.extension=md))");
                            Iterator iterator = sr.iterator();
                            if (!iterator.hasNext()) break block9;
                            ServiceReference ref = (ServiceReference)iterator.next();
                            IRegistryHelper helper = (IRegistryHelper)ctx.getService(ref);
                            try {
                                helper.persist(crossRefURI, (Object)item);
                                break block9;
                            }
                            finally {
                                ctx.ungetService(ref);
                            }
                        }
                        catch (Exception ex) {
                            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.md.ui").error(String.format(REGISTRY_EXTRACTION_FAILURE_MESSAGE, "CrossItem", this.getURI()), (Object)ex);
                        }
                        break block9;
                    }
                    ((XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class)).deleteResource(crossRefURI);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return super.save(doc, options, handler);
    }

    public void save(Map<?, ?> options) throws IOException {
        EObject o;
        if (!this.getContents().isEmpty() && (o = (EObject)this.getContents().get(0)) instanceof DocumentRoot) {
            MdRootNode node = ((DocumentRoot)o).getNode();
            if (node.getInternalVersion() != Version.V200) {
                boolean deliver = node.eDeliver();
                try {
                    node.eSetDeliver(false);
                    if (node.isSubMetaDataChildFile() && !node.isSubMd()) {
                        node.setSubMd(true);
                    }
                    node.setInternalVersion(Version.V200);
                }
                finally {
                    node.eSetDeliver(deliver);
                }
            }
            TreeIterator it = node.eAllContents();
            ArrayList<Attribute> toDelete = new ArrayList<Attribute>();
            while (it.hasNext()) {
                boolean hasValue;
                EObject obj = (EObject)it.next();
                if (!(obj instanceof Attribute)) continue;
                Attribute att = (Attribute)obj;
                boolean bl = hasValue = att.getValues() != null && !att.getValues().isEmpty() || att.getRef() != null || att.getRefs() != null && !att.getRefs().isEmpty() || att.getValueEntry() != null && !att.getValueEntry().isEmpty();
                if (hasValue || att.eIsSet((EStructuralFeature)MdPackage.eINSTANCE.getAttribute_Value())) continue;
                toDelete.add(att);
            }
            toDelete.forEach(a -> {
                EObject parent = a.eContainer();
                boolean deliver = parent.eDeliver();
                try {
                    parent.eSetDeliver(false);
                    ((Configuration)parent).getAttribute().remove(a);
                }
                finally {
                    parent.eSetDeliver(deliver);
                }
            });
        }
        super.save(options);
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        super.doSave(outputStream, options);
    }

    public void doSave(Writer writer, Map<?, ?> options) throws IOException {
        super.doSave(writer, options);
    }

    public Level getLevel(Configuration conf) {
        String defType = "";
        defType = conf instanceof MdNode ? conf.getDefType() : ((MdNode)conf.eContainer()).getDefType();
        return this.getLevel(defType);
    }

    private void refreshTech() {
        this.merger.refreshTech();
    }

    public Level getLevel(String code) {
        this.refreshTech();
        String defType = code;
        if (defType != null) {
            Level level = this.levelMap.get(defType);
            if (level != null && !level.eIsProxy()) {
                return level;
            }
            level = null;
            if (this.merger.getTech() != null) {
                level = this.merger.getTech().getLevel(defType);
            }
            if (level != null) {
                this.levelMap.put(defType, level);
            }
            return level;
        }
        return null;
    }

    public List<Level> getChildrenLevel(String defType) {
        if (defType != null) {
            List<Level> result = null;
            this.refreshTech();
            Set<String> children = this.merger.getParentChildren().get(defType);
            result = this.childrenLevelMap.get(defType);
            if (result != null) {
                for (Level level : result) {
                    if (!level.eIsProxy()) continue;
                    result = null;
                    break;
                }
            }
            if (result != null) {
                return result;
            }
            if (children != null) {
                result = new ArrayList<Level>();
                for (Level level : this.merger.getTech().getLevel()) {
                    if (level.getCode() == null || !children.contains(level.getCode())) continue;
                    result.add(level);
                }
                if (result != null) {
                    this.childrenLevelMap.put(defType, result);
                }
                return result;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public List<Level> getChildrenLevel(MdNode node) {
        String defType = node.getDefType();
        return this.getChildrenLevel(defType);
    }

    public List<Action> getChildrenAction(MdNode node) {
        this.refreshTech();
        String defType = node.getDefType();
        List<Action> result = null;
        if (defType != null) {
            result = this.childrenActionMap.get(defType);
            if (result != null) {
                return result;
            }
            result = new ArrayList<Action>();
            Level base = node.getLevel();
            Tech tech = this.merger.getTech();
            if (tech != null) {
                for (Action action : tech.getAction()) {
                    for (Level level : action.getExecutableLevel()) {
                        if (level.getCode() == null || !level.getCode().equals(base.getCode())) continue;
                        result.add(action);
                    }
                }
            }
            if (result != null) {
                this.childrenActionMap.put(defType, result);
            }
        }
        return result;
    }

    public List<Tpl> getChildrenExecutableTemplate(MdNode node) {
        this.refreshTech();
        String defType = node.getDefType();
        List<Tpl> result = null;
        if (defType != null) {
            result = this.childrenExecutableTemplateMap.get(defType);
            if (result != null) {
                return result;
            }
            result = new ArrayList<Tpl>();
            Level base = node.getLevel();
            Tech tech = this.merger.getTech();
            for (Tpl tpl : tech.getTemplate()) {
                for (Level level : tpl.getExecutableLevel()) {
                    if (level.getCode() == null || !level.getCode().equals(base.getCode())) continue;
                    result.add(tpl);
                }
            }
            if (result != null) {
                this.childrenExecutableTemplateMap.put(defType, result);
            }
        }
        return result;
    }

    public List<Tpl> getChildrenSettableTemplate(MdNode node) {
        this.refreshTech();
        String defType = node.getDefType();
        List<Tpl> result = null;
        if (defType != null) {
            result = this.childrenSettableTemplateMap.get(defType);
            if (result != null) {
                return result;
            }
            result = new ArrayList<Tpl>();
            Level base = node.getLevel();
            Tech tech = this.merger.getTech();
            for (Tpl tpl : tech.getTemplate()) {
                for (Level level : tpl.getSettableLevel()) {
                    if (level.getCode() == null || !level.getCode().equals(base.getCode())) continue;
                    result.add(tpl);
                }
            }
            if (result != null) {
                this.childrenSettableTemplateMap.put(defType, result);
            }
        }
        return result;
    }

    public static boolean isParentLevel(MdNode parent, Element child) {
        Level level;
        Resource parentResource = null;
        if (!(parent.eResource() instanceof StbMdResourceImpl)) {
            parentResource = parent.getSubstituteResource();
        }
        if (parentResource == null) {
            parentResource = parent.eResource();
        }
        if ((level = ((Configuration)child).getLevel(parentResource)) != null) {
            return StbMdResourceImpl.isParentLevel(parent, level);
        }
        return false;
    }

    public static boolean isParentLevel(MdNode parent, Level child) {
        for (Level test : parent.getChildrenLevel()) {
            if (test != child && !test.getCode().equals(child.getCode())) continue;
            return true;
        }
        return false;
    }

    public void addDisposable(IWithDisposable.IDisposable disposable) {
        if (this.disposables == null) {
            this.disposables = new ArrayList<IWithDisposable.IDisposable>();
        }
        this.disposables.add(disposable);
    }

    private List<IWithDisposable.IDisposable> getDisposable() {
        return this.disposables;
    }

    public EObject getEObjectByID(String id) {
        EObject eObject;
        Map map = this.getIntrinsicIDToEObjectMap();
        if (map != null && (eObject = (EObject)map.get(id)) != null) {
            return eObject;
        }
        return null;
    }

    private String getContributedRegistryIDWithoutFilter(String s) {
        return s.replaceAll(REGISTRY_FILTER_REGEX, "");
    }

    public List<Class> getContributedRegistries() {
        ArrayList<Class> res = new ArrayList<Class>();
        if (!this.getContents().isEmpty()) {
            this.merger.refreshTech();
            Tech tech = this.merger.getTech();
            if (tech == null) {
                return res;
            }
            LogService logger = (LogService)E4InjectorHelper.getService(LogService.class);
            for (String s : tech.getContributedRegistryID()) {
                String id = IRegistryService.extractRegistryIdFromContribution((String)s);
                if (id.equals(LevelCodeInfo.class.getName()) || !this.checkRegistryIdFilters(s)) continue;
                try {
                    res.add(Class.forName(id, false, IRegistryService.class.getClassLoader()));
                }
                catch (ClassNotFoundException e) {
                    if (id.startsWith("com.indy.ui.custom.out.services.registry")) {
                        String fallbackClassName = id.replace("com.indy.ui.custom.out.services.registry.", "com.semarchy.xdi.designer.core.services.registry.");
                        try {
                            res.add(Class.forName(fallbackClassName, false, IRegistryService.class.getClassLoader()));
                        }
                        catch (ClassNotFoundException ex) {
                            logger.getLogger(StbMdResourceImpl.class).error(String.format("Failed to load fallback registry class %s", fallbackClassName), (Object)ex);
                        }
                        continue;
                    }
                    logger.getLogger(StbMdResourceImpl.class).error(String.format("Failed to load registry class %s", id), (Object)e);
                }
            }
            if (!this.getURI().segment(2).equals("indy.build")) {
                res.add(ICrossReference.class);
                res.add(ReferencableObject.class);
                for (Level l : tech.getLevel()) {
                    if (!l.getMappingType().contains((Object)MappingType.STAGING)) continue;
                    res.add(StagingAreaDescriptor.class);
                    break;
                }
            }
        }
        return res;
    }

    private boolean checkRegistryIdFilters(String registryIdExpression) {
        block4: {
            Matcher m = REGISTRY_FILTER_PATTERN.matcher(registryIdExpression);
            if (m.find()) {
                String filter = m.group(1);
                try {
                    MdRootNode o = ((DocumentRoot)this.getContents().get(0)).getNode();
                    if (filter.startsWith("@defType=")) {
                        String defType = filter.substring(filter.indexOf("=") + 1);
                        return defType.equals(o.getDefType());
                    }
                    break block4;
                }
                catch (Exception ex) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public List<Object> createRegistryItemsFor(Class c) throws Exception {
        Object f;
        block22: {
            if (c == UDF.class && this.getContributedRegistries().contains(c)) {
                UDFFactory factory = new UDFFactory();
                return factory.createUDF(this);
            }
            if (c == ProcessToolDescriptor.class && this.getContributedRegistries().contains(c)) {
                f = new ProcessToolFactory();
                try {
                    return ((ProcessToolFactory)f).createDescriptors(this);
                }
                catch (Exception e) {
                    ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.md.ui").error(String.format(REGISTRY_EXTRACTION_FAILURE_MESSAGE, "ProcessToolDescriptor", this.getURI()), (Object)e);
                }
            }
            if (c == RuntimeEngine.class && this.getContributedRegistries().contains(c)) {
                f = new RuntimeEngineFactory();
                try {
                    return ((RuntimeEngineFactory)f).createEngines(this);
                }
                catch (Exception e) {
                    ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.md.ui").error(String.format(REGISTRY_EXTRACTION_FAILURE_MESSAGE, "RuntimeEngine", this.getURI()), (Object)e);
                }
            }
            if (c == ICrossReference.class && !this.getURI().segment(2).equals("indy.build")) {
                List list;
                BundleContext ctx = Platform.getBundle((String)"com.indy.md.ui").getBundleContext();
                Collection sr = ctx.getServiceReferences(IRegistryHelper.class, "(&(registryItemType=com.indy.cross.CrossItem)(model.file.extension=md))");
                Iterator iterator = sr.iterator();
                if (!iterator.hasNext()) break block22;
                ServiceReference ref = (ServiceReference)iterator.next();
                IRegistryHelper helper = (IRegistryHelper)ctx.getService(ref);
                try {
                    list = helper.getRegistryObjects((Resource)this);
                }
                catch (Throwable throwable) {
                    try {
                        ctx.ungetService(ref);
                        throw throwable;
                    }
                    catch (Exception ex) {
                        ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.md.ui").error(String.format(REGISTRY_EXTRACTION_FAILURE_MESSAGE, "CrossItem", this.getURI()), (Object)ex);
                    }
                }
                ctx.ungetService(ref);
                return list;
            }
        }
        if (c == ReferencableObject.class && !this.getURI().segment(2).equals("indy.build")) {
            f = new ReferencableObjectFactory();
            try {
                return ((ReferencableObjectFactory)f).createReferencableObject(this);
            }
            catch (Exception e) {
                ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.md.ui").error(String.format(REGISTRY_EXTRACTION_FAILURE_MESSAGE, "ReferencableObject", this.getURI()), (Object)e);
            }
        }
        if (c == StagingAreaDescriptor.class && !this.getURI().segment(2).equals("indy.build")) {
            f = new StageAreaDescriptorFactory();
            try {
                return ((StageAreaDescriptorFactory)f).createReferencableObject(this);
            }
            catch (Exception e) {
                ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.md.ui").error(String.format(REGISTRY_EXTRACTION_FAILURE_MESSAGE, "StagingAreaDescriptor", this.getURI()), (Object)e);
            }
        }
        if (c == ModuleRequirment.class && this.getContributedRegistries().contains(c)) {
            f = new ModuleRequirmentFactory();
            try {
                return ((ModuleRequirmentFactory)f).createModuleRequirment(this);
            }
            catch (Exception e) {
                ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.md.ui").error(String.format(REGISTRY_EXTRACTION_FAILURE_MESSAGE, "ModuleRequirment", this.getURI()));
            }
        }
        return Collections.EMPTY_LIST;
    }

    protected XMLLoad createXMLLoad(Map<?, ?> options) {
        if (options != null && options.get("com.indy.md.ui.validateMdXML") == Boolean.TRUE) {
            return new XMLLoadImpl(this.createXMLHelper()){

                protected DefaultHandler makeDefaultHandler() {
                    return new MdXMLHandler(this.resource, this.helper, this.options);
                }
            };
        }
        return super.createXMLLoad(options);
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        MdRootNode node;
        Version version;
        super.doLoad(inputStream, options);
        if (!(this.getContents().isEmpty() || (version = (node = ((DocumentRoot)this.getContents().get(0)).getNode()).getInternalVersion()) != null && version.ordinal() >= Version.V200.ordinal())) {
            AutomaticEmptyAttributeUpgrader upgrader = new AutomaticEmptyAttributeUpgrader();
            upgrader.cleanupEmptyAttributes(node);
            this.getWarnings().add((Object)new OutdatedModelDiagnostic(String.format(Messages.StbMdResourceImpl_8, new Object[]{node.getInternalVersion()})));
        }
    }

    public void unloadTech() {
        Tech t = this.merger.getTech();
        if (t != null && !t.eIsProxy()) {
            if (!this.getContents().isEmpty()) {
                URI proxyURI = EcoreUtil.getURI((EObject)((DocumentRoot)this.getContents().get(0)).getNode().getRef());
                ((InternalEObject)this.merger.getTech()).eSetProxyURI(proxyURI);
            }
            this.eNotify((Notification)new NotificationImpl(-9999, true, false));
        }
    }
}

