/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.util;

import com.semarchy.xdi.designer.core.services.IModelTranslationProvider;
import com.semarchy.xdi.designer.core.services.IOverrideService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.tech.Action;
import com.stambia.tech.Level;
import com.stambia.tech.MessageEntry;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyPage;
import com.stambia.tech.Tech;
import com.stambia.tech.TechPackage;
import com.stambia.tech.Value;
import com.stambia.tech.ValueSet;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TechMessageProvider {
    private static final char SEPARATOR = '/';
    private static final char DOT = '.';
    private static final Object nullValue = new Object();
    private Properties properties = null;
    private HashMap<String, Object> messageKeyMap = new HashMap();

    public TechMessageProvider(List<URI> resourceURI) {
        this.properties = new Properties();
        resourceURI.stream().filter(u -> u != null && ("tech".equals(u.fileExtension()) || "tech_ext".equals(u.fileExtension()))).forEach(uri -> {
            URI internalResourceURI = null;
            internalResourceURI = uri.segment(1).equals("com.indy.environment") ? uri : ((IOverrideService)E4InjectorHelper.getService(IOverrideService.class)).getOverridenURI(uri);
            if (internalResourceURI != null) {
                this.loadMessageFile(internalResourceURI);
            }
        });
    }

    private void loadMessageFile(URI resourceURI) {
        BundleContext ctx = Platform.getBundle((String)"com.indy.tech").getBundleContext();
        ServiceReference sr = ctx.getServiceReference(IModelTranslationProvider.class);
        IModelTranslationProvider provider = null;
        if (sr != null) {
            try {
                List u;
                provider = (IModelTranslationProvider)ctx.getService(sr);
                if (provider != null && (u = provider.getTranslationFileURI(resourceURI)) != null) {
                    u.stream().forEach(p -> {
                        try {
                            Throwable throwable = null;
                            Object var3_5 = null;
                            try (InputStreamReader is = new InputStreamReader(p.toURL().openStream(), "UTF-8");){
                                this.properties.load(is);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    });
                }
            }
            finally {
                provider = null;
                ctx.ungetService(sr);
            }
        }
    }

    public String getMessageKey(EObject obj, EStructuralFeature feature) {
        String messageKeyMap_key = String.valueOf(obj.eClass().getName()) + '/' + obj.hashCode() + '/' + feature.getName();
        Object res = this.messageKeyMap.get(messageKeyMap_key);
        if (res != null) {
            if (res == nullValue) {
                return null;
            }
            return (String)res;
        }
        if (obj instanceof Tech) {
            res = feature.getName();
        } else if (obj instanceof Level) {
            Level level = (Level)obj;
            res = String.valueOf(level.getCode()) + '.' + feature.getName();
        } else if (obj instanceof Property) {
            res = String.valueOf(((Level)obj.eContainer()).getCode()) + '/' + ((Property)obj).getCode() + '.' + feature.getName();
        } else if (obj instanceof Action) {
            res = "action/" + ((Action)obj).getCode() + '.' + feature.getName();
        } else if (obj instanceof PropertyPage) {
            int i = ((Level)obj.eContainer()).getPropertyPage().indexOf((Object)obj);
            res = String.valueOf(((Level)obj.eContainer()).getCode()) + '/' + "propertyPage" + '/' + i + '.' + feature.getName();
        } else if (obj instanceof Value) {
            String valueCode = ((Value)obj).getCode();
            String valueSetCode = ((ValueSet)obj.eContainer()).getCode();
            res = "valueSet/" + valueSetCode + '/' + valueCode + '.' + feature.getName();
        } else if (obj instanceof MessageEntry && feature == TechPackage.eINSTANCE.getMessageEntry_Value()) {
            res = String.valueOf(((Level)obj.eContainer()).getCode()) + '/' + "message" + '/' + ((MessageEntry)obj).getKey() + '.' + feature.getName();
        }
        if (res != null) {
            this.messageKeyMap.put(messageKeyMap_key, res);
        } else {
            this.messageKeyMap.put(messageKeyMap_key, nullValue);
        }
        return (String)res;
    }

    public String getMessage(EObject object, EStructuralFeature feature) throws FeatureNotFoundException {
        if (this.properties == null) {
            return null;
        }
        if (!object.eClass().getEAllStructuralFeatures().contains((Object)feature)) {
            throw new FeatureNotFoundException(feature.getName(), object, null, 0, 0);
        }
        String messageKey = this.getMessageKey(object, feature);
        if (messageKey != null && messageKey != nullValue) {
            return this.properties.getProperty(messageKey);
        }
        return null;
    }
}

