/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.cmdline;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.hsqldb.cmdline.SqltoolRB;
import org.hsqldb.cmdline.libclone.FrameworkLogger;
import org.hsqldb.cmdline.sqltool.Token;
import org.hsqldb.cmdline.utilclone.RCData;

public class SqlTool {
    private static final FrameworkLogger logger = FrameworkLogger.getLog(SqlTool.class);
    public static final String DEFAULT_RCFILE = System.getProperty("user.home") + "/sqltool.rc";
    private static final String revString = "$Revision: 6559 $";
    private static final int revStringLength = "$Revision: 6559 $".length();
    private static final String revnum = revStringLength - " $".length() > "$Revision: ".length() ? "$Revision: 6559 $".substring("$Revision: ".length(), revStringLength - " $".length()) : "<UNTRACKED>";
    public static final int SQLTOOLERR_EXITVAL = 1;
    public static final int SYNTAXERR_EXITVAL = 11;
    public static final int RCERR_EXITVAL = 2;
    public static final int SQLERR_EXITVAL = 3;
    public static final int IOERR_EXITVAL = 4;
    public static final int FILEERR_EXITVAL = 5;
    public static final int INPUTERR_EXITVAL = 6;
    public static final int CONNECTERR_EXITVAL = 7;
    private static final String CMDLINE_ID = "cmdline";
    public static final String LS = System.getProperty("line.separator");
    private static final BadCmdline bcl = new BadCmdline();

    private static String promptForPassword(String string) throws PrivateException {
        String string2;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(SqltoolRB.passwordFor_prompt.getString(RCData.expandSysPropVars(string)));
            string2 = bufferedReader.readLine();
            string2 = string2 == null ? "" : string2.trim();
        }
        catch (IOException iOException) {
            throw new PrivateException(iOException.getMessage());
        }
        finally {
            Object var1_2 = null;
        }
        return string2;
    }

    private static void varParser(String string, Map<String, String> map, boolean bl) throws PrivateException {
        if (map == null) {
            throw new IllegalArgumentException("varMap is null in SqlTool.varParser call");
        }
        if (string == null) {
            throw new IllegalArgumentException("inVarString is null in SqlTool.varParser call");
        }
        boolean bl2 = string.contains("\\,");
        String string2 = bl2 ? string.replace("\\,", "\u0002") : string;
        for (String string3 : string2.split("\\s*,\\s*")) {
            int n = string3.indexOf(61);
            if (n < 1) {
                throw new PrivateException(SqltoolRB.SqlTool_varset_badformat.getString());
            }
            String string4 = string3.substring(0, n).trim();
            String string5 = string3.substring(n + 1).trim();
            if (bl2) {
                string5 = string5.replace("\u0002", ",");
            }
            if (string4.length() < 1) {
                throw new PrivateException(SqltoolRB.SqlTool_varset_badformat.getString());
            }
            if (bl) {
                string4 = string4.toLowerCase();
            }
            map.put(string4, string5);
        }
    }

    public static void main(String[] stringArray) {
        try {
            SqlTool.objectMain(stringArray);
        }
        catch (SqlToolException sqlToolException) {
            System.err.println(sqlToolException.getMessage() == null ? sqlToolException : sqlToolException.getMessage());
            System.exit(sqlToolException.exitValue);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void objectMain(String[] stringArray) throws SqlToolException {
        SqlFile[] sqlFileArray;
        Object[] objectArray;
        Object object;
        logger.finer("Invoking SqlTool");
        String string = null;
        PipedReader pipedReader = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        URL[] uRLArray = null;
        int n = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        Boolean bl7 = null;
        Boolean bl8 = null;
        String string5 = null;
        Connection connection = null;
        Map<String, String> map = new HashMap<String, String>();
        try {
            boolean bl9;
            block147: {
                try {
                    int n2;
                    while (n + 1 < stringArray.length) {
                        if (stringArray[n + 1].startsWith("--")) {
                            if (stringArray[++n].length() == 2) break;
                            String string6 = stringArray[n].substring(2).toLowerCase();
                            if (string6.equals("help")) {
                                System.out.println(SqltoolRB.SqlTool_syntax.getString(revnum, "org.hsqldb.jdbc.JDBCDriver"));
                                pipedReader = null;
                                return;
                            }
                            if (string6.equals("abortonerr")) {
                                if (bl7 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_abort_continue_mutuallyexclusive.getString());
                                }
                                bl7 = Boolean.FALSE;
                                continue;
                            }
                            if (string6.equals("continueonerr")) {
                                if (bl7 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_abort_continue_mutuallyexclusive.getString());
                                }
                                bl7 = Boolean.TRUE;
                                continue;
                            }
                            if (string6.startsWith("continueonerr=")) {
                                if (bl7 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_abort_continue_mutuallyexclusive.getString());
                                }
                                bl7 = Boolean.valueOf(stringArray[n].substring("--continueonerr=".length()));
                                continue;
                            }
                            if (string6.equals("list")) {
                                if (bl2) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                bl2 = true;
                                continue;
                            }
                            if (string6.equals("rcfile")) {
                                if (++n == stringArray.length) {
                                    throw bcl;
                                }
                                if (string != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string = stringArray[n];
                                continue;
                            }
                            if (string6.startsWith("rcfile=")) {
                                if (string != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string = stringArray[n].substring("--rcfile=".length());
                                continue;
                            }
                            if (string6.equals("setvar")) {
                                if (++n == stringArray.length) {
                                    throw bcl;
                                }
                                try {
                                    SqlTool.varParser(stringArray[n], map, false);
                                    continue;
                                }
                                catch (PrivateException privateException) {
                                    throw new SqlToolException(2, privateException.getMessage());
                                }
                            }
                            if (string6.startsWith("setvar=")) {
                                try {
                                    SqlTool.varParser(stringArray[n].substring("--setvar=".length()), map, false);
                                    continue;
                                }
                                catch (PrivateException privateException) {
                                    throw new SqlToolException(2, privateException.getMessage());
                                }
                            }
                            if (string6.equals("sql")) {
                                bl3 = true;
                                if (++n == stringArray.length) {
                                    throw bcl;
                                }
                                if (string2 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string2 = stringArray[n];
                                continue;
                            }
                            if (string6.startsWith("sql=")) {
                                bl3 = true;
                                if (string2 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string2 = stringArray[n].substring("--sql=".length());
                                continue;
                            }
                            if (string6.equals("debug")) {
                                if (bl) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                bl = true;
                                continue;
                            }
                            if (string6.equals("noautofile")) {
                                if (bl4) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                bl4 = true;
                                continue;
                            }
                            if (string6.equals("autocommit")) {
                                if (bl5) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                bl5 = true;
                                continue;
                            }
                            if (string6.equals("stdinput")) {
                                bl3 = false;
                                if (bl8 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                bl8 = Boolean.TRUE;
                                continue;
                            }
                            if (string6.equals("noinput")) {
                                bl3 = true;
                                if (bl8 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                bl8 = Boolean.FALSE;
                                continue;
                            }
                            if (string6.equals("driver")) {
                                if (++n == stringArray.length) {
                                    throw bcl;
                                }
                                if (string3 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string3 = stringArray[n];
                                continue;
                            }
                            if (string6.startsWith("driver=")) {
                                if (string3 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string3 = stringArray[n].substring("--driver=".length());
                                continue;
                            }
                            if (string6.equals("inlinerc")) {
                                if (++n == stringArray.length) {
                                    throw bcl;
                                }
                                if (string5 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string5 = stringArray[n];
                                continue;
                            }
                            if (string6.startsWith("inlinerc=")) {
                                if (string5 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                string5 = stringArray[n].substring("--inlinerc=".length());
                                continue;
                            }
                            if (string6.equals("overriderc")) {
                                if (++n == stringArray.length) {
                                    throw bcl;
                                }
                                if (string5 != null) {
                                    throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                                }
                                bl6 = true;
                                string5 = stringArray[n];
                                continue;
                            }
                            if (!string6.startsWith("overriderc=")) throw bcl;
                            if (string5 != null) {
                                throw new SqlToolException(11, SqltoolRB.SqlTool_params_redundant.getString());
                            }
                            bl6 = true;
                            string5 = stringArray[n].substring("--overriderc=".length());
                            continue;
                        }
                        if (!stringArray[n + 1].startsWith("-P") && !stringArray[n + 1].startsWith("-p")) break;
                        int n3 = n2 = stringArray[++n].length() < 3 ? 1 : 0;
                        if (n2 != 0 && ++n == stringArray.length) {
                            throw bcl;
                        }
                        int n4 = stringArray[n].indexOf(61);
                        if (n4 < (n2 != 0 ? 1 : 3)) {
                            throw new SqlToolException(2, "Specified var assignment contains no '='");
                        }
                        map.put(stringArray[n].substring(n2 != 0 ? 0 : 2, n4), stringArray[n].substring(n4 + 1));
                    }
                    if (!bl2 && (string5 == null || bl6) && ++n != stringArray.length && (string4 = stringArray[n]).equals("-")) {
                        string4 = null;
                    }
                    n2 = 0;
                    if (string2 != null) {
                        try {
                            pipedReader = new PipedReader();
                            PipedWriter pipedWriter = new PipedWriter(pipedReader);
                            try {
                                pipedWriter.write(string2 + LS);
                                pipedWriter.flush();
                            }
                            finally {
                                try {
                                    pipedWriter.close();
                                }
                                finally {
                                    pipedWriter = null;
                                }
                            }
                        }
                        catch (IOException iOException) {
                            throw new SqlToolException(4, SqltoolRB.sqltempfile_fail.getString(iOException.toString()));
                        }
                    }
                    if (bl8 != null) {
                        bl3 = bl8 == false;
                    }
                    boolean bl10 = bl9 = !bl3 && stringArray.length <= n + 1;
                    if (stringArray.length == n + 2 && stringArray[n + 1].equals("-")) {
                        if (bl8 == null) {
                            bl3 = false;
                        }
                        break block147;
                    }
                    if (stringArray.length <= n + 1) break block147;
                    uRLArray = new URL[stringArray.length - n - 1 + (bl8 == null || bl8 == false ? 0 : 1)];
                    if (bl) {
                        System.err.println("scriptFiles has " + uRLArray.length + " elements");
                    }
                    while (n + 1 < stringArray.length) {
                        try {
                            uRLArray[n2] = SqlFile.URL_WITH_PROTO_RE.matcher(stringArray[++n]).matches() ? new URL(stringArray[n]) : new URL("file", null, stringArray[n]);
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new RuntimeException("Invalid SQL file URL " + stringArray[n]);
                        }
                    }
                    if (bl8 != null && bl8.booleanValue()) {
                        bl3 = true;
                    }
                }
                catch (BadCmdline badCmdline) {
                    throw new SqlToolException(11, SqltoolRB.SqlTool_syntax.getString(revnum, "org.hsqldb.jdbc.JDBCDriver"));
                }
            }
            object = null;
            if (bl2 || string4 != null) {
                try {
                    object = new RCData(new File(string == null ? DEFAULT_RCFILE : string), string4);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new SqlToolException(2, SqltoolRB.conndata_retrieval_fail.getString(string4, exception.getMessage()));
                }
            }
            if (string5 != null) {
                if (bl6 && object == null) {
                    throw new RuntimeException("rcParams override but no urlid specified");
                }
                if (!bl6 && object != null) {
                    throw new RuntimeException("inlineRc override but urlid was specified");
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                try {
                    SqlTool.varParser(string5, hashMap, true);
                }
                catch (PrivateException privateException) {
                    throw new SqlToolException(11, privateException.getMessage());
                }
                String string7 = (String)hashMap.remove("url");
                String string8 = (String)hashMap.remove("user");
                String string9 = (String)hashMap.remove("username");
                String string10 = (String)hashMap.remove("charset");
                String string11 = (String)hashMap.remove("truststore");
                String string12 = (String)hashMap.remove("password");
                String string13 = (String)hashMap.remove("transiso");
                String string14 = (String)hashMap.remove("driver");
                if (hashMap.size() > 0) {
                    throw new SqlToolException(6, SqltoolRB.rcdata_inline_extravars.getString(hashMap.keySet().toString()));
                }
                if (string8 != null) {
                    if (string9 != null) {
                        throw new RuntimeException("RC params 'user' and 'username' both set.  Set only 'username'");
                    }
                    string9 = string8;
                }
                if (string14 != null && string3 != null) {
                    throw new SqlToolException(2, SqltoolRB.rcdata_driver_conflict.getString());
                }
                if (string12 != null && string12.length() > 0) {
                    throw new SqlToolException(2, SqltoolRB.rcdata_password_visible.getString());
                }
                if (object == null) {
                    try {
                        object = new RCData(CMDLINE_ID, string7, string9, string12, string14 == null ? string3 : string14, string10, string11, null, string13);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new SqlToolException(2, SqltoolRB.rcdata_genfromvalues_fail.getString(exception.getMessage()));
                    }
                } else {
                    if (string7 != null) {
                        ((RCData)object).url = string7;
                    }
                    if (string9 != null) {
                        ((RCData)object).username = string9;
                    }
                    if (string10 != null) {
                        ((RCData)object).charset = string10;
                    }
                    if (string11 != null) {
                        ((RCData)object).truststore = string11;
                    }
                    if (string12 != null) {
                        ((RCData)object).password = string12;
                    }
                    if (string13 != null) {
                        ((RCData)object).ti = string13;
                    }
                    if (string14 != null) {
                        ((RCData)object).driver = string14;
                    }
                }
                if (((RCData)object).url == null) throw new SqlToolException(2, SqltoolRB.rcdata_inlineurl_missing.getString());
                if (((RCData)object).url.length() < 1) {
                    throw new SqlToolException(2, SqltoolRB.rcdata_inlineurl_missing.getString());
                }
                if (((RCData)object).username != null && ((RCData)object).password == null) {
                    try {
                        ((RCData)object).password = SqlTool.promptForPassword(((RCData)object).username);
                    }
                    catch (PrivateException privateException) {
                        throw new SqlToolException(6, SqltoolRB.password_readfail.getString(privateException.getMessage()));
                    }
                }
            }
            if (bl2) {
                pipedReader = null;
                return;
            }
            if (bl9) {
                System.out.print("SqlTool v. " + revnum + '.' + LS);
            }
            if (object != null) {
                try {
                    String string15;
                    connection = ((RCData)object).getConnection(null, System.getProperty("javax.net.ssl.trustStore"));
                    connection.setAutoCommit(bl5);
                    if (bl9 && (string15 = SqlFile.getBanner(connection)) != null) {
                        System.out.println(string15);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    if (bl) {
                        logger.error(exception.getClass().getName(), exception);
                    }
                    String string16 = ((RCData)object).username == null ? "<DFLTUSER>" : ((RCData)object).username;
                    throw new SqlToolException(7, SqltoolRB.connection_fail.getString(((RCData)object).url, string16, exception.getMessage()));
                }
            }
            objectArray = new URL[]{};
            URL[] uRLArray2 = new URL[]{null};
            File file = null;
            if (!(!bl9 || bl4 || (file = new File(System.getProperty("user.home") + "/auto.sql")).isFile() && file.canRead())) {
                file = null;
            }
            if (uRLArray == null) {
                uRLArray = bl3 ? objectArray : uRLArray2;
            }
            int n5 = uRLArray.length;
            if (pipedReader != null) {
                ++n5;
            }
            if (file != null) {
                ++n5;
            }
            sqlFileArray = new SqlFile[n5];
            int n6 = -1;
            String string17 = object == null ? null : ((RCData)object).charset;
            try {
                int n7 = 0;
                if (file != null) {
                    sqlFileArray[n7++] = new SqlFile(new URL("file", null, file.getPath()), string17);
                }
                if (pipedReader != null) {
                    sqlFileArray[n7++] = new SqlFile((Reader)pipedReader, "--sql", System.out, null, false, (URL)null);
                }
                for (URL uRL : uRLArray) {
                    if (n6 < 0 && bl9) {
                        n6 = n7;
                    }
                    sqlFileArray[n7++] = uRL == null ? new SqlFile(string17, bl9) : new SqlFile(uRL, string17, bl9);
                }
            }
            catch (IOException iOException) {
                try {
                    if (connection == null) throw new SqlToolException(5, iOException.getMessage());
                    connection.close();
                    throw new SqlToolException(5, iOException.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SqlToolException(5, iOException.getMessage());
            }
        }
        finally {
            pipedReader = null;
        }
        object = null;
        try {
            objectArray = sqlFileArray;
            int n8 = objectArray.length;
            int n9 = 0;
            while (n9 < n8) {
                Object object2 = objectArray[n9];
                if (connection != null) {
                    ((SqlFile)object2).setConnection(connection);
                }
                if (map.size() > 0) {
                    ((SqlFile)object2).addUserVars(map);
                }
                if (object != null) {
                    ((SqlFile)object2).addMacros((Map<String, Token>)object);
                }
                if (bl7 != null) {
                    ((SqlFile)object2).setContinueOnError(bl7);
                }
                ((SqlFile)object2).execute();
                map = ((SqlFile)object2).getUserVars();
                object = ((SqlFile)object2).getMacros();
                connection = ((SqlFile)object2).getConnection();
                ++n9;
            }
            return;
        }
        catch (SqlToolError sqlToolError) {
            throw new SqlToolException(1);
        }
        catch (SQLException sQLException) {
            throw new SqlToolException(3);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static class SqlToolException
    extends Exception {
        static final long serialVersionUID = 1424909871915188519L;
        int exitValue;

        SqlToolException(String string, int n) {
            super(string);
            this.exitValue = n;
        }

        SqlToolException(int n, String string) {
            this(string, n);
        }

        SqlToolException(int n) {
            this.exitValue = n;
        }
    }

    private static class PrivateException
    extends Exception {
        static final long serialVersionUID = -7765061479594523462L;

        PrivateException(String string) {
            super(string);
        }
    }

    private static class BadCmdline
    extends Exception {
        static final long serialVersionUID = -2134764796788108325L;

        BadCmdline() {
        }
    }
}

