/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.app.authorization.impl;

import com.stambia.app.authorization.Action;
import com.stambia.app.authorization.Auth;
import com.stambia.app.authorization.AuthorizationFactory;
import com.stambia.app.authorization.AuthorizationPackage;
import com.stambia.app.authorization.DocumentRoot;
import com.stambia.app.authorization.Group;
import com.stambia.app.authorization.Role;
import com.stambia.app.authorization.User;
import com.stambia.app.authorization.impl.AuthImpl;
import com.stambia.app.authorization.impl.DocumentRootImpl;
import com.stambia.app.authorization.impl.GroupImpl;
import com.stambia.app.authorization.impl.Messages;
import com.stambia.app.authorization.impl.RoleImpl;
import com.stambia.app.authorization.impl.UserImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class AuthorizationFactoryImpl
extends EFactoryImpl
implements AuthorizationFactory {
    public static AuthorizationFactory init() {
        try {
            AuthorizationFactory theAuthorizationFactory = (AuthorizationFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.stambia.com/app/authorization");
            if (theAuthorizationFactory != null) {
                return theAuthorizationFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new AuthorizationFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createAuth();
            }
            case 1: {
                return this.createDocumentRoot();
            }
            case 2: {
                return this.createGroup();
            }
            case 3: {
                return this.createRole();
            }
            case 4: {
                return this.createUser();
            }
        }
        throw new IllegalArgumentException(String.valueOf(Messages.AuthorizationFactoryImpl_0) + eClass.getName() + Messages.AuthorizationFactoryImpl_1);
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.createActionFromString(eDataType, initialValue);
            }
            case 6: {
                return this.createActionObjectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException(String.valueOf(Messages.AuthorizationFactoryImpl_2) + eDataType.getName() + Messages.AuthorizationFactoryImpl_3);
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.convertActionToString(eDataType, instanceValue);
            }
            case 6: {
                return this.convertActionObjectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException(String.valueOf(Messages.AuthorizationFactoryImpl_4) + eDataType.getName() + Messages.AuthorizationFactoryImpl_5);
    }

    @Override
    public Auth createAuth() {
        AuthImpl auth = new AuthImpl();
        return auth;
    }

    @Override
    public DocumentRoot createDocumentRoot() {
        DocumentRootImpl documentRoot = new DocumentRootImpl();
        return documentRoot;
    }

    @Override
    public Group createGroup() {
        GroupImpl group = new GroupImpl();
        return group;
    }

    @Override
    public Role createRole() {
        RoleImpl role = new RoleImpl();
        return role;
    }

    @Override
    public User createUser() {
        UserImpl user = new UserImpl();
        return user;
    }

    public Action createActionFromString(EDataType eDataType, String initialValue) {
        Action result = Action.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException(String.valueOf(Messages.AuthorizationFactoryImpl_6) + initialValue + Messages.AuthorizationFactoryImpl_7 + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertActionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Action createActionObjectFromString(EDataType eDataType, String initialValue) {
        return this.createActionFromString((EDataType)AuthorizationPackage.Literals.ACTION, initialValue);
    }

    public String convertActionObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertActionToString((EDataType)AuthorizationPackage.Literals.ACTION, instanceValue);
    }

    @Override
    public AuthorizationPackage getAuthorizationPackage() {
        return (AuthorizationPackage)this.getEPackage();
    }

    @Deprecated
    public static AuthorizationPackage getPackage() {
        return AuthorizationPackage.eINSTANCE;
    }

    @Override
    public Role createRole(String name) {
        Role role = this.createRole();
        role.setName(name);
        return role;
    }
}

