/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command.impl;

import com.indy.engine.command.impl.InternalEngineCommandsI;
import com.indy.engine.command.impl.Messages;
import com.indy.engine.command.impl.RuntimeCommand;
import com.indy.engine.common.command.parser.CommandLine;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.objects2.DeliveryRepositoryInfoExchange;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

@CommandLine(startWith="get repositories", removeString="get repositories", usage="get repositories", description="Get the list of available repositories")
public class ListRepositoriesCommand
implements RuntimeCommand {
    @Override
    public void execute(IEngineClient engineAPI, PrintStream out, Map<String, Object> ctx) throws Exception {
        Map repos = engineAPI.getRepositories(null);
        if (repos != null && !repos.isEmpty()) {
            HashMap<String, InternalEngineCommandsI.Column> columns = new HashMap<String, InternalEngineCommandsI.Column>();
            int position = 0;
            columns.put("name", new InternalEngineCommandsI.Column(position++, Messages.getString("ListRepositoriesCommand.0"), 0));
            columns.put("type", new InternalEngineCommandsI.Column(position++, Messages.getString("ListRepositoriesCommand.1"), 0));
            columns.put("webService", new InternalEngineCommandsI.Column(position++, Messages.getString("ListRepositoriesCommand.2"), 0));
            columns.put("default", new InternalEngineCommandsI.Column(position++, Messages.getString("ListRepositoriesCommand.3"), 0));
            columns.put("scanMode", new InternalEngineCommandsI.Column(position++, Messages.getString("ListRepositoriesCommand.4"), 0));
            for (Map repoMap : repos.values()) {
                DeliveryRepositoryInfoExchange esd = new DeliveryRepositoryInfoExchange(repoMap);
                ((InternalEngineCommandsI.Column)columns.get((Object)"name")).datas.add(esd.getName());
                ((InternalEngineCommandsI.Column)columns.get((Object)"type")).datas.add(esd.getType());
                ((InternalEngineCommandsI.Column)columns.get((Object)"webService")).datas.add(String.valueOf(esd.isWebservice()));
                ((InternalEngineCommandsI.Column)columns.get((Object)"default")).datas.add(String.valueOf(esd.isDefault()));
                ((InternalEngineCommandsI.Column)columns.get((Object)"scanMode")).datas.add(esd.getStringScanMode());
            }
            out.println(InternalEngineCommandsI.formatList2(columns, null));
        } else {
            out.println(Messages.getString("ListRepositoriesCommand.5"));
        }
    }
}

