/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command.impl;

import com.indy.engine.command.impl.InternalEngineCommandsI;
import com.indy.engine.command.impl.Messages;
import com.indy.engine.command.impl.RuntimeCommand;
import com.indy.engine.common.command.parser.CommandLine;
import com.indy.engine.common.command.parser.CommandParameter;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.objects2.EngineScheduleDetail;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@CommandLine(startWith="get list schedules", removeString="get list schedules", usage="get list schedules [to <file>]", description="Get list of schedules on scheduler")
public class ListScheduleCommand
implements RuntimeCommand {
    @CommandParameter(name="file", valueSample="file", usage="to file")
    public String fileName;

    @Override
    public void execute(IEngineClient engineAPI, PrintStream out, Map<String, Object> ctx) throws Exception {
        FileOutputStream fos = null;
        List schedules = engineAPI.getLstSchedules(null);
        try {
            if (this.fileName != null) {
                fos = new FileOutputStream(this.fileName);
            }
        }
        catch (Exception exception) {
            this.fileName = null;
        }
        if (schedules != null && !schedules.isEmpty()) {
            HashMap<String, InternalEngineCommandsI.Column> columns = new HashMap<String, InternalEngineCommandsI.Column>();
            int position = 0;
            columns.put("name", new InternalEngineCommandsI.Column(position++, Messages.getString("ListScheduleCommand.0"), 0));
            columns.put("triggerName", new InternalEngineCommandsI.Column(position++, Messages.getString("ListScheduleCommand.1"), 0));
            columns.put("logLevel", new InternalEngineCommandsI.Column(position++, Messages.getString("ListScheduleCommand.5"), 0));
            for (Map scheduleMap : schedules) {
                EngineScheduleDetail esd = new EngineScheduleDetail(scheduleMap);
                if (this.fileName == null) {
                    ((InternalEngineCommandsI.Column)columns.get((Object)"name")).datas.add(esd.getScheduleName());
                    ((InternalEngineCommandsI.Column)columns.get((Object)"triggerName")).datas.add(esd.getTriggerName());
                    ((InternalEngineCommandsI.Column)columns.get((Object)"logLevel")).datas.add(esd.getLogLevel());
                    continue;
                }
                fos.write((String.valueOf(esd.getTriggerName()) + System.getProperty("line.separator")).getBytes());
            }
            if (this.fileName != null && fos != null) {
                out.println(String.valueOf(Messages.getString("ListScheduleCommand.2")) + this.fileName);
            } else {
                out.println(InternalEngineCommandsI.formatList2(columns, null));
            }
            if (this.fileName != null && fos != null) {
                fos.close();
            }
        } else {
            out.println(Messages.getString("ListScheduleCommand.3"));
        }
    }
}

