/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command.impl;

import com.indy.engine.command.impl.Messages;
import com.indy.engine.command.impl.RuntimeCommand;
import com.indy.engine.common.command.parser.CommandLine;
import com.indy.engine.common.command.parser.CommandParameter;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.CommonUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@CommandLine(startWith="purge", usage="purge keep <number> <minute|hour|day|session> [sessionname <name,name2,...>] [sessionid <id,id2,...>] [status <done,error,killed,dead>] [currentRuntime]", description="do a purge", removeString="purge")
public class PurgeLogCronDefineCommand
implements RuntimeCommand {
    @CommandParameter(name="keep", parameters={"size", "unit"}, required=true)
    public Map<String, String> keep;
    @CommandParameter(name="sessionname")
    public String sessionnames;
    @CommandParameter(name="sessionid")
    public String sessionids;
    @CommandParameter(name="status")
    public String statuses;
    @CommandParameter(name="currentRuntime")
    public Boolean currentRuntime;

    @Override
    public void execute(IEngineClient engineAPI, PrintStream out, Map<String, Object> ctx) throws Exception {
        block22: {
            HashMap<String, Object> rules;
            boolean withCurrentRuntime;
            block23: {
                int n;
                boolean withSessionId = this.sessionids != null && !this.sessionids.trim().isEmpty();
                boolean withSessionName = this.sessionnames != null && !this.sessionnames.trim().isEmpty();
                boolean withSessionStatus = this.statuses != null && !this.statuses.trim().isEmpty();
                boolean bl = withCurrentRuntime = this.currentRuntime != null && this.currentRuntime != false;
                if (withSessionId) {
                    String[] stringArray = this.sessionids.split(",");
                    int n2 = stringArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String sessionid = stringArray[n3];
                        engineAPI.deleteSession(sessionid);
                        ++n3;
                    }
                }
                if (!withSessionName && !withSessionStatus && !withCurrentRuntime && withSessionId) break block22;
                rules = new HashMap<String, Object>();
                rules.putAll(this.keep);
                if (withSessionName) {
                    int i = 0;
                    HashMap purgeSessionName = new HashMap();
                    Object object = this.sessionnames.split(",");
                    int n4 = ((String[])object).length;
                    n = 0;
                    while (n < n4) {
                        String sessionname = object[n];
                        HashMap<String, String> filter = new HashMap<String, String>();
                        filter.put("filter", sessionname);
                        purgeSessionName.put(String.valueOf(i++), filter);
                        ++n;
                    }
                    rules.put("purgeSessionName", purgeSessionName);
                }
                if (!withSessionStatus) break block23;
                ArrayList<Integer> purgeStatusList = new ArrayList<Integer>();
                this.statuses = this.statuses.toLowerCase();
                String[] stringArray = this.statuses.split(",");
                n = stringArray.length;
                int n5 = 0;
                while (n5 < n) {
                    String status = stringArray[n5];
                    switch (status) {
                        case "done": {
                            purgeStatusList.add(1);
                            break;
                        }
                        case "error": {
                            purgeStatusList.add(-1);
                            break;
                        }
                        case "killed": {
                            purgeStatusList.add(-2);
                            break;
                        }
                        case "dead": {
                            purgeStatusList.add(-4);
                            break;
                        }
                        default: {
                            throw new Exception(String.valueOf(Messages.getString("InternalEngineCommandsI.117")) + status + Messages.getString("InternalEngineCommandsI.118"));
                        }
                    }
                    rules.put("purgeStatusList", purgeStatusList);
                    ++n5;
                }
            }
            if (withCurrentRuntime) {
                rules.put("currentRuntime", "currentRuntime");
            }
            Map parameters = CommonUtils.transformPurgeMap(rules);
            engineAPI.purgeLogs(parameters);
        }
    }
}

