/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.delivery;

import com.indy.engine.delivery.Delivery;
import com.indy.engine.delivery.Messages;
import com.indy.engine.manager.Action;
import com.indy.engine.wsdl.EmptyContentHandler;
import com.indy.engine.wsdl.WsdlAPI;
import com.indy.runtime.wsdl.HttpRestDeliveryProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Utils {
    static Map<String, Delivery> deliveriesRegistry = Collections.synchronizedMap(new HashMap());
    static Map<String, Set<String>> procToDeliveries = new HashMap<String, Set<String>>();

    public static Delivery parseDelivery(File deliv, WsdlAPI wsdlAPI, boolean force) throws Exception {
        return Utils.parseDelivery(deliv, wsdlAPI, force, wsdlAPI == null ? null : wsdlAPI.getMetaDataSchema().getSchemaNodes(), null);
    }

    public static Delivery parseDelivery(File deliv, WsdlAPI wsdlAPI, boolean force, Map<String, List<Node>> schemaNodes, Map<String, String> swaggers) throws Exception {
        if (deliv.exists()) {
            Delivery d = deliveriesRegistry.get(deliv.getPath());
            if (force || d == null || d.getLastAccess() != deliv.lastModified()) {
                Set<String> list;
                Delivery currentDelivery = new Delivery();
                currentDelivery.setLastAccess(deliv.lastModified());
                String name = deliv.getName().substring(0, deliv.getName().lastIndexOf(46));
                currentDelivery.setName(name);
                FileInputStream is = new FileInputStream(deliv);
                currentDelivery = Utils.parseDelivery(is, wsdlAPI, schemaNodes, swaggers, currentDelivery);
                deliveriesRegistry.put(deliv.getPath(), currentDelivery);
                if (d != null && d.getProcId() != null && (list = procToDeliveries.get(d.getProcId())) != null) {
                    list.remove(deliv.getPath());
                }
                if (currentDelivery.getProcId() != null) {
                    list = procToDeliveries.get(currentDelivery.getProcId());
                    if (list == null) {
                        list = new HashSet<String>();
                        procToDeliveries.put(currentDelivery.getProcId(), list);
                    }
                    list.add(deliv.getPath());
                }
                return currentDelivery;
            }
            return d;
        }
        deliveriesRegistry.remove(deliv.getPath());
        return null;
    }

    public static Delivery parseDelivery(InputStream is, final WsdlAPI wsdlAPI, final Map<String, List<Node>> schemaNodes, final Map<String, String> swaggers, final Delivery currentDelivery) throws Exception {
        Delivery delivery = null;
        if (is != null) {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(Utils.class.getClassLoader());
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                parserFactory.setFeature("http://xml.org/sax/features/validation", false);
                parserFactory.setNamespaceAware(true);
                SAXParser parser = parserFactory.newSAXParser();
                XMLReader saxReader = parser.getXMLReader();
                EmptyContentHandler sch = new EmptyContentHandler(){
                    String path = "";
                    String text = null;
                    Delivery.Route currentRoute;
                    Delivery.Connection currentConnection;
                    private Delivery.AltId currentAltId;

                    @Override
                    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
                        if (this.path.equals("/delivery/connection")) {
                            currentDelivery.getConnection().add(this.currentConnection);
                            this.currentConnection = null;
                        } else if (this.path.equals("/delivery/metaData")) {
                            if (this.currentRoute != null && this.currentRoute.getType().equals("json")) {
                                if (!this.text.isEmpty() && swaggers != null) {
                                    try {
                                        this.currentRoute.setCheckSum(Utils.checkSum(this.text));
                                    }
                                    catch (NoSuchAlgorithmException e) {
                                        e.printStackTrace();
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        e.printStackTrace();
                                    }
                                    swaggers.put(this.currentRoute.getCheckSum(), this.text);
                                }
                            } else if (this.currentRoute != null && this.currentRoute.getType().equals("xsd") && wsdlAPI != null && !wsdlAPI.getMetaDataSchema().getSchemaMap().containsKey(this.currentRoute.getId())) {
                                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                                try {
                                    factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                                    factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                                    DocumentBuilder builder = factory.newDocumentBuilder();
                                    InputSource is = new InputSource(new StringReader(this.text));
                                    Document d = builder.parse(is);
                                    int i = 0;
                                    while (d.getChildNodes().getLength() > i) {
                                        Node targetnamespace;
                                        Node n = d.getChildNodes().item(i);
                                        if (((Element)n).getAttribute("targetNamespace") == null || ((Element)n).getAttribute("targetNamespace").isEmpty()) {
                                            ((Element)n).setAttribute("targetNamespace", "http://stambia.com/noNamespace");
                                        }
                                        if ((targetnamespace = n.getAttributes().getNamedItem("targetNamespace")) != null) {
                                            wsdlAPI.getMetaDataSchema().getSchemaMap().put(this.currentRoute.getId(), targetnamespace.getNodeValue());
                                        }
                                        String nameSpace = ((Element)n).getAttribute("targetNamespace");
                                        if (schemaNodes != null) {
                                            List<Node> nodes;
                                            if (!schemaNodes.isEmpty() && schemaNodes.containsKey(nameSpace)) {
                                                nodes = (List)schemaNodes.get(nameSpace);
                                                nodes.add(n);
                                            } else {
                                                nodes = new ArrayList<Node>();
                                                nodes.add(n);
                                                schemaNodes.put(nameSpace, nodes);
                                            }
                                        }
                                        ++i;
                                    }
                                }
                                catch (ParserConfigurationException e) {
                                    e.printStackTrace();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            this.currentRoute = null;
                        } else if (this.path.equals("/delivery/altId")) {
                            currentDelivery.getAltId().add(this.currentAltId);
                            this.currentAltId = null;
                        }
                        this.path = this.path.substring(0, this.path.lastIndexOf("/"));
                    }

                    @Override
                    public void startElement(String arg0, String localName, String arg2, Attributes arg3) throws SAXException {
                        this.path = String.valueOf(this.path) + "/" + localName;
                        if (this.path.equals("/delivery")) {
                            try {
                                if (arg3.getValue("externalized") != null) {
                                    currentDelivery.setExternalized(Boolean.valueOf(arg3.getValue("externalized")));
                                }
                                if (arg3.getValue("processId") != null) {
                                    currentDelivery.setProcId(arg3.getValue("processId"));
                                }
                                if (arg3.getValue("configurationCode") != null) {
                                    currentDelivery.setConfigurationCode(arg3.getValue("configurationCode"));
                                }
                                if (arg3.getValue("allowedScriptErrors") != null) {
                                    currentDelivery.setAllowedScriptErrors(arg3.getValue("allowedScriptErrors"));
                                }
                                if (arg3.getValue("allowedVariableErrors") != null) {
                                    currentDelivery.setAllowedVariableErrors(arg3.getValue("allowedVariableErrors"));
                                }
                                if (arg3.getValue("id") != null) {
                                    currentDelivery.setId(arg3.getValue("id"));
                                }
                                if (arg3.getValue("userName") != null) {
                                    currentDelivery.setBuildUser(arg3.getValue("userName"));
                                }
                                if (arg3.getValue("buildUser") != null) {
                                    currentDelivery.setBuildUser(arg3.getValue("buildUser"));
                                }
                                if (arg3.getValue("date") != null) {
                                    currentDelivery.setBuildDate(arg3.getValue("date"));
                                }
                                if (arg3.getValue("buildDate") != null) {
                                    currentDelivery.setBuildDate(arg3.getValue("buildDate"));
                                }
                                if (arg3.getValue("exportDate") != null) {
                                    currentDelivery.setExportDate(arg3.getValue("exportDate"));
                                }
                                if (arg3.getValue("exportUser") != null) {
                                    currentDelivery.setExportUser(arg3.getValue("exportUser"));
                                }
                                if (arg3.getValue("packageId") != null) {
                                    currentDelivery.setPackageId(arg3.getValue("packageId"));
                                }
                                if (arg3.getValue("version") != null) {
                                    currentDelivery.setVersion(arg3.getValue("version"));
                                }
                                if (arg3.getValue("description") != null) {
                                    currentDelivery.setDescription(arg3.getValue("description"));
                                }
                                if (arg3.getValue("checksum") != null) {
                                    currentDelivery.setChecksum(arg3.getValue("checksum"));
                                }
                                if (arg3.getValue("checksumVersion") != null) {
                                    currentDelivery.setChecksumVersion(arg3.getValue("checksumVersion"));
                                }
                                try {
                                    NodeList nl;
                                    String tmp;
                                    if (arg3.getValue("metaInf") != null && (tmp = arg3.getValue("metaInf")) != null && (nl = Action.parseMetaInf(tmp)) != null && nl.getLength() > 0) {
                                        int k = 0;
                                        while (k < nl.getLength()) {
                                            String value;
                                            Node node = nl.item(k);
                                            if (node.getNodeName().equals("produceOutputIfError")) {
                                                value = node.getTextContent();
                                                tmp = value;
                                                if (tmp != null && tmp.equals("true")) {
                                                    currentDelivery.setProduceOutputIfError(true);
                                                }
                                            } else if (node.getNodeName().equals("defaultXmlEncoding")) {
                                                value = node.getTextContent();
                                                tmp = value;
                                                if (tmp != null && !tmp.isEmpty()) {
                                                    currentDelivery.setDefaultXmlEncoding(tmp);
                                                }
                                            } else if (node.getNodeName().equals("defaultWriteXmlDeclartion")) {
                                                value = node.getTextContent();
                                                tmp = value;
                                                if (tmp != null && tmp.equals("false")) {
                                                    currentDelivery.setdefaultriteXmlDeclation(false);
                                                }
                                            } else if (node.getNodeName().equals("httpRestWebServiceProperties")) {
                                                HttpRestDeliveryProperties hrdp = HttpRestDeliveryProperties.getHttpRestDeliveryProperties((Node)node, (String)currentDelivery.getName());
                                                currentDelivery.setHttpRestDeliveryProperties(hrdp);
                                            } else if (node.getNodeName().equals("keepInputMessage")) {
                                                value = node.getTextContent();
                                                tmp = value;
                                                if (tmp != null && !tmp.isEmpty()) {
                                                    currentDelivery.setKeepInputMessage(tmp);
                                                }
                                            } else if (node.getNodeName().equals("keepOutputMessage")) {
                                                value = node.getTextContent();
                                                tmp = value;
                                                if (tmp != null && !tmp.isEmpty()) {
                                                    currentDelivery.setKeepOutputMessage(tmp);
                                                }
                                            } else if (node.getNodeName().equals("keepFaultMessage") && (tmp = (value = node.getTextContent())) != null && !tmp.isEmpty()) {
                                                currentDelivery.setKeepFaultMessage(tmp);
                                            }
                                            ++k;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (this.path.equals("/delivery/connection/transaction")) {
                            this.currentConnection.getTransaction().add(arg3.getValue("name"));
                        } else if (this.path.equals("/delivery/connection/parameter")) {
                            try {
                                this.currentConnection.getConnectionParam().put(arg3.getValue("name"), arg3.getValue("value"));
                            }
                            catch (Exception exception) {}
                        } else if (this.path.equals("/delivery/connection")) {
                            this.currentConnection = new Delivery.Connection();
                            this.currentConnection.setName(arg3.getValue("name"));
                            this.currentConnection.setType(arg3.getValue("type"));
                        } else if (this.path.equals("/delivery/parameter") || this.path.equals("/delivery/metaData")) {
                            boolean fault;
                            boolean input = arg3.getValue("input") != null && arg3.getValue("input").equals("true");
                            boolean output = arg3.getValue("output") != null && arg3.getValue("output").equals("true");
                            boolean bl = fault = arg3.getValue("fault") != null && arg3.getValue("fault").equals("true");
                            if (input || output || fault) {
                                if (this.path.equals("/delivery/parameter")) {
                                    Delivery.Parameter param = new Delivery.Parameter();
                                    param.setName(arg3.getValue("vName"));
                                    param.setType(arg3.getValue("type"));
                                    param.setInput(input);
                                    param.setOutput(output);
                                    param.setFault(fault);
                                    param.setDefaultValue(arg3.getValue("value"));
                                    currentDelivery.getParameters().put(param.getName(), param);
                                } else if (this.path.equals("/delivery/metaData")) {
                                    this.text = "";
                                    this.currentRoute = new Delivery.Route();
                                    this.currentRoute.setResource(arg3.getValue("resource"));
                                    this.currentRoute.setElementName(arg3.getValue("name"));
                                    this.currentRoute.setId(arg3.getValue("id"));
                                    this.currentRoute.setType(arg3.getValue("type"));
                                    this.currentRoute.setInternetMediaType(arg3.getValue("internetMediaType"));
                                    this.currentRoute.setInput(input);
                                    this.currentRoute.setOutput(output);
                                    this.currentRoute.setFault(fault);
                                    currentDelivery.setRoute(this.currentRoute.getElementName(), this.currentRoute);
                                }
                            }
                        } else if (this.path.equals("/delivery/altId")) {
                            if (currentDelivery.getProcId() != null && !currentDelivery.getProcId().isEmpty()) {
                                throw new SAXException("StopByUser");
                            }
                            this.currentAltId = currentDelivery.createAltId();
                            this.currentAltId.setOrigin(arg3.getValue("origin"));
                            this.currentAltId.setValue(arg3.getValue("value"));
                            if (this.currentAltId.getOrigin().equals("compilation")) {
                                currentDelivery.setProcId(this.currentAltId.getId());
                            }
                        } else if (this.path.equals("/delivery/process")) {
                            throw new SAXException(Messages.getString("Utils.0"));
                        }
                    }

                    @Override
                    public void characters(char[] ch, int start, int end) throws SAXException {
                        this.text = String.valueOf(this.text) + new String(ch, start, end);
                    }
                };
                saxReader.setContentHandler(sch);
                try {
                    saxReader.parse(new InputSource(is));
                }
                catch (SAXException e) {
                    if (e.getMessage() != null && !e.getMessage().equals("StopByUser")) {
                        throw e;
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
                if (is != null) {
                    is.close();
                }
            }
            delivery = currentDelivery;
        }
        return delivery;
    }

    public static Map<String, Object> deliveryToMap(Delivery delivery) {
        HashMap<String, Object> mapReturn = new HashMap<String, Object>();
        Map<String, Delivery.Parameter> mapParam = delivery.getParameters();
        List<Delivery.Connection> listConnection = delivery.getConnection();
        HashMap mapParam2 = new HashMap();
        mapReturn.put("externalized", delivery.isExternalized());
        mapReturn.put("idDeliv", delivery.getId());
        mapReturn.put("idProc", delivery.getProcId());
        mapReturn.put("userName", delivery.getBuildUser());
        mapReturn.put("buildUser", delivery.getBuildUser());
        mapReturn.put("date", delivery.getBuildDate());
        mapReturn.put("buildDate", delivery.getBuildDate());
        mapReturn.put("exportDate", delivery.getExportDate());
        mapReturn.put("exportUser", delivery.getExportUser());
        mapReturn.put("packageId", delivery.getPackageId());
        mapReturn.put("configurationCode", delivery.getConfigurationCode());
        mapReturn.put("deliveryName", delivery.getName());
        mapReturn.put("version", delivery.getVersion());
        mapReturn.put("description", delivery.getDescription());
        mapReturn.put("lastModifiedDate", delivery.getLastAccess());
        mapReturn.put("checksum", delivery.getChecksum());
        mapReturn.put("checksumVersion", delivery.getChecksumVersion());
        for (Map.Entry<String, Delivery.Parameter> entry : mapParam.entrySet()) {
            HashMap<String, String> mapDetail = new HashMap<String, String>();
            Delivery.Parameter param = entry.getValue();
            mapDetail.put("value", param.getDefaultValue());
            mapDetail.put("name", param.getName());
            mapDetail.put("type", param.getType());
            mapDetail.put("is_fault", String.valueOf(param.isFault()));
            mapDetail.put("is_output", String.valueOf(param.isOutput()));
            mapDetail.put("is_input", String.valueOf(param.isInput()));
            String paramName = entry.getKey();
            mapParam2.put(paramName, mapDetail);
        }
        HashMap mapParam3 = new HashMap();
        for (Delivery.Connection connection : listConnection) {
            Map<String, String> paramConnection = connection.getConnectionParam();
            List<String> transaction = connection.getTransaction();
            String name = connection.getName();
            String type = connection.getType();
            HashMap<String, Object> mapDetail = new HashMap<String, Object>();
            mapDetail.put("transaction", transaction);
            mapDetail.put("parameter", paramConnection);
            mapDetail.put("type", type);
            mapParam3.put(name, mapDetail);
        }
        mapReturn.put("parameters", mapParam2);
        mapReturn.put("connection", mapParam3);
        return mapReturn;
    }

    public static String checkSum(String raw) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] thedigest = md.digest(raw.getBytes("UTF-8"));
        return Base64.getEncoder().encodeToString(thedigest);
    }
}

