/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.action.statics;

import com.indy.engine.core.common.objects2.IIdDataExchange;
import com.indy.engine.core.common.objects2.IdDataExchange;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.action.statics.ActionStatic;
import com.indy.engine.main.action.statics.ConnectionStore;
import com.indy.engine.main.action.statics.Messages;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.DatatypeConverter;

public class SessionStatic {
    private Map<String, Map<String, IIdDataExchange>> lstActionsAltId = new HashMap<String, Map<String, IIdDataExchange>>();
    private Map<String, Map<String, IIdDataExchange>> allAltId = new HashMap<String, Map<String, IIdDataExchange>>();
    private Set<ConnectionStore> allConnections = new HashSet<ConnectionStore>();
    private Integer nbParallelizeExecution;
    private boolean allowedScriptErrors;
    private boolean allowedVariableErrors;
    Map<String, ActionStatic> allStaticActionsByName = new HashMap<String, ActionStatic>();
    Map<String, ActionStatic> allStaticActionsById = new HashMap<String, ActionStatic>();
    private ActionStatic startAction;
    private String configuration;
    private String dlvId;
    private String packageId;
    private String description;
    private String version;
    private String buildUser;
    private Date buildDate;
    int logLevel = MainEngineI.noLogLevel;
    private String deliveryName;
    private boolean externalized;
    Integer retryNumber = null;
    Integer retryInterval = null;
    private String checksum;

    public void addConnection(ConnectionStore conn) {
        this.allConnections.add(conn);
    }

    public void clear() throws Exception {
        if (this.lstActionsAltId != null) {
            this.lstActionsAltId.clear();
        }
        this.lstActionsAltId = null;
        if (this.allConnections != null) {
            this.allConnections.clear();
        }
        this.allConnections = null;
        if (this.allStaticActionsById != null) {
            this.allStaticActionsById.clear();
        }
        this.allStaticActionsById = null;
        if (this.allStaticActionsByName != null) {
            this.allStaticActionsByName.clear();
        }
        this.allStaticActionsByName = null;
        this.startAction = null;
        if (this.allConnections != null) {
            this.allConnections.clear();
        }
        this.allConnections = null;
        if (this.allAltId != null) {
            this.allAltId.clear();
            this.allAltId = null;
        }
    }

    public void setNbParallelizeExecution(Integer valueOf) {
        this.nbParallelizeExecution = valueOf;
    }

    public void setAllowedScriptErrors(boolean allowedScriptErrors) {
        this.allowedScriptErrors = allowedScriptErrors;
    }

    public void setAllowedVariableErrors(boolean allowedVariableErrors) {
        this.allowedVariableErrors = allowedVariableErrors;
    }

    public void setSessionConf(String nodeValue) {
        this.configuration = nodeValue;
    }

    public void addAction(ActionStatic action) throws Exception {
        if (this.allStaticActionsByName.containsKey(action.name)) {
            throw new Exception(String.valueOf(Messages.getString("SessionStatic.0")) + action.name + Messages.getString("SessionStatic.1"));
        }
        this.allStaticActionsByName.put(action.name, action);
        this.allStaticActionsById.put(action.id, action);
    }

    void addAltIdAssociation(String altId, String origin, ActionStatic action) {
        IdDataExchange ide = new IdDataExchange(altId, action.name, origin);
        Map<String, IIdDataExchange> tm = this.lstActionsAltId.get(altId);
        if (tm == null) {
            tm = new TreeMap<String, IIdDataExchange>();
            this.lstActionsAltId.put(altId, tm);
        }
        tm.put(action.id, (IIdDataExchange)ide);
        Map<String, IIdDataExchange> tm2 = this.allAltId.get(action.id);
        if (tm2 == null) {
            tm2 = new TreeMap<String, IIdDataExchange>();
            this.allAltId.put(action.id, tm2);
        }
        tm2.put(origin, (IIdDataExchange)ide);
    }

    public String getDlvId() {
        return this.dlvId;
    }

    public String getProcId() {
        for (String key : this.startAction.getAltIds().keySet()) {
            String value = this.startAction.getAltIds().get(key);
            if (!value.equals("compilation")) continue;
            return key;
        }
        return null;
    }

    public void setDlvId(String dlvId) {
        this.dlvId = dlvId;
    }

    public ActionStatic getStartAction() {
        return this.startAction;
    }

    public void setStartAction(ActionStatic action) {
        this.startAction = action;
    }

    public ActionStatic getActionByName(String nodeValue) {
        return this.allStaticActionsByName.get(nodeValue);
    }

    public ActionStatic getActionById(String nodeValue) {
        return this.allStaticActionsById.get(nodeValue);
    }

    public Collection<ConnectionStore> getConnection() {
        return this.allConnections;
    }

    public Collection<ActionStatic> getDefaultActions() {
        return this.allStaticActionsByName.values();
    }

    public Integer getNbMaxParallelSessions() {
        return this.nbParallelizeExecution;
    }

    public boolean isAllowedScriptErrors() {
        return this.allowedScriptErrors;
    }

    public boolean isAllowedVariableErrors() {
        return this.isAllowedVariableErrors();
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public Map<String, Map<String, IIdDataExchange>> getAltIds() {
        return this.lstActionsAltId;
    }

    public Map<String, IIdDataExchange> getAltIds(String actionId) {
        return this.allAltId.get(actionId);
    }

    public void setBuildUser(String nodeValue) {
        this.buildUser = nodeValue;
    }

    public void setVersion(String nodeValue) {
        this.version = nodeValue;
    }

    public void setDescription(String nodeValue) {
        this.description = nodeValue;
    }

    public void setBuildDate(String nodeValue) {
        Calendar c = DatatypeConverter.parseDateTime((String)nodeValue);
        this.buildDate = c.getTime();
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildUser() {
        return this.buildUser;
    }

    public Date getBuildDate() {
        return this.buildDate;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setRetryNumber(Integer retryNumber) {
        this.retryNumber = retryNumber;
    }

    public Integer getRetryNumber() {
        return this.retryNumber;
    }

    public void setRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Integer getRetryInterval() {
        if (this.retryInterval == null) {
            return 0;
        }
        return this.retryInterval;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public String getDeliveryName() {
        return this.deliveryName;
    }

    public void setDeliveryName(String deliveryName2) {
        this.deliveryName = deliveryName2;
    }

    public void setExternalized(boolean valueOf) {
        this.externalized = valueOf;
    }

    public boolean isExternalized() {
        return this.externalized;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getProcName() {
        return this.startAction.getActionName();
    }
}

