/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.listener.impl;

import com.indy.engine.main.action.statics.ActionStatic;
import com.indy.engine.main.action.statics.ActionStaticCode;
import com.indy.engine.main.action.statics.SessionStatic;
import com.indy.engine.main.listener.impl.ActionEventProvider;
import com.indy.engine.main.listener.impl.ActionFilter;
import com.indy.engine.main.listener.impl.Event;
import com.indy.engine.main.listener.impl.EventTrigger;
import com.indy.engine.main.listener.impl.SessionFilter;
import com.indy.engine.main.listener.impl.SynchEvent;
import com.indy.engine.main.listener.impl.UserLog;
import com.indy.engine.main.listener.impl.eval.Evaluator;
import com.indy.engine.main.listener.impl.eval.EvaluatorAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.w3c.dom.Node;

@XmlRootElement(name="events")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EventManager {
    @XmlElement(name="actionEventProvider")
    List<ActionEventProvider> actionListeners = new ArrayList<ActionEventProvider>();
    @XmlElement(name="synchEvent")
    List<SynchEvent> synchEvents = new ArrayList<SynchEvent>();
    @XmlElement(name="userLog")
    List<UserLog> userLogs = new ArrayList<UserLog>();
    @XmlTransient
    public Map<Event, List<EventTrigger>> eventToTrigger = new HashMap<Event, List<EventTrigger>>();
    static JAXBContext context;

    static {
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{EventManager.class});
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public void buildCrossRef() {
        ArrayList<UserLog> triggers = new ArrayList<UserLog>(this.userLogs);
        for (EventTrigger eventTrigger : triggers) {
            for (Event event : eventTrigger.events) {
                List<EventTrigger> list = this.eventToTrigger.get(event);
                if (list == null) {
                    list = new ArrayList<EventTrigger>();
                    this.eventToTrigger.put(event, list);
                }
                list.add(eventTrigger);
            }
        }
    }

    public static void main(String[] args) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{EventManager.class});
            EventManager config = new EventManager();
            config = (EventManager)context.createUnmarshaller().unmarshal(new File("d:/test/events.xml"));
            context.createMarshaller().marshal((Object)config, new File("d:/test/events2.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Collection<ActionEventProvider> staticActionEvaluation(ActionStatic action, SessionStatic session) {
        ArrayList<ActionEventProvider> list = new ArrayList<ActionEventProvider>();
        for (ActionEventProvider slc : this.actionListeners) {
            EvaluatorAdapter adapter;
            Evaluator eval;
            boolean ok = slc.eval(eval = (adapter = new EvaluatorAdapter(action, session){
                final EvaluatorAdapter adapter = this;
                Evaluator actionFilterEvaluator;
                Evaluator sessionFilterEvaluator;
                {
                    this.actionFilterEvaluator = new Evaluator(){

                        @Override
                        public String getPropertyValue(String name) {
                            if (name != null) {
                                if (name.equalsIgnoreCase("path")) {
                                    return actionStatic.getActionName();
                                }
                                if (name.equalsIgnoreCase("name")) {
                                    return actionStatic.getShortName();
                                }
                                if (name.equalsIgnoreCase("technology")) {
                                    if (actionStatic instanceof ActionStaticCode) {
                                        return ((ActionStaticCode)actionStatic).getActionTechnology();
                                    }
                                } else {
                                    if (name.equalsIgnoreCase("id")) {
                                        return actionStatic.getActionId();
                                    }
                                    if (name.equalsIgnoreCase("errorsAccepted")) {
                                        return actionStatic.getToleratedError() ? "true" : "false";
                                    }
                                }
                            }
                            return null;
                        }

                        @Override
                        public Evaluator adapt(Class clazz) {
                            return adapter.adapt(clazz);
                        }
                    };
                    this.sessionFilterEvaluator = new Evaluator(){

                        @Override
                        public String getPropertyValue(String name) {
                            if (name != null) {
                                if (name.equalsIgnoreCase("configuration")) {
                                    return sessionStatic.getConfiguration();
                                }
                                if (name.equalsIgnoreCase("builduser")) {
                                    return sessionStatic.getBuildUser();
                                }
                                if (name.equalsIgnoreCase("deliveryid")) {
                                    return sessionStatic.getDlvId();
                                }
                                if (name.equalsIgnoreCase("packageid")) {
                                    return sessionStatic.getPackageId();
                                }
                                if (name.equalsIgnoreCase("version")) {
                                    return sessionStatic.getVersion();
                                }
                                if (name.equalsIgnoreCase("deliveryname")) {
                                    return sessionStatic.getDeliveryName();
                                }
                            }
                            return null;
                        }

                        @Override
                        public Evaluator adapt(Class clazz) {
                            return adapter.adapt(clazz);
                        }
                    };
                }

                @Override
                public Evaluator adapt(Class clazz) {
                    if (clazz == ActionFilter.class) {
                        return this.actionFilterEvaluator;
                    }
                    if (clazz == SessionFilter.class) {
                        return this.sessionFilterEvaluator;
                    }
                    return null;
                }
            }).adapt(ActionFilter.class));
            if (!ok) continue;
            list.add(slc);
        }
        return list;
    }

    public static EventManager loadConfiguration(File file) throws JAXBException {
        EventManager conf = (EventManager)context.createUnmarshaller().unmarshal(file);
        conf.buildCrossRef();
        return conf;
    }

    public static EventManager loadConfiguration(Node node) throws JAXBException {
        EventManager conf = (EventManager)context.createUnmarshaller().unmarshal(node);
        conf.buildCrossRef();
        return conf;
    }

    public static class EventManagerLoader {
        File file;
        long lastModified = 0L;
        EventManager eventManager;

        public EventManagerLoader(File file) {
            this.file = file;
        }

        public EventManagerLoader(Node node) throws JAXBException {
            this.eventManager = EventManager.loadConfiguration(node);
        }

        public synchronized EventManager getEventManager() throws JAXBException {
            long lastModified;
            if (this.eventManager == null) {
                if (this.file.exists()) {
                    this.lastModified = this.file.lastModified();
                    this.eventManager = EventManager.loadConfiguration(this.file);
                }
            } else if (this.file != null && (lastModified = this.file.lastModified()) > this.lastModified) {
                this.eventManager = EventManager.loadConfiguration(this.file);
                this.lastModified = lastModified;
            }
            return this.eventManager;
        }
    }
}

