/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.repository.impl;

import com.indy.engine.core.repository.IDeliveryRepositoryInfo;
import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import com.indy.engine.main.repository.impl.Messages;
import com.indy.engine.main.repository.stores.HttpRepositoryStore;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.engine.shared.plugin.IPluginFactory;
import com.indy.runtime.utils.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class CommonAnalyticsRepository
implements IDeliveryRepositoryPlugin {
    private long lastCorrectTime = 0L;
    private final String rootUrl;
    protected File cacheFolder = null;
    protected final HttpRepositoryStore httpRepositoryStore;
    protected final Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> deliveriesInfo = Collections.synchronizedMap(new HashMap());
    protected static final String pathSeparator = "/";
    protected static final String paramStarter = "?";
    protected static final String paramSeparator = "&";
    protected static final String encoding = "UTF-8";
    private static final String base64Separator = ":";
    private static final String authorization = "Authorization";
    private static final String basic = "Basic ";
    protected static final int httpOk = 200;
    private static final int httpNoContent = 204;
    protected static final int httpNotModified = 304;
    private static final int httpBadRequest = 400;
    protected static final int refreshDelay = 1000;

    public CommonAnalyticsRepository(IPluginFactory.IPluginConfiguration conf, IPluginFactory.IRelativePathResolver resolver) {
        this.httpRepositoryStore = new HttpRepositoryStore(conf, resolver);
        this.rootUrl = this.httpRepositoryStore != null ? String.valueOf(this.httpRepositoryStore.getUrl()) + pathSeparator : pathSeparator;
    }

    public IDeliveryRepositoryInfo getInfos() {
        return this.httpRepositoryStore;
    }

    public final File getDeliveryContent(IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo) throws Exception {
        block4: {
            block5: {
                String errorMessagePrefix;
                block6: {
                    if (deliveryInfo == null) break block4;
                    if (deliveryInfo.getFile() != null) break block5;
                    String query = this.getSynchronizeQuery(deliveryInfo);
                    HttpURLConnection connection = this.connect(query);
                    String deliveryName = deliveryInfo.getName();
                    errorMessagePrefix = String.valueOf(Messages.getString("CommonAnalyticsRepository.0")) + deliveryName + Messages.getString("CommonAnalyticsRepository.1");
                    if (connection == null) break block6;
                    int responseCode = connection.getResponseCode();
                    switch (responseCode) {
                        case 200: {
                            InputStream inputStream = connection.getInputStream();
                            File f = new File(this.cacheFolder, String.valueOf(deliveryName) + ".deliv");
                            f.getParentFile().mkdirs();
                            FileOutputStream outStream = new FileOutputStream(f);
                            IOUtils.copy((InputStream)inputStream, (OutputStream)outStream);
                            deliveryInfo.setFile(f);
                            break block5;
                        }
                        case 304: {
                            break block5;
                        }
                        default: {
                            String responseMessage = connection.getResponseMessage();
                            throw new IOException(String.valueOf(errorMessagePrefix) + responseMessage);
                        }
                    }
                }
                throw new IOException(String.valueOf(errorMessagePrefix) + Messages.getString("CommonAnalyticsRepository.2"));
            }
            return deliveryInfo.getFile();
        }
        return null;
    }

    public final IDeliveryRepositoryPlugin.DeliveryInfo putDelivery(InputStream inputStream, String name) throws Exception {
        throw new IOException(Messages.getString("CommonAnalyticsRepository.3"));
    }

    public final void removeDelivery(String name) throws Exception {
        throw new IOException(Messages.getString("CommonAnalyticsRepository.4"));
    }

    protected final HttpURLConnection connect(String query) throws Exception {
        int responseCode = 0;
        String responseMessage = "";
        HttpURLConnection connection = null;
        try {
            URL url = new URL(String.valueOf(this.rootUrl) + query);
            connection = (HttpURLConnection)url.openConnection();
            String user = this.httpRepositoryStore.getUser();
            if (user != null) {
                String clearPassword = this.httpRepositoryStore.getUncryptedPassword();
                String cryptedPassword = this.httpRepositoryStore.getPassword();
                if (clearPassword == null && cryptedPassword != null) {
                    SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                    semaphoreManager.getIsSemaphore(Messages.getString("CommonAnalyticsRepository.5"));
                    clearPassword = semaphoreManager.getStringAsciiInfo(cryptedPassword);
                }
                if (clearPassword != null) {
                    String encoded = Base64.getEncoder().encodeToString((String.valueOf(user) + base64Separator + clearPassword).getBytes());
                    connection.setRequestProperty(authorization, basic + encoded);
                }
            }
            responseCode = connection.getResponseCode();
            responseMessage = connection.getResponseMessage();
        }
        catch (ConnectException connectException) {
            long connectionTimeDelta = System.currentTimeMillis() - this.lastCorrectTime;
            long unreachableTolerancePeriod = this.httpRepositoryStore.getUnreachableTolerancePeriod();
            if (unreachableTolerancePeriod <= connectionTimeDelta) {
                throw connectException;
            }
            return null;
        }
        if (responseCode >= 400) {
            throw new IOException(String.valueOf(Messages.getString("CommonAnalyticsRepository.6")) + query + " " + responseMessage);
        }
        this.lastCorrectTime = System.currentTimeMillis();
        return connection;
    }

    protected abstract String getSynchronizeQuery(IDeliveryRepositoryPlugin.DeliveryInfo var1);

    protected abstract String getDeliveryContentQuery(IDeliveryRepositoryPlugin.DeliveryInfo var1);

    public void setCacheFolder(File cacheFolder) {
        this.cacheFolder = cacheFolder;
    }
}

