/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.manager;

import com.indy.engine.Global;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.action.IAction;
import com.indy.engine.main.action.statics.ActionStaticCode;
import com.indy.engine.manager.Action;
import com.indy.engine.manager.ActionCode;
import com.indy.engine.manager.ActionProcess;
import com.indy.engine.manager.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ThreadManager
implements Runnable {
    IAction startAction;
    Map<ActionCode, Thread> activeThread = new HashMap<ActionCode, Thread>();
    MainEngineI mainEngine;
    ActionProcess startProcess;
    List<ActionProcess> runningProcess = new ArrayList<ActionProcess>();
    List<ActionProcess> killingProcess = new ArrayList<ActionProcess>();
    Set<ActionCode> actionToEnd = new HashSet<ActionCode>();
    String lock = "";
    Map<ActionCode, Thread> deadThread = new HashMap<ActionCode, Thread>();
    THState state = THState.NOT_STARTED;

    public ThreadManager(MainEngineI mainEngine, IAction startAction) {
        this.mainEngine = mainEngine;
        this.startAction = startAction;
        this.initActions();
    }

    private void interruptAllActiveThread() {
        for (ActionCode code : this.activeThread.keySet()) {
            Thread thread = this.activeThread.get(code);
            if (!thread.isAlive()) continue;
            code.debug(Messages.getString("ThreadManager.0"), null);
            thread.interrupt();
        }
    }

    @Override
    public synchronized void run() {
        try {
            try {
                this.startLoop();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.error(Messages.getString("ThreadManager.1"), e);
                try {
                    if (this.startProcess.getEndDate() == null) {
                        this.startProcess.setActionState(-1);
                        this.startProcess.writeEndVariable();
                    }
                }
                catch (Exception exception) {}
                this.interruptAllActiveThread();
                this.mainEngine.NotifyThreadMainEngine();
            }
        }
        finally {
            this.interruptAllActiveThread();
            this.mainEngine.NotifyThreadMainEngine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoop() throws EngineExceptionI, InterruptedException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.startProcess(this.startProcess);
        boolean stop = false;
        do {
            ArrayList<ActionCode> actionToStart = new ArrayList<ActionCode>();
            ArrayList<ActionProcess> processToStart = new ArrayList<ActionProcess>();
            ArrayList<ActionProcess> processToEnd = new ArrayList<ActionProcess>();
            boolean wait = false;
            String string = this.lock;
            synchronized (string) {
                for (ActionCode code : this.actionToEnd) {
                    this.endCode(code);
                }
                this.actionToEnd.clear();
                if (this.state == THState.KILLED_ASKED) {
                    this.state = THState.KILLING;
                    this.killingProcess.add(this.startProcess);
                    this.startProcess.setActionState(-3);
                    this.startProcess.setHasChange();
                } else {
                    for (ActionProcess process : this.runningProcess) {
                        if (!process.hasChange() || !process.hasErrorAction() && !process.hasKillAction() || process.isKilling() || process.isEnded()) continue;
                        this.killingProcess.add(process);
                        process.setActionState(-3);
                        process.setHasChange();
                    }
                }
                for (ActionProcess process : this.killingProcess) {
                    if (!process.hasRunningAction()) {
                        processToEnd.add(process);
                        continue;
                    }
                    process.stopAction();
                }
                for (ActionProcess process : this.runningProcess) {
                    if (!process.hasChange()) continue;
                    if (!process.isKilling()) {
                        Hashtable<String, Action> table = process.getLstActivableActions();
                        if (!table.isEmpty()) {
                            Enumeration<Action> e = table.elements();
                            while (e.hasMoreElements()) {
                                Action act = e.nextElement();
                                if (act instanceof ActionProcess) {
                                    processToStart.add((ActionProcess)act);
                                    continue;
                                }
                                actionToStart.add((ActionCode)act);
                            }
                        } else if (!process.hasOnlySrcBindedAction() && !process.hasRunningAction()) {
                            processToEnd.add(process);
                        }
                    }
                    process.unSetHasChange();
                }
                for (ActionProcess process : processToEnd) {
                    this.endProcess(process);
                }
                for (ActionProcess process : processToStart) {
                    this.startProcess(process);
                }
                for (ActionCode action : actionToStart) {
                    this.startAction(action);
                }
                boolean bl = wait = this.actionToEnd.size() == 0 && processToEnd.size() == 0 && processToStart.size() == 0 && actionToStart.size() == 0 && this.runningProcess.size() > 0;
                if (wait && this.activeThread.size() == 0) {
                    for (ActionProcess process : this.runningProcess) {
                        processToEnd.add(process);
                    }
                    for (ActionProcess process : processToEnd) {
                        this.endProcess(process);
                    }
                    wait = false;
                }
            }
            if (wait && this.activeThread.size() == 0) {
                System.out.println(Messages.getString("ThreadManager.2"));
            }
            boolean bl = stop = this.runningProcess.size() == 0;
            if (!wait || stop) continue;
            if (this.state == THState.KILLING || this.killingProcess.size() > 0) {
                this.wait(1000L);
                continue;
            }
            this.wait();
        } while (!stop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyThreadManager(ActionCode action) {
        String string = this.lock;
        synchronized (string) {
            action.debug(Messages.getString("ThreadManager.3"), null);
            this.actionToEnd.add(action);
        }
        this.notifyAll();
    }

    public synchronized void notifyThreadManager() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killAction(ActionCode action) {
        String string = this.lock;
        synchronized (string) {
            Thread thread;
            if (!this.actionToEnd.contains(action) && (thread = this.activeThread.get(action)) != null && thread.isAlive() && !thread.isInterrupted()) {
                thread.interrupt();
            }
        }
    }

    private void startAction(ActionCode action) {
        Thread thread = null;
        Throwable t = null;
        try {
            try {
                action.debug(Messages.getString("ThreadManager.4"), null);
                thread = action.runAction();
                thread.setName(String.valueOf(this.mainEngine.getEngineContext().getThreadName()) + "|" + action.getActionName() + "|" + ((ActionStaticCode)action.getActionStatic()).getActionTechnology());
                thread.start();
                if (thread == null || !thread.isAlive()) {
                    throw new EngineExceptionI(Messages.getString("ThreadManager.5"));
                }
                this.activeThread.put(action, thread);
                action.debug(Messages.getString("ThreadManager.6"), null);
            }
            catch (Throwable e) {
                t = e;
                action.setToError(Messages.getString("ThreadManager.7"), t);
                try {
                    this.getMainEngine().uLog.addAction(action, this.getMainEngine().incrNumAction());
                }
                catch (EngineExceptionI engineExceptionI) {}
                this.notifyThreadManager(action);
                action.getParentAction().addRunningAction(action);
                if (t != null) {
                    action.setToError(Messages.getString("ThreadManager.8"), t);
                    this.notifyThreadManager(action);
                }
            }
        }
        finally {
            action.getParentAction().addRunningAction(action);
            if (t != null) {
                action.setToError(Messages.getString("ThreadManager.8"), t);
                this.notifyThreadManager(action);
            }
        }
    }

    private void initActions() {
        for (IAction iAction : this.mainEngine.lstActions.values()) {
            ((Action)iAction).setThreadManager(this);
            if (iAction != this.startAction) continue;
            this.startProcess = (ActionProcess)iAction;
        }
    }

    private void startProcess(ActionProcess process) throws EngineExceptionI {
        try {
            try {
                process.debug(Messages.getString("ThreadManager.9"), null);
                process.runAction();
                process.debug(Messages.getString("ThreadManager.10"), null);
            }
            catch (Throwable t) {
                process.error(Messages.getString("ThreadManager.11"), t);
                if (process.getBeginDate() == null) {
                    process.initBeginDate();
                }
                process.setActionErrorMess(Messages.getString("ThreadManager.12"));
                process.setStackTrace(t);
                process.setActionState(-3);
                this.runningProcess.add(process);
                if (process.getParentAction() != null) {
                    process.getParentAction().addRunningAction(process);
                }
                process.setHasChange();
            }
        }
        finally {
            this.runningProcess.add(process);
            if (process.getParentAction() != null) {
                process.getParentAction().addRunningAction(process);
            }
            process.setHasChange();
        }
    }

    private void endCode(ActionCode code) throws EngineExceptionI {
        try {
            code.end();
        }
        finally {
            if (code.getParentAction() != null) {
                code.getParentAction().removeRunningAction(code);
            }
            this.activeThread.remove(code);
            if (code.getThread() != null && code.getThread().isAlive()) {
                this.deadThread.put(code, code.getThread());
            }
        }
    }

    private void error(String message, Throwable t) {
        if (t != null) {
            Global.getLogger().error(String.valueOf(this.getMainEngine().getSessionName()) + " " + message, t);
        } else {
            Global.getLogger().error(String.valueOf(this.getMainEngine().getSessionName()) + " " + message);
        }
    }

    private void debug(String message, Throwable t) {
        if (t != null) {
            Global.getLogger().debug(String.valueOf(this.getMainEngine().getSessionName()) + " " + message, t);
        } else {
            Global.getLogger().debug(String.valueOf(this.getMainEngine().getSessionName()) + " " + message);
        }
    }

    private void endProcess(ActionProcess process) throws EngineExceptionI {
        try {
            process.end();
        }
        finally {
            this.killingProcess.remove(process);
            this.runningProcess.remove(process);
        }
    }

    public MainEngineI getMainEngine() {
        return this.mainEngine;
    }

    public void start() {
        this.run();
    }

    public synchronized void kill() {
        if (this.state != THState.KILLING) {
            this.state = THState.KILLED_ASKED;
        }
        this.notifyAll();
    }

    public synchronized Date getEndDate(Date beginDate) {
        long l;
        long lb = beginDate.getTime();
        while ((l = System.currentTimeMillis()) == lb) {
        }
        return new Date(l);
    }

    static enum THState {
        NOT_STARTED,
        RUNNING,
        KILLED_ASKED,
        KILLING;

    }
}

