/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.rmi;

import com.indy.engine.EngineServerI;
import com.indy.engine.Global;
import com.indy.engine.command.impl.InternalEngineCommandsI;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.CommonVersion;
import com.indy.engine.core.common.ParameterType;
import com.indy.engine.core.common.RemoteSessionInfo;
import com.indy.engine.core.common.objects2.IActionDataExchange;
import com.indy.engine.core.common.objects2.IActionDataExchangeExt;
import com.indy.engine.core.common.objects2.IEngineScheduleDetail;
import com.indy.engine.core.common.objects2.IIdDataExchange;
import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.engine.core.common.objects2.IVariable;
import com.indy.engine.core.common.objects2.SessionDataExchange;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.core.module.classloader.StambiaClassLoaderRegistry;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.delivery.Utils;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.connections.jdbc.TestConnection;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.indy.engine.remote.RemoteSessionManagement;
import com.indy.engine.rmi.Messages;
import com.indy.engine.rmi.SessionFilterCriteria;
import com.indy.engine.scheduler.impl.EngineSchedulerVersionI;
import com.indy.engine.service.ServiceManager;
import com.indy.engine.wsdl.SoapService;
import com.semarchy.xdi.engine.common.EngineFactory;
import com.semarchy.xdi.engine.common.IRemoteSessionV01;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobDetail;
import org.xml.sax.SAXException;

public abstract class EngineServerAPI_V1_2_temp
implements IEngineClient {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private EngineServerI engineServer = null;
    private boolean log;

    public EngineServerAPI_V1_2_temp(EngineServerI pEngineServer, boolean log) {
        this.engineServer = pEngineServer;
        this.log = log;
    }

    protected abstract RemoteSessionInfo getSessionInfo();

    public String encryptPassword(String value, String cipheringKey) throws Exception {
        return Global.c(value, cipheringKey);
    }

    public boolean isConnected() throws Exception {
        this.logMethod("isConnected");
        return true;
    }

    public void stopEngine(boolean immediate) throws Exception {
        this.logMethod("stopEngine");
        this.engineServer.stopEngine(0, immediate ? 0 : 1);
    }

    public void stopEngine(Map<String, Object> parameters) throws Exception {
        int mode;
        this.logMethod("stopEngine");
        Integer _mode = (Integer)parameters.get("mode");
        Integer _type = (Integer)parameters.get("type");
        Boolean immediate = (Boolean)parameters.get("immediate");
        Boolean restart = (Boolean)parameters.get("restart");
        Boolean wait = (Boolean)parameters.get("wait");
        int type = _type != null ? _type : (restart != null ? (!restart.booleanValue() ? 0 : 1) : 0);
        if (_mode != null) {
            mode = _mode;
        } else {
            mode = immediate != null ? (immediate.booleanValue() ? 0 : 1) : 1;
            if (wait != null && wait.booleanValue()) {
                mode = 2;
            }
        }
        this.engineServer.stopEngine(type, mode);
    }

    public String getEngineVersion() throws Exception {
        this.logMethod("getEngineVersion");
        return EngineServerI.getEngineTechnicalVersion();
    }

    public String getVersions() throws Exception {
        this.logMethod("getVersions");
        return this.engineServer.getVersions();
    }

    public boolean existDelivery(Map<String, Object> parameters) throws Exception {
        this.logMethod("existDelivery");
        String deliveryName = (String)parameters.get("name");
        String dir = parameters != null ? (String)parameters.get("dir") : null;
        return this.engineServer.existDelivery(deliveryName, dir);
    }

    public List<String> getLstDeliveries(Map<String, Object> parameters) throws Exception {
        this.logMethod("getLstDeliveries");
        String dir = parameters != null ? (String)parameters.get("dir") : null;
        Long maxlastModifiedDate = parameters != null ? (Long)parameters.get("maxLastModifiedDate") : null;
        return this.engineServer.getLstDeliveries(dir, maxlastModifiedDate);
    }

    public boolean getIsSemaphore(String str) throws Exception {
        this.logMethod("getIsSemaphore");
        return this.engineServer.getIsSemaphore(str);
    }

    public String setSemaphore(boolean b, String str) throws Exception {
        this.logMethod("setSemaphore");
        return this.engineServer.setSemaphore(b, str);
    }

    public int executeSession(String pSessionId) throws Exception {
        this.logMethod("executeSession");
        return this.engineServer.executeSession(pSessionId, this.getSessionInfo());
    }

    public int stopSession(String sessionId, boolean waitMode) throws Exception {
        this.logMethod("stopSession");
        return this.engineServer.stopSession(sessionId, waitMode);
    }

    public int purgeLogs(Date pUntilDate) throws Exception {
        this.logMethod("purgeLogs");
        return this.engineServer.purgeLogs(pUntilDate, null, null, false);
    }

    public int deleteSession(String pSessionId) throws Exception {
        this.logMethod("deleteSession");
        return this.engineServer.deleteSession(pSessionId, 0);
    }

    public int restartSession(String pSessionId) throws Exception {
        this.logMethod("restartSession");
        return this.engineServer.restartSession(pSessionId, this.getSessionInfo());
    }

    public int restartSession(Map<String, Object> parameters) throws Exception {
        this.logMethod("restartSession");
        String pSessionId = (String)parameters.get("sessionId");
        return this.restartSession(pSessionId);
    }

    public boolean isRunningSession(String pSessionId) throws Exception {
        this.logMethod("isRunningSession");
        return this.engineServer.isRunningSession(pSessionId);
    }

    @Deprecated
    public int schedulePurgeLog(String pJobName, List<Map<String, Object>> pScheduleList, Map<String, Object> rules) throws Exception {
        this.logMethod("schedulePurgeLog");
        this.engineServer.schedulePurgeLog(pJobName, pScheduleList, rules);
        return 1;
    }

    public int scheduleDelivery(String pJobName, String pDeliveryName, int executionMode, List<Map<String, Object>> pScheduleList) throws Exception {
        this.logMethod("scheduleDelivery");
        if (this.engineServer.scheduleDelivery(pJobName, pDeliveryName, executionMode, pScheduleList) != null) {
            return 1;
        }
        return -10;
    }

    public int scheduleDelivery(String pJobName, String pDeliveryName, int executionMode, String httpHost, int httpPort, List<Map<String, Object>> pScheduleList) throws Exception {
        this.logMethod("scheduleDelivery");
        if (this.engineServer.scheduleDelivery(pJobName, pDeliveryName, executionMode, httpHost, httpPort, pScheduleList, null, null) != null) {
            return 1;
        }
        return -10;
    }

    public List<String> getLstTriggers() throws Exception {
        this.logMethod("getLstTriggers");
        return this.engineServer.getLstTriggers();
    }

    @Deprecated
    public List<Map<String, Object>> getLstSchedules(String jobName) throws Exception {
        this.logMethod("getLstSchedules");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (IEngineScheduleDetail key : this.engineServer.getLstSchedules(jobName)) {
            if (key == null) continue;
            result.add(key.toMap());
        }
        return result;
    }

    @Deprecated
    public Map<String, Object> getTriggerDetail(String triggerName) throws Exception {
        this.logMethod("getTriggerDetail");
        IEngineScheduleDetail tmp = this.engineServer.getTriggerDetail(triggerName);
        if (tmp != null) {
            return tmp.toMap();
        }
        return null;
    }

    @Deprecated
    public int removeJobTrigger(String triggerName) throws Exception {
        this.logMethod("removeJobTrigger");
        return this.engineServer.removeJobTrigger(triggerName);
    }

    public Map<String, Map<String, Object>> getLstInstanciatedIds(String sessionId, String altId) throws Exception {
        this.logMethod("getLstInstanciatedIds");
        TreeMap<String, Map<String, Object>> result = new TreeMap<String, Map<String, Object>>();
        Map<String, IIdDataExchange> map = this.engineServer.getLstInstanciatedIds(sessionId, altId);
        if (map != null) {
            for (String key : map.keySet()) {
                IIdDataExchange o = map.get(key);
                if (o == null) continue;
                result.put(key, o.toMap());
            }
            return result;
        }
        return null;
    }

    public List<String> getLstChildIds(String sessionId, String actionId) throws Exception {
        this.logMethod("getLstChildIds");
        return this.engineServer.getLstChildIds(sessionId, actionId);
    }

    public String getEngineName(String pSessionId) throws Exception {
        this.logMethod("getEngineName");
        return this.engineServer.getEngineName(pSessionId);
    }

    public Map<String, Map<String, Object>> getDeliveries(Map<String, Object> parameters) throws Exception {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        String dir = parameters != null ? (String)parameters.get("dir") : null;
        List list = null;
        if (parameters.get("ids") instanceof List) {
            list = (List)parameters.get("ids");
        }
        List<Delivery> delivs = this.engineServer.getDeliveries(dir, null, list);
        for (Delivery deliv : delivs) {
            map.put(deliv.getName(), Utils.deliveryToMap(deliv));
        }
        return map;
    }

    public int getActionStatus(String pSessionId, String pActionId) throws Exception {
        this.logMethod("getActionStatus");
        return this.engineServer.getActionStatus(pSessionId, pActionId);
    }

    public String getActionId(String pSessionId, String actionName) throws Exception {
        this.logMethod("getActionId");
        return this.engineServer.getActionId(pSessionId, actionName);
    }

    public String getActionCode(String sessionId, String pActionId) throws Exception {
        this.logMethod("getActionCode");
        return this.engineServer.getActionCode(sessionId, pActionId);
    }

    public String getActionExecutedCode(String pSessionId, String pActionId) throws Exception {
        this.logMethod("getActionExecutedCode");
        return this.engineServer.getActionExecutedCode(pSessionId, pActionId);
    }

    public Map<String, Object> aggregateVariable(String pSessionId, String pActionId, String pVvariableName, int pFunction, String pStartingPath) throws Exception {
        this.logMethod("aggregateVariable");
        Variable var = this.engineServer.aggregateVariable(pSessionId, pActionId, pVvariableName, pFunction, pStartingPath, "$NO_SCRIPT$");
        if (var != null) {
            return var.toMap();
        }
        return null;
    }

    public Map<String, Map<String, Object>> aggregateVariables(String pSessionId, String pActionId, List<String> variableNames, int pFunction, String pStartingPath, String valueFilter) throws Exception {
        this.logMethod("aggregateVariable");
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (String pVvariableName : variableNames) {
            Variable var = this.engineServer.aggregateVariable(pSessionId, pActionId, pVvariableName, pFunction, pStartingPath, valueFilter);
            if (var == null) continue;
            result.put(pVvariableName, var.toMap());
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    public Map<String, Map<String, Object>> aggregateVariables(String pSessionId, String pActionId, List<String> variableNames, int pFunction, String pStartingPath) throws Exception {
        this.logMethod("aggregateVariable");
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (String pVvariableName : variableNames) {
            Variable var = this.engineServer.aggregateVariable(pSessionId, pActionId, pVvariableName, pFunction, pStartingPath);
            if (var == null) continue;
            result.put(pVvariableName, var.toMap());
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    public Map<String, Object> getActionVariable(String pSessionId, String pActionId, String pVariableName) throws Exception {
        this.logMethod("getActionVariable");
        Variable var = this.engineServer.getActionVariable(pSessionId, pActionId, pVariableName);
        if (var != null) {
            return var.toMap();
        }
        return null;
    }

    public Map<String, Object> getActionInfo(String pSessionId, String pActionId) throws Exception {
        this.logMethod("getActionInfo");
        IActionDataExchange tmp = this.engineServer.getActionInfo(pSessionId, pActionId);
        if (tmp != null) {
            return tmp.toMap();
        }
        return null;
    }

    public Map<String, Object> getActionExtInfo(String pSessionId, String pActionId) throws Exception {
        this.logMethod("getActionExtInfo");
        IActionDataExchangeExt tmp = this.engineServer.getActionExtInfo(pSessionId, pActionId);
        if (tmp != null) {
            return tmp.toMap();
        }
        return null;
    }

    public Map<String, Object> getSessionInfo(String pSessionId) throws Exception {
        this.logMethod("getSessionInfo");
        ISessionDataExchange sess = this.engineServer.getSessionInfo(pSessionId);
        if (sess != null && sess.getId() != null) {
            return sess.toMap();
        }
        return null;
    }

    public Map<String, Map<String, Object>> getActionLstVariables(String pSessionId, String pActionId) throws Exception {
        this.logMethod("getActionLstVariables");
        TreeMap<String, Map<String, Object>> result = new TreeMap<String, Map<String, Object>>();
        Map<String, Variable> map = this.engineServer.getActionLstVariables(pSessionId, pActionId);
        if (map != null) {
            for (String key : map.keySet()) {
                IVariable o = (IVariable)map.get(key);
                if (o == null) continue;
                result.put(key, o.toMap());
            }
            return result;
        }
        return null;
    }

    public Map<String, Map<String, Object>> getLstSessionErrors(String pSessionId) throws Exception {
        this.logMethod("getLstSessionErrors");
        TreeMap<String, Map<String, Object>> result = new TreeMap<String, Map<String, Object>>();
        Map<String, Variable> map = this.engineServer.getLstSessionErrors(pSessionId);
        if (map != null) {
            for (String key : map.keySet()) {
                Variable o = map.get(key);
                if (o == null) continue;
                result.put(key, o.toMap());
            }
        }
        return result;
    }

    public Map<String, Map<String, Object>> getLstSessionWarnings(String pSessionId) throws Exception {
        this.logMethod("getLstSessionWarnings");
        return Variable.getVariableMap(this.engineServer.getLstSessionWarnings(pSessionId));
    }

    public Map<String, Map<String, Object>> getLstRootSessionVariables(String pSessionId) throws Exception {
        this.logMethod("getLstRootSessionVariables");
        Map result = Variable.getVariableMap(this.engineServer.getLstRootSessionVariables(pSessionId));
        return result;
    }

    public void setActionVariableByName(String pSessionId, String pVariableName, Map<String, Object> newVar) throws Exception {
        this.logMethod("setActionVariableByName");
        this.engineServer.setActionVariableByName(pSessionId, pVariableName, (Variable)Variable.getVariable(newVar));
    }

    private void logMethod(String methodName) {
        if (this.log) {
            try {
                String ip = this.getSessionInfo().getClientHost();
                if (ip != null) {
                    LogRMI log = EngineServerI.getMapUser().get(ip);
                    if (log == null) {
                        log = new LogRMI();
                        EngineServerI.getMapUser().put(ip, log);
                    }
                    log.setMethod(methodName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Map<String, Map<String, Object>> getLstSession(Map<String, Object> criteria) throws Exception {
        this.logMethod("getLstSession");
        ArrayList<SessionFilterCriteria> list = new ArrayList<SessionFilterCriteria>();
        list.add(new SessionFilterCriteria(criteria));
        int nbSessions = (Integer)criteria.get("nbSessions");
        Map tmp = SessionDataExchange.getSessionMap(this.engineServer.getLstSession(nbSessions, list));
        return tmp;
    }

    public String initSessionWithStream(Object istream, Map<String, Object> parameters) throws Exception {
        try {
            this.logMethod("initSessionWithStream");
            InputStream inputStream = (InputStream)istream;
            String sessionId = this.engineServer.initSessionWithStream(inputStream, (String)parameters.get("sessionName"), (String)parameters.get("fileName"), false, (String)parameters.get("launchMode"), (String)parameters.get("guestHost"), (String)parameters.get("parentSessionId"), (Integer)parameters.get("parentSessionIter"), (String)parameters.get("guestRuntimeHost"), (Integer)parameters.get("guestRuntimePort"), (String)parameters.get("configuration"), (Integer)parameters.get("logLevel"), (Integer)parameters.get("parentLogLevel"));
            boolean doExecute = Boolean.valueOf((String)parameters.get("executeAfterInit"));
            if (doExecute) {
                Object o = parameters.get("executeAfterInit.variables");
                if (o instanceof Map) {
                    this.handleSessionVariablesPlaceHolders(sessionId, (Map)o);
                }
                this.executeSession(sessionId);
            }
            return sessionId;
        }
        catch (Exception e) {
            this.logger.warn("unexpected", (Throwable)e);
            throw e;
        }
    }

    public void soapServerAction(Map<String, Object> parameters) throws Exception {
        this.logMethod("soapServerAction");
        if (parameters != null) {
            if (parameters.get("action") != null && parameters.get("action").equals("build")) {
                this.engineServer.getWsdlAPI().initWSDL();
            } else if (parameters.get("action") != null && parameters.get("action").equals("stop")) {
                ServiceManager.INSTANCE.stopService("http");
            } else if (parameters.get("action") != null && parameters.get("action").equals("start")) {
                ServiceManager.INSTANCE.startService("http");
            }
        }
    }

    public String getApiVersion() throws Exception {
        this.logMethod("getApiVersion");
        return CommonVersion.getVersion();
    }

    public String initSession(String deliveryName, Map<String, Object> parameters) throws Exception {
        this.logMethod("initSession");
        Map variables = (Map)parameters.get("variables");
        String sessionId = this.engineServer.initSession(deliveryName, parameters, variables);
        boolean doExecute = Boolean.valueOf((String)parameters.get("executeAfterInit"));
        if (doExecute) {
            Object o = parameters.get("executeAfterInit.variables");
            if (o instanceof Map) {
                this.handleSessionVariablesPlaceHolders(sessionId, (Map)o);
            }
            this.executeSession(sessionId);
        }
        return sessionId;
    }

    public String executeDelivery(String deliveryName, Map<String, Object> parameters) throws Exception {
        this.logMethod("executeDelivery");
        String sessionId = this.initSession(deliveryName, parameters);
        if (!sessionId.equals("-1")) {
            this.engineServer.executeSession(sessionId, this.getSessionInfo());
        }
        return sessionId;
    }

    public Map<String, Object> waitSession(Map<String, Object> parameters) throws Exception {
        Variable returnCodeVariable;
        this.logMethod("waitSession");
        String sessionId = (String)parameters.get("sessionId");
        MainEngineI session = this.engineServer.getMainEngine(sessionId);
        if (session.getThread() == null) {
            session.waitForThread();
        }
        session.getThread().join();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String returnCodePath = (String)parameters.get("returnCodePath");
        String deliveryName = (String)parameters.get("deliveryName");
        if (returnCodePath != null && (returnCodeVariable = session.getEngineContext().getExpressionVariable(returnCodePath, deliveryName)) != null) {
            map.put("returnCode", Integer.parseInt(returnCodeVariable.getValue()));
        }
        return map;
    }

    public void putDelivery(Object delivery, Map<String, Object> parameters) throws Exception {
        this.logMethod("putDelivery");
        String name = (String)parameters.get("name");
        String toDir = (String)parameters.get("toDir");
        if (name == null) {
            throw new Exception(Messages.getString("EngineServerAPI_V1_2_temp.3"));
        }
        InputStream inputStream = (InputStream)delivery;
        Global.getRepository(toDir).putDelivery(inputStream, name);
    }

    public Map<String, Map<String, Object>> getLstSessionVariables(String pSessionId) throws Exception {
        this.logMethod("getLstSessionVariables");
        return Variable.getVariableMap(this.engineServer.getSessionLstVariables(pSessionId));
    }

    public int purgeLogs(Map<String, Object> parameters) throws Exception {
        this.logMethod("purgeLogs");
        Integer nbSessions = (Integer)parameters.get("nbSessions");
        Date untilDate = (Date)parameters.get("untilDate");
        Map mapSession = (Map)parameters.get("sessionName");
        ArrayList<String> filters = new ArrayList<String>();
        if (mapSession != null) {
            for (String id : mapSession.keySet()) {
                String filter;
                Map map = (Map)mapSession.get(id);
                if (map == null || (filter = (String)map.get("filter")) == null || filter.isEmpty()) continue;
                filters.add(filter);
            }
        }
        List statusList = (List)parameters.get("statusList");
        Boolean currentRuntime = (Boolean)parameters.get("currentRuntime");
        if (currentRuntime == null) {
            currentRuntime = false;
        }
        if (nbSessions != null) {
            return this.engineServer.purgeLogs(nbSessions, filters, (List<Integer>)statusList, (boolean)currentRuntime);
        }
        if (untilDate != null) {
            return this.engineServer.purgeLogs(untilDate, filters, (List<Integer>)statusList, (boolean)currentRuntime);
        }
        return -1;
    }

    public int markInactiveSessionsAsDead() throws Exception {
        this.logMethod("markInactiveSessionsAsDead");
        return this.engineServer.markInactiveSessionsAsDead();
    }

    public Map<String, Object> getLogProperties(Map<String, Object> criteria) throws EngineExceptionI {
        this.logMethod("getLogProperties");
        return Global.getLstLogParametersInRepository(Global.USERLOG_DEFAULT_NAME);
    }

    public Map<String, Object> get(Map<String, Object> parameters) throws Exception {
        this.logMethod("get");
        TreeMap<String, Object> mapReturn = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            Map mapParam;
            String function = entry.getKey();
            if (function.equals(EngineFactory.FUNCTION_THREAD)) {
                mapReturn.put(EngineFactory.FUNCTION_THREAD, this.getAllThreads());
                continue;
            }
            if (function.equals(EngineFactory.FUNCTION_CLIENT_RMI)) {
                mapReturn.put(EngineFactory.FUNCTION_CLIENT_RMI, this.getConnectedClient());
                continue;
            }
            if (function.equals(EngineFactory.FUNCTION_MONITORING_SUMMARY)) {
                mapReturn.put(EngineFactory.FUNCTION_MONITORING_SUMMARY, this.getMonitoringSummary());
                continue;
            }
            if (function.equals(EngineFactory.FUNCTION_GET_DELIVERY_PARAMS)) {
                Delivery delivObj;
                Object o = entry.getValue();
                String name = null;
                String trigger = null;
                Boolean noScheduleInfo = null;
                Boolean force = null;
                Long lastModifiedDate = null;
                String repository = null;
                if (o instanceof String) {
                    name = (String)o;
                } else if (o instanceof Map) {
                    Map mapParam2 = (Map)o;
                    name = (String)mapParam2.get("name");
                    trigger = (String)mapParam2.get("trigger");
                    noScheduleInfo = (Boolean)mapParam2.get("noScheduleInfo");
                    force = (Boolean)mapParam2.get("forceAnalyze");
                    lastModifiedDate = (Long)mapParam2.get("lastModifiedDate");
                    repository = (String)mapParam2.get("dir");
                }
                if (force == null) {
                    force = false;
                }
                if (noScheduleInfo == null) {
                    noScheduleInfo = false;
                }
                if (lastModifiedDate == null) {
                    lastModifiedDate = 0L;
                }
                if ((delivObj = Global.getRepository(repository).getDelivery(name, force)) != null) {
                    Map<String, Object> map = Utils.deliveryToMap(delivObj);
                    if (!noScheduleInfo.booleanValue()) {
                        map.remove("parameters");
                        map.put("parameters", this.getDeliveryScheduleParameter(name, "Deliveries", trigger));
                    }
                    mapReturn.put(EngineFactory.FUNCTION_GET_DELIVERY_PARAMS, map);
                    continue;
                }
                throw new Exception(String.valueOf(Messages.getString("EngineServerAPI_V1_2_temp.4")) + name + Messages.getString("EngineServerAPI_V1_2_temp.5"));
            }
            if (function.equals(EngineFactory.FUNCTION_TEST_CONNECTION)) {
                mapReturn.put(EngineFactory.FUNCTION_TEST_CONNECTION, this.testConnection((Map)entry.getValue()));
                continue;
            }
            if (function.equals(EngineFactory.FUNCTION_PING)) {
                mapParam = (Map)entry.getValue();
                mapReturn.put(EngineFactory.FUNCTION_PING, this.ping(mapParam));
                continue;
            }
            if (function.equals(EngineFactory.FUNCTION_DIRECTORY_EXIST)) {
                mapParam = (Map)entry.getValue();
                mapReturn.put(EngineFactory.FUNCTION_DIRECTORY_EXIST, this.doesDirectoryExist((String)mapParam.get(ParameterType.path.name())));
                continue;
            }
            if (!function.equals(EngineFactory.FUNCTION_GET_INETADDRESS)) continue;
            mapParam = (Map)entry.getValue();
            mapReturn.put(EngineFactory.FUNCTION_GET_INETADDRESS, this.getInetAddress(mapParam));
        }
        return mapReturn;
    }

    private Map<String, Map<String, Object>> getDeliveryScheduleParameter(String deliveryName, String group, String triggerName) throws Exception, SAXException, IOException {
        HashMap mapParam;
        JobDetail job = this.engineServer.getJobDetail(deliveryName, group);
        Map mapVariableMemory = null;
        if (job != null && triggerName != null) {
            try {
                mapVariableMemory = (Map)((Map)job.getJobDataMap().get((Object)triggerName)).get("variables");
            }
            catch (NullPointerException nullPointerException) {
                mapVariableMemory = new HashMap();
            }
        } else {
            mapVariableMemory = new HashMap();
        }
        Delivery delivObj = Global.getRepository(null).getDelivery(deliveryName, false);
        Map mapVariableFile = (Map)Utils.deliveryToMap(delivObj).get("parameters");
        HashMap<String, Map<String, Object>> mapReturn = new HashMap<String, Map<String, Object>>();
        for (Map.Entry entry : mapVariableMemory.entrySet()) {
            mapParam = new HashMap();
            String strip = ((String)entry.getKey()).replace("/*/", "").replace("~/", "");
            mapParam.put("value", entry.getValue());
            mapParam.put("override", true);
            mapReturn.put(strip, mapParam);
        }
        for (Map.Entry entry : mapVariableFile.entrySet()) {
            if (mapReturn.containsKey(entry.getKey())) continue;
            mapParam = new HashMap();
            mapParam.put("value", ((Map)entry.getValue()).get("value"));
            mapReturn.put((String)entry.getKey(), mapParam);
        }
        return mapReturn;
    }

    private Map<String, InetAddress> getInetAddress(Map<String, Object> mapParam) throws UnknownHostException {
        HashMap<String, InetAddress> ret = new HashMap<String, InetAddress>();
        for (String ip : mapParam.keySet()) {
            ret.put(ip, InetAddress.getByName(ip));
        }
        return ret;
    }

    private boolean ping(Map<String, String> param) throws IOException {
        String port = param.get(ParameterType.port.name());
        String ip = param.get(ParameterType.ip.name());
        if (ip == null || ip.isEmpty()) {
            return false;
        }
        if (port == null || port.isEmpty()) {
            InetAddress addr = InetAddress.getByName(ip);
            return addr.isReachable(5000);
        }
        new Socket(ip, Integer.parseInt(port));
        return true;
    }

    private boolean doesDirectoryExist(String path) {
        File file = new File(path);
        return file.exists();
    }

    private String testConnection(Map<String, String> param) {
        String driver = param.get(ParameterType.driver.name());
        String url = param.get(ParameterType.url.name());
        String user = param.get(ParameterType.user.name());
        String password = param.get(ParameterType.password.name());
        String moduleName = param.get(ParameterType.moduleName.name());
        try {
            if (password != null) {
                this.engineServer.getIsSemaphore(Messages.getString("EngineServerAPI_V1_2_temp.6"));
                password = this.engineServer.getStringAsciiInfo(password);
            }
            TestConnection.testConnection(driver, url, user, password, moduleName);
            return null;
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
    }

    private Map<String, String> getMonitoringSummary() {
        NumberFormat format = NumberFormat.getNumberInstance();
        TreeMap<String, String> mapSummary = new TreeMap<String, String>();
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        long duration = runtime.getUptime();
        String timeSpent = String.format("%d:%02d:%02d", duration / 1000L / 3600L, duration / 1000L % 3600L / 60L, duration / 1000L % 60L);
        mapSummary.put("Uptime", timeSpent);
        mapSummary.put("Virtual Machine", runtime.getVmName());
        mapSummary.put("Vendor", runtime.getVmVendor());
        mapSummary.put("Name", runtime.getName());
        String args = "";
        for (String i : runtime.getInputArguments()) {
            args = String.valueOf(args) + i + " ";
        }
        mapSummary.put("VM arguments", args);
        mapSummary.put("Class path", runtime.getClassPath());
        mapSummary.put("Library path", runtime.getLibraryPath());
        if (runtime.isBootClassPathSupported()) {
            mapSummary.put("Boot class path", runtime.getBootClassPath());
        } else {
            mapSummary.put("Boot class path", "** Unsupported by the VM **");
        }
        CompilationMXBean compilation = ManagementFactory.getCompilationMXBean();
        duration = compilation.getTotalCompilationTime();
        timeSpent = String.format("%d,%02d", duration / 1000L, duration);
        mapSummary.put("Total compile time", timeSpent);
        mapSummary.put("JIT Compiler", compilation.getName());
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        duration = thread.getCurrentThreadCpuTime();
        timeSpent = String.format("%d,%02d", duration / 1000L / 1000L / 1000L, duration / 1000L / 1000L);
        mapSummary.put("Process CPU Time", String.valueOf(timeSpent) + " seconds");
        mapSummary.put("Live threads", String.valueOf(thread.getThreadCount()));
        mapSummary.put("Peak", String.valueOf(thread.getPeakThreadCount()));
        mapSummary.put("Daemon threads", String.valueOf(thread.getDaemonThreadCount()));
        mapSummary.put("Total threads started", String.valueOf(thread.getTotalStartedThreadCount()));
        ClassLoadingMXBean classLoading = ManagementFactory.getClassLoadingMXBean();
        mapSummary.put("Current classes loaded", String.valueOf(classLoading.getLoadedClassCount()));
        mapSummary.put("Total classes loaded", String.valueOf(classLoading.getTotalLoadedClassCount()));
        mapSummary.put("Total classes unloaded", String.valueOf(classLoading.getUnloadedClassCount()));
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        mapSummary.put("Current heap size", String.valueOf(format.format(memory.getHeapMemoryUsage().getUsed() / 1024L)) + " kbytes");
        mapSummary.put("Maximum heap size", String.valueOf(format.format(memory.getHeapMemoryUsage().getMax() / 1024L)) + " kbytes");
        mapSummary.put("Committed memory", String.valueOf(format.format(memory.getHeapMemoryUsage().getCommitted() / 1024L)) + " kbytes");
        mapSummary.put("Pending finalization", format.format(memory.getObjectPendingFinalizationCount()));
        List<GarbageCollectorMXBean> listGc = ManagementFactory.getGarbageCollectorMXBeans();
        int i = 1;
        for (GarbageCollectorMXBean bean : listGc) {
            duration = bean.getCollectionTime();
            timeSpent = String.format("%d,%02d", duration / 1000L, duration);
            mapSummary.put("Garbage collector " + i, "Name=" + bean.getName() + " Collections=" + bean.getCollectionCount() + " Total time spent=" + timeSpent + " seconds");
            ++i;
        }
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        mapSummary.put("Operating system", os.getName());
        mapSummary.put("Architecture", os.getArch());
        mapSummary.put("Number of processors", String.valueOf(os.getAvailableProcessors()));
        try {
            mapSummary.put("Total physical memory", String.valueOf(format.format(((com.sun.management.OperatingSystemMXBean)os).getTotalPhysicalMemorySize() / 1024L)) + " kbytes");
            mapSummary.put("Free physical memory", String.valueOf(format.format(((com.sun.management.OperatingSystemMXBean)os).getFreePhysicalMemorySize() / 1024L)) + " kbytes");
            mapSummary.put("Total swap space", String.valueOf(format.format(((com.sun.management.OperatingSystemMXBean)os).getTotalSwapSpaceSize() / 1024L)) + " kbytes");
            mapSummary.put("Free swap space", String.valueOf(format.format(((com.sun.management.OperatingSystemMXBean)os).getFreeSwapSpaceSize() / 1024L)) + " kbytes");
            mapSummary.put("Committed virtual memory", String.valueOf(format.format(((com.sun.management.OperatingSystemMXBean)os).getCommittedVirtualMemorySize() / 1024L)) + " kbytes");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        return mapSummary;
    }

    private Map<String, Map<String, Object>> getConnectedClient() {
        Map<String, LogRMI> map = EngineServerI.getMapUser();
        HashMap<String, Map<String, Object>> mapReturn = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, LogRMI> entry : map.entrySet()) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            entry.getValue();
            ret.put(ParameterType.lastAccessTime.name(), entry.getValue().getTime());
            ret.put(ParameterType.lastAccessMethod.name(), entry.getValue().getMethod());
            mapReturn.put(entry.getKey(), ret);
        }
        return mapReturn;
    }

    private List<String> getAllThreads() {
        ThreadInfo[] tabInfo = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
        List<ThreadInfo> threadInfo = Arrays.asList(tabInfo);
        ArrayList<String> listRet = new ArrayList<String>();
        for (ThreadInfo info : threadInfo) {
            long cputime = ManagementFactory.getThreadMXBean().getThreadCpuTime(info.getThreadId());
            if (cputime == -1L) {
                cputime = 0L;
            }
            listRet.add(String.valueOf(info.getThreadName()) + "|" + cputime);
        }
        return listRet;
    }

    public Map<String, Object> scheduleDeliv(Map<String, Object> parameters) throws Exception {
        this.logMethod("scheduleDelivery");
        String jobName = (String)parameters.get(ParameterType.jobName.name());
        Map mapScheduleParameter = (Map)parameters.get(ParameterType.scheduleParameters.name());
        String deliveryName = (String)parameters.get(ParameterType.deliveryName.name());
        List listSchedules = (List)parameters.get(ParameterType.listSchedules.name());
        String httpHost = (String)parameters.get(ParameterType.host.name());
        Object _httpPort = parameters.get(ParameterType.port.name());
        int httpPort = -1;
        if (_httpPort instanceof String) {
            try {
                httpPort = Integer.parseInt((String)parameters.get(ParameterType.port.name()));
            }
            catch (NumberFormatException numberFormatException) {
                httpPort = -1;
            }
        } else if (_httpPort instanceof Integer) {
            try {
                httpPort = (Integer)parameters.get(ParameterType.port.name());
            }
            catch (NumberFormatException numberFormatException) {
                httpPort = -1;
            }
        }
        int executionMode = (Integer)parameters.get(ParameterType.executionType.name());
        Integer logLevel = null;
        if (parameters.get(ParameterType.logLevel.name()) != null) {
            logLevel = (Integer)parameters.get(ParameterType.logLevel.name());
        }
        HashMap<String, Object> mapVariable = new HashMap<String, Map>();
        if (mapScheduleParameter.get("variables") == null) {
            mapVariable.put("variables", mapScheduleParameter);
        } else {
            mapVariable = mapScheduleParameter;
        }
        return this.engineServer.scheduleDelivery(jobName, deliveryName, executionMode, httpHost, httpPort, listSchedules, mapVariable, logLevel).toMap();
    }

    public Map<String, Object> invokeCommand(Map<String, Object> parameters) throws Exception {
        String command = (String)parameters.get("singleCommand");
        List disableCommands = (List)parameters.get("disableCommands");
        List cfr_ignored_0 = (List)parameters.get("roles");
        boolean disableExit = false;
        boolean disableConnect = false;
        boolean disablePut = false;
        if (disableCommands != null) {
            if (disableCommands.contains("exit")) {
                disableExit = true;
            }
            if (disableCommands.contains("connect")) {
                disableConnect = true;
            }
            if (disableCommands.contains("put")) {
                disablePut = true;
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        InternalEngineCommandsI engineCommands = new InternalEngineCommandsI(ps, (IEngineClient)RemoteSessionManagement.INSTANCE.createPrivileged((IRemoteSessionV01)this), disableExit, disableConnect, disablePut, ctx);
        engineCommands.executeCommand(command);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("singleResult", baos.toString());
        result.put("context", ctx);
        return result;
    }

    public Map<String, Object> getVersion() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("runtime", EngineServerI.getEngineTechnicalVersion());
        map.put("branding.engine", EngineServerI.getEngineBrandingVersion());
        map.put("scheduler", EngineSchedulerVersionI.getVersion());
        map.put("common", CommonVersion.getVersion());
        map.put("action", this.getActionCodeVersion());
        map.put("command", Global.getCommandVersion());
        map.put("api", Global.getRMIApiVersion());
        return map;
    }

    private String getActionCodeVersion() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        Class<?> c = this.getClass().getClassLoader().loadClass("com.indy.engine.actionCodes.ActionCodeVersionI");
        Object o = c.newInstance();
        Method m = c.getMethod("getVersion", null);
        return (String)m.invoke(o, null);
    }

    public int scheduleDelivery(Map<String, Object> parameters) throws Exception {
        if (this.scheduleDeliv(parameters) != null) {
            return 1;
        }
        return -10;
    }

    public Map<String, Object> scheduleLogsPurge(String pJobName, List<Map<String, Object>> pScheduleList, Map<String, Object> rules) throws Exception {
        this.logMethod("scheduleLogsPurge");
        IEngineScheduleDetail scheduleDetails = this.engineServer.schedulePurgeLog(pJobName, pScheduleList, rules);
        return scheduleDetails.toMap();
    }

    public void pauseTrigger(Map<String, Object> parameters) throws Exception {
        this.logMethod("pauseTrigger");
        String triggerName = (String)parameters.get("triggerName");
        String triggerGroupName = (String)parameters.get("triggerGroupName");
        this.engineServer.pauseTrigger(triggerName, triggerGroupName);
    }

    public void resumeTrigger(Map<String, Object> parameters) throws Exception {
        this.logMethod("resumeTrigger");
        String triggerName = (String)parameters.get("triggerName");
        String triggerGroupName = (String)parameters.get("triggerGroupName");
        this.engineServer.resumeTrigger(triggerName, triggerGroupName);
    }

    public Map<String, Object> getActionInfo(Map<String, Object> parameters) throws Exception {
        this.logMethod("getActionInfo2");
        String sessionId = (String)parameters.get("sessionId");
        String actionId = (String)parameters.get("actionId");
        Boolean getAltId = (Boolean)parameters.get("getAltIds");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (sessionId != null && actionId != null) {
            IActionDataExchange iade;
            Map<String, IIdDataExchange> ex;
            if (getAltId != null && getAltId.booleanValue() && (ex = this.engineServer.getActionAltIds(sessionId, actionId)) != null) {
                HashMap<String, Map> _map = new HashMap<String, Map>();
                map.put("altIds", _map);
                for (String str : ex.keySet()) {
                    _map.put(str, ex.get(str).toMap());
                }
            }
            if ((iade = this.engineServer.getActionInfo(sessionId, actionId)) != null) {
                map.putAll(iade.toMap());
            }
        }
        return map;
    }

    public Map<String, Object> getRemoteSessions(Map<String, Object> parameters) throws Exception {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (RemoteSessionInfo remoteSessionInfo : RemoteSessionManagement.INSTANCE.getActiveSessions()) {
            ret.put(remoteSessionInfo.getRemoteSessionId(), remoteSessionInfo.toMap());
        }
        for (Map.Entry entry : Global.engineServer.getMapUser().entrySet()) {
            HashMap map = new HashMap();
            SimpleDateFormat df = new SimpleDateFormat();
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            map.put("lastAccess", df.format(((LogRMI)entry.getValue()).date));
            map.put("clientHost", entry.getKey());
            ret.put("IP:" + (String)entry.getKey(), map);
        }
        return ret;
    }

    public void removeDelivery(Map<String, Object> parameters) throws Exception {
        IDeliveryRepository repo;
        this.logMethod("deleteDelivery");
        String name = (String)parameters.get("name");
        String toDir = (String)parameters.get("dir");
        if (name != null) {
            JobDetail jd;
            repo = Global.getRepository(toDir);
            if (repo.isDefault() && !repo.isWebservice() && (jd = this.engineServer.getJobDetail(name, "Deliveries")) != null) {
                throw new Exception(Messages.getString("EngineServerAPI_V1_2_temp.7"));
            }
        } else {
            throw new Exception(Messages.getString("EngineServerAPI_V1_2_temp.8"));
        }
        repo.removeDelivery(name);
    }

    public Map<String, Map<String, Object>> getRepositories(Map<String, Object> parameters) throws Exception {
        HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>();
        for (String name : Global.getRepositories()) {
            IDeliveryRepository repo = Global.getRepository(name);
            ret.put(name, repo.getInfo().toMap());
        }
        return ret;
    }

    public String getEngineHttpEndpoint() throws Exception {
        try {
            return SoapService.getWsdlApi().getURL();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void handleSessionVariablesPlaceHolders(String sessionID, Map<String, Map<String, Object>> variablesMap) throws Exception {
        for (String variableName : variablesMap.keySet()) {
            String engineName = this.getEngineName(sessionID);
            Map<String, Object> map = variablesMap.get(variableName);
            variableName = variableName.replace("${engineName}", engineName);
            for (String k : new HashSet<String>(map.keySet())) {
                Object o = map.get(k);
                if (!(o instanceof String)) continue;
                map.put(k, ((String)o).replace("${engineName}", engineName));
            }
            this.setActionVariableByName(sessionID, variableName, map);
        }
    }

    public void reloadModules() throws Exception {
        StambiaClassLoaderRegistry.INSTANCE.getModuleService().reloadAllModules();
    }

    public class LogRMI {
        Date date;
        String lastMethodName;

        public Long getTime() {
            if (this.date != null) {
                return this.date.getTime();
            }
            return null;
        }

        public String getMethod() {
            return this.lastMethodName;
        }

        public void setMethod(String methodName) {
            this.date = new Date();
            this.lastMethodName = methodName;
        }
    }
}

