/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.scheduler;

import com.indy.engine.Global;
import com.indy.engine.InternalDatabase;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.objects2.EngineScheduleDetail;
import com.indy.engine.core.common.objects2.IEngineScheduleDetail;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.indy.engine.scheduler.Messages;
import com.indy.engine.scheduler.impl.jobs.CommandLineDeliveryExecutionJob;
import com.indy.engine.scheduler.impl.jobs.PurgeLogJob;
import com.indy.engine.scheduler.impl.jobs.RemoteDeliveryExecutionJob;
import com.indy.engine.service.Service;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class EngineSchedulerI
extends Service {
    public static final String GROUP_ENGINE_SYSTEM = "system";
    private static final String INTERNAL_JDBC_DRIVER = "org.h2.Driver";
    private static final String INTERNAL_DATASOURCE_NAME = "internal";
    boolean endBeforeStopping = false;
    SchedulerFactory sdiSchedFactory = null;
    Scheduler sdiScheduler = null;
    Log sdiSchedulerLog = LogFactory.getLog(EngineSchedulerI.class);
    private Properties props;
    ClassLoader contextClassLoader = null;
    boolean alreadyPrepared = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prepare() throws EngineExceptionI, IOException {
        boolean createSchema;
        block11: {
            createSchema = false;
            if (!this.alreadyPrepared) {
                this.alreadyPrepared = true;
                String propertyFile = System.getProperty("org.quartz.properties");
                if (propertyFile != null) {
                    File file = new File(propertyFile);
                    if (file.exists()) {
                        this.props = new Properties();
                        try (FileInputStream is = null;){
                            is = new FileInputStream(file);
                            this.props.load(is);
                            String datasource = this.props.getProperty("org.quartz.jobStore.dataSource");
                            if (datasource == null) break block11;
                            String driverKey = "org.quartz.dataSource." + datasource + ".driver";
                            String urlKey = "org.quartz.dataSource." + datasource + ".URL";
                            String driver = this.props.getProperty(driverKey);
                            String moduleKey = "org.quartz.dataSource." + datasource + ".module";
                            String module = this.props.getProperty(moduleKey);
                            String url = this.props.getProperty(urlKey);
                            if (datasource.equals(INTERNAL_DATASOURCE_NAME) && INTERNAL_JDBC_DRIVER.equals(driver) && url != null && url.contains("scheduler/internalDb")) {
                                createSchema = true;
                            }
                            if (datasource.equals(INTERNAL_DATASOURCE_NAME) || driver == null || driver.isEmpty()) break block11;
                            try {
                                this.contextClassLoader = ClassLoaderServiceProvider.INSTANCE.getClassLoader(module, driver);
                                break block11;
                            }
                            catch (Exception e) {
                                throw new EngineExceptionI((Throwable)e);
                            }
                        }
                    }
                    this.props = null;
                } else {
                    createSchema = true;
                    this.props = new Properties();
                    this.props.put("org.quartz.scheduler.instanceName", "RUNTIME_H2_STD");
                    this.props.put("org.quartz.scheduler.instanceId", "RUNTIME_H2_STD");
                    this.props.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
                    this.props.put("org.quartz.threadPool.threadCount", "50");
                    this.props.put("org.quartz.threadPool.threadPriority", "5");
                    this.props.put("org.quartz.jobStore.misfireThreshold", "10000");
                    this.props.put("org.quartz.jobStore.class", "org.quartz.impl.jdbcjobstore.JobStoreTX");
                    this.props.put("org.quartz.jobStore.driverDelegateClass", "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
                    this.props.put("org.quartz.jobStore.useProperties", "false");
                    this.props.put("org.quartz.jobStore.dataSource", INTERNAL_DATASOURCE_NAME);
                    this.props.put("org.quartz.jobStore.tablePrefix", "STB_");
                    this.props.put("org.quartz.jobStore.isClustered", "false");
                    this.props.put("org.quartz.dataSource.internal.driver", INTERNAL_JDBC_DRIVER);
                    this.props.put("org.quartz.dataSource.internal.URL", "jdbc:h2:file:scheduler/internalDb;SCHEMA=SCHEDULER");
                    this.props.put("org.quartz.dataSource.internal.user", "backend-user");
                    this.props.put("org.quartz.dataSource.internal.password", "backend-password");
                    this.props.put("org.quartz.dataSource.internal.connectionProvider.class", "com.indy.engine.scheduler.XdiQuartzConnectionProvider");
                    this.props.put("org.quartz.dataSource.internal.maxConnections", "5");
                    this.props.put("org.quartz.dataSource.internal.module", INTERNAL_DATASOURCE_NAME);
                }
            }
        }
        InternalDatabase.prepareSystemSchedulerDatabase(createSchema);
    }

    public void startSchedulerThread() throws Exception {
        this.sdiSchedFactory = this.props != null ? new StdSchedulerFactory(this.props) : new StdSchedulerFactory();
        this.sdiScheduler = this.sdiSchedFactory.getScheduler();
        this.sdiScheduler.standby();
        IDeliveryRepository repo = Global.getRepository(null);
        for (String jobGroupName : this.sdiScheduler.getJobGroupNames()) {
            for (JobKey jobKey : this.sdiScheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)jobGroupName))) {
                JobDetail jd = this.sdiScheduler.getJobDetail(jobKey);
                ArrayList<Trigger> triggerToPause = new ArrayList<Trigger>();
                for (Trigger trigger : this.sdiScheduler.getTriggersOfJob(jobKey)) {
                    if (this.sdiScheduler.getTriggerState(trigger.getKey()) == Trigger.TriggerState.PAUSED) {
                        triggerToPause.add(trigger);
                        continue;
                    }
                    if (!jobGroupName.equals("Deliveries")) continue;
                    String deliveryName = null;
                    JobDataMap data = jd.getJobDataMap();
                    Map parameters = (Map)data.get((Object)trigger.getKey().getName());
                    if (parameters != null) {
                        deliveryName = (String)parameters.get("deliveryName");
                    }
                    if (deliveryName == null) {
                        deliveryName = data.getString("deliveryName");
                    }
                    if (repo.exists(deliveryName)) continue;
                    triggerToPause.add(trigger);
                }
                this.sdiScheduler.pauseJob(jobKey);
                this.sdiScheduler.resumeJob(jobKey);
                if (triggerToPause.isEmpty()) continue;
                for (Trigger trigger : triggerToPause) {
                    this.sdiScheduler.pauseTrigger(trigger.getKey());
                }
            }
        }
        this.sdiScheduler.start();
        Global.getConsoleLogger().info(Messages.getString("EngineSchedulerI.0"));
    }

    public synchronized void shutdown() throws SchedulerException {
        this.sdiScheduler.shutdown(this.endBeforeStopping);
        Global.getConsoleLogger().info(Messages.getString("EngineSchedulerI.1"));
    }

    public void setEndBeforeStopping(boolean b) {
        this.endBeforeStopping = b;
    }

    public String[] getLstJobs() {
        return this.getLstJobs("Deliveries");
    }

    public String[] getLstJobs(String groupName) {
        if (this.sdiScheduler != null) {
            try {
                return (String[])this.sdiScheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName)).stream().map(j -> j.getName()).toArray();
            }
            catch (SchedulerException schedulerException) {
                return null;
            }
        }
        return null;
    }

    public ArrayList<String> getLstTriggers() {
        if (this.sdiScheduler != null) {
            try {
                Set lstSimpleTrig = this.sdiScheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)"Simple Trigger"));
                Set lstCronTrig = this.sdiScheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)"Cron Expression"));
                ArrayList<String> list = new ArrayList<String>(lstSimpleTrig.stream().map(t -> t.getName()).collect(Collectors.toList()));
                list.addAll(lstCronTrig.stream().map(t -> t.getName()).collect(Collectors.toList()));
                return list;
            }
            catch (SchedulerException schedulerException) {
                return null;
            }
        }
        return null;
    }

    private static String getQuartzTriggerState(Trigger.TriggerState triggerState) {
        switch (triggerState) {
            case NONE: {
                return "None";
            }
            case NORMAL: {
                return "Normal";
            }
            case PAUSED: {
                return "Paused";
            }
            case COMPLETE: {
                return "Complete";
            }
            case ERROR: {
                return "Error";
            }
            case BLOCKED: {
                return "Blocked";
            }
        }
        return null;
    }

    public static String getTriggerNameFromScheduleOrTriggerName(IEngineClient engineAPI, String name) throws Exception {
        if (name.startsWith("CRON")) {
            return name;
        }
        for (Map schedules : engineAPI.getLstSchedules(null)) {
            if (!schedules.containsKey("scheduleName") || !schedules.get("scheduleName").equals(name)) continue;
            return (String)schedules.get("triggerName");
        }
        return null;
    }

    private EngineScheduleDetail initEngineScheduleDetail(int pExecutionType, String triggerGroup, Trigger trigger) {
        EngineScheduleDetail esd = new EngineScheduleDetail(pExecutionType);
        esd.setStartTime(trigger.getStartTime());
        esd.setEndTime(trigger.getEndTime());
        esd.setJobName(trigger.getJobKey().getName());
        esd.setTriggerName(trigger.getKey().getName());
        esd.setLastExecution(trigger.getPreviousFireTime());
        esd.setNextExecution(trigger.getNextFireTime());
        try {
            esd.setTriggerState(EngineSchedulerI.getQuartzTriggerState(this.sdiScheduler.getTriggerState(trigger.getKey())));
        }
        catch (SchedulerException e) {
            this.sdiSchedulerLog.warn((Object)"An exception occured : ", (Throwable)e);
        }
        if (trigger instanceof SimpleTrigger) {
            esd.setRepeatCount(((SimpleTrigger)trigger).getRepeatCount());
            esd.setRepeatInterval((long)((SimpleTrigger)trigger).getRepeatCount());
        } else if (trigger instanceof CronTrigger) {
            esd.setCronExpression(((CronTrigger)trigger).getCronExpression());
        }
        try {
            JobDetail jd = this.sdiScheduler.getJobDetail(new JobKey(trigger.getJobKey().getName(), "Deliveries"));
            if (jd != null) {
                if (jd.getJobClass() == RemoteDeliveryExecutionJob.class) {
                    esd.setExecutionType(1);
                } else if (jd.getJobClass() == CommandLineDeliveryExecutionJob.class) {
                    esd.setExecutionType(2);
                }
                JobDataMap data = jd.getJobDataMap();
                if (data != null) {
                    Map mapJob = (Map)data.get((Object)trigger.getKey().getName());
                    String deliveryName = (String)mapJob.get("deliveryName");
                    if (deliveryName == null) {
                        deliveryName = data.getString("deliveryName");
                    }
                    esd.setDeliveryName(deliveryName);
                    esd.setSessionName((String)mapJob.get("sessName"));
                    esd.setScheduleName((String)mapJob.get("scheduleName"));
                    esd.setConfiguration((String)mapJob.get("configuration"));
                    esd.setHost((String)mapJob.get("httpHost"));
                    esd.setPort((Integer)mapJob.get("httpPort"));
                    esd.setLogLevel(mapJob.getOrDefault("logLevel", "").toString());
                    Map mapParam = (Map)mapJob.get("variables");
                    esd.setMapParameters(mapParam);
                }
            }
        }
        catch (SchedulerException e) {
            this.sdiSchedulerLog.warn((Object)"An exception occured : ", (Throwable)e);
        }
        return esd;
    }

    public IEngineScheduleDetail getTriggerDetail(String triggerName) {
        EngineScheduleDetail esd = null;
        try {
            SimpleTrigger sTrig = null;
            sTrig = (SimpleTrigger)this.sdiScheduler.getTrigger(new TriggerKey(triggerName, "Simple Trigger"));
            if (sTrig != null) {
                if (sTrig.getJobKey().getGroup().equals("Deliveries")) {
                    esd = this.initEngineScheduleDetail(2, sTrig.getJobKey().getGroup(), (Trigger)sTrig);
                }
            } else {
                CronTrigger sCron = null;
                sCron = (CronTrigger)this.sdiScheduler.getTrigger(new TriggerKey(triggerName, "Cron Expression"));
                if (sCron != null && (sCron.getJobKey().getGroup().equals("Deliveries") || sCron.getJobKey().getGroup().equals("Purge"))) {
                    esd = this.initEngineScheduleDetail(1, sCron.getJobKey().getGroup(), (Trigger)sCron);
                    if (sCron.getJobKey().getGroup().equals("Purge")) {
                        JobDetail job = this.sdiScheduler.getJobDetail(sCron.getJobKey());
                        JobDataMap data = job.getJobDataMap();
                        esd.setPurgeSize(data.getString("size"));
                        esd.setPurgeUnit(data.getString("unit"));
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        HashMap<String, Integer> statusList = new HashMap<String, Integer>();
                        List list = (List)data.get((Object)"purgeStatusList");
                        if (list != null) {
                            int i = 0;
                            for (Integer k : list) {
                                statusList.put(String.valueOf(i++), k);
                            }
                        }
                        map.put("purgeStatusList", statusList);
                        map.put("purgeSessionName", data.get((Object)"purgeSessionName"));
                        esd.setMapParameters(map);
                    }
                }
            }
        }
        catch (SchedulerException e) {
            this.sdiSchedulerLog.warn((Object)"An exception occured : ", (Throwable)e);
        }
        return esd;
    }

    public ArrayList<IEngineScheduleDetail> getLstSchedules(String jobName) {
        ArrayList<IEngineScheduleDetail> lst = new ArrayList<IEngineScheduleDetail>();
        if (this.sdiScheduler != null) {
            try {
                EngineScheduleDetail esd;
                SimpleTrigger sTrig;
                Set lstTrigs = this.sdiScheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)"Simple Trigger"));
                for (TriggerKey triggerKey : lstTrigs) {
                    sTrig = (SimpleTrigger)this.sdiScheduler.getTrigger(triggerKey);
                    if (!sTrig.getJobKey().getGroup().equals("Deliveries")) continue;
                    esd = this.initEngineScheduleDetail(2, sTrig.getJobKey().getGroup(), (Trigger)sTrig);
                    if (jobName != null && !esd.getDeliveryName().equals(jobName)) continue;
                    lst.add((IEngineScheduleDetail)esd);
                }
                lstTrigs = this.sdiScheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)"Cron Expression"));
                for (TriggerKey triggerKey : lstTrigs) {
                    sTrig = (CronTrigger)this.sdiScheduler.getTrigger(triggerKey);
                    if (!sTrig.getJobKey().getGroup().equals("Deliveries")) continue;
                    esd = this.initEngineScheduleDetail(1, sTrig.getJobKey().getGroup(), (Trigger)sTrig);
                    if (jobName != null && !esd.getDeliveryName().equals(jobName)) continue;
                    lst.add((IEngineScheduleDetail)esd);
                }
            }
            catch (SchedulerException schedulerException) {
                return null;
            }
        }
        return lst;
    }

    public int removeJobTrigger(String TriggerName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            if (TriggerName.startsWith("SMPL_")) {
                this.removeSimpleJobTrigger(TriggerName);
            } else if (TriggerName.startsWith("CRON_")) {
                this.removeCronJobTrigger(TriggerName);
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public int removeCronJobTrigger(String triggerName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            try {
                String jobName = this.sdiScheduler.getTrigger(new TriggerKey(triggerName, "Cron Expression")).getJobKey().getName();
                String jobGroup = this.sdiScheduler.getTrigger(new TriggerKey(triggerName, "Cron Expression")).getJobKey().getGroup();
                JobDetail job = this.sdiScheduler.getJobDetail(new JobKey(jobName, jobGroup));
                job.getJobDataMap().remove((Object)triggerName);
                this.sdiScheduler.unscheduleJob(new TriggerKey(triggerName, "Cron Expression"));
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.warn((Object)"An exception occured : ", (Throwable)e);
                ret = -10;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public int removeSimpleJobTrigger(String triggerName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            try {
                this.sdiScheduler.unscheduleJob(new TriggerKey(triggerName, "Simple Trigger"));
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.warn((Object)"An exception occured : ", (Throwable)e);
                ret = -10;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public int removeJobAndTriggers(String jobName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            try {
                this.sdiScheduler.deleteJob(new JobKey(jobName, "Deliveries"));
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.warn((Object)"An exception occured : ", (Throwable)e);
                ret = -10;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public IEngineScheduleDetail scheduleDelivery(String jobName, String pDeliveryName, int executionMode, List<Map<String, Object>> pScheduleList) throws Exception {
        return this.scheduleDelivery(jobName, pDeliveryName, executionMode, null, -1, pScheduleList);
    }

    public IEngineScheduleDetail schedulePurgeLog(String triggerName, List<Map<String, Object>> pScheduleList, Map<String, Object> rules) throws Exception {
        if (pScheduleList == null || pScheduleList.size() == 0) {
            throw new EngineExceptionI("Schedule List is Empty");
        }
        if (this.sdiScheduler != null) {
            Object delivJob = null;
            String pJobName = null;
            try {
                boolean existTrigger = false;
                if (triggerName != null) {
                    Set triggersCron = this.sdiScheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)"Cron Expression"));
                    Set triggersSimple = this.sdiScheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)"Simple Trigger"));
                    for (TriggerKey triggerKey : triggersCron) {
                        if (!triggerKey.getName().equals(triggerName)) continue;
                        existTrigger = true;
                        pJobName = triggerName;
                        break;
                    }
                    if (!existTrigger) {
                        for (TriggerKey triggerKey : triggersSimple) {
                            if (!triggerKey.getName().equals(triggerName)) continue;
                            existTrigger = true;
                            break;
                        }
                    }
                    if (!existTrigger) {
                        pJobName = "CRON_SystemPurgeOperation." + System.currentTimeMillis();
                    }
                } else {
                    pJobName = "CRON_SystemPurgeOperation." + System.currentTimeMillis();
                }
                triggerName = pJobName;
                String jobName = pJobName;
                Set jobKeys = this.sdiScheduler.getJobKeys(GroupMatcher.groupEquals((String)"Purge"));
                Optional<JobKey> optionalJobKey = jobKeys.stream().filter(j -> jobName.equals(j.getName())).findFirst();
                delivJob = !optionalJobKey.isPresent() ? new JobDetailImpl(pJobName, "Purge", PurgeLogJob.class) : this.sdiScheduler.getJobDetail(optionalJobKey.get());
                delivJob.getJobDataMap().putAll(rules);
                this.sdiScheduler.addJob((JobDetail)delivJob, true, true);
                this.addTrigger(triggerName, "Purge", (JobDetail)delivJob, pScheduleList);
                return this.getTriggerDetail(triggerName);
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.warn((Object)"An exception occured : ", (Throwable)e);
                throw new EngineExceptionI(Messages.getString("EngineSchedulerI.2"), (Throwable)e);
            }
            catch (Exception e) {
                this.sdiSchedulerLog.warn((Object)"An exception occured : ", (Throwable)e);
                throw new EngineExceptionI(Messages.getString("EngineSchedulerI.3"), (Throwable)e);
            }
        }
        throw new EngineExceptionI(Messages.getString("EngineSchedulerI.4"));
    }

    public JobDetail getJobDetail(String jobName, String group) throws SchedulerException {
        JobDetail delivJob = this.sdiScheduler.getJobDetail(new JobKey(jobName, group));
        return delivJob;
    }

    private int addTrigger(String pJobName, String type, JobDetail delivJob, List<Map<String, Object>> pScheduleList) throws SchedulerException, Exception {
        Iterator<Map<String, Object>> it = pScheduleList.iterator();
        if (!it.hasNext()) {
            return -3;
        }
        IEngineScheduleDetail esd = null;
        int i = 0;
        while (it.hasNext()) {
            boolean isCronType;
            esd = EngineScheduleDetail.getEngineScheduleDetail(it.next());
            boolean bl = isCronType = esd.getCronExpression() != null;
            if (!isCronType) {
                SimpleTriggerImpl simpleTrigger = null;
                if (esd.getStartTime() != null) {
                    if (esd.getEndTime() == null) {
                        Date endDt = new Date();
                        endDt.setTime(0x7FFFFFFFFFFFFFFEL);
                        simpleTrigger = new SimpleTriggerImpl(pJobName, "Simple Trigger", esd.getStartTime(), endDt, esd.getRepeatCount(), esd.getRepeatInterval());
                    } else {
                        simpleTrigger = new SimpleTriggerImpl(pJobName, "Simple Trigger", esd.getStartTime(), esd.getEndTime(), esd.getRepeatCount(), esd.getRepeatInterval());
                    }
                    this.sdiScheduler.scheduleJob(delivJob, (Trigger)simpleTrigger);
                }
            } else {
                if (esd.getCronExpression().isEmpty()) {
                    return -4;
                }
                CronTriggerImpl cronTrigger = null;
                boolean update = esd.getTriggerName() != null;
                String triggerName = pJobName;
                try {
                    if (esd.getStartTime() != null) {
                        if (esd.getEndTime() == null) {
                            Date endDt = new Date();
                            endDt.setTime(0x7FFFFFFFFFFFFFFEL);
                            cronTrigger = new CronTriggerImpl(triggerName, "Cron Expression", pJobName, type, esd.getStartTime(), endDt, esd.getCronExpression());
                        } else {
                            cronTrigger = new CronTriggerImpl(triggerName, "Cron Expression", pJobName, type, esd.getStartTime(), esd.getEndTime(), esd.getCronExpression());
                        }
                    } else {
                        cronTrigger = new CronTriggerImpl(triggerName, "Cron Expression", pJobName, type, esd.getCronExpression());
                    }
                    if (cronTrigger != null) {
                        cronTrigger.setMisfireInstruction(2);
                    }
                    if (update) {
                        this.sdiScheduler.rescheduleJob(new TriggerKey(triggerName, cronTrigger.getGroup()), (Trigger)cronTrigger);
                    } else {
                        this.sdiScheduler.scheduleJob((Trigger)cronTrigger);
                    }
                }
                catch (ParseException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            ++i;
        }
        return i;
    }

    public IEngineScheduleDetail scheduleDelivery(String pJobName, String pDeliveryName, int executionMode, String httpHost, int httpPort, List<Map<String, Object>> pScheduleList) throws Exception {
        return this.scheduleDelivery(pJobName, pDeliveryName, executionMode, httpHost, httpPort, pScheduleList, null);
    }

    public IEngineScheduleDetail scheduleDelivery(String pJobName, String pDeliveryName, int executionMode, String httpHost, int httpPort, List<Map<String, Object>> pScheduleList, Map<String, Object> parameters) throws Exception {
        return this.scheduleDelivery(pJobName, pDeliveryName, executionMode, httpHost, httpPort, pScheduleList, parameters, null);
    }

    public IEngineScheduleDetail scheduleDelivery(String pJobName, String pDeliveryName, int executionMode, String httpHost, int httpPort, List<Map<String, Object>> pScheduleList, Map<String, Object> parameters, Integer logLevel) throws Exception {
        if (pScheduleList == null || pScheduleList.size() == 0) {
            throw new EngineExceptionI(Messages.getString("EngineSchedulerI.5"));
        }
        try {
            if (!Global.engineServer.existDelivery(pDeliveryName, null)) {
                throw new EngineExceptionI(Messages.getString("EngineSchedulerI.6"));
            }
        }
        catch (Exception e1) {
            throw new EngineExceptionI((Throwable)e1);
        }
        if (this.sdiScheduler != null) {
            Object delivJob = null;
            try {
                Set jobKeys = this.sdiScheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)"Deliveries"));
                Optional<JobKey> optionalJobKey = jobKeys.stream().filter(j -> pJobName.equals(j.getName())).findFirst();
                delivJob = !optionalJobKey.isPresent() ? (executionMode == 1 ? new JobDetailImpl(pJobName, "Deliveries", RemoteDeliveryExecutionJob.class) : new JobDetailImpl(pJobName, "Deliveries", CommandLineDeliveryExecutionJob.class)) : this.sdiScheduler.getJobDetail(optionalJobKey.get());
                delivJob.getJobDataMap().put("deliveryName", pDeliveryName);
                Iterator<Map<String, Object>> it = pScheduleList.iterator();
                IEngineScheduleDetail esd = null;
                int i = 0;
                List lstSimpleTrig = this.sdiScheduler.getTriggersOfJob(new JobKey(pJobName, "Deliveries"));
                ArrayList<Integer> set = new ArrayList<Integer>();
                for (Trigger trig : lstSimpleTrig) {
                    int index = trig.getKey().getName().lastIndexOf("-");
                    if (index <= -1) continue;
                    String num = trig.getKey().getName().substring(index + 1);
                    int _num = Integer.valueOf(num);
                    set.add(_num);
                }
                Collections.sort(set);
                int last = -1;
                Iterator index = set.iterator();
                while (index.hasNext()) {
                    int ii = (Integer)index.next();
                    if (ii != last + 1) break;
                    last = ii;
                }
                i = last + 1;
                while (it.hasNext()) {
                    boolean isCronType;
                    esd = EngineScheduleDetail.getEngineScheduleDetail(it.next());
                    String triggerName = esd.getTriggerName();
                    boolean update = triggerName != null;
                    boolean bl = isCronType = esd.getCronExpression() != null;
                    if (!isCronType) {
                        triggerName = !update ? "SMPL_" + pJobName + "-" + String.valueOf(i) : triggerName;
                        SimpleTriggerImpl simpleTrigger = null;
                        if (esd.getStartTime() != null) {
                            simpleTrigger = esd.getEndTime() == null ? new SimpleTriggerImpl(triggerName, "Simple Trigger", esd.getStartTime(), null, esd.getRepeatCount(), esd.getRepeatInterval()) : new SimpleTriggerImpl(triggerName, "Simple Trigger", esd.getStartTime(), esd.getEndTime(), esd.getRepeatCount(), esd.getRepeatInterval());
                            if (parameters != null) {
                                parameters.put("configuration", esd.getConfiguration());
                                parameters.put("sessName", esd.getSessionName());
                                parameters.put("scheduleName", esd.getScheduleName());
                                delivJob.getJobDataMap().put(simpleTrigger.getKey().getName(), parameters);
                            }
                            this.sdiScheduler.addJob(delivJob, true, true);
                            this.sdiScheduler.scheduleJob(delivJob, (Trigger)simpleTrigger);
                        }
                    } else {
                        String string = triggerName = !update ? "CRON_" + pJobName + "-" + String.valueOf(i) : triggerName;
                        if (esd.getCronExpression().isEmpty()) {
                            throw new EngineExceptionI(Messages.getString("EngineSchedulerI.7"));
                        }
                        CronTriggerImpl cronTrigger = null;
                        try {
                            if (esd.getStartTime() != null) {
                                cronTrigger = esd.getEndTime() == null ? new CronTriggerImpl(triggerName, "Cron Expression", pJobName, "Deliveries", esd.getStartTime(), null, esd.getCronExpression()) : new CronTriggerImpl(triggerName, "Cron Expression", pJobName, "Deliveries", esd.getStartTime(), esd.getEndTime(), esd.getCronExpression());
                            } else {
                                cronTrigger = new CronTriggerImpl(triggerName, "Cron Expression", pJobName, "Deliveries", esd.getCronExpression());
                                cronTrigger.setEndTime(esd.getEndTime());
                            }
                            if (cronTrigger != null) {
                                cronTrigger.setMisfireInstruction(2);
                            }
                            if (parameters != null) {
                                parameters.put("configuration", esd.getConfiguration());
                                parameters.put("sessName", esd.getSessionName());
                                parameters.put("scheduleName", esd.getScheduleName());
                                if (executionMode == 1) {
                                    if (httpHost != null) {
                                        parameters.put("httpHost", httpHost);
                                    } else {
                                        parameters.remove("httpHost");
                                    }
                                    if (httpPort > -1) {
                                        parameters.put("httpPort", httpPort);
                                    } else {
                                        parameters.remove("httpPort");
                                    }
                                }
                                if (logLevel != null) {
                                    parameters.put("logLevel", logLevel);
                                }
                                parameters.put("deliveryName", pDeliveryName);
                                delivJob.getJobDataMap().put(cronTrigger.getName(), parameters);
                            }
                            this.sdiScheduler.addJob(delivJob, true, true);
                            if (update) {
                                this.sdiScheduler.rescheduleJob(new TriggerKey(triggerName, cronTrigger.getGroup()), (Trigger)cronTrigger);
                            } else {
                                this.sdiScheduler.scheduleJob((Trigger)cronTrigger);
                            }
                            return this.getTriggerDetail(triggerName);
                        }
                        catch (Exception e) {
                            throw new EngineExceptionI((Throwable)e);
                        }
                    }
                    ++i;
                }
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.error((Object)Messages.getString("EngineSchedulerI.8"), (Throwable)e);
                throw new EngineExceptionI(Messages.getString("EngineSchedulerI.8"), (Throwable)e);
            }
            catch (Exception e) {
                this.sdiSchedulerLog.error((Object)Messages.getString("EngineSchedulerI.9"), (Throwable)e);
                throw new EngineExceptionI(Messages.getString("EngineSchedulerI.9"), (Throwable)e);
            }
        } else {
            throw new EngineExceptionI(Messages.getString("EngineSchedulerI.10"));
        }
        return null;
    }

    public IEngineScheduleDetail scheduleSystemJob(String pJobName, List<IEngineScheduleDetail> pScheduleList, Class jobClass, TreeMap<String, Object> lstParams) throws Exception {
        if (pScheduleList == null || pScheduleList.isEmpty()) {
            throw new EngineExceptionI(Messages.getString("EngineSchedulerI.11"));
        }
        if (this.sdiScheduler != null) {
            this.sdiSchedulerLog.debug((Object)Messages.getString("EngineSchedulerI.12"));
            JobDetail job = null;
            try {
                Set jobKeys = this.sdiScheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)GROUP_ENGINE_SYSTEM));
                Optional<JobKey> optionalJobKey = jobKeys.stream().filter(j -> pJobName.equals(j.getName())).findFirst();
                if (!optionalJobKey.isPresent()) {
                    this.sdiSchedulerLog.debug((Object)(String.valueOf(Messages.getString("EngineSchedulerI.13")) + pJobName));
                    job = new JobDetailImpl(pJobName, GROUP_ENGINE_SYSTEM, jobClass);
                } else {
                    JobKey jobKey = optionalJobKey.get();
                    job = this.sdiScheduler.getJobDetail(jobKey);
                }
                this.sdiSchedulerLog.debug((Object)Messages.getString("EngineSchedulerI.14"));
                JobDataMap jobMap = job.getJobDataMap();
                for (String pName : lstParams.keySet()) {
                    jobMap.put(pName, lstParams.get(pName));
                }
                this.sdiScheduler.addJob(job, true);
                Iterator<IEngineScheduleDetail> it = pScheduleList.iterator();
                IEngineScheduleDetail esd = null;
                List lstSimpleTrig = this.sdiScheduler.getTriggersOfJob(new JobKey(pJobName, GROUP_ENGINE_SYSTEM));
                int i = 0;
                if (lstSimpleTrig != null && lstSimpleTrig.size() != 0) {
                    i = lstSimpleTrig.size();
                }
                this.sdiSchedulerLog.debug((Object)Messages.getString("EngineSchedulerI.15"));
                while (it.hasNext()) {
                    Date endDt;
                    boolean isCronType;
                    esd = it.next();
                    boolean bl = isCronType = esd.getCronExpression() != null;
                    if (!isCronType) {
                        SimpleTriggerImpl simpleTrigger = null;
                        if (esd.getStartTime() != null) {
                            if (esd.getEndTime() == null) {
                                endDt = new Date();
                                endDt.setTime(0x7FFFFFFFFFFFFFFEL);
                                simpleTrigger = new SimpleTriggerImpl("SMPL_" + pJobName + "-" + String.valueOf(i), "Simple Trigger", esd.getStartTime(), endDt, esd.getRepeatCount(), esd.getRepeatInterval());
                            } else {
                                simpleTrigger = new SimpleTriggerImpl("SMPL_" + pJobName + "-" + String.valueOf(i), "Simple Trigger", esd.getStartTime(), esd.getEndTime(), esd.getRepeatCount(), esd.getRepeatInterval());
                            }
                            this.sdiSchedulerLog.debug((Object)(String.valueOf(Messages.getString("EngineSchedulerI.22")) + job.getKey().getName()));
                            this.sdiScheduler.scheduleJob(job, (Trigger)simpleTrigger);
                        }
                    } else {
                        if (esd.getCronExpression().isEmpty()) {
                            throw new EngineExceptionI(Messages.getString("EngineSchedulerI.25"));
                        }
                        CronTriggerImpl cronTrigger = null;
                        try {
                            if (esd.getStartTime() != null) {
                                if (esd.getEndTime() == null) {
                                    endDt = new Date();
                                    endDt.setTime(0x7FFFFFFFFFFFFFFEL);
                                    cronTrigger = new CronTriggerImpl("CRON_" + pJobName + "-" + String.valueOf(i), "Cron Expression", pJobName, GROUP_ENGINE_SYSTEM, esd.getStartTime(), endDt, esd.getCronExpression());
                                } else {
                                    cronTrigger = new CronTriggerImpl("CRON_" + pJobName + "-" + String.valueOf(i), "Cron Expression", pJobName, GROUP_ENGINE_SYSTEM, esd.getStartTime(), esd.getEndTime(), esd.getCronExpression());
                                }
                            } else {
                                cronTrigger = new CronTriggerImpl("CRON_" + pJobName + "-" + String.valueOf(i), "Cron Expression", pJobName, GROUP_ENGINE_SYSTEM, esd.getCronExpression());
                            }
                            this.sdiScheduler.scheduleJob((Trigger)cronTrigger);
                        }
                        catch (ParseException e) {
                            throw new EngineExceptionI(Messages.getString("EngineSchedulerI.16"), (Throwable)e);
                        }
                    }
                    ++i;
                }
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.error((Object)Messages.getString("EngineSchedulerI.17"), (Throwable)e);
                throw new EngineExceptionI(Messages.getString("EngineSchedulerI.17"), (Throwable)e);
            }
            catch (Exception e) {
                this.sdiSchedulerLog.error((Object)Messages.getString("EngineSchedulerI.17"), (Throwable)e);
                throw new EngineExceptionI(Messages.getString("EngineSchedulerI.18"), (Throwable)e);
            }
        }
        throw new EngineExceptionI(Messages.getString("EngineSchedulerI.19"));
        return null;
    }

    public String[] getLstSystemJobs() {
        return this.getLstJobs(GROUP_ENGINE_SYSTEM);
    }

    public int removeSystemJobTrigger(String TriggerName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            if (TriggerName.startsWith("SMPL_")) {
                this.removeSystemSimpleJobTrigger(TriggerName);
            } else if (TriggerName.startsWith("CRON_")) {
                this.removeSystemCronJobTrigger(TriggerName);
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public int removeSystemCronJobTrigger(String triggerName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            try {
                this.sdiScheduler.unscheduleJob(new TriggerKey(triggerName, "Cron Expression"));
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.warn((Object)"An exception occured : ", (Throwable)e);
                ret = -10;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public int removeSystemSimpleJobTrigger(String triggerName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            try {
                this.sdiScheduler.unscheduleJob(new TriggerKey(triggerName, "Simple Trigger"));
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.error((Object)(String.valueOf(Messages.getString("EngineSchedulerI.24")) + triggerName), (Throwable)e);
                ret = -10;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public int removeSystemJobAndTriggers(String jobName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            try {
                this.sdiScheduler.deleteJob(new JobKey(jobName, GROUP_ENGINE_SYSTEM));
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.error((Object)(String.valueOf(Messages.getString("EngineSchedulerI.23")) + jobName), (Throwable)e);
                ret = -10;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    @Override
    protected void doStart() throws Exception {
        Global.dLog.write("EngineServerI()", Messages.getString("EngineSchedulerI.20"), 0, 0, "INFO");
        this.prepare();
        this.startSchedulerThread();
        Global.dLog.write("EngineServerI()", Messages.getString("EngineSchedulerI.21"), 0, 0, "INFO");
    }

    @Override
    protected void doStop() throws Exception {
        this.shutdown();
    }

    @Override
    public String getName() {
        return "scheduler";
    }

    public void pauseTrigger(String triggerName, String triggerGroup) throws SchedulerException {
        this.sdiScheduler.pauseTrigger(new TriggerKey(triggerName, triggerGroup));
    }

    public void resumeTrigger(String triggerName, String triggerGroup) throws SchedulerException {
        this.sdiScheduler.resumeTrigger(new TriggerKey(triggerName, triggerGroup));
    }
}

