/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.ssl;

import com.indy.engine.Global;
import com.indy.engine.ssl.Messages;
import com.indy.engine.ssl.SSLKeyPairNoFoundException;
import com.semarchy.xdi.engine.common.EngineFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SSLContextFactory {
    private SSLContext createSSLContext(String protocol, String keyStoreType, InputStream keyStoreStream, char[] keyStorePassword, char[] keyPassword, String alias, SecureRandom random) throws Exception {
        SSLContext sslContext = protocol == null ? SSLContext.getDefault() : SSLContext.getInstance(protocol);
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        ks.load(keyStoreStream, keyStorePassword);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, keyPassword);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), random);
        this.checkKeyPairs(alias, keyStorePassword, ks);
        return sslContext;
    }

    private void checkKeyPairs(String aliasToUse, char[] keyStorePassword, KeyStore ks) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, SSLKeyPairNoFoundException {
        Enumeration<String> aliases = ks.aliases();
        boolean isKeyPairValidFound = false;
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (aliasToUse != null && (aliasToUse == null || !aliasToUse.equals(alias))) continue;
            PrivateKey privateKey = (PrivateKey)ks.getKey(alias, keyStorePassword);
            PublicKey publicKey = ks.getCertificate(alias).getPublicKey();
            if (privateKey == null || publicKey == null) continue;
            isKeyPairValidFound = true;
        }
        if (!isKeyPairValidFound) {
            throw new SSLKeyPairNoFoundException(Messages.getString("SSLContextFactory.0"));
        }
    }

    public SSLContext createServerRuntimeSSLContext(EngineFactory.Protocol protocol) throws Exception {
        if (protocol == EngineFactory.Protocol.https) {
            if (Global.webServiceHttpsKeyStoreFile == null) {
                throw new Exception(Messages.getString("SSLContextFactory.1"));
            }
            File keyStoreFile = new File(Global.webServiceHttpsKeyStoreFile);
            if (!keyStoreFile.exists() || !keyStoreFile.isFile()) {
                throw new Exception(String.format(Messages.getString("SSLContextFactory.2"), Global.webServiceHttpsKeyStoreFile));
            }
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileInputStream is = new FileInputStream(Global.webServiceHttpsKeyStoreFile);){
                SSLContext sslContext = this.createSSLContext(Global.webServiceSecureProtocolType, Global.webServiceHttpsKeyStoreType == null ? "JKS" : Global.webServiceHttpsKeyStoreType, is, Global.webServiceHttpsKeyStorePassword == null ? null : Global.webServiceHttpsKeyStorePassword.toCharArray(), Global.webServiceHttpsKeyPassword == null ? null : Global.webServiceHttpsKeyPassword.toCharArray(), Global.webServiceHttpsKeyStoreAlias, null);
                return sslContext;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        throw new Exception(Messages.getString("SSLContextFactory.4"));
    }
}

