/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.userLog.log4j;

import com.indy.engine.Global;
import com.indy.engine.common.monitoring.EngineStatusGlobalVar;
import com.indy.engine.core.common.VariableDataType;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.main.action.statics.VariableStatic;
import com.indy.engine.manager.ActionStatus;
import com.indy.engine.userLog.SessionRecorder;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

class SessionRecordDTO {
    private static int VERSION = 1;
    private static final List<String> ACTION_END_DISCARDED_VARIABLES = Arrays.asList(VariableType.CORE_ACTION_TXT.getName(), VariableType.CORE_ACTION_TECHNOLOGY.getName(), VariableType.CORE_BEGIN_DATE.getName(), VariableType.CORE_END_DATE.getName(), "CORE_NAME", VariableType.CORE_NB_ENABLED_EXECUTIONS.getName(), VariableType.CORE_TOLERATED_ERROR.getName(), VariableType.CORE_END_DATE.getName(), "CORE_PATH", VariableType.CORE_ACTION_ID.getName());

    SessionRecordDTO() {
    }

    public static DTO convert(Object record, List<SessionRecorder.VariableRecord> innerVariableRecords) {
        if (record instanceof SessionRecorder.ActionEndRecord) {
            return new ActionEndDTO((SessionRecorder.ActionEndRecord)record, innerVariableRecords);
        }
        if (record instanceof SessionRecorder.ActionStartRecord) {
            return new ActionStartDTO((SessionRecorder.ActionStartRecord)record, innerVariableRecords);
        }
        if (record instanceof SessionRecorder.SessionStartRecord) {
            return new SessionStartDTO((SessionRecorder.SessionStartRecord)record, innerVariableRecords);
        }
        if (record instanceof SessionRecorder.SessionEndRecord) {
            return new SessionEndDTO((SessionRecorder.SessionEndRecord)record, innerVariableRecords);
        }
        if (record instanceof SessionRecorder.VariableRecord) {
            return new VariableDTO((SessionRecorder.VariableRecord)record);
        }
        if (record instanceof SessionRecorder.AggregateRecord) {
            return new AggregateDTO((SessionRecorder.AggregateRecord)record);
        }
        return null;
    }

    static abstract class ActionDTO
    extends DTO {
        String actionId;
        String actionType;
        int actionIteration;
        String actionPath;
        String actionPathWithIteration;
        String actionStatus;
        int actionNumber;

        public ActionDTO() {
        }

        public ActionDTO(SessionRecorder.ActionRecord record) {
            super(record);
            this.actionId = record.getAction().getActionId();
            this.actionIteration = record.getAction().getActionIteration();
            this.actionPath = record.getAction().getActionName();
            this.actionPathWithIteration = record.getAction().getPathWithIteration();
            this.actionStatus = ActionStatus.getStatusByCode(record.getActionState()).name();
            this.actionType = record.getActionStatic().getActionType();
            this.actionNumber = record.getNumAction();
        }
    }

    @XmlRootElement(name="actionEnd")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class ActionEndDTO
    extends ActionDTO {
        long actionBindIteration;
        @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
        Date actionEndDate;
        int actionExecutionCount;
        long actionDuration;
        String actionErrorMessage;
        List<VariableDTO> variables;
        List<AggregateDTO> aggregates = null;

        ActionEndDTO() {
        }

        @Override
        void read(KeyValueReader kvr) {
            super.read(kvr);
        }

        ActionEndDTO(SessionRecorder.ActionEndRecord r, List<SessionRecorder.VariableRecord> innerVariableRecords) {
            super(r);
            if (r.getActionErrorMsg() != null && !r.getActionErrorMsg().isEmpty()) {
                this.actionErrorMessage = r.getActionErrorMsg();
            }
            if (r.getAggregates() != null) {
                this.aggregates = new ArrayList<AggregateDTO>();
                r.getAggregates().forEach(rec -> {
                    boolean bl = this.aggregates.add((AggregateDTO)SessionRecordDTO.convert(rec, null));
                });
            }
            this.actionBindIteration = r.getCurrentBindIteration();
            this.actionEndDate = r.getEndDate();
            this.actionExecutionCount = r.getNbExecution();
            this.actionDuration = r.getDuration();
            if (innerVariableRecords != null && !innerVariableRecords.isEmpty()) {
                this.variables = new ArrayList<VariableDTO>(innerVariableRecords.size());
                innerVariableRecords.stream().sorted(Comparator.comparing(SessionRecorder.VariableRecord::getShortName)).forEach(v -> {
                    if (!ACTION_END_DISCARDED_VARIABLES.contains(v.getShortName())) {
                        this.variables.add((VariableDTO)SessionRecordDTO.convert(v, null));
                    }
                });
            }
        }

        @Override
        String getMessage() {
            return "Action end";
        }

        @Override
        String getType() {
            return "actionEnd";
        }
    }

    @XmlRootElement(name="actionStart")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class ActionStartDTO
    extends ActionDTO {
        @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
        Date actionBeginDate;
        String actionParentId;
        boolean actionIsBegin;
        int actionParentIteration;
        List<StaticVariableDTO> initVariables = new ArrayList<StaticVariableDTO>();
        List<VariableDTO> variables;

        ActionStartDTO() {
        }

        ActionStartDTO(SessionRecorder.ActionStartRecord r, List<SessionRecorder.VariableRecord> innerVariableRecords) {
            super(r);
            this.actionType = r.getActionStatic().getActionType();
            this.actionBeginDate = r.getBeginDate();
            this.actionParentId = r.getFatherId();
            this.actionIsBegin = r.getBeginAction();
            this.actionParentIteration = r.getParentIteration();
            this.actionStatus = "RUNNING";
            r.getActionStatic().getAllStaticVariables().values().stream().sorted(Comparator.comparing(VariableStatic::getShortName)).forEach(v -> {
                if (v.getValue() != null) {
                    if (v.getShortName().equals("CORE_ACTION_ID")) {
                        return;
                    }
                    this.initVariables.add(new StaticVariableDTO(v.getDataType(), v.getShortName(), v.getShortName(), v.getValue()));
                }
            });
            if (innerVariableRecords != null && !innerVariableRecords.isEmpty()) {
                this.variables = new ArrayList<VariableDTO>(innerVariableRecords.size());
                innerVariableRecords.stream().sorted(Comparator.comparing(SessionRecorder.VariableRecord::getShortName)).forEach(v -> {
                    boolean bl = this.variables.add((VariableDTO)SessionRecordDTO.convert(v, null));
                });
            }
        }

        @Override
        String getMessage() {
            return "Action start";
        }

        @Override
        String getType() {
            return "actionStart";
        }
    }

    @XmlRootElement(name="aggregate")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class AggregateDTO
    extends DTO {
        int count;
        long max;
        long min;
        String name;
        String sessionID;
        int sessionIter;
        long sum;

        AggregateDTO() {
        }

        AggregateDTO(SessionRecorder.AggregateRecord r) {
            this.count = r.getCount();
            this.max = r.getMax();
            this.min = r.getMin();
            this.name = r.getName();
            this.sum = r.getSum();
        }

        @Override
        void read(KeyValueReader kvr) {
            kvr.read("stat." + this.name, String.valueOf(this.sum));
        }

        @Override
        String getMessage() {
            return null;
        }

        @Override
        String getType() {
            return null;
        }
    }

    static abstract class DTO {
        String sessionId;
        int sessionIteration;
        String sessionName;
        String message;
        String type;
        int version;

        void read(KeyValueReader kvr) {
            ArrayList<Field> fields = new ArrayList<Field>();
            Class<?> currentClass = this.getClass();
            while (currentClass != Object.class) {
                fields.addAll(Arrays.asList(currentClass.getDeclaredFields()));
                currentClass = currentClass.getSuperclass();
            }
            for (Field field : fields) {
                try {
                    Object obj = field.get(this);
                    if (obj == null) continue;
                    if (field.getType() == List.class) {
                        for (Object o : (List)obj) {
                            if (!(o instanceof DTO)) continue;
                            ((DTO)o).read(kvr);
                        }
                        continue;
                    }
                    kvr.read(field.getName(), field.get(this).toString());
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {}
            }
        }

        public DTO() {
        }

        public DTO(SessionRecorder.SessionRecord record) {
            this.sessionId = record.getSessionID();
            this.sessionIteration = record.getSessionIter();
            this.sessionName = record.getSessionName();
            this.version = VERSION;
            this.message = this.getMessage();
            this.type = this.getType();
        }

        abstract String getMessage();

        abstract String getType();
    }

    static class DateTimeAdapter
    extends XmlAdapter<String, Date> {
        private final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");

        DateTimeAdapter() {
        }

        public String marshal(Date object) throws Exception {
            return this.dateFormat.format(object);
        }

        public Date unmarshal(String xml) throws Exception {
            return this.dateFormat.parse(xml);
        }
    }

    static interface KeyValueReader {
        public void read(String var1, String var2);
    }

    @XmlRootElement(name="sessionEnd")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class SessionEndDTO
    extends DTO {
        long sessionDuration;
        @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
        Date sessionEndDate;
        String sessionStatus;
        String sessionErrorMessage;
        List<VariableDTO> variables;
        List<AggregateDTO> aggregates = null;

        SessionEndDTO() {
        }

        SessionEndDTO(SessionRecorder.SessionEndRecord r, List<SessionRecorder.VariableRecord> innerVariableRecords) {
            super(r);
            this.sessionDuration = r.getElapseTIme();
            this.sessionEndDate = r.getEndDate();
            this.sessionId = r.getSessionID();
            this.sessionIteration = r.getSessionIter();
            this.sessionErrorMessage = r.getSessionMsg();
            this.sessionName = r.getSessionName();
            this.sessionStatus = EngineStatusGlobalVar.getStringEngineStatus((int)r.getSessionStatus());
            if (r.getAggregates() != null) {
                this.aggregates = new ArrayList<AggregateDTO>();
                r.getAggregates().forEach(rec -> {
                    boolean bl = this.aggregates.add((AggregateDTO)SessionRecordDTO.convert(rec, null));
                });
            }
            if (innerVariableRecords != null && !innerVariableRecords.isEmpty()) {
                this.variables = new ArrayList<VariableDTO>(innerVariableRecords.size());
                innerVariableRecords.stream().sorted(Comparator.comparing(SessionRecorder.VariableRecord::getShortName)).forEach(v -> {
                    boolean bl = this.variables.add((VariableDTO)SessionRecordDTO.convert(v, null));
                });
            }
        }

        @Override
        String getMessage() {
            return "Session end";
        }

        @Override
        String getType() {
            return "sessionEnd";
        }
    }

    @XmlRootElement(name="sessionStart")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class SessionStartDTO
    extends DTO {
        final String sessionStatus = "RUNNING";
        String sessionParentId;
        @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
        Date sessionBeginDate;
        String processId;
        String processName;
        String deliveryId;
        String deliveryName;
        @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
        Date deliveryBuildDate;
        String deliveryBuildUser;
        String deliveryVersion;
        String configuration;
        String runtimeHost;
        int runtimePort;
        String guestHost;
        String executionMode;
        String launchMode;
        int sessionLogLevel;
        Integer maxParallelExecutions;
        Integer autoRestartInterval;
        Integer autoRestartMaxTries;
        String launchUserName;

        SessionStartDTO() {
        }

        SessionStartDTO(SessionRecorder.SessionStartRecord r, List<SessionRecorder.VariableRecord> innerVariableRecords) {
            super(r);
            this.deliveryBuildDate = r.getSessionStatic().getBuildDate();
            this.deliveryBuildUser = r.getSessionStatic().getBuildUser();
            this.deliveryName = r.getSessionStatic().getDeliveryName();
            this.deliveryId = r.getSessionStatic().getDlvId();
            this.deliveryVersion = r.getSessionStatic().getVersion();
            this.sessionLogLevel = r.getSessionStatic().getLogLevel();
            this.maxParallelExecutions = r.getSessionStatic().getNbMaxParallelSessions();
            this.processId = r.getSessionStatic().getProcId();
            this.processName = r.getSessionStatic().getProcName();
            this.autoRestartInterval = r.getSessionStatic().getRetryInterval();
            this.autoRestartMaxTries = r.getSessionStatic().getRetryNumber();
            this.configuration = r.getSessionStatic().getConfiguration();
            this.sessionBeginDate = r.getBeginDate();
            this.runtimeHost = Global.HTTP_HOST;
            this.runtimePort = Global.HTTP_PORT;
            this.executionMode = r.getExecutionMode();
            this.guestHost = r.getGuestHost();
            this.launchMode = r.getLaunchMode();
            this.sessionParentId = r.getParentSessionId();
            this.sessionId = r.getSessionID();
            this.sessionIteration = r.getSessionIter();
            this.sessionName = r.getSessionName();
            this.launchUserName = r.getUserName();
        }

        @Override
        String getMessage() {
            return "Session start";
        }

        @Override
        String getType() {
            return "sessionStart";
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class StaticVariableDTO
    extends DTO {
        String name;
        VariableDataType type;
        String value;

        StaticVariableDTO() {
        }

        StaticVariableDTO(VariableDataType type, String fullName, String name, String value) {
            this.type = type;
            this.name = name;
            this.value = value;
        }

        @Override
        void read(KeyValueReader kvr) {
            kvr.read("var." + this.name, this.value);
        }

        @Override
        String getMessage() {
            return null;
        }

        @Override
        String getType() {
            return null;
        }
    }

    @XmlRootElement(name="variable")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class VariableDTO
    extends DTO {
        Number cumulativeValue;
        String lastBindedValue;
        String name;
        String shortName;
        String type;
        String value;

        VariableDTO() {
        }

        VariableDTO(SessionRecorder.VariableRecord r) {
            this.cumulativeValue = (Number)r.getCumulativeValue();
            this.lastBindedValue = r.getLastBindedValue();
            this.shortName = r.getShortName();
            this.type = r.getType();
            this.value = r.getValue();
        }

        @Override
        void read(KeyValueReader kvr) {
            kvr.read("var." + this.shortName, this.value);
        }

        @Override
        String getMessage() {
            return null;
        }

        @Override
        String getType() {
            return null;
        }
    }
}

