/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.userLog.reportLog;

import com.indy.engine.Global;
import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.engine.rmi.SessionFilterCriteria;
import com.indy.engine.userLog.IUserLogI;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ReportLogManagerI {
    public Class rLogClass;
    public Object rLogObject;
    public IUserLogI uLog;
    public Map<String, String> lstLogProperties;
    String logName = "";

    public void clean() {
        this.cleanReportLog();
        this.lstLogProperties.clear();
        this.lstLogProperties = null;
        this.rLogClass = null;
        this.rLogObject = null;
    }

    public ReportLogManagerI(String pName) throws EngineExceptionI {
        this.logName = pName;
        this.lstLogProperties = Global.getLstLogParametersInRepository(this.logName);
        try {
            Global.dLog.write("ReportEngineServer", "ReportLogManagerI()", "Report Log Class : " + this.lstLogProperties.get("userLogClass"), 2, 2, "DEBUG");
            this.rLogClass = Class.forName(this.lstLogProperties.get("userLogClass"));
            this.rLogObject = this.rLogClass.newInstance();
            if (this.rLogObject instanceof IUserLogI) {
                this.uLog = (IUserLogI)this.rLogObject;
            }
        }
        catch (ClassNotFoundException e) {
            Global.dLog.write("ReportEngineServer", "ReportLogManagerI()", "ClassNotFoundException :" + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI("ReportLogManagerI() Exception", (Throwable)e);
        }
        catch (InstantiationException e) {
            Global.dLog.write("ReportEngineServer", "ReportLogManagerI()", "InstantiationException :" + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI("ReportLogManagerI() Exception", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Global.dLog.write("ReportEngineServer", "ReportLogManagerI()", "IllegalAccessException :" + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI("ReportLogManagerI() Exception", (Throwable)e);
        }
    }

    public void cleanReportLog() {
        this.uLog.cleanReportLog();
    }

    public int purgeLogs(Date untilDate, List<String> filters, List<Integer> statusList, boolean currentRuntime) throws EngineExceptionI {
        return this.uLog.purgeLogs(untilDate, filters, statusList, currentRuntime);
    }

    public int deleteSession(String sessionId, int logLevel) throws EngineExceptionI {
        return this.uLog.deleteSession(sessionId, logLevel);
    }

    public int init() throws EngineExceptionI {
        return this.uLog.initLog(this.lstLogProperties, this.logName, "r");
    }

    public void updateLog(boolean force) throws EngineExceptionI {
        this.uLog.updateLog(force);
    }

    public String getVesion() throws EngineExceptionI {
        return this.uLog.getVersion();
    }

    public Map<String, ISessionDataExchange> getLstSessions(int nbSessions, List<SessionFilterCriteria> lstfilters) throws EngineExceptionI {
        Map<String, ISessionDataExchange> ret = null;
        ISessionDataExchange sde2 = null;
        ret = this.uLog.getLstSessions(nbSessions, lstfilters);
        if (ret != null) {
            for (ISessionDataExchange sde2 : ret.values()) {
                sde2.setLogName(this.logName);
            }
        }
        return ret;
    }

    public Map<String, ISessionDataExchange> getLstInactiveSessions() throws EngineExceptionI {
        Map<String, ISessionDataExchange> ret = null;
        ret = this.uLog.getLstInactiveSessions();
        if (ret != null) {
            ret.values().stream().forEach(sde -> sde.setLogName(this.logName));
        }
        return ret;
    }

    public void purgeLogs(int nbSessions, List<String> filters, List<Integer> statusList, boolean currentRuntime) throws EngineExceptionI {
        this.uLog.purgeLogs(nbSessions, filters, statusList, currentRuntime);
    }

    public void connect() throws EngineExceptionI {
        this.uLog.connect();
    }
}

