/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.wsdl;

import com.indy.engine.Global;
import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import com.indy.engine.main.repository.IDeliveryListener;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.indy.engine.main.repository.internal.PollingSynchronizer;
import com.indy.engine.service.Service;
import com.indy.engine.shared.configuration.repository.AbstractRepositoryBean;
import com.indy.engine.wsdl.Messages;
import com.indy.engine.wsdl.WsdlAPI;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.net.MalformedURLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoapService
extends Service {
    private static final Logger logger = LogManager.getLogger(SoapService.class);
    private static WsdlAPI wsdlAPI;
    boolean init = false;

    public static WsdlAPI getWsdlApi() {
        if (wsdlAPI == null) {
            try {
                IDeliveryRepository repo = Global.getRepository("webservices");
                wsdlAPI = new WsdlAPI(Global.engineServer, repo);
            }
            catch (EngineExceptionI e) {
                logger.warn("An exception occured : ", (Throwable)e);
            }
            catch (MalformedURLException e) {
                logger.warn("An exception occured : ", (Throwable)e);
            }
        }
        return wsdlAPI;
    }

    @Override
    protected void doStart() throws Exception {
        try {
            Exception t;
            if (!this.init) {
                WsdlAPI api = SoapService.getWsdlApi();
                api.initWSDL();
                if (api.repo != null && api.repo.getScanMode().equals(AbstractRepositoryBean.ScanMode.poll.name())) {
                    PollingSynchronizer synchronizer = new PollingSynchronizer(SoapService.getWsdlApi().repo, (IDeliveryRepositoryPlugin.IDeliveryDelta)new IDeliveryRepositoryPlugin.DeliveryDelta());
                    synchronizer.addListener(new IDeliveryListener(){

                        @Override
                        public void handleDeliveryChanged(IDeliveryRepositoryPlugin.IDeliveryDelta dd) {
                            try {
                                SoapService.getWsdlApi().initWSDL();
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    synchronizer.startSyncrhonisation();
                }
                this.init = true;
            }
            if ((t = SoapService.getWsdlApi().startSOAPServer()) != null) {
                throw t;
            }
        }
        catch (Exception e) {
            Global.getLogger().error(Messages.getString("SoapService.1"), (Throwable)e);
            Global.getConsoleLogger().info(String.valueOf(Messages.getString("SoapService.2")) + e.getMessage());
            throw e;
        }
    }

    @Override
    protected void doStop() throws Exception {
        Exception t = SoapService.getWsdlApi().stopSOAPServer();
        if (t != null) {
            throw t;
        }
    }

    @Override
    public String getName() {
        return "soap";
    }
}

