/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.wsdl;

import com.indy.engine.EngineServerI;
import com.indy.engine.Global;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.delivery.Utils;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.indy.engine.wsdl.AskToClearRunnable;
import com.indy.engine.wsdl.DeliveryRestAPIHelper;
import com.indy.engine.wsdl.Invocation;
import com.indy.engine.wsdl.Messages;
import com.semarchy.xdi.runtime.httpserver.Application;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WsdlAPI {
    public static final String DEFAULT_CATALOG_NAME = "default";
    private static final String SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    static final String STAMBIA_XSD_PARAMETERS_URI = "http://stambia.com/xsd/parameters";
    private static final String STAMBIA_PARAMETERS_PREFIX = "stbXP";
    private static final String WSDL_URI = "http://schemas.xmlsoap.org/wsdl/";
    static final String USER_PARAMETERS_IN = "userParameters";
    static final String USER_PARAMETERS_OUT = "userParameters";
    static final String STAMBIA_OUTPUT = "stambiaOutput";
    static final String STAMBIA_OUTPUT_TYPE = "OutputType";
    static final String STAMBIA_INPUT = "stambiaInput";
    static final String STAMBIA_INPUT_TYPE = "InputType";
    static final String STAMBIA_WSDL_URI = "http://stambia.com/wsdl";
    public static final String STAMBIA_NO_NAMESAPCE_URI = "http://stambia.com/noNameSapce";
    public static final String STAMBIA_NO_NAMESPACE_URI = "http://stambia.com/noNamespace";
    private static final String STAMBIA_WSDL_PREFIX = "stbW";
    private static final String SOAP_PREFIX = "soap";
    private static final String SOAP_URI = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String STAMBIA_DOCUMENT_LITERAL_WRAPPER_URI = "http://stambia.com/document/literal/wrapped";
    static final String STAMBIA_DOCUMENT_LITERAL_WRAPPER_PREFIX = "stbWP";
    static final String DEF_NAME = "StambiaDelivery";
    static final String DEF_NAME_WSI = "DeliverableService";
    static final String NAME = "Delivery";
    static final String NAME_WSI = "Deliverable";
    static final String SERVICE_NAME = "DeliveryService";
    static final String SERVICE_NAME_REST = "DeliveryService";
    static final String SERVICE_NAME_WSI = "DeliverableService";
    static final String SERVICE_WSDL_NAME_WSI = "DeliverableService";
    static final String SERVICE_WSDL_NAME = "StambiaDeliveryService";
    static final String SERVICE_CTX_NONWSI = "nonwsi";
    static final String SERVICE_CTX_WSI = "wsi";
    static final String SERVICE_CTX_REST = "rest/";
    static final String SERVICE_CTX_APP = "app/";
    static final String ctxRestV1 = "rest/DeliveryService/1";
    static final String ctxRestV2 = "rest/DeliveryService/2";
    static final String ctxRestV3 = "rest/DeliveryService/3";
    static final String BACKWARD_COMP_NAME = "Stambia";
    static final String backwardCompCtxRestV1 = "rest/StambiaDeliveryService/1";
    static final String backwardCompCtxRestV2 = "rest/StambiaDeliveryService/2";
    static final String backwardCompCtxRestV3 = "rest/StambiaDeliveryService/3";
    static final String ctxSwaggerUI = "app/swagger-ui";
    static final String PORT_NAME = "DeliveryPortType";
    static final String PORT_NAME_WSI = "DeliverablePortType";
    static final String BINDING_NAME = "DeliveryBinding";
    static final String BINDING_NAME_WSI = "DeliverableBinding";
    static final String STAMBIA_STANDARD_PREFIX = "stbPS";
    static final String STAMBIA_STANDARD_URI = "http://stambia.com/xsd/standard";
    private static final String XSD_PREFIX = "xs";
    private static final String STAMBIA_NONAMESPACE_PREFIX = "noNS";
    private static final String STAMBIA_NONAMESAPCE_PREFIX = "noNS2";
    public static String STAMBIA_WSDL_PATH = "xdi-runtime-api-user-endpoint.wsdl";
    public static String STAMBIA_WSDL_PATH_WSI = "xdi-runtime-api-user-endpoint-wsi.wsdl";
    private Element definitions;
    public Element types;
    private Element xsdParametersSchema;
    private Element xsdStandardSchema;
    private Element xsdStandardSchemaWSI;
    private Element portType;
    private Element wsiPortType;
    private Element binding;
    private Element wsiBinding;
    Element service;
    Element wsiService;
    Map<String, String> allNamepsaces = new HashMap<String, String>();
    Map<String, Delivery> allDeliveries = new HashMap<String, Delivery>();
    String url;
    private String urlWSI;
    private String urlNonWSI;
    EngineServerI engineServerI;
    private File wsdlMessageDir;
    IDeliveryRepository repo;
    private Element xsdWrappedSchema;
    private Document docWSI;
    private Element definitionsWSI;
    private MeteDataSchema metadataSchema = new MeteDataSchema();
    public MainLock mainLock = new MainLock();
    private Node xsdNoNamespace;
    static AskToClearRunnable clearRunnable;
    static Map<String, Invocation> askToDelete;
    static Thread threadDeleteFile;
    public Document doc;
    DeliveryRestAPIHelper deliveryRestHelper = new DeliveryRestAPIHelper();
    Logger log;
    boolean hasError = false;
    Application sprintBootApp;

    static {
        askToDelete = Collections.synchronizedMap(new HashMap());
    }

    public static String STAMBIA_NO_NAMESPACE_URI(boolean wsiCompliant) {
        return wsiCompliant ? STAMBIA_NO_NAMESPACE_URI : STAMBIA_NO_NAMESAPCE_URI;
    }

    public static String STAMBIA_NONAMESPACE_PREFIX(boolean wsiCompliant) {
        return wsiCompliant ? STAMBIA_NONAMESPACE_PREFIX : STAMBIA_NONAMESAPCE_PREFIX;
    }

    public IDeliveryRepository getRepository() {
        return this.repo;
    }

    public Map<String, Delivery> getAllDeliveries() {
        return Collections.unmodifiableMap(this.allDeliveries);
    }

    public WsdlAPI(EngineServerI engineServerI, IDeliveryRepository repo) throws MalformedURLException {
        this.repo = repo;
        this.log = LogManager.getLogger((String)Global.comIndyEngineWsdlLogger);
        this.url = Global.webServiceSecureProtocolType != null ? "https" : "http";
        this.url = String.valueOf(this.url) + "://" + Global.HTTP_HOST + ":" + Global.HTTP_PORT + "/";
        this.urlWSI = String.valueOf(this.url) + SERVICE_CTX_WSI;
        this.urlNonWSI = String.valueOf(this.url) + SERVICE_CTX_NONWSI;
        this.engineServerI = engineServerI;
        if (this.repo != null) {
            STAMBIA_WSDL_PATH = String.valueOf(this.repo.getCacheFolder().getAbsolutePath()) + File.separator + "xdi-runtime-api-user-endpoint-" + new URL(this.url).getPort() + ".wsdl";
            STAMBIA_WSDL_PATH_WSI = String.valueOf(this.repo.getCacheFolder().getAbsolutePath()) + File.separator + "xdi-runtime-api-user-endpoint-" + new URL(this.url).getPort() + "-wsi.wsdl";
        }
        this.wsdlMessageDir = new File(String.valueOf(Global.TEMPORARY_FOLDER) + File.separator + "wsdl" + File.separator + "messages" + File.separator + "out");
        if (!this.wsdlMessageDir.exists()) {
            this.wsdlMessageDir.mkdirs();
        }
    }

    public String getURL() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public File getWsdlMessageDir() {
        return this.wsdlMessageDir;
    }

    private void initDoc() throws ParserConfigurationException {
        this.log.info("initDoc");
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
        this.definitions = this.doc.createElementNS(WSDL_URI, "definitions");
        this.doc.appendChild(this.definitions);
        this.types = this.doc.createElementNS(WSDL_URI, "types");
        this.docWSI = docBuilder.newDocument();
        this.types = this.doc.createElementNS(WSDL_URI, "types");
        this.definitions.setAttribute("xmlns:soap", SOAP_URI);
        this.definitions.setAttribute("xmlns:stbW", STAMBIA_WSDL_URI);
        this.definitions.setAttribute("xmlns:stbPS", STAMBIA_STANDARD_URI);
        this.definitions.setAttribute("targetNamespace", STAMBIA_WSDL_URI);
        this.xsdParametersSchema = this.doc.createElementNS(SCHEMA_URI, "schema");
        this.xsdParametersSchema.setAttribute("targetNamespace", STAMBIA_XSD_PARAMETERS_URI);
        this.xsdParametersSchema.setPrefix(XSD_PREFIX);
        this.definitions.setAttribute("xmlns:xs", SCHEMA_URI);
        this.initStandarParameters(true);
        this.initStandarParameters(false);
        this.definitionsWSI = (Element)this.definitions.cloneNode(true);
        this.definitionsWSI.setAttribute("xmlns:stbWP", STAMBIA_DOCUMENT_LITERAL_WRAPPER_URI);
        this.xsdWrappedSchema = this.docWSI.createElementNS(SCHEMA_URI, "schema");
        this.xsdWrappedSchema.setAttribute("targetNamespace", STAMBIA_DOCUMENT_LITERAL_WRAPPER_URI);
        this.xsdWrappedSchema.setPrefix(XSD_PREFIX);
        this.definitionsWSI.setAttribute("xmlns:xs", SCHEMA_URI);
        Element stdImport = this.appendXsdNode(this.docWSI, this.xsdWrappedSchema, "import");
        stdImport.setAttribute("namespace", STAMBIA_STANDARD_URI);
        this.xsdWrappedSchema.appendChild(stdImport);
        this.docWSI.adoptNode(this.definitionsWSI);
        this.docWSI.appendChild(this.definitionsWSI);
        this.portType = this.doc.createElementNS(WSDL_URI, "portType");
        this.portType.setAttribute("name", PORT_NAME);
        this.binding = this.doc.createElementNS(WSDL_URI, "binding");
        this.binding.setAttribute("name", BINDING_NAME);
        this.binding.setAttribute("type", "stbW:DeliveryPortType");
        Element soapBinding = this.doc.createElementNS(SOAP_URI, "binding");
        soapBinding.setPrefix(SOAP_PREFIX);
        soapBinding.setAttribute("style", "document");
        soapBinding.setAttribute("transport", "http://schemas.xmlsoap.org/soap/http");
        this.binding.appendChild(soapBinding);
        this.service = this.doc.createElementNS(WSDL_URI, "service");
        this.service.setAttribute("name", "DeliveryService");
        Element port = this.doc.createElementNS(WSDL_URI, "port");
        port.setAttribute("name", PORT_NAME);
        port.setAttribute("binding", "stbW:DeliveryBinding");
        Element soapAddress = this.doc.createElementNS(SOAP_URI, "address");
        soapAddress.setPrefix(SOAP_PREFIX);
        soapAddress.setAttribute("location", this.urlNonWSI);
        this.service.appendChild(port);
        port.appendChild(soapAddress);
        this.wsiPortType = this.docWSI.createElementNS(WSDL_URI, "portType");
        this.wsiPortType.setAttribute("name", PORT_NAME_WSI);
        this.wsiBinding = this.docWSI.createElementNS(WSDL_URI, "binding");
        this.wsiBinding.setAttribute("name", BINDING_NAME_WSI);
        this.wsiBinding.setAttribute("type", "stbW:DeliverablePortType");
        Element soapBindingWsi = this.docWSI.createElementNS(SOAP_URI, "binding");
        soapBindingWsi.setPrefix(SOAP_PREFIX);
        soapBindingWsi.setAttribute("style", "document");
        soapBindingWsi.setAttribute("transport", "http://schemas.xmlsoap.org/soap/http");
        this.wsiBinding.appendChild(soapBindingWsi);
        this.wsiService = this.docWSI.createElementNS(WSDL_URI, "service");
        this.wsiService.setAttribute("name", "DeliverableService");
        Element wsiPort = this.docWSI.createElementNS(WSDL_URI, "port");
        wsiPort.setAttribute("name", PORT_NAME_WSI);
        wsiPort.setAttribute("binding", "stbW:DeliverableBinding");
        Element wsiSoapAddress = this.docWSI.createElementNS(SOAP_URI, "address");
        wsiSoapAddress.setPrefix(SOAP_PREFIX);
        wsiSoapAddress.setAttribute("location", this.urlWSI);
        wsiPort.appendChild(wsiSoapAddress);
        this.wsiService.appendChild(wsiPort);
    }

    private Element createElement(Document doc, Element parent, String name, String type, String minOccurs, String maxOccurs, String _default) {
        Element element = this.appendXsdNode(doc, parent, "element");
        if (minOccurs != null) {
            element.setAttribute("minOccurs", minOccurs);
        }
        if (maxOccurs != null) {
            element.setAttribute("maxOccurs", maxOccurs);
        }
        element.setAttribute("name", name);
        if (type != null) {
            element.setAttribute("type", "xs:" + type);
        }
        if (_default != null) {
            element.setAttribute(DEFAULT_CATALOG_NAME, _default);
        }
        return element;
    }

    private Element createAttribute(Document doc, Element parent, String name, String type, String use, String _default) {
        Element attribute = this.appendXsdNode(doc, parent, "attribute");
        if (use != null) {
            attribute.setAttribute("use", use);
        }
        attribute.setAttribute("name", name);
        if (type != null) {
            attribute.setAttribute("type", "xs:" + type);
        }
        if (_default != null) {
            attribute.setAttribute(DEFAULT_CATALOG_NAME, _default);
        }
        return attribute;
    }

    private void initStandarParameters(boolean isWsiCompliant) {
        if (isWsiCompliant) {
            this.xsdStandardSchemaWSI = this.docWSI.createElementNS(SCHEMA_URI, "schema");
            this.xsdStandardSchemaWSI.setAttribute("targetNamespace", STAMBIA_STANDARD_URI);
            this.xsdStandardSchemaWSI.setPrefix(XSD_PREFIX);
            Element complexType = this.appendXsdNode(this.docWSI, this.xsdStandardSchemaWSI, "complexType");
            complexType.setAttribute("name", STAMBIA_INPUT_TYPE);
            this.createAttribute(this.docWSI, complexType, "pAsynchronous", "boolean", "optional", "false");
            this.createAttribute(this.docWSI, complexType, "pSessionId", "string", "optional", null);
            this.createAttribute(this.docWSI, complexType, "pParentSessionId", "string", "optional", null);
            this.createAttribute(this.docWSI, complexType, "pLogLevel", "int", "optional", null);
            this.createAttribute(this.docWSI, complexType, "pSessionName", "string", "optional", null);
            complexType = this.appendXsdNode(this.docWSI, this.xsdStandardSchemaWSI, "complexType");
            complexType.setAttribute("name", STAMBIA_OUTPUT_TYPE);
            this.createAttribute(this.docWSI, complexType, "pSessionId", "string", "optional", null);
        } else {
            this.xsdStandardSchema = this.doc.createElementNS(SCHEMA_URI, "schema");
            this.xsdStandardSchema.setAttribute("targetNamespace", STAMBIA_STANDARD_URI);
            this.xsdStandardSchema.setPrefix(XSD_PREFIX);
            Element stambiaInput = this.createElement(this.doc, this.xsdStandardSchema, STAMBIA_INPUT, null, null, null, null);
            Element complexType = this.appendXsdNode(this.doc, stambiaInput, "complexType");
            this.createAttribute(this.doc, complexType, "synchronous", "boolean", "optional", "true");
            this.createAttribute(this.doc, complexType, "sessionId", "string", "optional", null);
            this.createAttribute(this.doc, complexType, "parentSessionId", "string", "optional", null);
            this.createAttribute(this.doc, complexType, "logLevel", "int", "optional", null);
            this.createAttribute(this.doc, complexType, "sessionName", "string", "optional", null);
            Element stambiaOutput = this.createElement(this.doc, this.xsdStandardSchema, STAMBIA_OUTPUT, null, null, null, null);
            complexType = this.appendXsdNode(this.doc, stambiaOutput, "complexType");
            this.createAttribute(this.doc, complexType, "sessionId", "string", "optional", null);
        }
    }

    public Element appendXsdNode(Document doc, Element elt, String type) {
        return this.appendXsdNode(doc, elt, type, -1);
    }

    public Element appendXsdNode(Document doc, Element elt, String type, int position) {
        Element _elt = doc.createElementNS(SCHEMA_URI, type);
        _elt.setPrefix(XSD_PREFIX);
        if (position > -1) {
            Node node = elt.getChildNodes().item(position);
            elt.insertBefore(_elt, node);
        } else {
            elt.appendChild(_elt);
        }
        return _elt;
    }

    private void parseDelivery(DeliveryInfo info, List<Element> result, boolean wsiCompliant) throws Exception {
        Element elt;
        String outputMessageName;
        Document doc = wsiCompliant ? this.docWSI : this.doc;
        Delivery currentDelivery = info.deliv;
        String name = info.name;
        String qname = "deliv_" + info.name.replaceAll("[^A-Za-z0-9]", "_");
        String inputMessageName = "in_" + qname;
        String outputParametersTypeName = outputMessageName = "out_" + qname;
        String inputParametersTypeName = inputMessageName;
        String inputwrappedName = qname;
        String outputwrappedName = String.valueOf(qname) + "_Ouput";
        String operationName = qname;
        if (wsiCompliant) {
            qname = info.name.replaceAll("[^A-Za-z0-9]", "_");
            qname = String.valueOf(qname.substring(0, 1).matches("[^A-Za-z]") ? "_" : "") + qname;
            inputMessageName = String.valueOf(qname) + "InputMessage";
            outputMessageName = String.valueOf(qname) + "OutputMessage";
            inputwrappedName = String.valueOf(qname) + "Input";
            outputwrappedName = String.valueOf(qname) + "Output";
            operationName = qname;
        }
        this.setPort(operationName, inputMessageName, outputMessageName, wsiCompliant);
        this.setBinding(name, operationName, wsiCompliant);
        Element outputMessage = this.setStandardOutput(outputMessageName, outputwrappedName, wsiCompliant);
        Element inputMessage = this.setStandardInput(inputMessageName, inputwrappedName, wsiCompliant);
        Element sinputParams = null;
        Element soutputParams = null;
        Element sfaultParams = null;
        Element sequenceInput = null;
        Element sequenceOutput = null;
        if (wsiCompliant) {
            Element stambiaInput = this.createElement(doc, this.xsdWrappedSchema, inputwrappedName, null, null, null, null);
            Element complexTypeInput = this.appendXsdNode(doc, stambiaInput, "complexType");
            Element complexContentInput = this.appendXsdNode(doc, complexTypeInput, "complexContent");
            Element extensionInput = this.appendXsdNode(doc, complexContentInput, "extension");
            extensionInput.setAttribute("base", "stbPS:InputType");
            sinputParams = sequenceInput = this.appendXsdNode(doc, extensionInput, "sequence");
            Element stambiaOutput = this.createElement(doc, this.xsdWrappedSchema, outputwrappedName, null, null, null, null);
            Element complexTypeOutput = this.appendXsdNode(doc, stambiaOutput, "complexType");
            Element complexContentOutput = this.appendXsdNode(doc, complexTypeOutput, "complexContent");
            Element extensionOutput = this.appendXsdNode(doc, complexContentOutput, "extension");
            extensionOutput.setAttribute("base", "stbPS:OutputType");
            soutputParams = sequenceOutput = this.appendXsdNode(doc, extensionOutput, "sequence");
            sfaultParams = doc.createElementNS(SCHEMA_URI, "sequence");
            sfaultParams.setPrefix(XSD_PREFIX);
        } else {
            sinputParams = doc.createElementNS(SCHEMA_URI, "sequence");
            sinputParams.setPrefix(XSD_PREFIX);
            soutputParams = doc.createElementNS(SCHEMA_URI, "sequence");
            soutputParams.setPrefix(XSD_PREFIX);
            sfaultParams = doc.createElementNS(SCHEMA_URI, "sequence");
            sfaultParams.setPrefix(XSD_PREFIX);
        }
        for (String key : currentDelivery.getParameters().keySet()) {
            Delivery.Parameter param = currentDelivery.getParameters().get(key);
            if (param.isInput()) {
                this.createParams(doc, sinputParams, param);
            }
            if (param.isOutput()) {
                this.createParams(doc, soutputParams, param);
            }
            if (!param.isFault()) continue;
            this.createParams(doc, sfaultParams, param);
        }
        if (!wsiCompliant && sinputParams.getChildNodes().getLength() > 0) {
            Element inputParams = doc.createElementNS(SCHEMA_URI, "complexType");
            inputParams.appendChild(sinputParams);
            inputParams.setPrefix(XSD_PREFIX);
            inputParams.setAttribute("name", inputParametersTypeName);
            this.xsdParametersSchema.appendChild(inputParams);
            elt = null;
            elt = doc.createElementNS(WSDL_URI, "part");
            inputMessage.appendChild(elt);
            elt.setAttribute("name", "userParameters");
            elt.setAttribute("type", "stbXP:" + inputParametersTypeName);
        }
        result.add(inputMessage);
        if (!wsiCompliant && soutputParams.getChildNodes().getLength() > 0) {
            Element outputParams = doc.createElementNS(SCHEMA_URI, "complexType");
            outputParams.setPrefix(XSD_PREFIX);
            outputParams.setAttribute("name", outputParametersTypeName);
            outputParams.appendChild(soutputParams);
            this.xsdParametersSchema.appendChild(outputParams);
            elt = null;
            elt = doc.createElementNS(WSDL_URI, "part");
            outputMessage.appendChild(elt);
            elt.setAttribute("name", "userParameters");
            elt.setAttribute("type", "stbXP:" + outputParametersTypeName);
        }
        result.add(outputMessage);
        for (Delivery.Route _route : currentDelivery.getRoutes()) {
            String attributeName;
            String routeId = _route.getId();
            String targetnamespaceStr = this.getMetaDataSchema().getSchemaMap().get(routeId);
            if (targetnamespaceStr != null) {
                boolean noNamespace = false;
                if (targetnamespaceStr.equals(STAMBIA_NO_NAMESPACE_URI)) {
                    noNamespace = true;
                    if (!wsiCompliant) {
                        targetnamespaceStr = STAMBIA_NO_NAMESAPCE_URI;
                    }
                }
                if (!this.allNamepsaces.containsKey(targetnamespaceStr)) {
                    if (targetnamespaceStr.equals(WsdlAPI.STAMBIA_NO_NAMESPACE_URI(wsiCompliant))) {
                        this.allNamepsaces.put(targetnamespaceStr, WsdlAPI.STAMBIA_NONAMESPACE_PREFIX(wsiCompliant));
                    } else {
                        this.allNamepsaces.put(targetnamespaceStr, "ns" + (this.allNamepsaces.size() + 1));
                    }
                }
                if (!noNamespace) {
                    _route.setTargetNameSpace(targetnamespaceStr);
                    _route.setTargetPrefix(this.allNamepsaces.get(targetnamespaceStr));
                } else {
                    _route.setTargetNameSpace(null);
                    _route.setTargetPrefix(null);
                }
            }
            if (_route.isInput() && _route.getType().equals("xsd")) {
                Element elt2 = null;
                if (wsiCompliant) {
                    elt2 = this.appendXsdNode(doc, sequenceInput, "element");
                    attributeName = "ref";
                } else {
                    elt2 = doc.createElementNS(WSDL_URI, "part");
                    inputMessage.appendChild(elt2);
                    elt2.setAttribute("name", _route.getElementName());
                    attributeName = "element";
                }
                if (targetnamespaceStr != null) {
                    elt2.setAttribute(attributeName, String.valueOf(this.allNamepsaces.get(targetnamespaceStr)) + ":" + _route.getElementName());
                } else {
                    elt2.setAttribute(attributeName, String.valueOf(WsdlAPI.STAMBIA_NONAMESPACE_PREFIX(wsiCompliant)) + ":" + _route.getElementName());
                }
            }
            if (!_route.isOutput() || !_route.getType().equals("xsd")) continue;
            Element elt3 = null;
            if (wsiCompliant) {
                elt3 = this.appendXsdNode(doc, sequenceOutput, "element");
                attributeName = "ref";
                elt3.setAttribute("maxOccurs", "1");
                elt3.setAttribute("minOccurs", "0");
            } else {
                elt3 = doc.createElementNS(WSDL_URI, "part");
                outputMessage.appendChild(elt3);
                elt3.setAttribute("name", _route.getElementName());
                attributeName = "element";
            }
            if (targetnamespaceStr != null) {
                elt3.setAttribute(attributeName, String.valueOf(this.allNamepsaces.get(targetnamespaceStr)) + ":" + _route.getElementName());
                continue;
            }
            elt3.setAttribute(attributeName, String.valueOf(WsdlAPI.STAMBIA_NONAMESPACE_PREFIX(wsiCompliant)) + ":" + _route.getElementName());
        }
    }

    private Element setStandardOutput(String outputMessageName, String wrappedElementName, boolean wsiCompliant) {
        Element outputMessage = this.doc.createElementNS(WSDL_URI, "message");
        outputMessage.setAttribute("name", outputMessageName);
        Element part = this.doc.createElementNS(WSDL_URI, "part");
        outputMessage.appendChild(part);
        String partName = wsiCompliant ? "body" : STAMBIA_OUTPUT;
        String attributeValue = wsiCompliant ? "stbWP:" + wrappedElementName : "stbPS:stambiaOutput";
        part.setAttribute("name", partName);
        part.setAttribute("element", attributeValue);
        return outputMessage;
    }

    private Element setStandardInput(String inputMessageName, String wrappedElementName, boolean wsiCompliant) {
        Element inputMessage = this.doc.createElementNS(WSDL_URI, "message");
        inputMessage.setAttribute("name", inputMessageName);
        Element part = this.doc.createElementNS(WSDL_URI, "part");
        inputMessage.appendChild(part);
        String partName = wsiCompliant ? "body" : STAMBIA_INPUT;
        String attributeValue = wsiCompliant ? "stbWP:" + wrappedElementName : "stbPS:stambiaInput";
        part.setAttribute("name", partName);
        part.setAttribute("element", attributeValue);
        return inputMessage;
    }

    private void createParams(Document doc, Element sequence, Delivery.Parameter _param) {
        Element param = doc.createElementNS(SCHEMA_URI, "element");
        param.setAttribute("minOccurs", "0");
        param.setPrefix(XSD_PREFIX);
        param.setAttribute("name", _param.getName());
        String type = _param.getType();
        if (type != null) {
            if (type.equals("String")) {
                param.setAttribute("type", "xs:string");
            } else if (type.equals("Boolean")) {
                param.setAttribute("type", "xs:boolean");
            } else if (type.equals("Integer")) {
                param.setAttribute("type", "xs:integer");
            }
        }
        sequence.appendChild(param);
    }

    private void setBinding(String action, String operation, boolean wsiCompliant) {
        Document doc = wsiCompliant ? this.docWSI : this.doc;
        Element bindingOperation = doc.createElementNS(WSDL_URI, "operation");
        if (wsiCompliant) {
            this.wsiBinding.appendChild(bindingOperation);
        } else {
            this.binding.appendChild(bindingOperation);
        }
        bindingOperation.setAttribute("name", operation);
        Element soapAction = doc.createElementNS(SOAP_URI, "operation");
        soapAction.setPrefix(SOAP_PREFIX);
        soapAction.setAttribute("soapAction", action);
        bindingOperation.appendChild(soapAction);
        Element bindingInput = doc.createElementNS(WSDL_URI, "input");
        bindingOperation.appendChild(bindingInput);
        Element soapBody = doc.createElementNS(SOAP_URI, "body");
        soapBody.setPrefix(SOAP_PREFIX);
        soapBody.setAttribute("use", "literal");
        bindingInput.appendChild(soapBody);
        Element bindingOutput = doc.createElementNS(WSDL_URI, "output");
        bindingOperation.appendChild(bindingOutput);
        soapBody = doc.createElementNS(SOAP_URI, "body");
        soapBody.setPrefix(SOAP_PREFIX);
        soapBody.setAttribute("use", "literal");
        bindingOutput.appendChild(soapBody);
    }

    private void setPort(String qname, String inputMessageName, String outputMessageName, boolean wsiCompliant) {
        Document doc = wsiCompliant ? this.docWSI : this.doc;
        Element operation = doc.createElementNS(WSDL_URI, "operation");
        operation.setAttribute("name", qname);
        if (wsiCompliant) {
            this.wsiPortType.appendChild(operation);
        } else {
            this.portType.appendChild(operation);
        }
        Element input = doc.createElementNS(WSDL_URI, "input");
        operation.appendChild(input);
        input.setAttribute("message", "stbW:" + inputMessageName);
        Element output = doc.createElementNS(WSDL_URI, "output");
        operation.appendChild(output);
        output.setAttribute("message", "stbW:" + outputMessageName);
    }

    void askToClear(String _session, long delay) {
        Invocation invoc = askToDelete.get(_session);
        if (invoc != null) {
            this.askToClear(invoc, delay);
        }
    }

    void askToClear(Invocation invocation, long delay) {
        if (delay <= 0L) {
            invocation.clear();
        } else {
            invocation.delayBeforeClear = System.currentTimeMillis() + delay;
            askToDelete.put(invocation.getSessionId(), invocation);
            clearRunnable._notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initWSDL() throws Exception {
        this.log.info("initWsdl");
        MainLock mainLock = this.mainLock;
        synchronized (mainLock) {
            ArrayList list;
            List list2 = this.mainLock.invocationLock;
            synchronized (list2) {
                list = new ArrayList(this.mainLock.invocationLock);
            }
            for (Lock lock : list) {
                lock.waitEndLock();
            }
            this.mainLock.removeAllLock();
            new ArrayList();
            this.metadataSchema = new MeteDataSchema();
            this.allDeliveries.clear();
            Map<String, List<Node>> schemaNodes = this.metadataSchema.getSchemaNodes();
            Pattern.compile("(.*)(\\." + Global.DELIVERY_EXTENSION + ")");
            this.initDoc();
            DeliveryRestAPIHelper.CatalogConfiguration catalogConf = new DeliveryRestAPIHelper.CatalogConfiguration(DEFAULT_CATALOG_NAME);
            if (this.repo != null) {
                catalogConf.setProperty(DeliveryRestAPIHelper.CatalogConfiguration.SWAGGER2_FILE_PATH, String.valueOf(this.repo.getCacheFolder().getAbsolutePath()) + File.separator + "xdi-runtime-api-user-endpoint-" + new URL(this.url).getPort() + String.format("-swagger2-%s.json", DEFAULT_CATALOG_NAME));
                catalogConf.setProperty(DeliveryRestAPIHelper.CatalogConfiguration.SWAGGER2_HOST, String.valueOf(Global.HTTP_HOST) + ":" + Global.HTTP_PORT);
                catalogConf.setProperty(DeliveryRestAPIHelper.CatalogConfiguration.SWAGGER2_BASE_PATH, "/rest/DeliveryService/3/default");
                catalogConf.setProperty(DeliveryRestAPIHelper.CatalogConfiguration.OPENAPI3_FILE_PATH, String.valueOf(this.repo.getCacheFolder().getAbsolutePath()) + File.separator + "xdi-runtime-api-user-endpoint-" + new URL(this.url).getPort() + String.format("-openAPI303-%s.json", DEFAULT_CATALOG_NAME));
                catalogConf.setProperty(DeliveryRestAPIHelper.CatalogConfiguration.OPENAPI3_URL, String.valueOf(Global.webServiceSecureProtocolType != null ? "https" : "http") + "://" + Global.HTTP_HOST + ":" + Global.HTTP_PORT + "/" + ctxRestV3 + "/" + DEFAULT_CATALOG_NAME);
            }
            DeliveryRestAPIHelper.Catalog catalog = DeliveryRestAPIHelper.initCatalog(catalogConf);
            ArrayList<DeliveryInfo> deliveries = new ArrayList<DeliveryInfo>();
            HashMap<String, String> jsonSchemas = new HashMap<String, String>();
            if (this.repo != null) {
                boolean[] bs;
                Object namespace;
                for (String name : this.repo.getLstDeliveries(null)) {
                    File deliv = this.repo.getDeliveryFile(name);
                    if (!deliv.getName().endsWith(".deliv")) continue;
                    try {
                        HashMap<String, List<Node>> _schemaNodes = new HashMap<String, List<Node>>();
                        Delivery currentDelivery = Utils.parseDelivery(deliv, this, true, _schemaNodes, jsonSchemas);
                        DeliveryInfo info = new DeliveryInfo();
                        info.deliv = currentDelivery;
                        info.name = name;
                        currentDelivery.setName(info.name);
                        this.allDeliveries.put(name, currentDelivery);
                        deliveries.add(info);
                        Iterator iterator = _schemaNodes.keySet().iterator();
                        while (iterator.hasNext()) {
                            namespace = (String)iterator.next();
                            List<Node> nodes = null;
                            if (!schemaNodes.isEmpty() && schemaNodes.containsKey(namespace)) {
                                nodes = schemaNodes.get(namespace);
                            } else {
                                nodes = new ArrayList();
                                schemaNodes.put((String)namespace, nodes);
                            }
                            nodes.addAll((Collection)_schemaNodes.get(namespace));
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().error(String.valueOf(Messages.getString("WsdlAPI.1")) + deliv, (Throwable)e);
                        e.printStackTrace();
                    }
                }
                ArrayList<Element> messages = new ArrayList<Element>();
                ArrayList<Element> messagesWSI = new ArrayList<Element>();
                boolean[] blArray = new boolean[2];
                blArray[0] = true;
                namespace = bs = blArray;
                int info = bs.length;
                int n = 0;
                while (n < info) {
                    boolean wsiCompliant = namespace[n];
                    if (wsiCompliant || !wsiCompliant) {
                        for (DeliveryInfo deliv : deliveries) {
                            if (deliv.deliv.getInputType().isXmlOnly() && deliv.deliv.getOutputType().isXmlOnly()) {
                                ArrayList<Element> _messages = new ArrayList<Element>();
                                try {
                                    this.parseDelivery(deliv, _messages, wsiCompliant);
                                }
                                catch (Exception e) {
                                    this.getLogger().error(String.valueOf(Messages.getString("WsdlAPI.2")) + deliv, (Throwable)e);
                                    e.printStackTrace();
                                }
                                for (Element message : _messages) {
                                    if (wsiCompliant) {
                                        messagesWSI.add(message);
                                        continue;
                                    }
                                    messages.add(message);
                                }
                            }
                            catalog.add(deliv, jsonSchemas);
                        }
                    }
                    ++n;
                }
                this.deliveryRestHelper.addCatalog(catalog);
                for (String uri : this.allNamepsaces.keySet()) {
                    if (!uri.equals(STAMBIA_NO_NAMESPACE_URI)) {
                        this.definitions.setAttribute("xmlns:" + this.allNamepsaces.get(uri), uri);
                    }
                    if (uri.equals(STAMBIA_NO_NAMESAPCE_URI)) continue;
                    this.definitionsWSI.setAttribute("xmlns:" + this.allNamepsaces.get(uri), uri);
                    if (uri.equals(STAMBIA_DOCUMENT_LITERAL_WRAPPER_URI)) continue;
                    Element stdImport = this.appendXsdNode(this.docWSI, this.xsdWrappedSchema, "import", 0);
                    stdImport.setAttribute("namespace", uri);
                }
                if (!schemaNodes.isEmpty()) {
                    for (String nameSpace : schemaNodes.keySet()) {
                        List<Node> source = schemaNodes.get(nameSpace);
                        ArrayList<Node> schemas = new ArrayList<Node>(source.size());
                        for (Node n2 : source) {
                            schemas.add(n2);
                        }
                        Node firstSchema = (Node)schemas.remove(0);
                        this.doc.adoptNode(firstSchema);
                        for (Node schema : schemas) {
                            this.mergeSchema(firstSchema, schema, nameSpace);
                        }
                        if (nameSpace.equals(STAMBIA_NO_NAMESPACE_URI)) {
                            this.xsdNoNamespace = firstSchema;
                        }
                        this.types.appendChild(firstSchema);
                    }
                }
                if (this.types.getChildNodes().getLength() > 0) {
                    this.types.insertBefore(this.xsdStandardSchema, this.types.getFirstChild());
                } else {
                    this.types.appendChild(this.xsdStandardSchema);
                }
                if (this.xsdParametersSchema.getChildNodes().getLength() > 0) {
                    this.definitions.setAttribute("xmlns:stbXP", STAMBIA_XSD_PARAMETERS_URI);
                    this.types.appendChild(this.xsdParametersSchema);
                } else {
                    this.xsdParametersSchema = null;
                }
                this.definitions.setAttribute("xmlns:xs", SCHEMA_URI);
                this.definitions.appendChild(this.types);
                for (Element message : messages) {
                    this.definitions.appendChild(message);
                }
                this.definitions.appendChild(this.portType);
                this.definitions.appendChild(this.binding);
                this.definitions.appendChild(this.service);
                if (this.xsdNoNamespace != null) {
                    this.xsdNoNamespace.getAttributes().getNamedItem("targetNamespace").setNodeValue(STAMBIA_NO_NAMESAPCE_URI);
                }
                this.definitions.setAttribute("name", DEF_NAME);
                this.writeFile(STAMBIA_WSDL_PATH, this.doc);
                try {
                    this.deliveryRestHelper.getCatalog(DEFAULT_CATALOG_NAME).serializeFile();
                }
                catch (Exception ex) {
                    throw new Exception(String.valueOf(Messages.getString("WsdlAPI.3")) + DEFAULT_CATALOG_NAME, ex);
                }
                this.docWSI.adoptNode(this.types);
                this.types.appendChild(this.xsdWrappedSchema);
                if (this.xsdStandardSchema != null) {
                    this.types.removeChild(this.xsdStandardSchema);
                }
                if (this.xsdParametersSchema != null) {
                    this.types.removeChild(this.xsdParametersSchema);
                }
                this.definitionsWSI.setAttribute("xmlns:xs", SCHEMA_URI);
                this.types.appendChild(this.xsdStandardSchemaWSI);
                this.definitionsWSI.appendChild(this.types);
                for (Element message : messagesWSI) {
                    this.docWSI.adoptNode(message);
                    this.definitionsWSI.appendChild(message);
                }
                this.definitionsWSI.appendChild(this.wsiPortType);
                this.definitionsWSI.appendChild(this.wsiBinding);
                this.definitionsWSI.appendChild(this.wsiService);
                if (this.xsdNoNamespace != null) {
                    this.xsdNoNamespace.getAttributes().getNamedItem("targetNamespace").setNodeValue(STAMBIA_NO_NAMESPACE_URI);
                }
                this.definitionsWSI.setAttribute("name", "DeliverableService");
                this.writeFile(STAMBIA_WSDL_PATH_WSI, this.docWSI);
            }
        }
    }

    private void mergeSchema(Node firstSchema, Node schema, String targetNamespace) {
        String elementName;
        Node element;
        String prefix = "Namespace merging: " + targetNamespace;
        this.log.info(String.valueOf(prefix) + " start");
        int firstSchemaNbElement = firstSchema.getChildNodes().getLength();
        int schemaNbElement = schema.getChildNodes().getLength();
        if (firstSchemaNbElement != schemaNbElement) {
            this.log.info(String.valueOf(prefix) + Messages.getString("WsdlAPI.4"));
        }
        HashMap<String, Node> firstSchemaElements = new HashMap<String, Node>();
        HashMap<String, Node> schemaElements = new HashMap<String, Node>();
        ArrayList<Node> nodeToAddToSchema = new ArrayList<Node>();
        int i = 0;
        while (i < firstSchemaNbElement) {
            element = firstSchema.getChildNodes().item(i);
            elementName = element.getAttributes().getNamedItem("name").getNodeValue();
            if (elementName != null) {
                firstSchemaElements.put(elementName, element);
            }
            ++i;
        }
        i = 0;
        while (i < schemaNbElement) {
            element = schema.getChildNodes().item(i);
            elementName = element.getAttributes().getNamedItem("name").getNodeValue();
            if (elementName != null) {
                schemaElements.put(elementName, element);
            }
            ++i;
        }
        ArrayList<String> nodeNameToBeCompared = new ArrayList<String>();
        for (String elementName2 : firstSchemaElements.keySet()) {
            if (!schemaElements.containsKey(elementName2)) {
                this.log.info(String.valueOf(prefix) + Messages.getString("WsdlAPI.5") + elementName2 + Messages.getString("WsdlAPI.6"));
                continue;
            }
            nodeNameToBeCompared.add(elementName2);
        }
        for (String elementName2 : schemaElements.keySet()) {
            if (!firstSchemaElements.containsKey(elementName2)) {
                this.log.info(String.valueOf(prefix) + Messages.getString("WsdlAPI.7") + elementName2 + Messages.getString("WsdlAPI.8"));
                nodeToAddToSchema.add((Node)schemaElements.get(elementName2));
                continue;
            }
            this.log.warn(String.valueOf(prefix) + Messages.getString("WsdlAPI.9") + elementName2 + Messages.getString("WsdlAPI.10"));
        }
        for (Node node : nodeToAddToSchema) {
            this.doc.adoptNode(node);
            firstSchema.appendChild(node);
        }
        this.log.info(String.valueOf(prefix) + " end");
    }

    public DeliveryRestAPIHelper getDeliveryRestHelper() {
        return this.deliveryRestHelper;
    }

    public void writeFile(String wsdlPath, Document doc) throws TransformerException, IOException {
        TransformerFactory transfac = TransformerFactory.newInstance();
        transfac.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transfac.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        trans.setOutputProperty("encoding", "UTF-8");
        if (!new File(wsdlPath).getParentFile().exists()) {
            new File(wsdlPath).getParentFile().mkdirs();
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(wsdlPath)), StandardCharsets.UTF_8);){
            StreamResult result = new StreamResult(fw);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Exception startSOAPServer() throws Exception {
        this.sprintBootApp = new Application();
        Exception t = null;
        this.log.info("Starting soapServer...");
        this.sprintBootApp.start();
        try {
            clearRunnable = new AskToClearRunnable(this);
            threadDeleteFile = new Thread(clearRunnable);
            threadDeleteFile.setName("SoapPersistenceFileCleaner");
            threadDeleteFile.setDaemon(true);
            threadDeleteFile.start();
            boolean warningDuringServerStart = false;
            try {
                new URL(this.url);
                this.log.info("Url: " + this.urlNonWSI);
                this.log.info("UrlWsi: " + this.urlWSI);
                this.log.info("UrlRest: " + this.url + ctxRestV1);
                this.log.info("UrlRest: " + this.url + ctxRestV2);
                this.log.info("UrlRest: " + this.url + ctxRestV3);
                if (this.repo == null) {
                    throw new NoWebServiceRepositoryException();
                }
            }
            catch (NoWebServiceRepositoryException e) {
                Global.getConsoleLogger().warn(e.getMessage());
                this.log.error("Error", (Throwable)e);
                warningDuringServerStart = true;
            }
            catch (Exception e) {
                t = e;
                e.printStackTrace();
                this.log.error("Error", (Throwable)e);
                System.out.println(e.getMessage());
                this.hasError = true;
            }
            if (!this.hasError) {
                Global.getConsoleLogger().info(String.valueOf(Messages.getString("WsdlAPI.16")) + this.urlWSI + "/" + "DeliverableService" + "?WSDL");
                Global.getConsoleLogger().info("SOAP Legacy \"Non WSI-Compliant\" Endpoint: " + this.urlNonWSI + "/" + "DeliveryService" + "?WSDL");
                this.deliveryRestHelper.catalogs.keySet().stream().sorted().forEach(catalogName -> {
                    Global.getConsoleLogger().info(String.valueOf(Messages.getString("WsdlAPI.17")) + this.url + ctxRestV3 + "/" + catalogName + "/<path>");
                    Global.getConsoleLogger().info("HTTP Rest v3 - UI: " + this.url + ctxRestV3 + "/" + catalogName + "?swagger-ui");
                    Global.getConsoleLogger().info(String.valueOf(Messages.getString("WsdlAPI.18")) + this.url + ctxRestV3 + "/" + catalogName + "?openapi3.json");
                    Global.getConsoleLogger().info(String.valueOf(Messages.getString("WsdlAPI.19")) + this.url + ctxRestV3 + "/" + catalogName + "?swagger2.json");
                });
                Global.getConsoleLogger().info(String.valueOf(Messages.getString("WsdlAPI.20")) + this.url + ctxRestV2 + "/<deliveryName>");
                Global.getConsoleLogger().info(String.valueOf(Messages.getString("WsdlAPI.21")) + this.url + ctxRestV1 + "/<deliveryName>");
                if (warningDuringServerStart) {
                    Global.getConsoleLogger().warn(String.format(Messages.getString("WsdlAPI.22"), this.url));
                }
                this.log.info("SOAP Server is started");
            } else {
                Global.getConsoleLogger().error(String.valueOf(Messages.getString("WsdlAPI.23")) + this.url);
                this.log.info(Messages.getString("WsdlAPI.24"));
            }
        }
        catch (Exception e) {
            t = e;
            Global.getConsoleLogger().info(String.valueOf(Messages.getString("WsdlAPI.25")) + this.url);
            this.log.error("Error", (Throwable)e);
        }
        return t;
    }

    public Exception stopSOAPServer() {
        try {
            this.sprintBootApp.stop();
            if (threadDeleteFile != null && threadDeleteFile.isAlive()) {
                threadDeleteFile.interrupt();
            }
            Global.getConsoleLogger().info(String.valueOf(Messages.getString("WsdlAPI.28")) + this.url);
            this.log.info(Messages.getString("WsdlAPI.29"));
        }
        catch (Exception e) {
            this.log.error(Messages.getString("WsdlAPI.30"), (Throwable)e);
            Global.getConsoleLogger().info(String.valueOf(Messages.getString("WsdlAPI.31")) + this.url);
            return e;
        }
        return null;
    }

    public Logger getLogger() {
        return this.log;
    }

    public MeteDataSchema getMetaDataSchema() {
        return this.metadataSchema;
    }

    public class DeliveryInfo {
        Delivery deliv;
        String name;
    }

    class Lock {
        Lock() {
        }

        public synchronized void waitEndLock() {
        }
    }

    class MainLock {
        private List<Lock> invocationLock = Collections.synchronizedList(new ArrayList());

        MainLock() {
        }

        public synchronized void addLock(Lock lock) {
            this.invocationLock.add(lock);
        }

        public void removeLock(Lock lock) {
            this.invocationLock.remove(lock);
        }

        public void removeAllLock() {
            this.invocationLock.clear();
        }
    }

    public class MeteDataSchema {
        private Map<String, String> metadataSchema = new HashMap<String, String>();
        private Map<String, List<Node>> schemaNodes = new HashMap<String, List<Node>>();

        public Map<String, String> getSchemaMap() {
            return this.metadataSchema;
        }

        public Map<String, List<Node>> getSchemaNodes() {
            return this.schemaNodes;
        }
    }

    private class NoWebServiceRepositoryException
    extends Exception {
        public NoWebServiceRepositoryException() {
            super(Messages.getString("WsdlAPI.0"));
        }
    }
}

