/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.Global;
import com.indy.engine.common.security.SecurityConfiguration;
import com.indy.engine.core.common.CommonUtils;
import com.indy.engine.core.common.objects2.IVariable;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.indy.engine.main.repository.impl.AnalyticsV3Repository;
import com.indy.engine.userLog.UserLogManagerI;
import com.indy.engine.wsdl.HttpSoapWrapper;
import com.indy.engine.wsdl.InvocationRest;
import com.indy.engine.wsdl.Messages;
import com.indy.engine.wsdl.WsdlAPI;
import com.indy.runtime.wsdl.HttpRestDeliveryProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;

public class DeliveryRestServlet2
extends HttpServlet {
    private volatile boolean classLoaderUpdated = false;
    protected WsdlAPI wsdlApi;

    public DeliveryRestServlet2(WsdlAPI wsdlAPI2) {
        this.wsdlApi = wsdlAPI2;
    }

    protected static boolean checkExecutionPermission(Principal userPrincipal) {
        if (Global.hasUser()) {
            String username;
            if (userPrincipal != null && (username = userPrincipal.getName()) != null && !username.isEmpty()) {
                SecurityConfiguration.User user = Global.getUser(username);
                return user != null && (user.isAdmin() || user.canExecute());
            }
            return Global.getAnonymousUser() != null && Global.getAnonymousUser().canExecute();
        }
        return true;
    }

    public static String encode(Map<Delivery.Parameter, String> params, String encoding) throws UnsupportedEncodingException {
        String queryString = null;
        if (params != null) {
            for (Delivery.Parameter param : params.keySet()) {
                if (param == null || !param.isOutput() || param.getName() == null || params.get(param) == null) continue;
                queryString = queryString == null ? "" : String.valueOf(queryString) + "&";
                queryString = encoding != null ? String.valueOf(queryString) + param.getName() + "=" + URLEncoder.encode(params.get(param), encoding) : String.valueOf(queryString) + param.getName() + "=" + URLEncoder.encode(params.get(param));
            }
            return queryString;
        }
        return null;
    }

    URIParse parseURI(String requestURI, String contentType, String httpMethod) throws Exception {
        String lastPart;
        requestURI = requestURI.replace("/rest/DeliveryService/3/default/", "/rest/DeliveryService/2/").replace("/rest/StambiaDeliveryService/3/default/", "/rest/DeliveryService/2/");
        URIParse urlParse = new URIParse();
        int index = requestURI.indexOf("/2/");
        urlParse.localPath = lastPart = requestURI.substring(index + 3);
        String deliveryName = null;
        urlParse.parts = Arrays.asList(lastPart.split("/"));
        IDeliveryRepository repo = this.wsdlApi.getRepository();
        if (repo == null) {
            throw new Exception(Messages.getString("HttpRestEndpoint02.0"));
        }
        if (repo.getPlugin() instanceof AnalyticsV3Repository) {
            int cpt = 0;
            index = lastPart.indexOf("/");
            while (index > -1 && cpt < 2) {
                index = lastPart.indexOf("/", index + 1);
                ++cpt;
            }
            deliveryName = lastPart.endsWith("/") ? lastPart.substring(0, index) : lastPart;
            if (repo.exists(deliveryName)) {
                urlParse.delivery = repo.getDelivery(deliveryName, false);
            }
        } else {
            index = lastPart.indexOf("/");
            deliveryName = index > -1 ? lastPart.substring(0, lastPart.indexOf("/")) : lastPart;
            urlParse.delivery = this.wsdlApi.getAllDeliveries().get(deliveryName);
        }
        if (urlParse.delivery == null) {
            Delivery deliv = this.getCustomPathDelivery(urlParse.parts, httpMethod);
            if (deliv != null) {
                urlParse.delivery = deliv;
            } else {
                throw new Exception(String.valueOf(Messages.getString("HttpRestEndpoint02.1")) + deliveryName + Messages.getString("HttpRestEndpoint02.2"));
            }
        }
        return urlParse;
    }

    private Delivery getCustomPathDelivery(List<String> pathParts, String httpMethod) {
        for (Delivery deliv : this.wsdlApi.getAllDeliveries().values()) {
            if (deliv.getHttpRestDeliveryProperties() == null || !deliv.getHttpRestDeliveryProperties().testRequest(pathParts) || !deliv.getHttpRestDeliveryProperties().testMethod(httpMethod)) continue;
            return deliv;
        }
        return null;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block17: {
            block15: {
                if (req.getMethod() == null || req.getMethod().isEmpty()) break block15;
                switch (req.getMethod()) {
                    case "GET": 
                    case "PUT": 
                    case "POST": 
                    case "PATCH": 
                    case "DELETE": {
                        this.invokeDelivery(req, resp);
                        break;
                    }
                    default: {
                        super.service(req, resp);
                        break;
                    }
                }
                break block17;
            }
            super.service(req, resp);
        }
    }

    private void setClassLoader() {
        if (!this.classLoaderUpdated) {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.classLoaderUpdated = true;
        }
    }

    protected void invokeDelivery(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.setClassLoader();
        try {
            if (!DeliveryRestServlet2.checkExecutionPermission(req.getUserPrincipal())) {
                resp.sendError(HttpStatus.FORBIDDEN.value());
                return;
            }
            String contentType = req.getHeader("Content-Type");
            boolean urlEncoded = contentType != null && contentType.contains("application/x-www-form-urlencoded");
            Map<String, String> query_pair = HttpSoapWrapper.splitQuery(req.getQueryString());
            if (urlEncoded) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InvocationRest.copy((InputStream)req.getInputStream(), baos);
                String query = new String(baos.toByteArray(), "UTF-8");
                Map<String, String> query_pair2 = HttpSoapWrapper.splitQuery(query);
                query_pair.putAll(query_pair2);
            }
            HashMap<String, String> input = new HashMap<String, String>();
            for (String key : query_pair.keySet()) {
                String val = query_pair.get(key);
                input.put("~/" + key, val);
            }
            input.put("~/CORE_HTTP_REQUEST_METHOD", req.getMethod());
            URIParse uriParse = this.parseURI(String.valueOf(req.getContextPath()) + req.getServletPath() + req.getPathInfo(), contentType, req.getMethod());
            List<String> parts = uriParse.parts;
            Delivery delivery = uriParse.delivery;
            InvocationRest invok = new InvocationRest((InputStream)req.getInputStream(), (OutputStream)resp.getOutputStream(), delivery, uriParse.localPath, this.wsdlApi, input, req.getUserPrincipal() == null ? null : req.getUserPrincipal().getName(), req.getRemoteAddr());
            String _logLevel = req.getHeader("X-logLevel");
            String parentSessionId = req.getHeader("X-parentSessionId");
            String sessionName = req.getHeader("X-sessionName");
            String _synchLogMode = req.getHeader("X-synchLogMode");
            UserLogManagerI.SynchMode synchLogMode = null;
            if (_synchLogMode != null && !_synchLogMode.isEmpty()) {
                synchLogMode = UserLogManagerI.SynchMode.valueOf(_synchLogMode);
            }
            String inputMessageManagement = req.getHeader("X-keepInputMessage");
            String outputMessageManagement = req.getHeader("X-keepOutputMessage");
            String faultMessageManagement = req.getHeader("X-keepFaultMessage");
            if (delivery != null) {
                if (inputMessageManagement == null || inputMessageManagement.isEmpty()) {
                    inputMessageManagement = delivery.getKeepInputMessage();
                }
                if (outputMessageManagement == null || outputMessageManagement.isEmpty()) {
                    outputMessageManagement = delivery.getKeepOutputMessage();
                }
                if (faultMessageManagement == null || faultMessageManagement.isEmpty()) {
                    faultMessageManagement = delivery.getKeepFaultMessage();
                }
            }
            invok.setInputMessageManagement(inputMessageManagement);
            invok.setOutputMessageManagement(outputMessageManagement);
            invok.setFaultMessageManagement(faultMessageManagement);
            String executionConfiguration = req.getHeader("X-Delivery-Configuration-Name");
            invok.setExecutionConfiguration(executionConfiguration);
            invok.setAsynchronous(req.getHeader("X-asynchronous"));
            Integer logLevel = null;
            if (_logLevel != null && !_logLevel.isEmpty()) {
                logLevel = Integer.valueOf(_logLevel);
            }
            invok.invoke(new InvocationHandlerImpl(req, resp, parts, urlEncoded), parentSessionId, sessionName, logLevel, synchLogMode);
            if (invok.getErrors().size() > 0) {
                if (invok.getResponseCode() == null) {
                    resp.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value());
                }
                PrintStream ps = new PrintStream((OutputStream)resp.getOutputStream());
                for (String varName : invok.getErrors().keySet()) {
                    IVariable var = invok.getErrors().get(varName);
                    ps.println(var.getValue());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            e.printStackTrace(ps);
            resp.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), new String(bos.toByteArray()));
        }
    }

    class InvocationHandlerImpl
    implements InvocationRest.Handler {
        private HttpServletRequest req;
        private HttpServletResponse resp;
        private List<String> parts;
        private boolean urlEncoded;
        private String[] outputInternetMediaType = new String[1];

        public InvocationHandlerImpl(HttpServletRequest req, HttpServletResponse resp, List<String> parts, boolean urlEncoded) {
            this.req = req;
            this.resp = resp;
            this.parts = parts;
            this.urlEncoded = urlEncoded;
        }

        @Override
        public void handleDone(Delivery delivery, Map<Delivery.Parameter, String> parametersValues, Map<String, String> outputHeader, byte[] responseBodyValue, Integer responseCode) throws IOException {
            String str = DeliveryRestServlet2.encode(parametersValues, "UTF-8");
            if (this.outputInternetMediaType[0] != null) {
                this.resp.setHeader("Content-Type", this.outputInternetMediaType[0]);
            }
            if (outputHeader != null) {
                for (Map.Entry<String, String> entry : outputHeader.entrySet()) {
                    this.resp.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if (responseCode != null) {
                this.resp.setStatus(responseCode.intValue());
            } else {
                this.resp.setStatus(HttpStatus.OK.value());
            }
            if (str != null) {
                this.resp.getOutputStream().write(str.getBytes());
            }
            if (responseBodyValue != null) {
                this.resp.getOutputStream().write(responseBodyValue);
            }
        }

        @Override
        public void handleDeliveryUnexists() throws IOException {
            this.resp.sendError(HttpStatus.NOT_FOUND.value());
        }

        @Override
        public void handleDeliveryFound(Delivery delivery, Map<String, String> handleUrlReplacementParams) throws IOException {
            HttpRestDeliveryProperties hrdp = delivery.getHttpRestDeliveryProperties();
            if (hrdp != null && hrdp.extractRequestInf()) {
                this.extractRequestInformation(handleUrlReplacementParams);
            }
            if (hrdp != null && hrdp.getRequestBodyMapper() != null) {
                this.handleBodyMapper(handleUrlReplacementParams, hrdp);
            }
            this.handleUrlParts(handleUrlReplacementParams, hrdp);
            HashSet<String> touch = new HashSet<String>();
            if (hrdp != null && hrdp.getInputHeaderMapper() != null) {
                this.replaceHeaders(handleUrlReplacementParams, hrdp, touch);
            }
            if (this.req.getHeaderNames() != null && hrdp != null && hrdp.extractRequestInf()) {
                this.addHeaderVariables(handleUrlReplacementParams, touch);
            }
            this.outputInternetMediaType[0] = delivery.getFirstOutputInternetMediaType();
            int inputNb = this.countInputs(delivery);
            int outputNb = this.countResourceOutputs(delivery);
            int outputNb2 = this.countParamOutputs(delivery);
            if (outputNb > 1) {
                throw new IOException(String.valueOf(Messages.getString("HttpRestEndpoint02.5")) + delivery.getName() + Messages.getString("HttpRestEndpoint02.6"));
            }
            if (inputNb > 1) {
                throw new IOException(String.valueOf(Messages.getString("HttpRestEndpoint02.7")) + delivery.getName() + Messages.getString("HttpRestEndpoint02.8"));
            }
            if (outputNb > 0 && outputNb2 > 0) {
                throw new IOException(String.valueOf(Messages.getString("HttpRestEndpoint02.9")) + delivery.getName() + Messages.getString("HttpRestEndpoint02.10"));
            }
            if (this.urlEncoded && inputNb > 0) {
                throw new IOException(String.valueOf(Messages.getString("HttpRestEndpoint02.11")) + delivery.getName() + Messages.getString("HttpRestEndpoint02.12"));
            }
        }

        private int countParamOutputs(Delivery delivery) {
            int outputNb2 = 0;
            for (Delivery.Parameter param : delivery.getParameters().values()) {
                if (!param.isOutput()) continue;
                ++outputNb2;
            }
            return outputNb2;
        }

        private int countResourceOutputs(Delivery delivery) {
            int outputNb = 0;
            for (Delivery.Route rt : delivery.getRoutes()) {
                if (!rt.isOutput()) continue;
                ++outputNb;
            }
            return outputNb;
        }

        private int countInputs(Delivery delivery) {
            int inputNb = 0;
            for (Delivery.Route rt : delivery.getRoutes()) {
                if (!rt.isInput()) continue;
                ++inputNb;
            }
            return inputNb;
        }

        private void addHeaderVariables(Map<String, String> handleUrlReplacementParams, Set<String> touch) {
            for (String s : Collections.list(this.req.getHeaderNames())) {
                ArrayList l;
                if (this.req.getHeaders(s) == null || touch.contains(s) || this.req.getHeaders(s) == null || (l = Collections.list(this.req.getHeaders(s))).isEmpty()) continue;
                handleUrlReplacementParams.put("~/CORE_HTTP_REQUEST_HEADER_" + s.toUpperCase(), (String)l.get(0));
            }
        }

        private void replaceHeaders(Map<String, String> handleUrlReplacementParams, HttpRestDeliveryProperties hrdp, Set<String> touch) {
            HashMap requestHeaders = new HashMap();
            Enumeration headerNames = this.req.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                requestHeaders.put(name.toUpperCase(), Collections.list(this.req.getHeaders(name)));
            }
            for (HttpRestDeliveryProperties.RequestParameterHeader param : hrdp.getInputHeaderMapper()) {
                List values = (List)requestHeaders.get(param.getHeaderName().toUpperCase());
                if (values != null && !values.isEmpty()) {
                    touch.add(param.getHeaderName());
                    handleUrlReplacementParams.put("~/" + param.getParameterName(), (String)values.get(0));
                    continue;
                }
                if (param.getValue() == null) continue;
                handleUrlReplacementParams.put("~/" + param.getParameterName(), param.getValue());
            }
        }

        private void handleUrlParts(Map<String, String> handleUrlReplacementParams, HttpRestDeliveryProperties hrdp) {
            HashSet<Integer> touch1 = new HashSet<Integer>();
            if (this.parts.size() > 1) {
                if (hrdp != null && hrdp.getParameterReplacement() != null) {
                    this.replaceUrlParts(handleUrlReplacementParams, hrdp, touch1);
                }
                int i = 0;
                while (i < this.parts.size()) {
                    if (!touch1.contains(i)) {
                        handleUrlReplacementParams.put(String.format("~/CORE_HTTP_REQUEST_URL_PART_%s", i + 1), this.parts.get(i));
                    }
                    ++i;
                }
            }
        }

        private void replaceUrlParts(Map<String, String> handleUrlReplacementParams, HttpRestDeliveryProperties hrdp, Set<Integer> touch1) {
            for (HttpRestDeliveryProperties.ParameterReplacement pr : hrdp.getParameterReplacement()) {
                int index = pr.getPosition();
                String replacement = pr.getName();
                String str = null;
                str = this.parts.size() > index ? this.parts.get(index) : pr.getValue();
                if (replacement == null || str == null) continue;
                touch1.add(index);
                handleUrlReplacementParams.put("~/" + replacement, str);
            }
        }

        private void handleBodyMapper(Map<String, String> handleUrlReplacementParams, HttpRestDeliveryProperties hrdp) throws IOException {
            HttpRestDeliveryProperties.BodyMapper bm = hrdp.getRequestBodyMapper();
            if (bm != null) {
                String _str = CommonUtils.inputStreamToString((InputStream)this.req.getInputStream(), (String)bm.getCharset());
                if (_str == null || _str.isEmpty()) {
                    _str = bm.getValue();
                }
                if (_str != null) {
                    handleUrlReplacementParams.put("~/" + bm.getParameterName(), _str);
                }
            }
        }

        private void extractRequestInformation(Map<String, String> handleUrlReplacementParams) {
            handleUrlReplacementParams.put("~/CORE_HTTP_REQUEST_URL", String.valueOf(this.req.getContextPath()) + this.req.getServletPath() + this.req.getPathInfo());
            try {
                handleUrlReplacementParams.put("~/CORE_HTTP_REMOTE_HOST_NAME", this.req.getRemoteHost());
                handleUrlReplacementParams.put("~/CORE_HTTP_REMOTE_HOST_ADDRESS", this.req.getRemoteAddr());
                if (this.req.getUserPrincipal() != null) {
                    handleUrlReplacementParams.put("~/CORE_HTTP_USER_NAME", this.req.getUserPrincipal().getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class URIParse {
        Delivery delivery;
        List<String> parts;
        String localPath;
        String contentType;

        URIParse() {
        }
    }
}

