/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.Global;
import com.indy.engine.core.security.Role;
import com.semarchy.xdi.runtime.httpserver.LegacyBasicAuthenticationProvider;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;

public class LegacyAnonymousAuthenticationFilter
extends AnonymousAuthenticationFilter {
    public LegacyAnonymousAuthenticationFilter() {
        super("legacyAnonymous");
        if (Global.getAnonymousUser() != null) {
            for (Role r : Global.getAnonymousUser().getRoles()) {
                this.getAuthorities().add(new SimpleGrantedAuthority(r.name()));
            }
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            super.doFilter(req, res, chain);
        }
        catch (LegacyBasicAuthenticationProvider.ForbiddenException ex) {
            ((HttpServletResponse)res).setStatus(403);
            ((HttpServletResponse)res).getWriter().write(String.format("Http Error %s:%s", 403, ex.getMessage()));
        }
    }
}

