/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.Global;
import com.indy.engine.common.security.SecurityConfiguration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseStatus;

@Component
public class LegacyBasicAuthenticationProvider
implements AuthenticationProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());

    private boolean validatePassword(String password, SecurityConfiguration.User user) {
        try {
            String p = new String(MessageDigest.getInstance("SHA-256").digest(password.getBytes()));
            if (!user.getHashedPassword().equals(p)) {
                p = new String(MessageDigest.getInstance("SHA-256").digest(Global.b("b.old", password, "c.old").getBytes()));
            }
            return user.getHashedPassword().equals(p);
        }
        catch (Exception e) {
            this.logger.error((Object)String.format("The user %s password cannot be validated", user.getName()), (Throwable)e);
            return false;
        }
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        WebAuthenticationDetails cfr_ignored_0 = (WebAuthenticationDetails)authentication.getDetails();
        String username = authentication.getName();
        String password = authentication.getCredentials().toString();
        SecurityConfiguration.User u = Global.getUser(username);
        if (u != null) {
            if (this.validatePassword(password, u)) {
                return new UsernamePasswordAuthenticationToken((Object)username, (Object)password, (Collection)u.getRoles().stream().map(r -> new SimpleGrantedAuthority(r.name())).collect(Collectors.toList()));
            }
            throw new BadCredentialsException(String.format("The user %s password is invalid", username));
        }
        return null;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class) || AnonymousAuthenticationToken.class == authentication;
    }

    static void validateRemoteAdress(String remoteAdress) throws ForbiddenException {
        if (Global.getRemoteHosts() != null && !Global.getRemoteHosts().isEmpty()) {
            try {
                InetAddress remoteAddress = InetAddress.getByName(remoteAdress);
                if (!Global.getRemoteHosts().contains(remoteAddress.getHostAddress()) && !Global.getRemoteHosts().contains(remoteAddress.getHostName())) {
                    throw new ForbiddenException();
                }
            }
            catch (UnknownHostException e) {
                throw new AuthenticationServiceException("Couldn't resolve host", (Throwable)e);
            }
        }
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public static class ForbiddenException
    extends RuntimeException {
        ForbiddenException() {
            super("The IP address/hostname is not allowed");
        }
    }
}

