/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.common.security.PrivilegeException;
import com.indy.engine.remote.RemoteSessionManagement;
import com.indy.engine.wsdl.HttpRuntimeInvoker;
import com.indy.runtime.json.JsonNode;
import com.semarchy.xdi.engine.common.IRemoteSessionV01;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;

public class RuntimeServlet
extends HttpServlet {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private HttpRuntimeInvoker invoker = new HttpRuntimeInvoker();

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            try {
                String paramsInHeader = req.getHeader("Params-In-Header");
                String contentEncoding = req.getHeader("Content-Encoding");
                boolean igzip = contentEncoding != null && contentEncoding.equals("gzip");
                String acceptEncoding = req.getHeader("Accept-Encoding");
                boolean ogzip = acceptEncoding != null && acceptEncoding.equals("gzip");
                Object requestJsonStream = req.getInputStream();
                ServletInputStream data = null;
                if (paramsInHeader != null) {
                    data = requestJsonStream;
                    byte[] bytes = paramsInHeader.getBytes("UTF-8");
                    requestJsonStream = new ByteArrayInputStream(bytes);
                    if (igzip) {
                        requestJsonStream = new GZIPInputStream((InputStream)requestJsonStream);
                    }
                }
                String principal = null;
                try {
                    principal = req.getUserPrincipal().getName();
                }
                catch (Exception exception) {}
                String sessionID = req.getHeader("com.indy.engine.common.EngineFactory.sessionId");
                IRemoteSessionV01 remoteSession = RemoteSessionManagement.INSTANCE.getRemote(sessionID, req.getRemoteHost(), principal);
                Object invocationResult = this.invoker.invokeRuntimeMethod((InputStream)requestJsonStream, (InputStream)data, remoteSession);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                if (ogzip) {
                    GZIPOutputStream gos = new GZIPOutputStream(baos);
                    JsonNode.serialize((Object)invocationResult, (OutputStream)gos, (String)"UTF-8");
                    gos.finish();
                    resp.setHeader("Content-Encoding", "gzip");
                } else {
                    JsonNode.serialize((Object)invocationResult, (OutputStream)baos, (String)"UTF-8");
                }
                byte[] bytes = baos.toByteArray();
                resp.setStatus(HttpStatus.OK.value());
                resp.getWriter().write(new String(bytes, "UTF-8"));
            }
            catch (Throwable t) {
                this.handleError(t, resp);
                resp.getWriter().flush();
            }
        }
        finally {
            resp.getWriter().flush();
        }
    }

    private void handleError(Throwable t, HttpServletResponse resp) throws IOException {
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        try {
            throw t;
        }
        catch (PrivilegeException ex) {
            String message = null;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ex.printStackTrace(new PrintStream(bos));
                message = new String(bos.toByteArray());
            }
            catch (Exception exception) {
                message = ex.getMessage();
            }
            resp.sendError(HttpStatus.FORBIDDEN.value(), message);
        }
        catch (Throwable ex) {
            this.logger.error((Object)"Bad request Error", ex);
            resp.sendError(HttpStatus.BAD_REQUEST.value(), t.toString());
        }
    }
}

