/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.Global;
import com.indy.engine.common.security.SecurityConfiguration;
import com.indy.engine.core.security.Role;
import com.semarchy.xdi.runtime.httpserver.LegacyAnonymousAuthenticationFilter;
import com.semarchy.xdi.runtime.httpserver.LegacyBasicAuthenticationProvider;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;

@Configuration
@EnableWebSecurity
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private LegacyBasicAuthenticationProvider authProvider;

    protected void configure(HttpSecurity http) throws Exception {
        SecurityConfiguration conf = Global.getUserConfiguration();
        if (conf != null && !conf.getUsers().isEmpty()) {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.addFilter((Filter)new LegacyAnonymousAuthenticationFilter()).httpBasic().and()).csrf().disable()).authorizeRequests().antMatchers(new String[]{"/rest/DeliveryService/1/*", "/rest/StambiaDeliveryService/1/*", "/wsi", "/wsi/*", "/nonwsi/*", "/rest/DeliveryService/2/*", "/rest/StambiaDeliveryService/2/*"})).access(this.createAccessRule(Arrays.asList(Role.Admin, Role.ExecuteAPI), Global.getRemoteHosts())).and()).authorizeRequests().antMatchers(new String[]{"/rest/DeliveryService/3/**", "/rest/StambiaDeliveryService/3/**"})).access(this.createAccessRule(Arrays.asList(Role.Connect, Role.View, Role.Admin, Role.Execute, Role.ExecuteAPI), Global.getRemoteHosts())).and()).authorizeRequests().antMatchers(new String[]{"/client/*"})).access(this.createAccessRule(Arrays.asList(Role.Connect, Role.View, Role.Admin, Role.Execute, Role.ExecuteAPI), Global.getRemoteHosts())).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        } else {
            http.csrf().disable();
        }
        http.headers().frameOptions().sameOrigin();
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.authProvider);
    }

    private String createAccessRule(List<Role> roles, List<String> hosts) {
        StringBuilder builder = new StringBuilder();
        builder.append(roles.stream().map(Enum::name).map(s -> "'" + s + "'").collect(Collectors.joining(",", "hasAnyAuthority(", ")")));
        if (hosts != null && !hosts.isEmpty()) {
            builder.append(" and ");
            builder.append(hosts.stream().map(s -> "hasIpAddress('" + s + "')").collect(Collectors.joining(" or ", "(", ")")));
        }
        return builder.toString();
    }
}

