/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.mongodb.action;

import com.indy.addons.json.JSONReverser;
import com.indy.addons.mongodb.action.Messages;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IExecute;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ExecuteException;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.util.MdFactoryHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class ReverseDocAction
implements IExecute {
    public Object run(Object object, String configuration, Map<String, String> params) throws ExecuteException {
        MdNode node = (MdNode)object;
        try {
            this.reverse(node, 0);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            if (e instanceof ExecuteException) {
                throw new ExecuteException(sw.toString());
            }
            throw new ExecuteException(sw.toString());
        }
        return null;
    }

    public void reverse(MdNode node, int mode) throws XPathExpressionException, Exception {
        this.reverse(node, mode, null);
    }

    private void getFieldNameAndType(Document document, MdNode resultingDoc) {
        for (Map.Entry pair : document.entrySet()) {
            this.getDatatype((String)pair.getKey(), pair.getValue(), resultingDoc);
        }
    }

    private void getDatatype(String key, Object val, MdNode resultingJson) {
        if (val instanceof Document) {
            MdNode subObject = this.createNodeObject(resultingJson, key);
            resultingJson.getNode().add((Object)subObject);
            this.getFieldNameAndType((Document)val, subObject);
        } else {
            this.addDataTypeToJson(key, val, resultingJson);
        }
    }

    private void addDataTypeToJson(String key, Object val, MdNode resultingJson) {
        if (val instanceof ObjectId) {
            MdNode subObject = this.createNode(resultingJson, "objectId", key);
            resultingJson.getNode().add((Object)subObject);
        } else if (val instanceof String) {
            MdNode subObject = this.createNode(resultingJson, "string", key);
            resultingJson.getNode().add((Object)subObject);
        } else if (val instanceof Boolean) {
            MdNode subObject = this.createNode(resultingJson, "boolean", key);
            resultingJson.getNode().add((Object)subObject);
        } else if (val instanceof Integer) {
            MdNode subObject = this.createNode(resultingJson, "int", key);
            resultingJson.getNode().add((Object)subObject);
        } else if (val instanceof Long) {
            MdNode subObject = this.createNode(resultingJson, "long", key);
            resultingJson.getNode().add((Object)subObject);
        } else if (val instanceof Double) {
            MdNode subObject = this.createNode(resultingJson, "double", key);
            resultingJson.getNode().add((Object)subObject);
        } else if (val instanceof Date) {
            MdNode subObject = this.createNode(resultingJson, "date", key);
            resultingJson.getNode().add((Object)subObject);
        } else if (val instanceof ArrayList) {
            MdNode subObject = this.createNodeArray(resultingJson, key);
            Iterator iterator = ((ArrayList)val).iterator();
            if (iterator.hasNext()) {
                Object el = iterator.next();
                this.getDatatype("item", el, subObject);
            }
            resultingJson.getNode().add((Object)subObject);
        } else {
            MdNode subObject = this.createNode(resultingJson, "string", key);
            resultingJson.getNode().add((Object)subObject);
        }
    }

    protected void reverseType(MdNode collection, MongoCollection<Document> mongoCollection, String findQuery) throws Exception {
        JSONReverser jr = new JSONReverser();
        jr.setParentNode(collection);
        Document queryDoc = null;
        if (findQuery != null) {
            queryDoc = Document.parse((String)findQuery);
            Iterator iterator = mongoCollection.find((Bson)queryDoc).iterator();
            if (iterator.hasNext()) {
                Document doc = (Document)iterator.next();
                this.getFieldNameAndType(doc, collection);
            }
        } else {
            Iterator iterator = mongoCollection.find().iterator();
            if (iterator.hasNext()) {
                Document doc = (Document)iterator.next();
                this.getFieldNameAndType(doc, collection);
            }
        }
    }

    protected MdNode createNode(MdNode collection, String typeVal, String name) {
        MdNode exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
        exchattr.setName(name);
        collection.getNode().add((Object)exchattr);
        exchattr.setAttribute("type", typeVal, false);
        exchattr.setPosition(BigInteger.valueOf(1L));
        return exchattr;
    }

    protected MdNode createNodeObject(MdNode collection, String name) {
        MdNode exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.object");
        exchattr.setName(name);
        collection.getNode().add((Object)exchattr);
        exchattr.setPosition(BigInteger.valueOf(1L));
        return exchattr;
    }

    protected MdNode createNodeArray(MdNode collection, String name) {
        MdNode exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.array");
        exchattr.setName(name);
        collection.getNode().add((Object)exchattr);
        exchattr.setPosition(BigInteger.valueOf(1L));
        return exchattr;
    }

    protected List<MdNode> getNodes(MongoClient mongoClient, MdNode node, int mode, String query) throws ExecuteException, XPathExpressionException, Exception {
        MongoIterable databases = mongoClient.listDatabaseNames();
        ArrayList<MdNode> nodes = new ArrayList<MdNode>();
        for (String databaseNameInsideMongodb : databases) {
            MdNode __databaseElement = MdFactoryHelper.createMdNode((String)"com.stambia.mongodb.database");
            __databaseElement.setSubstituteContainer((EObject)node);
            __databaseElement.setName(databaseNameInsideMongodb);
            __databaseElement.setAttribute("physicalName", databaseNameInsideMongodb, false);
            MongoDatabase mongoDatabase = mongoClient.getDatabase(databaseNameInsideMongodb);
            for (String collectionNameInsideMongodb : mongoDatabase.listCollectionNames()) {
                MdNode __collection = MdFactoryHelper.createMdNode((String)"com.stambia.mongodb.collection");
                __collection.setSubstituteContainer((EObject)__databaseElement);
                __collection.setName(collectionNameInsideMongodb);
                __collection.setAttribute("physicalName", collectionNameInsideMongodb, false);
                __databaseElement.getNode().add((Object)__collection);
                this.reverseType(__collection, (MongoCollection<Document>)mongoDatabase.getCollection(collectionNameInsideMongodb), query);
                this.reverseIndexes(__collection, (MongoCollection<Document>)mongoDatabase.getCollection(collectionNameInsideMongodb));
            }
            nodes.add(__databaseElement);
        }
        return nodes;
    }

    protected void reverse(MdNode currentNode, int mode, String data) throws XPathExpressionException, Exception {
        MongoClient mongoClient = null;
        MongoCredential credential = null;
        MongoClientURI uri = null;
        String mongoConnectionMethod = null;
        String mongoUrl = null;
        String mongoUser = null;
        String mongoPassword = null;
        String mongoAuthDatabase = null;
        String mongoHost = null;
        String mongoPort = null;
        try {
            MdNode server = currentNode;
            if (currentNode.getDefType().contains("com.stambia.mongodb.collection")) {
                server = (MdNode)currentNode.eContainer().eContainer();
            }
            if (currentNode.getDefType().contains("com.stambia.mongodb.database")) {
                server = (MdNode)currentNode.eContainer();
            }
            mongoUrl = currentNode.evaluate("ancestor-or-self::*/@mongoUrl");
            mongoHost = currentNode.evaluate("ancestor-or-self::*/@mongoHost");
            mongoPort = currentNode.evaluate("ancestor-or-self::*/@mongoPort");
            mongoUser = currentNode.evaluate("ancestor-or-self::*/@mongoUser");
            mongoPassword = currentNode.evaluate("ancestor-or-self::*/@mongoPassword");
            mongoAuthDatabase = currentNode.evaluate("ancestor-or-self::*/@mongoAuthDatabase");
            mongoConnectionMethod = currentNode.evaluate("ancestor-or-self::*/@mongoConnectionMethod");
            if (mongoConnectionMethod == null || mongoConnectionMethod.isEmpty()) {
                mongoConnectionMethod = "URL";
            }
            if (!mongoConnectionMethod.contentEquals("URL") && !mongoConnectionMethod.contentEquals("UserPassword")) {
                throw new ReverseException("Unknown Connection Method");
            }
            if (mongoConnectionMethod.contentEquals("URL") && (mongoUrl == null || mongoUrl.isEmpty())) {
                throw new ReverseException(Messages.ReverseDocAction_0);
            }
            if (mongoConnectionMethod.contentEquals("UserPassword")) {
                if (mongoHost == null || mongoHost.isEmpty()) {
                    throw new ReverseException(Messages.ReverseDocAction_33);
                }
                if (mongoPort == null || mongoPort.isEmpty()) {
                    throw new ReverseException(Messages.ReverseDocAction_34);
                }
                if (mongoUser == null || mongoUser.isEmpty()) {
                    throw new ReverseException(Messages.ReverseDocAction_35);
                }
            }
            try {
                if (mongoConnectionMethod == null || mongoConnectionMethod.isEmpty() || mongoConnectionMethod.contentEquals("URL")) {
                    uri = new MongoClientURI(mongoUrl);
                    mongoClient = new MongoClient(uri);
                } else if (mongoConnectionMethod.contentEquals("UserPassword")) {
                    if (mongoPassword != null && !mongoPassword.isEmpty()) {
                        try {
                            String decrypt;
                            SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                            semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                            mongoPassword = decrypt = semaphoreManager.getStringAsciiInfo(mongoPassword);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    credential = mongoAuthDatabase != null && !mongoAuthDatabase.isEmpty() ? MongoCredential.createCredential((String)mongoUser, (String)mongoAuthDatabase, (char[])mongoPassword.toCharArray()) : MongoCredential.createCredential((String)mongoUser, (String)"admin", (char[])mongoPassword.toCharArray());
                    mongoClient = new MongoClient(new ServerAddress(mongoHost, Integer.parseInt(mongoPort)), credential, null);
                }
                List<MdNode> nodeToReverse = this.getNodes(mongoClient, currentNode, mode, data);
                HashMap<MdNode, MdNode> reverseNodes = new HashMap<MdNode, MdNode>();
                for (MdNode n : nodeToReverse) {
                    TreeIterator it = n.eAllContents();
                    while (it.hasNext()) {
                        EObject o = (EObject)it.next();
                        if (!(o instanceof MdNode)) continue;
                        ((MdNode)o).setSubstituteContainer(null);
                    }
                    reverseNodes.put(n, server.getNodeByName(n.getDefType(), n.getName()));
                }
                IncrementalReverser ir = new IncrementalReverser((EObject)server, reverseNodes, Collections.EMPTY_LIST, false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
                ir.reverse();
            }
            finally {
                if (mongoClient != null) {
                    mongoClient.close();
                }
            }
        }
        catch (Exception e) {
            if (mongoClient != null) {
                mongoClient.close();
            }
            if (e instanceof ReverseException) {
                throw new ReverseException((Throwable)e);
            }
            throw new ReverseException((Throwable)e);
        }
    }

    protected void reverseIndexes(MdNode collection, MongoCollection<Document> mongoCollection) {
    }

    private void getIndexKeys(Document doc, MdNode resultingJson) {
        for (String key : doc.keySet()) {
            if (!key.equals("key")) continue;
            this.getKeysElements((Document)doc.get((Object)key), resultingJson);
        }
    }

    private void getKeysElements(Document doc, MdNode resultingJson) {
        for (String key : doc.keySet()) {
            Object val = doc.get((Object)key);
            if (val instanceof Document) {
                MdNode subObject = this.createNodeObject(resultingJson, key);
                resultingJson.getNode().add((Object)subObject);
                this.getIndexKeys((Document)val, resultingJson);
                continue;
            }
            this.addDataTypeToJson(key, val, resultingJson);
        }
    }
}

