/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.mongodb.action;

import com.indy.addons.mongodb.action.Messages;
import com.indy.addons.mongodb.action.ReverseDocAction;
import com.indy.runtime.json.JsonUtils;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.stambia.md.MdNode;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.util.MdFactoryHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bson.Document;
import org.eclipse.emf.ecore.EObject;

public class ReverseDocActionOnFind
extends ReverseDocAction {
    @Override
    protected List<MdNode> getNodes(MongoClient mongoClient, MdNode node, int mode, String data) throws Exception {
        MdNode databaseNode = (MdNode)node.eContainer();
        String databasePhysicalName = databaseNode.evaluate("@physicalName");
        MongoDatabase mongoDatabase = mongoClient.getDatabase(databasePhysicalName);
        String collectionPhysicalName = node.evaluate("@collection");
        if (collectionPhysicalName == null || collectionPhysicalName.isEmpty()) {
            throw new ReverseException(Messages.ReverseDocActionOnFind_2);
        }
        String findQuery = node.evaluate("@query");
        if (findQuery == null || findQuery.isEmpty()) {
            throw new ReverseException(Messages.ReverseDocActionOnFind_4);
        }
        List _nodes = (List)node.evaluateMdSet("*[name()='value' and @name!='document']");
        HashMap<String, String> inputParams = new HashMap<String, String>();
        for (MdNode o : _nodes) {
            String val = o.evaluate("@reverseValue");
            if (val == null) continue;
            String _type = o.evaluate("@type");
            if (_type != null && _type.equals("string")) {
                inputParams.put(o.getName(), "\"" + val + "\"");
                continue;
            }
            inputParams.put(o.getName(), val);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JsonUtils.convertJsonToXml((InputStream)new ByteArrayInputStream(findQuery.getBytes("UTF-8")), (OutputStream)os, (String)"UTF-8", (String)"UTF-8", (boolean)false, inputParams);
        ByteArrayOutputStream os2 = new ByteArrayOutputStream();
        JsonUtils.convertXmlToJson((InputStream)new ByteArrayInputStream(os.toByteArray()), (OutputStream)os2, (String)"UTF-8", (String)"UTF-8");
        String _query = new String(os2.toByteArray());
        ArrayList<MdNode> nodes = new ArrayList<MdNode>();
        MdNode result = MdFactoryHelper.createMdNode((String)"com.stambia.json.array");
        result.setSubstituteContainer((EObject)node);
        result.setName("result");
        MdNode document = MdFactoryHelper.createMdNode((String)"com.stambia.json.object");
        document.setSubstituteContainer((EObject)result);
        document.setName("document");
        result.getNode().add((Object)document);
        nodes.add(result);
        this.reverseType(document, (MongoCollection<Document>)mongoDatabase.getCollection(collectionPhysicalName), _query);
        return nodes;
    }
}

