/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class ResetJobAction
extends ActionType<AcknowledgedResponse> {
    public static final String NAME = "cluster:admin/xpack/ml/job/reset";
    public static final ResetJobAction INSTANCE = new ResetJobAction();
    public static final Version VERSION_INTRODUCED = Version.V_7_14_0;

    private ResetJobAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private String jobId;
        private boolean skipJobStateValidation;
        private boolean shouldStoreResult;

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobId = in.readString();
            this.skipJobStateValidation = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeBoolean(this.skipJobStateValidation);
        }

        public void setSkipJobStateValidation(boolean skipJobStateValidation) {
            this.skipJobStateValidation = skipJobStateValidation;
        }

        public boolean isSkipJobStateValidation() {
            return this.skipJobStateValidation;
        }

        public void setShouldStoreResult(boolean shouldStoreResult) {
            this.shouldStoreResult = shouldStoreResult;
        }

        public boolean getShouldStoreResult() {
            return this.shouldStoreResult;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "job-" + this.jobId, parentTaskId, headers);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String getJobId() {
            return this.jobId;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.skipJobStateValidation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request that = (Request)((Object)o);
            return Objects.equals(this.jobId, that.jobId) && this.skipJobStateValidation == that.skipJobStateValidation;
        }
    }
}

