/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.service;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Map;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class TokenInfo
implements Writeable,
ToXContentObject,
Comparable<TokenInfo> {
    private final String name;
    @Nullable
    private final Collection<String> nodeNames;

    private TokenInfo(String name) {
        this(name, null);
    }

    private TokenInfo(String name, Collection<String> nodeNames) {
        this.name = name;
        this.nodeNames = nodeNames;
    }

    public TokenInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.nodeNames = in.readOptionalStringList();
    }

    public String getName() {
        return this.name;
    }

    public TokenSource getSource() {
        return this.nodeNames == null ? TokenSource.INDEX : TokenSource.FILE;
    }

    public Collection<String> getNodeNames() {
        return this.nodeNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenInfo tokenInfo = (TokenInfo)o;
        return Objects.equals(this.name, tokenInfo.name) && Objects.equals(this.nodeNames, tokenInfo.nodeNames);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nodeNames);
    }

    public String toString() {
        return "TokenInfo{name='" + this.name + '\'' + ", nodeNames=" + this.nodeNames + '}';
    }

    public static TokenInfo indexToken(String name) {
        return new TokenInfo(name);
    }

    public static TokenInfo fileToken(String name, Collection<String> nodeNames) {
        return new TokenInfo(name, nodeNames);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.nodeNames == null) {
            return builder.field(this.name, Map.of());
        }
        return builder.field(this.name, Map.of((Object)"nodes", this.nodeNames));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalStringCollection(this.nodeNames);
    }

    @Override
    public int compareTo(TokenInfo o) {
        int v = this.getSource().compareTo(o.getSource());
        if (v == 0) {
            return this.name.compareTo(o.name);
        }
        return v;
    }

    public static enum TokenSource {
        INDEX,
        FILE;

    }
}

