/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.auto.common.AnnotationMirrors;
import autovalue.shaded.com.google.auto.common.GeneratedAnnotations;
import autovalue.shaded.com.google.auto.common.MoreElements;
import autovalue.shaded.com.google.auto.common.MoreStreams;
import autovalue.shaded.com.google.auto.common.MoreTypes;
import autovalue.shaded.com.google.auto.common.Visibility;
import autovalue.shaded.com.google.common.base.Throwables;
import autovalue.shaded.com.google.common.collect.BiMap;
import autovalue.shaded.com.google.common.collect.ImmutableBiMap;
import autovalue.shaded.com.google.common.collect.ImmutableCollection;
import autovalue.shaded.com.google.common.collect.ImmutableList;
import autovalue.shaded.com.google.common.collect.ImmutableListMultimap;
import autovalue.shaded.com.google.common.collect.ImmutableMap;
import autovalue.shaded.com.google.common.collect.ImmutableSet;
import autovalue.shaded.com.google.common.collect.Iterables;
import autovalue.shaded.com.google.common.collect.Sets;
import com.google.auto.value.processor.AbortProcessingException;
import com.google.auto.value.processor.AnnotationOutput;
import com.google.auto.value.processor.AutoValueishTemplateVars;
import com.google.auto.value.processor.ClassNames;
import com.google.auto.value.processor.EclipseHack;
import com.google.auto.value.processor.ErrorReporter;
import com.google.auto.value.processor.MissingTypes;
import com.google.auto.value.processor.Nullables;
import com.google.auto.value.processor.Optionalish;
import com.google.auto.value.processor.PropertyNames;
import com.google.auto.value.processor.SimpleMethod;
import com.google.auto.value.processor.TypeEncoder;
import com.google.auto.value.processor.TypeMirrorSet;
import com.google.auto.value.processor.TypeSimplifier;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

abstract class AutoValueishProcessor
extends AbstractProcessor {
    private final String annotationClassName;
    private final boolean appliesToInterfaces;
    private final Map<String, String> deferredTypeNames = new LinkedHashMap<String, String>();
    private TypeElement annotationType;
    private String simpleAnnotationName;
    private ErrorReporter errorReporter;

    AutoValueishProcessor(String annotationClassName, boolean appliesToInterfaces) {
        this.annotationClassName = annotationClassName;
        this.appliesToInterfaces = appliesToInterfaces;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.errorReporter = new ErrorReporter(processingEnv);
        this.annotationType = this.elementUtils().getTypeElement(this.annotationClassName);
        if (this.annotationType != null) {
            this.simpleAnnotationName = this.annotationType.getSimpleName().toString();
        }
    }

    final ErrorReporter errorReporter() {
        return this.errorReporter;
    }

    final Types typeUtils() {
        return this.processingEnv.getTypeUtils();
    }

    final Elements elementUtils() {
        return this.processingEnv.getElementUtils();
    }

    final ImmutableList<String> deferredTypeNames() {
        return ImmutableList.copyOf(this.deferredTypeNames.keySet());
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    void addDeferredType(TypeElement type, String missingType) {
        this.deferredTypeNames.put(type.getQualifiedName().toString(), missingType);
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.annotationType == null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Did not process @" + this.annotationClassName + " because the annotation class was not found");
            return false;
        }
        ImmutableMap<TypeElement, String> deferredTypes = this.deferredTypeNames.entrySet().stream().collect(MoreStreams.toImmutableMap(entry -> this.elementUtils().getTypeElement((CharSequence)entry.getKey()), Map.Entry::getValue));
        if (roundEnv.processingOver()) {
            deferredTypes.forEach((type, missing) -> {
                String including = missing.isEmpty() ? "" : "including " + missing;
                this.errorReporter.reportError((Element)type, "[%sUndefined] Did not generate @%s class for %s because it references undefined types %s", this.simpleAnnotationName, this.simpleAnnotationName, type.getQualifiedName(), including);
            });
            return false;
        }
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(this.annotationType);
        ImmutableCollection types = ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll((Iterable)deferredTypes.keySet())).addAll(ElementFilter.typesIn(annotatedElements))).build();
        this.deferredTypeNames.clear();
        for (TypeElement type2 : types) {
            try {
                this.validateType(type2);
                this.processType(type2);
            }
            catch (AbortProcessingException abortProcessingException) {
            }
            catch (MissingTypes.MissingTypeException e) {
                this.addDeferredType(type2, e.getMessage());
            }
            catch (RuntimeException e) {
                String trace = Throwables.getStackTraceAsString(e);
                this.errorReporter.reportError(type2, "[%sException] @%s processor threw an exception: %s", this.simpleAnnotationName, this.simpleAnnotationName, trace);
                throw e;
            }
        }
        return false;
    }

    private void validateType(TypeElement type) {
        boolean kindOk;
        ElementKind kind = type.getKind();
        boolean bl = kindOk = kind.equals((Object)ElementKind.CLASS) || this.appliesToInterfaces && kind.equals((Object)ElementKind.INTERFACE);
        if (!kindOk) {
            String appliesTo = this.appliesToInterfaces ? "classes and interfaces" : "classes";
            this.errorReporter.abortWithError(type, "[%sWrongType] @%s only applies to %s", this.simpleAnnotationName, this.simpleAnnotationName, appliesTo);
        }
        this.checkModifiersIfNested(type);
        if (!AutoValueishProcessor.hasVisibleNoArgConstructor(type)) {
            this.errorReporter.reportError(type, "[%sConstructor] @%s class must have a non-private no-arg constructor", this.simpleAnnotationName, this.simpleAnnotationName);
        }
        if (type.getModifiers().contains((Object)Modifier.FINAL)) {
            this.errorReporter.abortWithError(type, "[%sFinal] @%s class must not be final", this.simpleAnnotationName, this.simpleAnnotationName);
        }
    }

    abstract void processType(TypeElement var1);

    abstract Optional<String> nullableAnnotationForMethod(ExecutableElement var1);

    final ImmutableSet<Property> propertySet(ImmutableMap<ExecutableElement, TypeMirror> propertyMethodsAndTypes, ImmutableListMultimap<ExecutableElement, AnnotationMirror> annotatedPropertyFields, ImmutableListMultimap<ExecutableElement, AnnotationMirror> annotatedPropertyMethods, Nullables nullables) {
        BiMap methodToPropertyName = this.propertyNameToMethodMap(propertyMethodsAndTypes.keySet()).inverse();
        LinkedHashMap methodToIdentifier = new LinkedHashMap(methodToPropertyName);
        AutoValueishProcessor.fixReservedIdentifiers(methodToIdentifier);
        ImmutableSet.Builder props = ImmutableSet.builder();
        propertyMethodsAndTypes.forEach((arg_0, arg_1) -> this.lambda$propertySet$2((ImmutableBiMap)methodToPropertyName, methodToIdentifier, annotatedPropertyFields, annotatedPropertyMethods, nullables, props, arg_0, arg_1));
        return props.build();
    }

    final void defineSharedVarsForType(TypeElement type, ImmutableSet<ExecutableElement> methods, Nullables nullables, AutoValueishTemplateVars vars) {
        vars.pkg = TypeSimplifier.packageNameOf(type);
        vars.origClass = TypeSimplifier.classNameOf(type);
        vars.simpleClassName = TypeSimplifier.simpleNameOf(vars.origClass);
        vars.generated = GeneratedAnnotations.generatedAnnotation(this.elementUtils(), this.processingEnv.getSourceVersion()).map(annotation -> TypeEncoder.encode(annotation.asType())).orElse("");
        vars.formalTypes = TypeEncoder.typeParametersString(type.getTypeParameters());
        vars.actualTypes = TypeSimplifier.actualTypeParametersString(type);
        vars.wildcardTypes = AutoValueishProcessor.wildcardTypeParametersString(type);
        vars.annotations = this.copiedClassAnnotations(type);
        Map<ObjectMethod, ExecutableElement> methodsToGenerate = AutoValueishProcessor.determineObjectMethodsToGenerate(methods);
        vars.toString = methodsToGenerate.containsKey((Object)ObjectMethod.TO_STRING);
        vars.equals = methodsToGenerate.containsKey((Object)ObjectMethod.EQUALS);
        vars.hashCode = methodsToGenerate.containsKey((Object)ObjectMethod.HASH_CODE);
        vars.equalsParameterType = AutoValueishProcessor.equalsParameterType(methodsToGenerate, nullables);
        vars.serialVersionUID = this.getSerialVersionUID(type);
    }

    static ImmutableList<String> annotationStrings(List<? extends AnnotationMirror> annotations) {
        return annotations.stream().map(AnnotationOutput::sourceFormForAnnotation).sorted().collect(MoreStreams.toImmutableList());
    }

    static String generatedClassName(TypeElement type, String prefix) {
        String name = type.getSimpleName().toString();
        while (MoreElements.isType(type.getEnclosingElement())) {
            type = MoreElements.asType(type.getEnclosingElement());
            name = type.getSimpleName() + "_" + name;
        }
        String pkg = TypeSimplifier.packageNameOf(type);
        String dot = pkg.isEmpty() ? "" : ".";
        return pkg + dot + prefix + name;
    }

    private static boolean isJavaLangObject(TypeElement type) {
        return type.getSuperclass().getKind() == TypeKind.NONE && type.getKind() == ElementKind.CLASS;
    }

    static ObjectMethod objectMethodToOverride(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        switch (method.getParameters().size()) {
            case 0: {
                if (name.equals("toString")) {
                    return ObjectMethod.TO_STRING;
                }
                if (!name.equals("hashCode")) break;
                return ObjectMethod.HASH_CODE;
            }
            case 1: {
                TypeElement paramType;
                TypeMirror param;
                if (!name.equals("equals") || !(param = Iterables.getOnlyElement(method.getParameters()).asType()).getKind().equals((Object)TypeKind.DECLARED) || !(paramType = MoreTypes.asTypeElement(param)).getQualifiedName().contentEquals("java.lang.Object")) break;
                return ObjectMethod.EQUALS;
            }
        }
        return ObjectMethod.NONE;
    }

    final ImmutableBiMap<String, ExecutableElement> propertyNameToMethodMap(Set<ExecutableElement> propertyMethods) {
        LinkedHashMap<String, ExecutableElement> map = new LinkedHashMap<String, ExecutableElement>();
        HashSet<String> reportedDups = new HashSet<String>();
        boolean allPrefixed = AutoValueishProcessor.gettersAllPrefixed(propertyMethods);
        for (ExecutableElement method : propertyMethods) {
            String methodName = method.getSimpleName().toString();
            String name = allPrefixed ? AutoValueishProcessor.nameWithoutPrefix(methodName) : methodName;
            ExecutableElement old = map.put(name, method);
            if (old == null) continue;
            ArrayList<ExecutableElement> contexts = new ArrayList<ExecutableElement>(Arrays.asList(method));
            if (reportedDups.add(name)) {
                contexts.add(old);
            }
            for (ExecutableElement context : contexts) {
                this.errorReporter.reportError(context, "[%sDupProperty] More than one @%s property called %s", this.simpleAnnotationName, this.simpleAnnotationName, name);
            }
        }
        return ImmutableBiMap.copyOf(map);
    }

    private static boolean gettersAllPrefixed(Set<ExecutableElement> methods) {
        return AutoValueishProcessor.prefixedGettersIn(methods).size() == methods.size();
    }

    static Optional<String> nullableAnnotationFor(Element element, TypeMirror elementType) {
        if (AutoValueishProcessor.isNullable(elementType)) {
            return Optional.of("");
        }
        List<? extends AnnotationMirror> elementAnnotations = element.getAnnotationMirrors();
        OptionalInt nullableAnnotationIndex = AutoValueishProcessor.nullableAnnotationIndex(elementAnnotations);
        if (nullableAnnotationIndex.isPresent()) {
            AnnotationMirror annotation = elementAnnotations.get(nullableAnnotationIndex.getAsInt());
            String annotationString = AnnotationOutput.sourceFormForAnnotation(annotation);
            return Optional.of(annotationString + " ");
        }
        return Optional.empty();
    }

    private static OptionalInt nullableAnnotationIndex(List<? extends AnnotationMirror> annotations) {
        return IntStream.range(0, annotations.size()).filter(i -> AutoValueishProcessor.isNullable((AnnotationMirror)annotations.get(i))).findFirst();
    }

    private static boolean isNullable(TypeMirror type) {
        return AutoValueishProcessor.isNullable(type, 0);
    }

    private static boolean isNullable(TypeMirror type, int depth) {
        if (depth > 10) {
            return false;
        }
        List<? extends AnnotationMirror> typeAnnotations = type.getAnnotationMirrors();
        if (AutoValueishProcessor.nullableAnnotationIndex(typeAnnotations).isPresent()) {
            return true;
        }
        if (type.getKind().equals((Object)TypeKind.TYPEVAR)) {
            TypeVariable typeVariable = MoreTypes.asTypeVariable(type);
            TypeMirror bound = typeVariable.getUpperBound();
            if (bound.getKind().equals((Object)TypeKind.INTERSECTION)) {
                return MoreTypes.asIntersection(bound).getBounds().stream().allMatch(t -> AutoValueishProcessor.isNullable(t, depth + 1));
            }
            return AutoValueishProcessor.isNullable(bound, depth + 1);
        }
        return false;
    }

    private static boolean isNullable(AnnotationMirror annotation) {
        return annotation.getAnnotationType().asElement().getSimpleName().contentEquals("Nullable");
    }

    static ImmutableSet<ExecutableElement> prefixedGettersIn(Collection<ExecutableElement> methods) {
        return methods.stream().filter(AutoValueishProcessor::isPrefixedGetter).collect(MoreStreams.toImmutableSet());
    }

    static boolean isPrefixedGetter(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return name.startsWith("get") && !name.equals("get") || name.startsWith("is") && !name.equals("is") && method.getReturnType().getKind() == TypeKind.BOOLEAN;
    }

    static String nameWithoutPrefix(String name) {
        if (name.startsWith("get")) {
            name = name.substring(3);
        } else {
            assert (name.startsWith("is"));
            name = name.substring(2);
        }
        return PropertyNames.decapitalizeLikeJavaBeans(name);
    }

    final void checkModifiersIfNested(TypeElement type) {
        this.checkModifiersIfNested(type, type, this.simpleAnnotationName);
    }

    final void checkModifiersIfNested(TypeElement type, TypeElement reportedType, String what) {
        ElementKind enclosingKind = type.getEnclosingElement().getKind();
        if (enclosingKind.isClass() || enclosingKind.isInterface()) {
            if (type.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.errorReporter.abortWithError(reportedType, "[%sPrivate] @%s class must not be private", this.simpleAnnotationName, what);
            } else if (Visibility.effectiveVisibilityOfElement(type).equals((Object)Visibility.PRIVATE)) {
                this.errorReporter.abortWithError(reportedType, "[%sInPrivate] @%s class must not be nested in a private class", this.simpleAnnotationName, what);
            }
            if (!type.getModifiers().contains((Object)Modifier.STATIC)) {
                this.errorReporter.abortWithError(reportedType, "[%sInner] Nested @%s class must be static", this.simpleAnnotationName, what);
            }
        }
    }

    static void fixReservedIdentifiers(Map<?, String> methodToIdentifier) {
        for (Map.Entry<?, String> entry : methodToIdentifier.entrySet()) {
            String name = entry.getValue();
            if (!SourceVersion.isKeyword(name) && Character.isJavaIdentifierStart(name.codePointAt(0))) continue;
            entry.setValue(AutoValueishProcessor.disambiguate(name, methodToIdentifier.values()));
        }
    }

    private static String disambiguate(String name, Collection<String> existingNames) {
        if (!Character.isJavaIdentifierStart(name.codePointAt(0)) && !existingNames.contains(name = "_" + name)) {
            return name;
        }
        int i = 0;
        String candidate;
        while (existingNames.contains(candidate = name + i)) {
            ++i;
        }
        return candidate;
    }

    private static Map<ObjectMethod, ExecutableElement> determineObjectMethodsToGenerate(Set<ExecutableElement> methods) {
        EnumMap<ObjectMethod, ExecutableElement> methodsToGenerate = new EnumMap<ObjectMethod, ExecutableElement>(ObjectMethod.class);
        for (ExecutableElement method : methods) {
            boolean canGenerate;
            ObjectMethod override = AutoValueishProcessor.objectMethodToOverride(method);
            boolean bl = canGenerate = method.getModifiers().contains((Object)Modifier.ABSTRACT) || AutoValueishProcessor.isJavaLangObject(MoreElements.asType(method.getEnclosingElement()));
            if (override.equals((Object)ObjectMethod.NONE) || !canGenerate) continue;
            methodsToGenerate.put(override, method);
        }
        return methodsToGenerate;
    }

    static String equalsParameterType(Map<ObjectMethod, ExecutableElement> methodsToGenerate, Nullables nullables) {
        ExecutableElement equals = methodsToGenerate.get((Object)ObjectMethod.EQUALS);
        if (equals == null) {
            return "";
        }
        TypeMirror parameterType = equals.getParameters().get(0).asType();
        ImmutableList<AnnotationMirror> extraAnnotations = AutoValueishProcessor.nullableAnnotationFor(equals, parameterType).isPresent() ? ImmutableList.of() : nullables.nullableTypeAnnotations();
        return TypeEncoder.encodeWithAnnotations(parameterType, extraAnnotations);
    }

    static ImmutableSet<ExecutableElement> abstractMethodsIn(Iterable<ExecutableElement> methods) {
        HashSet<Name> noArgMethods = new HashSet<Name>();
        ImmutableSet.Builder abstracts = ImmutableSet.builder();
        for (ExecutableElement method : methods) {
            boolean hasArgs;
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            MissingTypes.deferIfMissingTypesIn(method);
            boolean bl = hasArgs = !method.getParameters().isEmpty();
            if (!hasArgs && !noArgMethods.add(method.getSimpleName())) continue;
            abstracts.add(method);
        }
        return abstracts.build();
    }

    ImmutableMap<ExecutableElement, TypeMirror> propertyMethodsIn(Set<ExecutableElement> abstractMethods, TypeElement autoValueOrOneOfType) {
        DeclaredType declaredType = MoreTypes.asDeclared(autoValueOrOneOfType.asType());
        ImmutableSet.Builder properties = ImmutableSet.builder();
        for (ExecutableElement method : abstractMethods) {
            if (!method.getParameters().isEmpty() || method.getReturnType().getKind() == TypeKind.VOID && !this.propertiesCanBeVoid() || AutoValueishProcessor.objectMethodToOverride(method) != ObjectMethod.NONE) continue;
            properties.add(method);
        }
        return new EclipseHack(this.processingEnv).methodReturnTypes((Set<ExecutableElement>)((Object)properties.build()), declaredType);
    }

    boolean propertiesCanBeVoid() {
        return false;
    }

    final void checkReturnType(TypeElement autoValueClass, ExecutableElement getter) {
        TypeMirror type = getter.getReturnType();
        if (type.getKind() == TypeKind.ARRAY) {
            TypeMirror componentType = MoreTypes.asArray(type).getComponentType();
            if (componentType.getKind().isPrimitive()) {
                this.warnAboutPrimitiveArrays(autoValueClass, getter);
            } else {
                this.errorReporter.reportError(getter, "[AutoValueArray] An @%s class cannot define an array-valued property unless it is a primitive array", this.simpleAnnotationName);
            }
        }
    }

    private void warnAboutPrimitiveArrays(TypeElement autoValueClass, ExecutableElement getter) {
        boolean suppressed = false;
        Optional<AnnotationMirror> maybeAnnotation = AutoValueishProcessor.getAnnotationMirror(getter, "java.lang.SuppressWarnings");
        if (maybeAnnotation.isPresent()) {
            AnnotationValue listValue = AnnotationMirrors.getAnnotationValue(maybeAnnotation.get(), "value");
            suppressed = listValue.accept(new ContainsMutableVisitor(), null);
        }
        if (!suppressed) {
            boolean sameClass = getter.getEnclosingElement().equals(autoValueClass);
            Parameterizable element = sameClass ? getter : autoValueClass;
            String context = sameClass ? "" : " Method: " + getter.getEnclosingElement() + "." + getter;
            this.errorReporter.reportWarning(element, "[AutoValueMutable] An @%s property that is a primitive array returns the original array, which can therefore be modified by the caller. If this is OK, you can suppress this warning with @SuppressWarnings(\"mutable\"). Otherwise, you should replace the property with an immutable type, perhaps a simple wrapper around the original array.%s", this.simpleAnnotationName, context);
        }
    }

    final String getSerialVersionUID(TypeElement type) {
        TypeMirror serializable = this.elementUtils().getTypeElement(Serializable.class.getName()).asType();
        if (this.typeUtils().isAssignable(type.asType(), serializable)) {
            List<VariableElement> fields = ElementFilter.fieldsIn(type.getEnclosedElements());
            for (VariableElement field : fields) {
                if (!field.getSimpleName().contentEquals("serialVersionUID")) continue;
                Object value = field.getConstantValue();
                if (field.getModifiers().containsAll(Arrays.asList(Modifier.STATIC, Modifier.FINAL)) && field.asType().getKind() == TypeKind.LONG && value != null) {
                    return "private static final long serialVersionUID = " + value + "L;";
                }
                this.errorReporter.reportError(field, "serialVersionUID must be a static final long compile-time constant", new Object[0]);
                break;
            }
        }
        return "";
    }

    static ImmutableList<AnnotationMirror> annotationsToCopy(Element autoValueType, Element typeOrMethod, Set<String> excludedAnnotations, Types typeUtils) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : typeOrMethod.getAnnotationMirrors()) {
            String annotationFqName = AutoValueishProcessor.getAnnotationFqName(annotationMirror);
            if (AutoValueishProcessor.isInAutoValuePackage(annotationFqName) || excludedAnnotations.contains(annotationFqName) || !AutoValueishProcessor.annotationVisibleFrom(annotationMirror, autoValueType, typeUtils)) continue;
            result.add(annotationMirror);
        }
        return result.build();
    }

    private static boolean isInAutoValuePackage(String className) {
        return className.startsWith("com.google.auto.value.") && !className.contains("Test");
    }

    ImmutableList<String> copiedClassAnnotations(TypeElement type) {
        if (AutoValueishProcessor.hasAnnotationMirror(type, "com.google.auto.value.AutoValue.CopyAnnotations")) {
            ImmutableCollection excludedAnnotations = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(AutoValueishProcessor.getExcludedAnnotationClassNames(type))).addAll(AutoValueishProcessor.getAnnotationsMarkedWithInherited(type))).add(ClassNames.KOTLIN_METADATA_NAME)).build();
            return this.copyAnnotations(type, type, (Set<String>)((Object)excludedAnnotations));
        }
        return ImmutableList.of();
    }

    ImmutableList<String> copyAnnotations(Element autoValueType, Element typeOrMethod, Set<String> excludedAnnotations) {
        ImmutableList<AnnotationMirror> annotationsToCopy = AutoValueishProcessor.annotationsToCopy(autoValueType, typeOrMethod, excludedAnnotations, this.typeUtils());
        return AutoValueishProcessor.annotationStrings(annotationsToCopy);
    }

    private static Set<TypeMirror> getExcludedAnnotationTypes(Element element) {
        Optional<AnnotationMirror> maybeAnnotation = AutoValueishProcessor.getAnnotationMirror(element, "com.google.auto.value.AutoValue.CopyAnnotations");
        if (!maybeAnnotation.isPresent()) {
            return ImmutableSet.of();
        }
        List excludedClasses = (List)AnnotationMirrors.getAnnotationValue(maybeAnnotation.get(), "exclude").getValue();
        return excludedClasses.stream().map(annotationValue -> (DeclaredType)annotationValue.getValue()).collect(Collectors.toCollection(TypeMirrorSet::new));
    }

    static Set<String> getExcludedAnnotationClassNames(Element element) {
        return AutoValueishProcessor.getExcludedAnnotationTypes(element).stream().map(MoreTypes::asTypeElement).map(typeElement -> typeElement.getQualifiedName().toString()).collect(Collectors.toSet());
    }

    static Set<String> getAnnotationsMarkedWithInherited(Element element) {
        return element.getAnnotationMirrors().stream().filter(a -> MoreElements.isAnnotationPresent(a.getAnnotationType().asElement(), Inherited.class)).map(a -> AutoValueishProcessor.getAnnotationFqName(a)).collect(Collectors.toSet());
    }

    private static String getAnnotationFqName(AnnotationMirror annotation) {
        return ((QualifiedNameable)annotation.getAnnotationType().asElement()).getQualifiedName().toString();
    }

    static ImmutableListMultimap<ExecutableElement, AnnotationMirror> propertyMethodAnnotationMap(TypeElement type, ImmutableSet<ExecutableElement> propertyMethods, Types typeUtils) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (ExecutableElement propertyMethod : propertyMethods) {
            builder.putAll((Object)propertyMethod, AutoValueishProcessor.propertyMethodAnnotations(type, propertyMethod, typeUtils));
        }
        return builder.build();
    }

    static ImmutableList<AnnotationMirror> propertyMethodAnnotations(TypeElement type, ExecutableElement method, Types typeUtils) {
        ImmutableCollection excludedAnnotations = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(AutoValueishProcessor.getExcludedAnnotationClassNames(method))).add(Override.class.getCanonicalName())).build();
        Set<String> returnTypeAnnotations = AutoValueishProcessor.getReturnTypeAnnotations(method, a -> true);
        Sets.SetView<String> excluded = Sets.union(excludedAnnotations, returnTypeAnnotations);
        return AutoValueishProcessor.annotationsToCopy(type, method, excluded, typeUtils);
    }

    final ImmutableListMultimap<ExecutableElement, AnnotationMirror> propertyFieldAnnotationMap(TypeElement type, ImmutableSet<ExecutableElement> propertyMethods) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (ExecutableElement propertyMethod : propertyMethods) {
            builder.putAll((Object)propertyMethod, this.propertyFieldAnnotations(type, propertyMethod));
        }
        return builder.build();
    }

    private ImmutableList<AnnotationMirror> propertyFieldAnnotations(TypeElement type, ExecutableElement method) {
        if (!AutoValueishProcessor.hasAnnotationMirror(method, "com.google.auto.value.AutoValue.CopyAnnotations")) {
            return ImmutableList.of();
        }
        ImmutableCollection excludedAnnotations = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(AutoValueishProcessor.getExcludedAnnotationClassNames(method))).add(Override.class.getCanonicalName())).build();
        Set<String> returnTypeAnnotations = AutoValueishProcessor.getReturnTypeAnnotations(method, this::annotationAppliesToFields);
        Set nonFieldAnnotations = method.getAnnotationMirrors().stream().map(a -> a.getAnnotationType().asElement()).map(MoreElements::asType).filter(a -> !this.annotationAppliesToFields((TypeElement)a)).map(e -> e.getQualifiedName().toString()).collect(Collectors.toSet());
        ImmutableCollection excluded = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)excludedAnnotations)).addAll(returnTypeAnnotations)).addAll((Iterable)nonFieldAnnotations)).build();
        return AutoValueishProcessor.annotationsToCopy(type, method, (Set<String>)((Object)excluded), this.typeUtils());
    }

    private static Set<String> getReturnTypeAnnotations(ExecutableElement method, Predicate<TypeElement> typeFilter) {
        return method.getReturnType().getAnnotationMirrors().stream().map(a -> a.getAnnotationType().asElement()).map(MoreElements::asType).filter(typeFilter).map(e -> e.getQualifiedName().toString()).collect(Collectors.toSet());
    }

    private boolean annotationAppliesToFields(TypeElement annotation) {
        Target target = annotation.getAnnotation(Target.class);
        return target == null || Arrays.asList(target.value()).contains((Object)ElementType.FIELD);
    }

    private static boolean annotationVisibleFrom(AnnotationMirror annotation, Element from, Types typeUtils) {
        Element annotationElement = annotation.getAnnotationType().asElement();
        Visibility visibility = Visibility.effectiveVisibilityOfElement(annotationElement);
        switch (visibility) {
            case PUBLIC: {
                return true;
            }
            case PROTECTED: {
                return MoreElements.getPackage(annotationElement).equals(MoreElements.getPackage(from)) || typeUtils.isSubtype(from.asType(), annotationElement.getEnclosingElement().asType());
            }
            case DEFAULT: {
                return MoreElements.getPackage(annotationElement).equals(MoreElements.getPackage(from));
            }
        }
        return false;
    }

    private static String wildcardTypeParametersString(TypeElement type) {
        List<? extends TypeParameterElement> typeParameters = type.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return "";
        }
        return typeParameters.stream().map(e -> "?").collect(Collectors.joining(", ", "<", ">"));
    }

    static Optional<AnnotationMirror> getAnnotationMirror(Element element, String annotationName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationElement = MoreTypes.asTypeElement(annotationMirror.getAnnotationType());
            if (!annotationElement.getQualifiedName().contentEquals(annotationName)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.empty();
    }

    static boolean hasAnnotationMirror(Element element, String annotationName) {
        return AutoValueishProcessor.getAnnotationMirror(element, annotationName).isPresent();
    }

    static boolean hasVisibleNoArgConstructor(TypeElement type) {
        return type.getKind().isInterface() || ElementFilter.constructorsIn(type.getEnclosedElements()).stream().anyMatch(c -> c.getParameters().isEmpty() && !c.getModifiers().contains((Object)Modifier.PRIVATE));
    }

    final void writeSourceFile(String className, String text, TypeElement originatingType) {
        try {
            JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(className, originatingType);
            try (Writer writer = sourceFile.openWriter();){
                writer.write(text);
            }
        }
        catch (IOException e) {
            this.errorReporter.reportWarning(originatingType, "[AutoValueCouldNotWrite] Could not write generated class %s: %s", className, e);
        }
    }

    private /* synthetic */ void lambda$propertySet$2(ImmutableBiMap methodToPropertyName, Map methodToIdentifier, ImmutableListMultimap annotatedPropertyFields, ImmutableListMultimap annotatedPropertyMethods, Nullables nullables, ImmutableSet.Builder props, ExecutableElement propertyMethod, TypeMirror returnType) {
        String propertyTypeString = TypeEncoder.encodeWithAnnotations(returnType, ImmutableList.of(), AutoValueishProcessor.getExcludedAnnotationTypes(propertyMethod));
        String propertyName = (String)methodToPropertyName.get(propertyMethod);
        String identifier = (String)methodToIdentifier.get(propertyMethod);
        ImmutableList<String> fieldAnnotations = AutoValueishProcessor.annotationStrings((List<? extends AnnotationMirror>)((Object)annotatedPropertyFields.get(propertyMethod)));
        ImmutableCollection methodAnnotationMirrors = annotatedPropertyMethods.get(propertyMethod);
        ImmutableList<String> methodAnnotations = AutoValueishProcessor.annotationStrings((List<? extends AnnotationMirror>)((Object)methodAnnotationMirrors));
        Optional<String> nullableAnnotation = this.nullableAnnotationForMethod(propertyMethod);
        GetterProperty p = new GetterProperty(propertyName, identifier, propertyMethod, returnType, propertyTypeString, fieldAnnotations, methodAnnotations, nullableAnnotation, nullables);
        props.add(p);
        if (p.isNullable() && returnType.getKind().isPrimitive()) {
            this.errorReporter().reportError(propertyMethod, "[%sNullPrimitive] Primitive types cannot be @Nullable", this.simpleAnnotationName);
        }
    }

    private static class ContainsMutableVisitor
    extends SimpleAnnotationValueVisitor8<Boolean, Void> {
        private ContainsMutableVisitor() {
        }

        @Override
        public Boolean visitArray(List<? extends AnnotationValue> list, Void p) {
            return list.stream().map(AnnotationValue::getValue).anyMatch("mutable"::equals);
        }
    }

    static enum ObjectMethod {
        NONE,
        TO_STRING,
        EQUALS,
        HASH_CODE;

    }

    public static class GetterProperty
    extends Property {
        private final ExecutableElement method;
        private final ImmutableList<String> fieldAnnotations;
        private final ImmutableList<String> methodAnnotations;

        GetterProperty(String name, String identifier, ExecutableElement method, TypeMirror typeMirror, String typeString, ImmutableList<String> fieldAnnotations, ImmutableList<String> methodAnnotations, Optional<String> nullableAnnotation, Nullables nullables) {
            super(name, identifier, typeString, typeMirror, nullableAnnotation, nullables, method.getSimpleName().toString(), Optional.empty(), false);
            this.method = method;
            this.fieldAnnotations = fieldAnnotations;
            this.methodAnnotations = methodAnnotations;
        }

        public List<String> getFieldAnnotations() {
            return this.fieldAnnotations;
        }

        public List<String> getMethodAnnotations() {
            return this.methodAnnotations;
        }

        public String getAccess() {
            return SimpleMethod.access(this.method);
        }

        public boolean equals(Object obj) {
            return obj instanceof GetterProperty && ((GetterProperty)obj).method.equals(this.method);
        }

        public int hashCode() {
            return this.method.hashCode();
        }
    }

    public static class Property {
        private final String name;
        private final String identifier;
        private final String type;
        private final TypeMirror typeMirror;
        private final Optional<String> nullableAnnotation;
        private final ImmutableList<AnnotationMirror> availableNullableTypeAnnotations;
        private final Optionalish optional;
        private final String getter;
        private final String builderInitializer;
        private final boolean hasDefault;

        Property(String name, String identifier, String type, TypeMirror typeMirror, Optional<String> nullableAnnotation, Nullables nullables, String getter, Optional<String> maybeBuilderInitializer, boolean hasDefault) {
            this.name = name;
            this.identifier = identifier;
            this.type = type;
            this.typeMirror = typeMirror;
            this.nullableAnnotation = nullableAnnotation;
            this.availableNullableTypeAnnotations = nullables.nullableTypeAnnotations();
            this.optional = Optionalish.createIfOptional(typeMirror);
            this.builderInitializer = maybeBuilderInitializer.isPresent() ? " = " + maybeBuilderInitializer.get() : Property.builderInitializer(typeMirror, nullableAnnotation);
            this.getter = getter;
            this.hasDefault = hasDefault;
        }

        private static String builderInitializer(TypeMirror typeMirror, Optional<String> nullableAnnotation) {
            if (nullableAnnotation.isPresent()) {
                return "";
            }
            Optionalish optional = Optionalish.createIfOptional(typeMirror);
            if (optional == null) {
                return "";
            }
            return " = " + optional.getEmpty();
        }

        public String getBuilderFieldType() {
            if (this.typeMirror.getKind().isPrimitive() || this.nullableAnnotation.isPresent() || !this.builderInitializer.isEmpty() || this.availableNullableTypeAnnotations.isEmpty()) {
                return this.type;
            }
            return TypeEncoder.encodeWithAnnotations(this.typeMirror, this.availableNullableTypeAnnotations);
        }

        public String toString() {
            return this.identifier;
        }

        public String getName() {
            return this.name;
        }

        TypeMirror getTypeMirror() {
            return this.typeMirror;
        }

        public String getType() {
            return this.type;
        }

        public TypeKind getKind() {
            return this.typeMirror.getKind();
        }

        public Optionalish getOptional() {
            return this.optional;
        }

        public String getBuilderInitializer() {
            return this.builderInitializer;
        }

        public final String getNullableAnnotation() {
            return this.nullableAnnotation.orElse("");
        }

        public boolean isNullable() {
            return this.nullableAnnotation.isPresent();
        }

        public String getGetter() {
            return this.getter;
        }

        boolean hasDefault() {
            return this.hasDefault;
        }
    }
}

