/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.sap;

import com.indy.engine.addons.sap.Messages;
import com.indy.engine.addons.sap.utils.JCOProvider;
import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocXMLProcessor;
import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.idoc.jco.JCoIDocHandler;
import com.sap.conn.idoc.jco.JCoIDocHandlerFactory;
import com.sap.conn.idoc.jco.JCoIDocServer;
import com.sap.conn.idoc.jco.JCoIDocServerContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerContextInfo;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.server.JCoServerStateChangedListener;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class IDocConsumer {
    private int consume = 0;
    private int toConsume;
    private JCoIDocServer server;
    boolean enableConsumation = false;
    public static final int START_IDOC_LIST = 0;
    public static final int END_IDOC_LIST = 1;
    public static final int ERROR_IDOC_LIST = 2;
    Set<String> tids = new HashSet<String>();
    boolean refresh;
    long timeToStop;
    boolean stop = false;
    private String host;
    private String clientStr;
    private String system;
    private String user;
    private String password;
    private String language;
    private String unicode;
    private String gateway;
    private String progId;
    private File outDir;
    private String mask;
    private boolean traceServer = false;
    private boolean traceClient = false;
    String destinationId = UUID.randomUUID().toString();
    String serverId = UUID.randomUUID().toString();
    private String IDOCTYP = null;
    private String RCVPOR = null;
    private String RCVPRT = null;
    private String RCVPRN = null;
    private String DOCNUM = null;
    private String QUEUE = null;
    private String error;
    private Exception exception;
    private String encoding = "UTF-8";
    private long timeout;
    private String UPDDAT;
    private String UPDTIM;
    private String MESTYP;

    public void setEnableConsumation(boolean enableConsumation) {
        this.enableConsumation = enableConsumation;
    }

    public synchronized void activity() {
        if (this.timeout != -1L) {
            this.timeToStop = System.currentTimeMillis() + this.timeout;
        }
    }

    public synchronized void stop() {
        this.stop = true;
        this.notifyAll();
    }

    public IDocConsumer(String host, String clientStr, String system, String user, String password, String unicode, String gateway, String progId, File outDir, String mask) {
        this.host = host;
        this.clientStr = clientStr;
        this.system = system;
        this.user = user;
        this.password = password;
        this.language = "EN";
        this.unicode = unicode;
        this.gateway = gateway;
        this.progId = progId;
        this.outDir = outDir;
        this.mask = mask;
    }

    public void setIDOCTYP(String iDOCTYP) {
        this.IDOCTYP = iDOCTYP;
    }

    public void setRCVPOR(String rCVPOR) {
        this.RCVPOR = rCVPOR;
    }

    public void setRCVPRT(String rCVPRT) {
        this.RCVPRT = rCVPRT;
    }

    public void setRCVPRN(String rCVPRN) {
        this.RCVPRN = rCVPRN;
    }

    public void setQUEUE(String qUEUE) {
        this.QUEUE = qUEUE;
    }

    public void setDOCNUM(String dOCNUM) {
        this.DOCNUM = dOCNUM;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public static void main(String[] argv) throws Exception {
        IDocConsumer idocc = new IDocConsumer("gcecc62", "800", "00", "sapuser", "india123", "1", "3300", "IDOCTEST", new File("d:/temp/sap"), "*.xml"){

            @Override
            public void handleRequest(JCoServerContext serverCtx, IDocDocumentList idocList, int status, Throwable thr) {
            }
        };
        idocc.setRCVPOR("JAVIDOC");
        idocc.setRCVPRT("LS");
        idocc.setIDOCTYP("ORDERS05");
        idocc.start();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public synchronized void start() throws Exception {
        try {
            this.error = null;
            Properties properties = new Properties();
            properties.setProperty("jco.client.ashost", this.host);
            properties.setProperty("jco.client.sysnr", this.system);
            properties.setProperty("jco.client.client", this.clientStr);
            properties.setProperty("jco.client.user", this.user);
            properties.setProperty("jco.client.passwd", this.password);
            properties.setProperty("jco.client.lang", this.language);
            properties.setProperty("jco.destination.repository_destination", this.destinationId);
            if (this.traceClient) {
                properties.setProperty("jco.client.trace", "1");
            }
            JCOProvider.getInstance().addDestinationProperties(this.destinationId, properties);
            properties = new Properties();
            properties.setProperty("jco.server.gwhost", this.host);
            properties.setProperty("jco.server.gwserv", this.gateway);
            properties.setProperty("jco.server.progid", this.progId);
            properties.setProperty("jco.server.repository_destination", this.destinationId);
            properties.setProperty("jco.server.connection_count", "1");
            properties.setProperty("jco.server.unicode", this.unicode);
            if (this.traceServer) {
                properties.setProperty("jco.server.trace", "1");
            }
            JCOProvider.getInstance().addServerProperties(this.serverId, properties);
            this.server = JCoIDoc.getServer((String)this.serverId);
            this.server.setIDocHandlerFactory((JCoIDocHandlerFactory)new MyIDocHandlerFactory());
            this.server.setTIDHandler((JCoServerTIDHandler)new MyTidHandler());
            MyThrowableListener listener = new MyThrowableListener();
            this.server.addServerErrorListener((JCoServerErrorListener)listener);
            this.server.addServerExceptionListener((JCoServerExceptionListener)listener);
            this.server.addServerStateChangedListener((JCoServerStateChangedListener)new MyJCoServerStateChangedListener());
            this.server.setConnectionCount(1);
            this.server.start();
            try {
                long t = this.timeout;
                do {
                    if (this.timeout != -1L) {
                        this.wait(t);
                        t = System.currentTimeMillis() - this.timeToStop;
                        continue;
                    }
                    this.wait();
                } while ((this.timeout == -1L || t > 0L) && !this.stop);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.server.getState() != JCoServerState.STOPPED) {
                this.server.stop();
                while (this.server.getState() != JCoServerState.STOPPED) {
                    this.wait(100L);
                }
            }
            if (this.error != null) {
                throw new EngineExceptionI(String.valueOf(Messages.getString("IDocConsumer.4")) + this.error);
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
        finally {
            JCOProvider.getInstance().removeDestinationProperties(this.destinationId);
            JCOProvider.getInstance().removeServerProperties(this.serverId);
        }
    }

    public void setTraceServer(boolean traceServer) {
        this.traceServer = traceServer;
    }

    public void setTraceClient(boolean traceClient) {
        this.traceClient = traceClient;
    }

    public abstract void handleRequest(JCoServerContext var1, IDocDocumentList var2, int var3, Throwable var4);

    private void addParam(JCoTable table, String name, String value, boolean lowandhigh, boolean isChar) throws Exception {
        if (value != null && !value.isEmpty()) {
            table.appendRow();
            if (lowandhigh) {
                if (value.toUpperCase().contains(" BETWEEN ")) {
                    table.setValue("LINE", "WITH " + name + " " + value);
                } else {
                    String val = isChar ? "'" + value + "'" : value;
                    table.setValue("LINE", "WITH " + name + " BETWEEN " + val + " AND " + val);
                }
            } else {
                String val = isChar ? "'" + value + "'" : value;
                table.setValue("LINE", "WITH " + name + " = " + val);
            }
        }
    }

    private void triggerCosumation() {
        block12: {
            if (this.enableConsumation) {
                try {
                    JCoDestination destination = JCoDestinationManager.getDestination((String)this.destinationId);
                    JCoFunction function = destination.getRepository().getFunction("RFC_ABAP_INSTALL_AND_RUN");
                    if (function == null) {
                        throw new RuntimeException("RFC_ABAP_INSTALL_AND_RUN not found in SAP.");
                    }
                    JCoTable table = function.getTableParameterList().getTable("PROGRAM");
                    table.appendRow();
                    table.setValue("LINE", "REPORT Z" + UUID.randomUUID().toString() + ".");
                    table.appendRow();
                    table.setValue("LINE", "SUBMIT RSEOUT00 EXPORTING LIST TO MEMORY");
                    this.addParam(table, "P_IDOCTP", this.IDOCTYP, false, true);
                    this.addParam(table, "P_RCVPOR", this.RCVPOR, false, true);
                    this.addParam(table, "P_RCVPRT", this.RCVPRT, false, true);
                    this.addParam(table, "P_QUEUE", this.QUEUE, false, true);
                    this.addParam(table, "DOCNUM", this.DOCNUM, true, false);
                    this.addParam(table, "RCVPRN", this.RCVPRN, true, true);
                    this.addParam(table, "UPDDAT", this.UPDDAT, true, true);
                    this.addParam(table, "UPDTIM", this.UPDTIM, true, true);
                    this.addParam(table, "MESTYP", this.MESTYP, true, true);
                    table.appendRow();
                    table.setValue("LINE", "AND RETURN.");
                    int i = 0;
                    while (i < table.getNumRows()) {
                        table.setRow(i);
                        System.out.println(table.getValue(0));
                        ++i;
                    }
                    function.execute(destination);
                    this.error = function.getExportParameterList().getString("ERRORMESSAGE");
                    if (this.error.length() > 0) {
                        this.stop();
                    }
                }
                catch (Exception e) {
                    String str = e.getMessage();
                    if (str != null) {
                        if (str.contains(Messages.getString("IDocConsumer.5"))) {
                            System.out.println(Messages.getString("IDocConsumer.6"));
                        } else {
                            Pattern pDeb2 = Pattern.compile("[ ]*'([0-9,\\.]+)' IDocs selected[ ]*");
                            Matcher mDeb2 = pDeb2.matcher(str);
                            mDeb2.find();
                            if (mDeb2.matches()) {
                                this.toConsume = Integer.valueOf(mDeb2.group(1).replace(".", "").replace(",", ""));
                                System.out.println(String.valueOf(mDeb2.group(1)) + " IDocs selected");
                            } else {
                                this.exception = e;
                            }
                        }
                    } else {
                        this.exception = e;
                    }
                    if (this.toConsume != 0) break block12;
                    this.server.stop();
                }
            }
        }
    }

    private void receive(JCoServerContext serverCtx, IDocDocumentList idocList) {
        block19: {
            this.consume += idocList.size();
            this.handleRequest(serverCtx, idocList, 0, null);
            int i = 0;
            while (i < idocList.size()) {
                IDocDocument doc = idocList.get(i);
                System.out.println("Receive Idoc:+" + doc.getIDocNumber());
                ++i;
            }
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            try {
                try {
                    IDocXMLProcessor xmlProcessor = JCoIDoc.getIDocFactory().getIDocXMLProcessor();
                    String fileName = null;
                    fileName = this.mask != null ? this.mask.replace("*", serverCtx.getTID()) : String.valueOf(idocList.getIDocType()) + "_" + serverCtx.getTID() + ".xml";
                    fos = this.outDir != null ? new FileOutputStream(String.valueOf(this.outDir.getAbsolutePath()) + File.separator + fileName) : new FileOutputStream(fileName);
                    osw = new OutputStreamWriter((OutputStream)fos, this.encoding);
                    xmlProcessor.render(idocList, (Writer)osw);
                    osw.flush();
                    this.handleRequest(serverCtx, idocList, 1, null);
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                    this.handleRequest(serverCtx, idocList, 2, thr);
                    this.stop();
                    try {
                        if (osw != null) {
                            osw.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        break block19;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (osw != null) {
                        osw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (osw != null) {
                    osw.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.tids.size() == 0 && this.consume == this.toConsume) {
            this.stop();
        }
    }

    class MyIDocHandler
    implements JCoIDocHandler {
        MyIDocHandler() {
        }

        public void handleRequest(JCoServerContext serverCtx, IDocDocumentList idocList) {
            IDocConsumer.this.activity();
            IDocConsumer.this.receive(serverCtx, idocList);
        }
    }

    class MyIDocHandlerFactory
    implements JCoIDocHandlerFactory {
        private JCoIDocHandler handler;

        MyIDocHandlerFactory() {
            this.handler = new MyIDocHandler();
        }

        public JCoIDocHandler getIDocHandler(JCoIDocServerContext serverCtx) {
            return this.handler;
        }
    }

    class MyJCoServerStateChangedListener
    implements JCoServerStateChangedListener {
        MyJCoServerStateChangedListener() {
        }

        public void serverStateChangeOccurred(JCoServer arg0, JCoServerState arg1, JCoServerState arg2) {
            IDocConsumer.this.activity();
            System.out.println(arg2.toString());
            if (arg2 == JCoServerState.STOPPED) {
                IDocConsumer.this.stop();
            }
            if (arg2 == JCoServerState.ALIVE) {
                IDocConsumer.this.triggerCosumation();
            }
        }
    }

    class MyThrowableListener
    implements JCoServerErrorListener,
    JCoServerExceptionListener {
        MyThrowableListener() {
        }

        public void serverErrorOccurred(JCoServer server, String connectionId, JCoServerContextInfo ctx, Error error) {
            System.out.println(String.valueOf(Messages.getString("IDocConsumer.0")) + server.getProgramID() + Messages.getString("IDocConsumer.1") + connectionId);
            error.printStackTrace();
        }

        public void serverExceptionOccurred(JCoServer server, String connectionId, JCoServerContextInfo ctx, Exception error) {
            System.out.println(String.valueOf(Messages.getString("IDocConsumer.2")) + server.getProgramID() + Messages.getString("IDocConsumer.3") + connectionId);
            error.printStackTrace();
        }
    }

    class MyTidHandler
    implements JCoServerTIDHandler {
        MyTidHandler() {
        }

        public boolean checkTID(JCoServerContext serverCtx, String tid) {
            IDocConsumer.this.activity();
            System.out.println("checkTID called for TID=" + tid);
            IDocConsumer.this.tids.add(tid);
            return true;
        }

        public void confirmTID(JCoServerContext serverCtx, String tid) {
            IDocConsumer.this.activity();
            System.out.println("confirmTID called for TID=" + tid);
            IDocConsumer.this.tids.remove(tid);
            if (IDocConsumer.this.tids.size() == 0 && IDocConsumer.this.consume == IDocConsumer.this.toConsume) {
                IDocConsumer.this.stop();
            }
        }

        public void commit(JCoServerContext serverCtx, String tid) {
            IDocConsumer.this.activity();
            System.out.println("commit called for TID=" + tid);
        }

        public void rollback(JCoServerContext serverCtx, String tid) {
            IDocConsumer.this.activity();
            System.out.print("rollback called for TID=" + tid);
        }
    }
}

