/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.sap;

import com.indy.engine.addons.sap.Messages;
import com.indy.engine.addons.sap.SapAbstractActionCodeI;
import com.indy.engine.addons.sap.utils.JCOProvider;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoTable;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.UUID;

public class SapAbapExecuteActionCodeI
extends SapAbstractActionCodeI {
    private String programName;
    boolean commit = true;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private JCoDestination destination;
    String destinationId = UUID.randomUUID().toString();

    public SapAbapExecuteActionCodeI() {
        super("Sap With Rfc", true);
    }

    @Override
    public int prepare(ResultSet sourceRSet) throws EngineExceptionI {
        super.prepare(sourceRSet);
        this.programName = this.getLocalStringBindedParameter(sourceRSet, "SAP_PROGRAM_NAME", null);
        this.commit = this.getLocalBooleanBindedParameter(sourceRSet, "SAP_COMMIT", false);
        return 0;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        try {
            try {
                String error;
                String programString = this.actionTxtCode;
                this.destination = SapAbapExecuteActionCodeI.connect(this, this.destinationId);
                JCoFunctionTemplate tpl = this.destination.getRepository().getFunctionTemplate("RFC_ABAP_INSTALL_AND_RUN");
                JCoFunction function = tpl.getFunction();
                JCoTable program = function.getTableParameterList().getTable("PROGRAM");
                String[] stringArray = programString.split("\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    program.appendRow();
                    program.setValue("LINE", line);
                    ++n2;
                }
                function.getImportParameterList().setValue("MODE", "F");
                if (this.programName != null) {
                    function.getImportParameterList().setValue("PROGRAMNAME", this.programName);
                }
                JCoContext.begin((JCoDestination)this.destination);
                function.execute(this.destination);
                if (this.commit) {
                    JCoFunction _function = this.destination.getRepository().getFunctionTemplate("BAPI_TRANSACTION_COMMIT").getFunction();
                    _function.execute(this.destination);
                }
                JCoContext.end((JCoDestination)this.destination);
                JCoTable writes = function.getTableParameterList().getTable("WRITES");
                if (writes.getNumRows() > 0) {
                    int i = 0;
                    while (i < writes.getNumRows()) {
                        writes.setRow(i);
                        ++i;
                    }
                }
                if ((error = function.getExportParameterList().getString("ERRORMESSAGE")) != null && !error.isEmpty()) {
                    throw new EngineExceptionI(String.valueOf(Messages.getString("SapAbapExecuteActionCodeI.0")) + error);
                }
            }
            catch (Throwable e) {
                if (e instanceof EngineExceptionI) {
                    throw (EngineExceptionI)e;
                }
                throw new EngineExceptionI(e);
            }
        }
        finally {
            try {
                JCOProvider.getInstance().removeDestinationProperties(this.destinationId);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        int ret = 0;
        return ret;
    }
}

