/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.sap;

import com.indy.engine.actionCodes.utils.Constant;
import com.indy.engine.addons.sap.IDocConsumer;
import com.indy.engine.addons.sap.Messages;
import com.indy.engine.addons.sap.SapAbstractActionCodeI;
import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.jco.server.JCoServerContext;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;

public class SapIdocConsumeActionCodeI
extends SapAbstractActionCodeI {
    private String gateway;
    private String unicode;
    private String progId;
    private IDocConsumer consumer;
    private File outDir;
    private String encoding;
    int nbIdoc = 0;
    private String mask;
    private String idoctyp;
    private String rcvpor;
    private String rcvprt;
    private Boolean cleanDir;
    private String docnum;
    private String queueName;
    private Boolean enableConsummation;
    private Integer serverTimeout;
    private Boolean enableServerTrace;
    private Boolean enableClientTrace;
    private Integer number;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    public SapIdocConsumeActionCodeI() {
        super("Sap With Idoc", true);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        if (!this.outDir.exists()) {
            throw new EngineExceptionI(String.valueOf(Messages.getString("SapIdocConsumeActionCodeI.2")) + this.outDir.getName() + Messages.getString("SapIdocConsumeActionCodeI.3"));
        }
        if (this.cleanDir.booleanValue()) {
            File[] fileArray = this.outDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    file.delete();
                }
                ++n2;
            }
        }
        this.consumer = new IDocConsumer(this.getHost(), this.getClientStr(), this.getSystem(), this.getUser(), this.getPassword(), this.unicode, this.gateway, this.progId, this.outDir, this.mask){

            @Override
            public void handleRequest(JCoServerContext serverCtx, IDocDocumentList idocList, int status, Throwable thr) {
                switch (status) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        SapIdocConsumeActionCodeI.this.nbIdoc += idocList.size();
                        SapIdocConsumeActionCodeI.this.handleStatistic();
                        break;
                    }
                }
            }
        };
        this.consumer.setEncoding(this.encoding);
        this.consumer.setIDOCTYP(this.idoctyp);
        this.consumer.setRCVPOR(this.rcvpor);
        this.consumer.setRCVPRT(this.rcvprt);
        this.consumer.setDOCNUM(this.docnum);
        this.consumer.setQUEUE(this.queueName);
        this.consumer.setTimeout(this.serverTimeout.intValue());
        this.consumer.setEnableConsumation(this.enableConsummation);
        this.consumer.setTraceClient(this.enableClientTrace);
        this.consumer.setTraceServer(this.enableServerTrace);
        try {
            this.consumer.start();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new EngineExceptionI((Throwable)e);
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return 0;
    }

    private void handleStatistic() {
        this.publishVariable("SAP_NB_CONSUMED_IDOC", new Long(this.nbIdoc), "Long", false);
    }

    public int finalizeExecuteCode() throws EngineExceptionI {
        this.handleStatistic();
        return 0;
    }

    @Override
    public int prepare(ResultSet sourceRSet) throws EngineExceptionI {
        super.prepare(sourceRSet);
        this.gateway = this.getLocalStringBindedParameter(sourceRSet, "SAP_GATEWAY", null);
        if (this.gateway == null) {
            throw new EngineExceptionI(Messages.getString("SapIdocConsumeActionCodeI.4"));
        }
        this.unicode = this.getLocalStringBindedParameter(sourceRSet, "SAP_UNICODE", "1");
        this.progId = this.getLocalStringBindedParameter(sourceRSet, "SAP_PROG_ID", null);
        if (this.progId == null) {
            throw new EngineExceptionI(Messages.getString("SapIdocConsumeActionCodeI.5"));
        }
        this.encoding = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_ENCODING", "UTF-8");
        String _file = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_NAME");
        if (_file == null) {
            _file = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + Constant.VAR_CORE_TEMPORARY_FOLDER);
            this.outDir = new File(_file);
        } else {
            this.mask = new File(_file).getName();
            this.outDir = new File(_file).getParentFile();
        }
        if (!this.outDir.exists()) {
            this.outDir.mkdirs();
        }
        this.cleanDir = this.getLocalBooleanBindedParameter(sourceRSet, "SAP_CLEAN_DIR", false);
        this.idoctyp = this.getLocalStringBindedParameter(sourceRSet, "SAP_IDOCTYP", null);
        if (this.idoctyp == null) {
            throw new EngineExceptionI(Messages.getString("SapIdocConsumeActionCodeI.6"));
        }
        this.rcvpor = this.getLocalStringBindedParameter(sourceRSet, "SAP_RECEIVER_PORT", null);
        if (this.rcvpor == null) {
            throw new EngineExceptionI(Messages.getString("SapIdocConsumeActionCodeI.7"));
        }
        this.rcvprt = this.getLocalStringBindedParameter(sourceRSet, "SAP_RECEIVER_PARTNER_TYPE", null);
        if (this.rcvprt == null) {
            throw new EngineExceptionI(Messages.getString("SapIdocConsumeActionCodeI.8"));
        }
        this.docnum = this.getLocalStringBindedParameter(sourceRSet, "SAP_DOCNUM", null);
        this.queueName = this.getLocalStringBindedParameter(sourceRSet, "SAP_QUEUE", null);
        this.enableConsummation = this.getLocalBooleanBindedParameter(sourceRSet, "SAP_CONSUME", true);
        this.enableServerTrace = this.getLocalBooleanBindedParameter(sourceRSet, "SAP_SERVER_TRACE", false);
        this.enableClientTrace = this.getLocalBooleanBindedParameter(sourceRSet, "SAP_CLIENT_TRACE", false);
        this.serverTimeout = this.getLocalIntegerBindedParameter(sourceRSet, "SAP_SERVER_TIMEOUT", 10000);
        this.number = this.getLocalIntegerBindedParameter(sourceRSet, "SAP_IDOC_NUMBER", -1);
        return 0;
    }
}

