/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.sap;

import com.indy.engine.addons.sap.Messages;
import com.indy.engine.addons.sap.SapAbstractActionCodeI;
import com.indy.engine.addons.sap.utils.JCOProvider;
import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocFactory;
import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.IDocXMLProcessor;
import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.jco.JCoDestination;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.UUID;

public class SapIdocSenderActionCodeI
extends SapAbstractActionCodeI {
    String destinationId = UUID.randomUUID().toString();
    private JCoDestination destination;
    private IDocRepository iDocRepository;
    private String inFile;
    private boolean oneByOne = false;
    private String queueName = null;

    public SapIdocSenderActionCodeI() {
        super("Send Idoc", true);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        try {
            try {
                this.destination = SapIdocSenderActionCodeI.connect(this, this.destinationId);
                this.iDocRepository = JCoIDoc.getIDocRepository((JCoDestination)this.destination);
                IDocFactory iDocFactory = JCoIDoc.getIDocFactory();
                IDocXMLProcessor processor = iDocFactory.getIDocXMLProcessor();
                IDocDocumentList iDocList = processor.parse(this.iDocRepository, (InputStream)new FileInputStream(this.inFile));
                if (this.oneByOne) {
                    for (IDocDocument doc : iDocList) {
                        String tid = this.destination.createTID();
                        JCoIDoc.send((IDocDocument)doc, (char)'0', (JCoDestination)this.destination, (String)tid, (String)this.queueName);
                        this.destination.confirmTID(tid);
                    }
                } else {
                    String tid = this.destination.createTID();
                    JCoIDoc.send((IDocDocumentList)iDocList, (char)'0', (JCoDestination)this.destination, (String)tid, (String)this.queueName);
                    this.destination.confirmTID(tid);
                }
            }
            catch (EngineExceptionI e) {
                throw e;
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            JCOProvider.getInstance().removeDestinationProperties(this.destinationId);
            this.destination = null;
            this.iDocRepository = null;
        }
        return 0;
    }

    @Override
    public int prepare(ResultSet sourceRSet) throws EngineExceptionI {
        super.prepare(sourceRSet);
        this.inFile = this.getLocalStringBindedParameter(sourceRSet, "IN_FILE_NAME");
        if (this.inFile == null) {
            throw new EngineExceptionI(String.valueOf(Messages.getString("SapIdocSenderActionCodeI.2")) + "IN_FILE_NAME" + Messages.getString("SapIdocSenderActionCodeI.3"));
        }
        int commitNb = this.getLocalIntegerBindedParameter(sourceRSet, "SAP_IDOC_TRANSACTION_COMMIT_NB", -1);
        if (commitNb == -1) {
            this.oneByOne = false;
        } else if (commitNb == 1) {
            this.oneByOne = true;
        } else {
            throw new EngineExceptionI(String.valueOf(Messages.getString("SapIdocSenderActionCodeI.4")) + "SAP_IDOC_TRANSACTION_COMMIT_NB" + Messages.getString("SapIdocSenderActionCodeI.5"));
        }
        this.queueName = this.getLocalStringBindedParameter(sourceRSet, "SAP_RFC_QUEUE_NAME", null);
        return 0;
    }
}

