/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.sap.utils;

import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.ext.ServerDataEventListener;
import com.sap.conn.jco.ext.ServerDataProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class JCOProvider {
    static JCOProvider INSTANCE;
    Map<String, Properties> destination = new HashMap<String, Properties>();
    Map<String, Properties> server = new HashMap<String, Properties>();
    ServerDataEventListener serverListener;
    private DestinationDataEventListener destinationListener;

    static {
        try {
            INSTANCE = new JCOProvider();
            INSTANCE.new DestinationProvider().register();
            INSTANCE.new ServerProvider().register();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static JCOProvider getInstance() {
        return INSTANCE;
    }

    public synchronized void addDestinationProperties(String name, Properties properties) {
        if (this.destinationListener != null) {
            this.destinationListener.updated(name);
        }
        this.destination.put(name, properties);
    }

    public synchronized void removeDestinationProperties(String name) {
        if (this.destinationListener != null) {
            this.destinationListener.deleted(name);
        }
        this.destination.remove(name);
    }

    public synchronized void addServerProperties(String name, Properties properties) {
        if (this.serverListener != null) {
            this.serverListener.updated(name);
        }
        this.server.put(name, properties);
    }

    public synchronized void removeServerProperties(String name) {
        if (this.serverListener != null) {
            this.serverListener.deleted(name);
        }
        this.server.remove(name);
    }

    class DestinationProvider
    implements DestinationDataProvider {
        DestinationProvider() {
        }

        public Properties getDestinationProperties(String name) {
            return JCOProvider.this.destination.get(name);
        }

        public void setDestinationDataEventListener(DestinationDataEventListener _eventListener) {
            JCOProvider.this.destinationListener = _eventListener;
            for (String name : JCOProvider.this.destination.keySet()) {
                JCOProvider.this.destinationListener.updated(name);
            }
        }

        public boolean supportsEvents() {
            return true;
        }

        public void register() {
            if (Environment.isDestinationDataProviderRegistered()) {
                System.out.println("by who");
            }
            Environment.registerDestinationDataProvider((DestinationDataProvider)this);
        }

        public void unregister() {
            if (JCOProvider.this.destinationListener != null) {
                for (String name : JCOProvider.this.destination.keySet()) {
                    JCOProvider.this.removeDestinationProperties(name);
                }
            }
            Environment.unregisterDestinationDataProvider((DestinationDataProvider)this);
        }
    }

    class ServerProvider
    implements ServerDataProvider {
        ServerProvider() {
        }

        public Properties getServerProperties(String arg0) {
            return JCOProvider.this.server.get(arg0);
        }

        public void setServerDataEventListener(ServerDataEventListener arg0) {
            JCOProvider.this.serverListener = arg0;
        }

        public boolean supportsEvents() {
            return true;
        }

        public void register() {
            Environment.registerServerDataProvider((ServerDataProvider)this);
            if (JCOProvider.this.serverListener != null) {
                for (String str : JCOProvider.this.server.keySet()) {
                    JCOProvider.this.serverListener.updated(str);
                }
            }
        }

        public void unregister() {
            if (JCOProvider.this.serverListener != null) {
                for (String name : JCOProvider.this.server.keySet()) {
                    JCOProvider.this.server.remove(name);
                }
            }
            Environment.unregisterServerDataProvider((ServerDataProvider)this);
        }
    }
}

