/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.tech.presentation;

import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import com.indy.ui.custom.out.dialog.TrimmedWizardNewFileCreationPage;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.tech.DocumentRoot;
import com.stambia.tech.Tech;
import com.stambia.tech.TechFactory;
import com.stambia.tech.presentation.TechEditorPlugin;
import com.stambia.tech.presentation.properties.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class TechExtensionModelWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    private TrimmedWizardNewFileCreationPage newFileCreationPage;
    private List<URI> contributedTechURI = new ArrayList<URI>();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
        this.setWindowTitle(TechEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(TechEditorPlugin.INSTANCE.getImage("full/wizban/NewTech")));
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new TrimmedWizardNewFileCreationPage("Whatever", this.selection){

            protected boolean validatePage() {
                if (super.validatePage()) {
                    String extension = new Path(this.getFileName()).getFileExtension();
                    if (!"tech_ext".equals(extension)) {
                        String key = "_WARN_FilenameExtension";
                        this.setErrorMessage(TechEditorPlugin.INSTANCE.getString(key, new Object[]{"tech_ext"}));
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        this.newFileCreationPage.setTitle(TechEditorPlugin.INSTANCE.getString("_UI_TechModelWizard_label"));
        this.newFileCreationPage.setDescription(TechEditorPlugin.INSTANCE.getString("_UI_TechModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(TechEditorPlugin.INSTANCE.getString("_UI_TechEditorFilenameDefaultBase")) + ".tech_ext");
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = TechEditorPlugin.INSTANCE.getString("_UI_TechEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = "tech_ext";
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        TechExtentionModelPage modelPage = new TechExtentionModelPage("", Messages.TechExtensionModelWizard_10, null);
        this.addPage((IWizardPage)modelPage);
    }

    public IFile getModelFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.newFileCreationPage.getContainerFullPath().append(this.newFileCreationPage.getFileName()));
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            resourceSet.setURIConverter((URIConverter)new InternalResourceURIConverter());
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI);
                            EObject rootObject = TechExtensionModelWizard.this.createInitialModel();
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", "UTF-8");
                            resource.save(options);
                        }
                        catch (Exception exception) {
                            TechEditorPlugin.INSTANCE.log(exception);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    @Override
                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)TechEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            TechEditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    private EObject createInitialModel() {
        DocumentRoot root = TechFactory.eINSTANCE.createDocumentRoot();
        Tech tech = TechFactory.eINSTANCE.createTech();
        for (URI u : this.contributedTechURI) {
            AnyType ref = XMLTypeFactory.eINSTANCE.createAnyType();
            if (u.fragment() != null) {
                ((InternalEObject)ref).eSetProxyURI(u);
            } else {
                String selectedId = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(u);
                ((InternalEObject)ref).eSetProxyURI(URI.createURI((String)("foo#" + selectedId + "?fileId=" + selectedId + "?")));
            }
            tech.getExtendedRefs().add((Object)ref);
        }
        root.setTech(tech);
        tech.setName(this.getModelFile().getLocation().removeFileExtension().lastSegment());
        tech.setId("__EXT_" + tech.getName().toUpperCase());
        return root;
    }

    class TechExtentionModelPage
    extends WizardPage {
        protected TechExtentionModelPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public boolean isPageComplete() {
            return !TechExtensionModelWizard.this.contributedTechURI.isEmpty();
        }

        public void createControl(Composite parent) {
            Composite main = new Composite(parent, 0);
            main.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(main, 0);
            l.setText(Messages.TechExtensionModelWizard_0);
            l.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            ToolBar tb = new ToolBar(main, 0);
            tb.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            ToolItem add = new ToolItem(tb, 8);
            add.setToolTipText(Messages.TechExtensionModelWizard_1);
            add.setImage(AbstractUnboundedControl.addIcon);
            final ToolItem del = new ToolItem(tb, 8);
            del.setToolTipText(Messages.TechExtensionModelWizard_2);
            del.setEnabled(false);
            del.setImage(AbstractUnboundedControl.delIcon);
            final TableViewer v = new TableViewer(main, 68352);
            v.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            v.setContentProvider((IContentProvider)new ArrayContentProvider());
            v.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    URI u = (URI)element;
                    String id = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(u);
                    return String.valueOf(u.trimFragment().trimFileExtension().lastSegment()) + "(" + id + ")";
                }
            });
            v.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    del.setEnabled(!event.getSelection().isEmpty());
                }
            });
            v.setSorter(new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    String s1 = ((LabelProvider)v.getLabelProvider()).getText(e1);
                    String s2 = ((LabelProvider)v.getLabelProvider()).getText(e2);
                    return s1.compareTo(s2);
                }
            });
            v.setInput((Object)TechExtensionModelWizard.this.contributedTechURI);
            del.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TechExtensionModelWizard.this.contributedTechURI.removeAll(((IStructuredSelection)v.getSelection()).toList());
                    v.refresh(true, true);
                    TechExtentionModelPage.this.getContainer().updateButtons();
                }
            });
            add.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ListDialog ld = new ListDialog(v.getControl().getShell()){

                        protected int getTableStyle() {
                            return 2818;
                        }
                    };
                    ld.setLabelProvider((ILabelProvider)v.getLabelProvider());
                    ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                    List allTechs = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURI("(.)*.(tech|tech_ext)");
                    allTechs.removeAll(TechExtensionModelWizard.this.contributedTechURI);
                    Collections.sort(allTechs, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            String s1 = ((LabelProvider)v.getLabelProvider()).getText(o1);
                            String s2 = ((LabelProvider)v.getLabelProvider()).getText(o2);
                            return s1.compareTo(s2);
                        }
                    });
                    ld.setInput((Object)allTechs);
                    ld.setInitialElementSelections((List)v.getInput());
                    if (ld.open() == 0) {
                        Object[] objectArray = ld.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            TechExtensionModelWizard.this.contributedTechURI.add((URI)o);
                            ++n2;
                        }
                        v.refresh(true, true);
                        TechExtentionModelPage.this.getContainer().updateButtons();
                    }
                }
            });
            this.setControl((Control)main);
        }
    }
}

