/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import com.sun.codemodel.SecureLoader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

class TypedAnnotationWriter<A extends Annotation, W extends JAnnotationWriter<A>>
implements InvocationHandler,
JAnnotationWriter<A> {
    private final JAnnotationUse use;
    private final Class<A> annotation;
    private final Class<W> writerType;
    private Map<String, JAnnotationArrayMember> arrays;

    public TypedAnnotationWriter(Class<A> annotation, Class<W> writer, JAnnotationUse use) {
        this.annotation = annotation;
        this.writerType = writer;
        this.use = use;
    }

    @Override
    public JAnnotationUse getAnnotationUse() {
        return this.use;
    }

    @Override
    public Class<A> getAnnotationType() {
        return this.annotation;
    }

    private static Method getOverriddenJAnnotationWriterMethod(Method method) {
        if (method.getDeclaringClass() == JAnnotationWriter.class) {
            return method;
        }
        try {
            return JAnnotationWriter.class.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method m;
        Class<?> rt;
        Method overridenMethod;
        if (method.getDeclaringClass() == Object.class) {
            switch (method.getName()) {
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "toString": {
                    return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
                }
            }
        }
        if ((overridenMethod = TypedAnnotationWriter.getOverriddenJAnnotationWriterMethod(method)) != null) {
            try {
                return overridenMethod.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        String name = method.getName();
        Object arg = null;
        if (args != null && args.length > 0) {
            arg = args[0];
        }
        if ((rt = (m = this.annotation.getDeclaredMethod(name, new Class[0])).getReturnType()).isArray()) {
            return this.addArrayValue(proxy, name, rt.getComponentType(), method.getReturnType(), arg);
        }
        if (Annotation.class.isAssignableFrom(rt)) {
            Class<?> r = rt;
            return super.createProxy();
        }
        if (arg instanceof JType) {
            JType targ = (JType)arg;
            this.checkType(Class.class, rt);
            if (m.getDefaultValue() != null && targ.equals(targ.owner().ref((Class)m.getDefaultValue()))) {
                return proxy;
            }
            this.use.param(name, targ);
            return proxy;
        }
        this.checkType(arg.getClass(), rt);
        if (m.getDefaultValue() != null && m.getDefaultValue().equals(arg)) {
            return proxy;
        }
        if (arg instanceof String) {
            this.use.param(name, (String)arg);
            return proxy;
        }
        if (arg instanceof Boolean) {
            this.use.param(name, (Boolean)arg);
            return proxy;
        }
        if (arg instanceof Integer) {
            this.use.param(name, (Integer)arg);
            return proxy;
        }
        if (arg instanceof Class) {
            this.use.param(name, (Class)arg);
            return proxy;
        }
        if (arg instanceof Enum) {
            this.use.param(name, (Enum)arg);
            return proxy;
        }
        throw new IllegalArgumentException("Unable to handle this method call " + method.toString());
    }

    private Object addArrayValue(Object proxy, String name, Class<?> itemType, Class<?> expectedReturnType, Object arg) {
        JAnnotationArrayMember m;
        if (this.arrays == null) {
            this.arrays = new HashMap<String, JAnnotationArrayMember>();
        }
        if ((m = this.arrays.get(name)) == null) {
            m = this.use.paramArray(name);
            this.arrays.put(name, m);
        }
        if (Annotation.class.isAssignableFrom(itemType)) {
            Class<?> r = itemType;
            if (!JAnnotationWriter.class.isAssignableFrom(expectedReturnType)) {
                throw new IllegalArgumentException("Unexpected return type " + expectedReturnType);
            }
            return super.createProxy();
        }
        if (arg instanceof JType) {
            this.checkType(Class.class, itemType);
            m.param((JType)arg);
            return proxy;
        }
        this.checkType(arg.getClass(), itemType);
        if (arg instanceof String) {
            m.param((String)arg);
            return proxy;
        }
        if (arg instanceof Boolean) {
            m.param((Boolean)arg);
            return proxy;
        }
        if (arg instanceof Integer) {
            m.param((Integer)arg);
            return proxy;
        }
        if (arg instanceof Class) {
            m.param((Class)arg);
            return proxy;
        }
        throw new IllegalArgumentException("Unable to handle this method call ");
    }

    private void checkType(Class<?> actual, Class<?> expected) {
        if (expected == actual || expected.isAssignableFrom(actual)) {
            return;
        }
        if (expected == JCodeModel.boxToPrimitive.get(actual)) {
            return;
        }
        throw new IllegalArgumentException("Expected " + expected + " but found " + actual);
    }

    private W createProxy() {
        return (W)((JAnnotationWriter)Proxy.newProxyInstance(SecureLoader.getClassClassLoader(this.writerType), new Class[]{this.writerType}, (InvocationHandler)this));
    }

    static <W extends JAnnotationWriter<?>> W create(Class<W> w, JAnnotatable annotatable) {
        Class<Annotation> a = TypedAnnotationWriter.findAnnotationType(w);
        return super.createProxy();
    }

    private static Class<? extends Annotation> findAnnotationType(Class<?> clazz) {
        for (Type t : clazz.getGenericInterfaces()) {
            Class<Annotation> r;
            ParameterizedType p;
            if (t instanceof ParameterizedType && (p = (ParameterizedType)t).getRawType() == JAnnotationWriter.class) {
                return (Class)p.getActualTypeArguments()[0];
            }
            if (!(t instanceof Class) || (r = TypedAnnotationWriter.findAnnotationType((Class)t)) == null) continue;
            return r;
        }
        return null;
    }
}

