/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.diagram.custom;

import com.stambia.md.MdNode;
import com.stambia.md.diagram.navigator.MdDomainNavigatorItem;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.navigator.CommonViewer;

public abstract class UIMdNodeSelector {
    private CommonViewer viewer;

    public void createControl(Composite parent) {
        this.viewer = new CommonViewer("org.eclipse.ui.navigator.ProjectExplorer", parent, 2816);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.viewer.getNavigatorContentService().getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "com.indy.md.ui.diagram.domainResourceContent"}, true);
        this.viewer.getNavigatorContentService().update();
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    boolean isMd;
                    boolean bl = isMd = ((IFile)element).getFileExtension() != null && ((IFile)element).getFileExtension().equals("md");
                    if (isMd) {
                        try {
                            IMarker[] m = ((IFile)element).findMarkers("com.stambia.resource.marker.duplicate", true, 0);
                            return m == null || m.length == 0;
                        }
                        catch (CoreException ex) {
                            return false;
                        }
                    }
                    return isMd;
                }
                if (element instanceof IContainer) {
                    return this.checkFolder((IContainer)element);
                }
                boolean cfr_ignored_0 = element instanceof MdDomainNavigatorItem;
                return true;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean checkFolder(IContainer f) {
                if (f.getName().equals("indy.build")) return false;
                if (f.getName().equals("indy.diagram")) {
                    return false;
                }
                try {
                    IResource[] iResourceArray = f.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        IResource m = iResourceArray[n2];
                        if (m instanceof IFile && "md".equals(((IFile)m).getFileExtension())) {
                            return true;
                        }
                        if (m instanceof IContainer && this.checkFolder((IContainer)m)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        });
        this.viewer.refresh();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UIMdNodeSelector.this.handleSelectedMd(UIMdNodeSelector.this.getSelectedMdNode());
            }
        });
    }

    public MdNode getSelectedMdNode() {
        EObject obj;
        IStructuredSelection ss = (IStructuredSelection)this.viewer.getSelection();
        if (!ss.isEmpty() && ss.getFirstElement() instanceof MdDomainNavigatorItem && (obj = ((MdDomainNavigatorItem)((Object)ss.getFirstElement())).getEObject()) instanceof MdNode) {
            return (MdNode)obj;
        }
        return null;
    }

    public abstract void handleSelectedMd(MdNode var1);
}

