/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.diagram.custom.move;

import com.indy.md.ui.diagram.Messages;
import com.indy.md.ui.diagram.custom.move.MdNodeRefactorer;
import com.indy.md.ui.diagram.custom.move.MoveDialog;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.stambia.md.MdNode;
import com.stambia.md.diagram.navigator.MdDomainNavigatorItem;
import com.stambia.md.presentation.MdEditorPlugin;
import com.stambia.tech.Level;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class MoveHandler
extends AbstractHandler {
    public static boolean setWorkspaceAutoBuild(boolean flag) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = workspace.getDescription();
            if (flag != description.isAutoBuilding()) {
                description.setAutoBuilding(flag);
                workspace.setDescription(description);
                return !description.isAutoBuilding();
            }
            return description.isAutoBuilding();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection s = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ArrayList<EObject> selectedMdNode = new ArrayList<EObject>();
        Level lvl = null;
        if (!this.allowClosedProject()) {
            return null;
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
        if (s instanceof IStructuredSelection) {
            for (Object o : ((IStructuredSelection)s).toList()) {
                EObject node = rs.getEObject(EcoreUtil.getURI((EObject)((MdDomainNavigatorItem)((Object)o)).getEObject()), true);
                selectedMdNode.add(node);
                if (lvl == null) {
                    lvl = ((MdNode)node.eContainer()).getLevel();
                    continue;
                }
                if (lvl == ((MdNode)node.eContainer()).getLevel()) continue;
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.MoveHandler_4, (String)Messages.MoveHandler_5);
                return null;
            }
        }
        selectedMdNode = new ArrayList(EcoreUtil.filterDescendants(selectedMdNode));
        MoveDialog d = new MoveDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), lvl);
        if (d.open() == 0) {
            final ArrayList<EObject> toMove = selectedMdNode;
            final URI targetURI = d.getResourceUri().appendFragment(d.getTargetURIFragment());
            AbstractOperation op = new AbstractOperation(Messages.MoveHandler_6, (ResourceSet)rs){
                private Set<URI> modifiedFiles;
                private final /* synthetic */ ResourceSet val$rs;
                {
                    this.val$rs = resourceSet;
                    super($anonymous0);
                    this.modifiedFiles = new HashSet<URI>();
                }

                public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    this.modifiedFiles.clear();
                    monitor.beginTask(Messages.MoveHandler_7, toMove.size());
                    HashMap<URI, URI> movedURIParent = new HashMap<URI, URI>();
                    HashSet<URI> uriToMove = new HashSet<URI>();
                    for (EObject n : toMove) {
                        URI toMoveParentUri = EcoreUtil.getURI((EObject)n.eContainer());
                        URI movingNodeUri = EcoreUtil.getURI((EObject)n);
                        movedURIParent.put(movingNodeUri, toMoveParentUri);
                        uriToMove.add(movingNodeUri);
                    }
                    if (monitor != null && monitor.isCanceled()) {
                        this.undo(monitor, info);
                    }
                    boolean autoBuild = MoveHandler.setWorkspaceAutoBuild(false);
                    try {
                        try {
                            MdNodeRefactorer ref = new MdNodeRefactorer(uriToMove, targetURI);
                            for (URI movedURI : ref.execute()) {
                                this.modifiedFiles.add(movedURI);
                            }
                        }
                        catch (Exception ex) {
                            this.undo(monitor, info);
                            Status status = new Status(4, "com.indy.md.ui.diagram", String.valueOf(Messages.MoveHandler_8) + ex.getMessage(), (Throwable)ex);
                            MoveHandler.setWorkspaceAutoBuild(autoBuild);
                            return status;
                        }
                    }
                    finally {
                        MoveHandler.setWorkspaceAutoBuild(autoBuild);
                    }
                    for (Resource r : this.val$rs.getResources()) {
                        if (r == null || !r.isLoaded()) continue;
                        r.unload();
                    }
                    return new Status(0, "com.indy.md.ui.diagram", Messages.MoveHandler_9);
                }

                public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    return this.execute(monitor, info);
                }

                public boolean canRedo() {
                    return false;
                }

                public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    WorkspaceJob job = new WorkspaceJob(new Runnable(){

                        @Override
                        public void run() {
                            boolean autoBuild = MoveHandler.setWorkspaceAutoBuild(false);
                            try {
                                IHistoryStore historyStore = ((Workspace)ResourcesPlugin.getWorkspace()).getFileSystemManager().getHistoryStore();
                                for (URI src : modifiedFiles) {
                                    IFile f = Util.convertEMFURIToFile((URI)src);
                                    IPath path = f.getFullPath();
                                    IFileState[] states = historyStore.getStates(path, (IProgressMonitor)new NullProgressMonitor());
                                    IFileState lastState = null;
                                    IFileState[] iFileStateArray = states;
                                    int n = states.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IFileState s = iFileStateArray[n2];
                                        if (lastState == null) {
                                            lastState = s;
                                        } else if (lastState.getModificationTime() < s.getModificationTime()) {
                                            lastState = s;
                                        }
                                        ++n2;
                                    }
                                    try {
                                        f.setContents(lastState, 3, (IProgressMonitor)new NullProgressMonitor());
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            finally {
                                MoveHandler.setWorkspaceAutoBuild(autoBuild);
                            }
                        }
                    });
                    job.setUser(true);
                    job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                    job.schedule();
                    return new Status(0, "com.indy.md.ui.diagram", Messages.MoveHandler_10);
                }
            };
            op.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
            WorkspaceJob job = new WorkspaceJob(op);
            job.setUser(true);
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.schedule();
        }
        return null;
    }

    private boolean allowClosedProject() {
        IPreferenceStore store = MdEditorPlugin.getPlugin().getPreferenceStore();
        if (!store.getBoolean("checkClosedProjectOnMove")) {
            return true;
        }
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.MoveHandler_11, null, String.valueOf(Messages.MoveHandler_12) + Messages.MoveHandler_13, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0){

            public int open() {
                int res = super.open();
                return res;
            }
        };
        return dialog.open() == 0;
    }

    public static class WorkspaceJob
    extends Job {
        AbstractOperation op;
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        Runnable runnable;

        public WorkspaceJob(Runnable runnable) {
            super(Messages.MoveHandler_0);
            this.runnable = runnable;
        }

        public WorkspaceJob(AbstractOperation op) {
            super(Messages.MoveHandler_1);
            this.op = op;
        }

        public final IStatus run(IProgressMonitor monitor) {
            IStatus iStatus;
            block9: {
                monitor = Policy.monitorFor((IProgressMonitor)monitor);
                int depth = -1;
                try {
                    this.workspace.prepareOperation(null, monitor);
                    this.workspace.beginOperation(true);
                    depth = this.workspace.getWorkManager().beginUnprotected();
                    iStatus = this.runInWorkspace(monitor);
                    if (depth < 0) break block9;
                }
                catch (OperationCanceledException e) {
                    IStatus iStatus2;
                    block10: {
                        try {
                            this.workspace.getWorkManager().operationCanceled();
                            iStatus2 = Status.CANCEL_STATUS;
                            if (depth < 0) break block10;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (depth >= 0) {
                                    this.workspace.getWorkManager().endUnprotected(depth);
                                }
                                this.workspace.endOperation(null, false);
                                throw throwable;
                            }
                            catch (CoreException e2) {
                                return e2.getStatus();
                            }
                        }
                        this.workspace.getWorkManager().endUnprotected(depth);
                    }
                    this.workspace.endOperation(null, false);
                    return iStatus2;
                }
                this.workspace.getWorkManager().endUnprotected(depth);
            }
            this.workspace.endOperation(null, false);
            return iStatus;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            IStatus st;
            IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
            if (this.op != null) {
                try {
                    st = operationHistory.execute((IUndoableOperation)this.op, monitor, null);
                }
                catch (Throwable e) {
                    st = new Status(4, "com.indy.md.ui.diagram", String.valueOf(Messages.MoveHandler_3) + e.getMessage(), e);
                    e.printStackTrace();
                }
            } else {
                this.runnable.run();
                st = Status.OK_STATUS;
            }
            return st;
        }
    }
}

